/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.base;

import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class FuzzyAlgo {
    public static List<SynAlgo> NO_SYN = Arrays.asList(new SynAlgo[0]);
    private final String name;

    public FuzzyAlgo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract List<SynAlgo> getSynonyms(List<IToken> var1, IToken var2, Iterable<StateTransition> var3);

    public List<SynAlgo> word2syn(String word) {
        SynAlgo synsAlgo = new SynAlgo(word, this.getName());
        ArrayList<SynAlgo> syns = new ArrayList<SynAlgo>(1);
        syns.add(synsAlgo);
        return syns;
    }

    public List<SynAlgo> words2syn(Collection<String> words) {
        return words.stream().map(w -> new SynAlgo((String)w, this.getName())).collect(Collectors.toList());
    }
}

