/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.base;

import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.ISynsProvider;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgos;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SynsProvider
implements ISynsProvider {
    private List<? extends FuzzyAlgo> fuzzyAlgos;

    public SynsProvider(List<? extends FuzzyAlgo> fuzzyAlgos) {
        this.fuzzyAlgos = fuzzyAlgos;
    }

    @Override
    public Collection<SynAlgos> getSynonyms(List<IToken> tokens, IToken token, Iterable<StateTransition> transitions) {
        HashMap<String, SynAlgos> syn2synAlgos = new HashMap<String, SynAlgos>();
        for (FuzzyAlgo fuzzyAlgo : this.fuzzyAlgos) {
            List<SynAlgo> synsAlgo = fuzzyAlgo.getSynonyms(tokens, token, transitions);
            for (SynAlgo synAlgo : synsAlgo) {
                String syn = synAlgo.getSyn();
                if (syn2synAlgos.containsKey(syn)) {
                    ((SynAlgos)syn2synAlgos.get(syn)).addAlgo(synAlgo.getAlgo());
                    continue;
                }
                SynAlgos synAlgos = new SynAlgos(syn, synAlgo.getAlgo());
                syn2synAlgos.put(syn, synAlgos);
            }
        }
        return syn2synAlgos.values();
    }
}

