/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.closestSubString;

import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.NormLabelAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.fuzzy.troncation.PrefixTrie;
import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ClosestSubString
extends NormLabelAlgo {
    private final PrefixTrie prefixTrie;
    private final int maxDistance;

    public ClosestSubString(String name, PrefixTrie prefixTrie, int maxDistance) {
        super(name);
        this.prefixTrie = prefixTrie;
        this.maxDistance = maxDistance;
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String normLabel) {
        if (this.prefixTrie.tokenLengthLessThanMinSize(normLabel)) {
            return FuzzyAlgo.NO_SYN;
        }
        Set<String> startsWith = this.getTokenStartingWith(normLabel);
        return this.words2syn(startsWith);
    }

    private Set<String> getTokenStartingWith(String token) {
        HashSet<String> startsWith = new HashSet<String>();
        List chars = this.prefixTrie.getCharTokenizer().tokenize(token).stream().map(t -> t.normLabel()).collect(Collectors.toList());
        INode currentNode = this.prefixTrie.getTrie().getInitialState();
        INode lastFinalNode = EmptyNode.EMPTYNODE;
        int countDepth = 0;
        for (String c : chars) {
            if ((currentNode = currentNode.gotoNode(c)).isAfinalState()) {
                lastFinalNode = currentNode;
                countDepth = 0;
                continue;
            }
            ++countDepth;
        }
        if (lastFinalNode != EmptyNode.EMPTYNODE && countDepth <= this.maxDistance) {
            for (IKeyword kw : lastFinalNode.getKeywords()) {
                startsWith.add(kw.label());
            }
        }
        return startsWith;
    }
}

