/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.encoder;

import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.StringDistance;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class StringEncoderSyn
extends StringDistance {
    private Map<String, Set<String>> encoding2tokens = new HashMap<String, Set<String>>();
    private final StringEncoder stringEncoder;
    private final int minNbChar;
    private String encodedStrSpliter = "\\|";

    public StringEncoderSyn(String name, StringEncoder stringEncoder, int minNbChar) {
        super(name, minNbChar);
        this.stringEncoder = stringEncoder;
        this.minNbChar = minNbChar;
    }

    public StringEncoderSyn(StringEncoder stringEncoder, int minNbChar) {
        this(stringEncoder.getClass().getSimpleName(), stringEncoder, minNbChar);
    }

    public void add(Collection<String> unigrams) throws EncoderException {
        for (String word : unigrams) {
            String encoded = this.stringEncoder.encode(word);
            this.add(word, encoded);
        }
    }

    private void add(String word, String encoded) {
        for (String encodedString : this.encodedStrSplit(encoded)) {
            if (!this.encoding2tokens.containsKey(encodedString)) {
                HashSet temp = new HashSet();
                this.encoding2tokens.put(encodedString, temp);
            }
            this.encoding2tokens.get(encodedString).add(word);
        }
    }

    private Collection<String> encodedStrSplit(String encoded) {
        if (this.encodedStrSpliter == null) {
            ArrayList<String> encodedStrings = new ArrayList<String>(1);
            encodedStrings.add(encoded);
            return encodedStrings;
        }
        return Arrays.asList(encoded.split(this.encodedStrSpliter));
    }

    private List<SynAlgo> findWordWithSimilarEncoding(String encoded) {
        if (this.encoding2tokens.containsKey(encoded)) {
            return this.words2syn((Collection<String>)this.encoding2tokens.get(encoded));
        }
        return FuzzyAlgo.NO_SYN;
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String token) {
        if (this.tokenLengthLessThanMinSize(token)) {
            return FuzzyAlgo.NO_SYN;
        }
        try {
            String encodedStr = this.stringEncoder.encode(token);
            return Arrays.asList(encodedStr.split(this.encodedStrSpliter)).stream().map(encoded -> this.findWordWithSimilarEncoding((String)encoded)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (EncoderException e) {
            System.err.println(e.getMessage());
            return FuzzyAlgo.NO_SYN;
        }
    }

    public void setEncodedStrSpliter(String encodedStringSeparator) {
        this.encodedStrSpliter = encodedStringSeparator;
    }

    private boolean tokenLengthLessThanMinSize(String token) {
        return token.length() < this.minNbChar;
    }
}

