/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.levenshtein;

import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.Candidate;
import com.github.liblevenshtein.transducer.ITransducer;
import com.github.liblevenshtein.transducer.factory.TransducerBuilder;
import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.StringDistance;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.matcher.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class Levenshtein
extends StringDistance {
    private final ITransducer<Candidate> transducer;

    public static ITransducer<Candidate> buildTransuder(int maxDistance, Collection<String> unigrams, Algorithm algorithm) {
        ArrayList<String> unigramsOrdered = new ArrayList<String>(unigrams);
        unigramsOrdered.sort(Comparator.naturalOrder());
        ITransducer transducer = new TransducerBuilder().algorithm(algorithm).defaultMaxDistance(maxDistance).dictionary(unigramsOrdered, true).build();
        return transducer;
    }

    public static ITransducer<Candidate> buildTransuder(int maxDistance, Matcher matcher, Algorithm algorithm) {
        return Levenshtein.buildTransuder(maxDistance, matcher.getUnigrams(), algorithm);
    }

    public Levenshtein(String name, int minNbChar, ITransducer<Candidate> transducer) {
        super(name, minNbChar);
        this.transducer = transducer;
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String normLabel) {
        if (this.isAword2ignore(normLabel)) {
            return FuzzyAlgo.NO_SYN;
        }
        HashSet<String> similarWords = new HashSet<String>();
        for (Candidate candidate : this.transducer.transduce(normLabel)) {
            similarWords.add(candidate.term());
        }
        return this.words2syn(similarWords);
    }
}

