/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.normfun;

import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.NormLabelAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.tokenize.INormalizeF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WordNormalizer
extends NormLabelAlgo {
    private INormalizeF normfun;
    private Map<String, List<SynAlgo>> norm2syns = new HashMap<String, List<SynAlgo>>();

    public WordNormalizer(String name, INormalizeF normfun) {
        super(name);
        this.normfun = normfun;
    }

    public void addWords(Iterable<String> unigrams) {
        for (String unigram : unigrams) {
            String normalized = this.normfun.normalize(unigram);
            if (!this.norm2syns.containsKey(normalized)) {
                this.norm2syns.put(normalized, new ArrayList());
            }
            SynAlgo synsAlgo = new SynAlgo(unigram, this.getName());
            this.norm2syns.get(normalized).add(synsAlgo);
        }
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String normLabel) {
        String normalized = this.normfun.normalize(normLabel);
        if (!this.norm2syns.containsKey(normalized)) {
            return FuzzyAlgo.NO_SYN;
        }
        return this.norm2syns.get(normalized);
    }
}

