/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.troncation;

import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class PrefixFounder {
    private final Collection<INode> nodes;
    private final int maxDistance;

    PrefixFounder(Collection<INode> nodes, int maxDistance) {
        this.nodes = nodes;
        this.maxDistance = maxDistance;
    }

    public Set<String> getTokenStartingWith() {
        HashSet<String> startsWith = new HashSet<String>();
        for (INode node : this.nodes) {
            if (node == EmptyNode.EMPTYNODE) continue;
            startsWith.addAll(this.getTokenStartingWith(node));
        }
        return startsWith;
    }

    private Set<String> getTokenStartingWith(INode node) {
        HashSet<String> startsWith = new HashSet<String>();
        if (node.isAfinalState()) {
            node.getKeywords().forEach(k -> startsWith.add(k.label()));
        }
        if (this.maxDistance > 0) {
            PrefixFounder sub = new PrefixFounder(node.getChildrenNodes(), this.maxDistance - 1);
            startsWith.addAll(sub.getTokenStartingWith());
        }
        return startsWith;
    }
}

