/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.troncation;

import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.ITokenizer;
import fr.erias.iamsystem.tokenize.ITokenizerStopwords;
import fr.erias.iamsystem.tokenize.NormFunctions;
import fr.erias.iamsystem.tokenize.SplitFunctions;
import fr.erias.iamsystem.tokenize.TokenizerImp;
import fr.erias.iamsystem.tree.Trie;
import java.util.Collection;
import java.util.List;

public class PrefixTrie
implements ITokenizerStopwords {
    private final int minPrefixLength;
    private final Trie trie;
    private final ITokenizer charTokenizer;

    public PrefixTrie(int minNbChar) {
        this.minPrefixLength = minNbChar;
        this.trie = new Trie();
        this.charTokenizer = new TokenizerImp(NormFunctions.rmAccents, SplitFunctions.splitChar);
    }

    public void addToken(Collection<String> unigrams) {
        unigrams.stream().filter(w -> !this.tokenLengthLessThanMinSize((String)w)).forEach(w -> this.addToken((String)w));
    }

    public void addToken(String unigram) {
        this.trie.addKeyword(unigram, this);
    }

    public ITokenizer getCharTokenizer() {
        return this.charTokenizer;
    }

    public Trie getTrie() {
        return this.trie;
    }

    @Override
    public boolean isTokenAStopword(IToken token) {
        return false;
    }

    @Override
    public List<IToken> tokenize(String text) {
        return this.charTokenizer.tokenize(text);
    }

    public boolean tokenLengthLessThanMinSize(String token) {
        return token.length() < this.minPrefixLength;
    }
}

