/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.troncation;

import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.NormLabelAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.fuzzy.troncation.PrefixFounder;
import fr.erias.iamsystem.fuzzy.troncation.PrefixTrie;
import fr.erias.iamsystem.tree.INode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Truncation
extends NormLabelAlgo {
    private final PrefixTrie prefixTrie;
    private final int maxDistance;

    public Truncation(String name, PrefixTrie prefixTrie, int maxDistance) {
        super(name);
        this.prefixTrie = prefixTrie;
        this.maxDistance = maxDistance;
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String normLabel) {
        if (this.prefixTrie.tokenLengthLessThanMinSize(normLabel)) {
            return FuzzyAlgo.NO_SYN;
        }
        Set<String> tokensStartingWith = this.getTokenStartingWith(normLabel);
        return this.words2syn(tokensStartingWith);
    }

    private Set<String> getTokenStartingWith(String token) {
        List<String> chars = this.prefixTrie.getCharTokenizer().tokenize(token).stream().map(t -> t.normLabel()).collect(Collectors.toList());
        INode node = this.prefixTrie.getTrie().getInitialState().gotoNode(chars);
        ArrayList<INode> nodes = new ArrayList<INode>(1);
        nodes.add(node);
        PrefixFounder prefix = new PrefixFounder(nodes, this.maxDistance);
        return prefix.getTokenStartingWith();
    }
}

