/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher;

import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.fuzzy.ExactMatch;
import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.ISynsProvider;
import fr.erias.iamsystem.fuzzy.base.SynAlgos;
import fr.erias.iamsystem.fuzzy.base.SynsProvider;
import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.keywords.IStoreKeywords;
import fr.erias.iamsystem.keywords.Keyword;
import fr.erias.iamsystem.keywords.Terminology;
import fr.erias.iamsystem.matcher.IBaseMatcher;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.matcher.strategy.IMatchingStrategy;
import fr.erias.iamsystem.matcher.strategy.StrategyUtils;
import fr.erias.iamsystem.matcher.strategy.WindowMatching;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.ITokenizer;
import fr.erias.iamsystem.tokenize.ITokenizerStopwords;
import fr.erias.iamsystem.tree.Trie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class Matcher
implements IBaseMatcher,
IStoreKeywords,
ITokenizerStopwords,
ISynsProvider {
    private ITokenizer tokenizer;
    private IStopwords stopwords;
    private IMatchingStrategy strategy;
    private int w = 1;
    private final Trie trie = new Trie();
    private Terminology termino = new Terminology();
    private boolean removeNestedAnnot = true;
    private List<FuzzyAlgo> fuzzyAlgos = new ArrayList<FuzzyAlgo>();
    private SynsProvider synsProvider;

    public Matcher(ITokenizer tokenizer, IStopwords stopwords) {
        this.setTokenizer(tokenizer);
        this.setStopwords(stopwords);
        this.strategy = new WindowMatching();
        this.fuzzyAlgos.add(new ExactMatch());
        this.synsProvider = new SynsProvider(this.fuzzyAlgos);
    }

    public void addFuzzyAlgo(FuzzyAlgo fuzzyAlgo) {
        this.fuzzyAlgos.add(fuzzyAlgo);
    }

    @Override
    public void addKeyword(IKeyword keyword) {
        this.termino.addKeyword(keyword);
        this.trie.addIKeyword(keyword, this);
    }

    public void addKeyword(Iterable<? extends IKeyword> keywords) {
        for (IKeyword iKeyword : keywords) {
            this.addKeyword(iKeyword);
        }
    }

    public void addKeyword(String ... labels) {
        for (String kw : labels) {
            Keyword k = new Keyword(kw);
            this.addKeyword(k);
        }
    }

    @Override
    public List<IAnnotation> annot(List<IToken> tokens) {
        List<IAnnotation> annots = this.strategy.detect(tokens, this.w, this.trie.getInitialState(), this, this.stopwords);
        if (this.removeNestedAnnot) {
            annots = StrategyUtils.rmNestedAnnots(annots, false);
        }
        return annots;
    }

    @Override
    public List<IAnnotation> annot(String text) {
        List<IToken> tokens = this.tokenize(text);
        List<IAnnotation> annots = this.annot(tokens);
        annots.forEach(annot -> annot.setText(text));
        return annots;
    }

    public List<FuzzyAlgo> getFuzzyAlgos() {
        return this.fuzzyAlgos;
    }

    @Override
    public Collection<IKeyword> getKeywords() {
        return this.termino.getKeywords();
    }

    public IStopwords getStopwords() {
        return this.stopwords;
    }

    @Override
    public Collection<SynAlgos> getSynonyms(List<IToken> tokens, IToken token, Iterable<StateTransition> transitions) {
        return this.synsProvider.getSynonyms(tokens, token, transitions);
    }

    public ITokenizer getTokenizer() {
        return this.tokenizer;
    }

    public Set<String> getUnigrams() {
        return IStoreKeywords.getUnigrams(this.getKeywords(), this);
    }

    public int getW() {
        return this.w;
    }

    @Override
    public boolean isTokenAStopword(IToken token) {
        return this.stopwords.isTokenAStopword(token);
    }

    public boolean removeNestedAnnot() {
        return this.removeNestedAnnot;
    }

    public void setRemoveNestedAnnot(boolean removeNestedAnnot) {
        this.removeNestedAnnot = removeNestedAnnot;
    }

    public void setStopwords(IStopwords stopwords) {
        this.stopwords = stopwords;
    }

    public void setStrategy(IMatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public void setTokenizer(ITokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setW(int w) {
        this.w = w;
    }

    @Override
    public List<IToken> tokenize(String text) {
        return this.tokenizer.tokenize(text);
    }
}

