/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher;

import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.Candidate;
import com.github.liblevenshtein.transducer.ITransducer;
import fr.erias.iamsystem.fuzzy.CacheFuzzyAlgos;
import fr.erias.iamsystem.fuzzy.FuzzyRegex;
import fr.erias.iamsystem.fuzzy.abbreviations.Abbreviations;
import fr.erias.iamsystem.fuzzy.base.ContextFreeAlgo;
import fr.erias.iamsystem.fuzzy.base.IWord2ignore;
import fr.erias.iamsystem.fuzzy.base.NoWord2ignore;
import fr.erias.iamsystem.fuzzy.base.SimpleWords2ignore;
import fr.erias.iamsystem.fuzzy.closestSubString.ClosestSubString;
import fr.erias.iamsystem.fuzzy.encoder.StringEncoderSyn;
import fr.erias.iamsystem.fuzzy.levenshtein.Levenshtein;
import fr.erias.iamsystem.fuzzy.normfun.WordNormalizer;
import fr.erias.iamsystem.fuzzy.troncation.PrefixTrie;
import fr.erias.iamsystem.fuzzy.troncation.Truncation;
import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.keywords.Keyword;
import fr.erias.iamsystem.matcher.Matcher;
import fr.erias.iamsystem.matcher.strategy.EMatchingStrategy;
import fr.erias.iamsystem.matcher.strategy.IMatchingStrategy;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.stopwords.NegativeStopwords;
import fr.erias.iamsystem.stopwords.NoStopwords;
import fr.erias.iamsystem.stopwords.Stopwords;
import fr.erias.iamsystem.stopwords.Word2KeepFuzzy;
import fr.erias.iamsystem.tokenize.ETokenizer;
import fr.erias.iamsystem.tokenize.INormalizeF;
import fr.erias.iamsystem.tokenize.ITokenizer;
import fr.erias.iamsystem.tokenize.OrderTokensTokenizer;
import fr.erias.iamsystem.tokenize.TokenizerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class MatcherBuilder {
    private ITokenizer tokenizer;
    private boolean orderTokens = false;
    private IStopwords stopwords;
    private Collection<IKeyword> keywords = new ArrayList<IKeyword>();
    private int w = 1;
    private boolean removeNestedAnnot = true;
    private IWord2ignore word2ignore = new NoWord2ignore();
    private List<String> shortForms = new ArrayList<String>();
    private List<String> longForms = new ArrayList<String>();
    private int minNbcharLeven;
    private int maxDistanceLeven;
    private Algorithm algorithmLeven;
    private boolean setNegativeStopwords = false;
    private int minPrefixLengthClosest = -1;
    private int maxDistanceClosest = -1;
    private int minNbCharTroncation;
    private int maxDistanceTroncation;
    private List<WordNormalizer> wordNormalizers = new ArrayList<WordNormalizer>();
    private List<FuzzyRegex> fuzzyRegex = new ArrayList<FuzzyRegex>();
    private List<StringEncoderSyn> stringEncoders = new ArrayList<StringEncoderSyn>();
    private IMatchingStrategy strategy = EMatchingStrategy.WindowStrategy.getInstance();

    public MatcherBuilder abbreviations(String shortForm, String longForm) {
        this.shortForms.add(shortForm);
        this.longForms.add(longForm);
        return this;
    }

    public Matcher build() {
        Iterator<ContextFreeAlgo> trie;
        ITokenizer tokenizer;
        ITokenizer iTokenizer = tokenizer = this.tokenizer != null ? this.tokenizer : TokenizerFactory.getTokenizer(ETokenizer.FRENCH);
        if (this.orderTokens) {
            tokenizer = new OrderTokensTokenizer(tokenizer);
        }
        IStopwords stopwords = this.stopwords != null ? this.stopwords : new NoStopwords();
        Matcher matcher = new Matcher(tokenizer, stopwords);
        matcher.setW(this.w);
        matcher.setRemoveNestedAnnot(this.removeNestedAnnot);
        matcher.addKeyword(this.keywords);
        matcher.setStrategy(this.strategy);
        if (this.setNegativeStopwords) {
            NegativeStopwords negativeStopwords = new NegativeStopwords();
            negativeStopwords.add(matcher.getUnigrams());
            matcher.setStopwords(negativeStopwords);
        }
        CacheFuzzyAlgos cache = new CacheFuzzyAlgos();
        matcher.addFuzzyAlgo(cache);
        if (this.algorithmLeven != null) {
            ITransducer<Candidate> transducer = Levenshtein.buildTransuder(this.maxDistanceLeven, matcher, this.algorithmLeven);
            Levenshtein leven = new Levenshtein("levenshtein", this.minNbcharLeven, transducer);
            leven.setWords2ignore(this.word2ignore);
            cache.addFuzzyAlgo(leven);
        }
        if (this.shortForms.size() != 0) {
            Abbreviations abbs = new Abbreviations("abbs");
            matcher.addFuzzyAlgo(abbs);
            for (int i = 0; i < this.shortForms.size(); ++i) {
                String shortForm = this.shortForms.get(i);
                String longForm = this.longForms.get(i);
                abbs.add(shortForm, longForm, matcher);
            }
        }
        if (this.minPrefixLengthClosest != -1) {
            trie = new PrefixTrie(this.minPrefixLengthClosest);
            ((PrefixTrie)((Object)trie)).addToken(matcher.getUnigrams());
            ClosestSubString closest = new ClosestSubString("closest", (PrefixTrie)((Object)trie), this.maxDistanceClosest);
            cache.addFuzzyAlgo(closest);
        }
        if (this.minNbCharTroncation != -1) {
            trie = new PrefixTrie(this.minPrefixLengthClosest);
            ((PrefixTrie)((Object)trie)).addToken(matcher.getUnigrams());
            Truncation troncation = new Truncation("troncation", (PrefixTrie)((Object)trie), this.maxDistanceTroncation);
            cache.addFuzzyAlgo(troncation);
        }
        for (StringEncoderSyn stringEncoder : this.stringEncoders) {
            cache.addFuzzyAlgo(stringEncoder);
            try {
                stringEncoder.add(matcher.getUnigrams());
            }
            catch (EncoderException e) {
                e.printStackTrace();
            }
        }
        for (WordNormalizer normalizer : this.wordNormalizers) {
            cache.addFuzzyAlgo(normalizer);
            normalizer.addWords(matcher.getUnigrams());
        }
        for (FuzzyRegex fuzzyRegex : this.fuzzyRegex) {
            matcher.addFuzzyAlgo(fuzzyRegex);
        }
        if (matcher.getStopwords() instanceof NegativeStopwords) {
            NegativeStopwords negativeStop = (NegativeStopwords)matcher.getStopwords();
            Word2KeepFuzzy words2keepFuzzy = new Word2KeepFuzzy(stopwords, matcher.getFuzzyAlgos());
            negativeStop.add(words2keepFuzzy);
        }
        return matcher;
    }

    public MatcherBuilder closestSubString(int minNbChar, int maxDistance) {
        this.minPrefixLengthClosest = minNbChar;
        this.maxDistanceClosest = maxDistance;
        return this;
    }

    public MatcherBuilder fuzzyRegex(String name, String pattern, String patternName) {
        FuzzyRegex fuzzy = new FuzzyRegex(name, pattern, patternName);
        this.fuzzyRegex.add(fuzzy);
        return this;
    }

    public MatcherBuilder keywords(IKeyword ... keywords) {
        for (IKeyword kw : keywords) {
            this.keywords.add(kw);
        }
        return this;
    }

    public MatcherBuilder keywords(Iterable<IKeyword> keywords) {
        for (IKeyword kw : keywords) {
            this.keywords.add(kw);
        }
        return this;
    }

    public MatcherBuilder keywords(String ... labels) {
        for (String label : labels) {
            Keyword kw = new Keyword(label);
            this.keywords.add(kw);
        }
        return this;
    }

    public MatcherBuilder levenshtein(int minNbChar, int maxDistance, Algorithm algorithm) {
        this.minNbcharLeven = minNbChar;
        this.maxDistanceLeven = maxDistance;
        this.algorithmLeven = algorithm;
        return this;
    }

    public MatcherBuilder negative(boolean negativeStopwords) {
        this.setNegativeStopwords = negativeStopwords;
        return this;
    }

    public MatcherBuilder orderTokens(boolean orderTokens) {
        this.orderTokens = orderTokens;
        return this;
    }

    public MatcherBuilder removeNestedAnnot(boolean removeNestedAnnot) {
        this.removeNestedAnnot = removeNestedAnnot;
        return this;
    }

    public MatcherBuilder stopwords(Collection<String> stopwords) {
        this.stopwords = new Stopwords(stopwords);
        return this;
    }

    public MatcherBuilder stopwords(IStopwords stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public MatcherBuilder stopwords(String ... words) {
        Stopwords stopwords = new Stopwords();
        for (String stopword : words) {
            stopwords.add(stopword);
        }
        this.stopwords = stopwords;
        return this;
    }

    public MatcherBuilder strategy(EMatchingStrategy strategy) {
        this.strategy = strategy.getInstance();
        return this;
    }

    public MatcherBuilder strategy(IMatchingStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public MatcherBuilder stringDistanceWords2ignore(Collection<String> words2ignore) {
        this.word2ignore = new SimpleWords2ignore(words2ignore);
        return this;
    }

    public MatcherBuilder stringEncoder(StringEncoder stringEncoder, int minNbChar) {
        StringEncoderSyn encoder = new StringEncoderSyn(stringEncoder, minNbChar);
        this.stringEncoders.add(encoder);
        return this;
    }

    public MatcherBuilder tokenizer(ITokenizer tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public MatcherBuilder troncation(int minNbChar, int maxDistance) {
        this.minNbCharTroncation = minNbChar;
        this.maxDistanceTroncation = maxDistance;
        return this;
    }

    public MatcherBuilder w(int w) {
        this.w = w;
        return this;
    }

    public MatcherBuilder wordNormalizer(String name, INormalizeF normfun) {
        WordNormalizer normalizer = new WordNormalizer(name, normfun);
        this.wordNormalizers.add(normalizer);
        return this;
    }
}

