/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher;

import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tree.INode;
import java.util.Collection;

public class StateTransition {
    private final INode node;
    private final StateTransition previousTrans;
    private final Collection<String> algos;
    private final IToken token;
    private final int countNotStopword;

    public static StateTransition createFristTrans(INode initialState) {
        return new StateTransition(null, initialState, null, null, -1);
    }

    public static boolean isFirstTrans(StateTransition trans) {
        return trans.previousTrans == null;
    }

    public StateTransition(StateTransition previousTrans, INode node, IToken token, Collection<String> algos, int countNotStopword) {
        this.node = node;
        this.previousTrans = previousTrans;
        this.algos = algos;
        this.token = token;
        this.countNotStopword = countNotStopword;
    }

    public boolean equals(Object o) {
        StateTransition c = (StateTransition)o;
        return this.node.getNodeNumber() == c.node.getNodeNumber();
    }

    public Collection<String> getAlgos() {
        return this.algos;
    }

    public int getCountNotStopword() {
        return this.countNotStopword;
    }

    public int getId() {
        return this.node.getNodeNumber();
    }

    public INode getNode() {
        return this.node;
    }

    public StateTransition getPreviousTrans() {
        return this.previousTrans;
    }

    public IToken getToken() {
        return this.token;
    }

    public int hashCode() {
        return this.node.getNodeNumber();
    }

    public boolean isObsolete(int countNotStopWord, int w) {
        if (StateTransition.isFirstTrans(this)) {
            return false;
        }
        int distance2currentToken = countNotStopWord - this.countNotStopword;
        return w - distance2currentToken < 0;
    }
}

