/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher.strategy;

import fr.erias.iamsystem.annotation.Annotation;
import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.fuzzy.base.ISynsProvider;
import fr.erias.iamsystem.fuzzy.base.SynAlgos;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.matcher.strategy.IMatchingStrategy;
import fr.erias.iamsystem.matcher.strategy.StrategyUtils;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LargeWindowMatching
implements IMatchingStrategy {
    private INode initialState = null;
    private final Map<Integer, StateTransition> transitions = new HashMap<Integer, StateTransition>();
    private final Map<String, Set<Integer>> availableTransitions = new HashMap<String, Set<Integer>>();

    private void addTransition(StateTransition state, Map<String, Set<Integer>> availableTransitions) {
        Set<String> childTokens = this.getChildTokens(state.getNode());
        childTokens.stream().forEach(token -> {
            if (!availableTransitions.containsKey(token)) {
                availableTransitions.put((String)token, new HashSet());
            }
            ((Set)availableTransitions.get(token)).add(state.getId());
        });
    }

    @Override
    public List<IAnnotation> detect(List<IToken> tokens, int w, INode initialState, ISynsProvider synsProvider, IStopwords stopwords) {
        if (initialState == null || this.initialState != initialState) {
            this.initialize(initialState);
        }
        ArrayList<IAnnotation> annots = new ArrayList<IAnnotation>();
        int countNotStopWord = 0;
        ArrayList<IToken> stopTokens = new ArrayList<IToken>();
        HashSet<StateTransition> newTransitions = new HashSet<StateTransition>();
        HashMap<Integer, StateTransition> transitionsCopy = new HashMap<Integer, StateTransition>(this.transitions);
        HashMap<String, Set<Integer>> availableTransitionsCopy = new HashMap<String, Set<Integer>>(this.availableTransitions);
        for (IToken token : tokens) {
            if (stopwords.isTokenAStopword(token)) {
                stopTokens.add(token);
                continue;
            }
            newTransitions.clear();
            ++countNotStopWord;
            Collection<SynAlgos> synAlgos = synsProvider.getSynonyms(tokens, token, transitionsCopy.values());
            for (SynAlgos synAlgo : synAlgos) {
                String firstSynToken = synAlgo.getSynToken()[0];
                if (!availableTransitionsCopy.containsKey(firstSynToken)) continue;
                Set transitionsId = (Set)availableTransitionsCopy.get(firstSynToken);
                HashSet<Integer> newTransId = new HashSet<Integer>();
                Iterator iterator = transitionsId.iterator();
                while (iterator.hasNext()) {
                    int transId = (Integer)iterator.next();
                    if (!transitionsCopy.containsKey(transId)) continue;
                    StateTransition trans = (StateTransition)transitionsCopy.get(transId);
                    if (trans.isObsolete(countNotStopWord, w)) {
                        transitionsCopy.remove(transId);
                        continue;
                    }
                    newTransId.add(transId);
                    INode node = trans.getNode().gotoNode(synAlgo.getSynToken());
                    if (node == EmptyNode.EMPTYNODE) continue;
                    StateTransition nextTrans = new StateTransition(trans, node, token, synAlgo.getAlgos(), countNotStopWord);
                    newTransitions.add(nextTrans);
                }
                availableTransitionsCopy.put(firstSynToken, newTransId);
            }
            for (StateTransition trans : newTransitions) {
                StateTransition oldtrans;
                if (trans.getNode().isAfinalState() && ((oldtrans = (StateTransition)transitionsCopy.get(trans.getId())) == null || oldtrans.isObsolete(countNotStopWord, w))) {
                    Annotation annot = StrategyUtils.createAnnot(trans, stopTokens);
                    annots.add(annot);
                }
                this.addTransition(trans, availableTransitionsCopy);
                transitionsCopy.put(trans.getId(), trans);
            }
        }
        return annots;
    }

    private Set<String> getChildTokens(INode node) {
        return node.getChildrenNodes().stream().map(childNode -> childNode.getToken()).collect(Collectors.toSet());
    }

    private void initialize(INode initialState) {
        StateTransition firstTrans = StateTransition.createFristTrans(initialState);
        this.transitions.put(firstTrans.getId(), firstTrans);
        this.addTransition(firstTrans, this.availableTransitions);
    }
}

