/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher.strategy;

import fr.erias.iamsystem.annotation.Annotation;
import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.fuzzy.base.ISynsProvider;
import fr.erias.iamsystem.fuzzy.base.SynAlgos;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.matcher.strategy.IMatchingStrategy;
import fr.erias.iamsystem.matcher.strategy.StrategyUtils;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.Token;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NoOverlapMatching
implements IMatchingStrategy {
    private static final Token END_TOKEN = new Token(-1, -1, "IAMSYSTEM_END_TOKEN", "IAMSYSTEM_END_TOKEN", -1);

    private int addAnnots(List<IAnnotation> annots, Set<StateTransition> transitions, int startedAt, List<IToken> stopTokens) {
        int lastAnnotI = -1;
        Iterator<StateTransition> iterator = transitions.iterator();
        while (iterator.hasNext()) {
            StateTransition trans;
            StateTransition currentTrans = trans = iterator.next();
            while (!currentTrans.getNode().isAfinalState() && !StateTransition.isFirstTrans(currentTrans = currentTrans.getPreviousTrans())) {
            }
            if (!currentTrans.getNode().isAfinalState()) continue;
            Annotation annotation = StrategyUtils.createAnnot(currentTrans, stopTokens);
            annots.add(annotation);
            lastAnnotI = Math.max(annotation.end_i(), lastAnnotI);
        }
        return Math.max(startedAt, lastAnnotI);
    }

    @Override
    public List<IAnnotation> detect(List<IToken> tokens, int w, INode initialState, ISynsProvider synsProvider, IStopwords stopwords) {
        ArrayList<IAnnotation> annots = new ArrayList<IAnnotation>();
        HashSet<StateTransition> transitions = new HashSet<StateTransition>();
        StateTransition firstTrans = StateTransition.createFristTrans(initialState);
        transitions.add(firstTrans);
        ArrayList<IToken> stopTokens = new ArrayList<IToken>();
        int i = 0;
        int startedAt = 0;
        while (i < tokens.size() + 1) {
            Token token;
            IToken iToken = token = i == tokens.size() ? END_TOKEN : tokens.get(i);
            if (stopwords.isTokenAStopword(token)) {
                stopTokens.add(token);
                ++i;
                ++startedAt;
                continue;
            }
            HashSet<StateTransition> newTransitions = new HashSet<StateTransition>();
            Collection<SynAlgos> synAlgos = synsProvider.getSynonyms(tokens, token, transitions);
            for (StateTransition trans : transitions) {
                for (SynAlgos synAlgo : synAlgos) {
                    INode node = trans.getNode().gotoNode(synAlgo.getSynToken());
                    if (node == EmptyNode.EMPTYNODE) continue;
                    StateTransition nextTrans = new StateTransition(trans, node, token, synAlgo.getAlgos(), -1);
                    newTransitions.add(nextTrans);
                }
            }
            if (newTransitions.size() != 0) {
                transitions = newTransitions;
                ++i;
                continue;
            }
            if (transitions.size() == 1 && transitions.contains(firstTrans)) {
                ++i;
                ++startedAt;
                continue;
            }
            int lastI = this.addAnnots(annots, transitions, startedAt, stopTokens);
            i = lastI + 1;
            ++startedAt;
            transitions.clear();
            transitions.add(firstTrans);
        }
        annots.sort(Comparator.naturalOrder());
        return annots;
    }
}

