/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher.strategy;

import fr.erias.iamsystem.annotation.Annotation;
import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.annotation.Span;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.tokenize.IOffsets;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tree.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StrategyUtils {
    public static Annotation createAnnot(StateTransition last_el, List<IToken> stopTokens) {
        List<StateTransition> transStates = StrategyUtils.toList(last_el);
        INode lastState = last_el.getNode();
        List<IToken> tokens = transStates.stream().map(t -> t.getToken()).collect(Collectors.toList());
        tokens.sort(Comparator.naturalOrder());
        List<Collection<String>> algos = transStates.stream().map(t -> t.getAlgos()).collect(Collectors.toList());
        return new Annotation(tokens, algos, lastState, stopTokens);
    }

    public static List<IAnnotation> rmNestedAnnots(List<IAnnotation> annots, boolean keepAncestors) {
        HashSet<Integer> ancestIndices = new HashSet<Integer>();
        HashSet<Integer> shortIndices = new HashSet<Integer>();
        block0: for (int i2 = 0; i2 < annots.size(); ++i2) {
            IAnnotation annot = annots.get(i2);
            for (int y = i2 + 1; y < annots.size(); ++y) {
                if (shortIndices.contains(y)) continue;
                IAnnotation other = annots.get(y);
                if (!IOffsets.offsetsOverlap(annot, other)) continue block0;
                if (Span.isShorterSpanOf(annot, other)) {
                    shortIndices.add(i2);
                    if (IAnnotation.isAncestorAnnotOf(annot, other)) {
                        ancestIndices.add(i2);
                    }
                }
                if (!Span.isShorterSpanOf(other, annot)) continue;
                shortIndices.add(y);
            }
        }
        Set<Object> indices2remove = !keepAncestors ? shortIndices : shortIndices.stream().filter(i -> !ancestIndices.contains(i)).collect(Collectors.toSet());
        ArrayList<IAnnotation> annots2keep = new ArrayList<IAnnotation>(annots.size() - indices2remove.size());
        for (int i3 = 0; i3 < annots.size(); ++i3) {
            if (indices2remove.contains(i3)) continue;
            annots2keep.add(annots.get(i3));
        }
        return annots2keep;
    }

    private static List<StateTransition> toList(StateTransition last_el) {
        ArrayList<StateTransition> transStates = new ArrayList<StateTransition>();
        transStates.add(last_el);
        StateTransition parent = last_el.getPreviousTrans();
        while (!StateTransition.isFirstTrans(parent)) {
            transStates.add(parent);
            parent = parent.getPreviousTrans();
        }
        Collections.reverse(transStates);
        return transStates;
    }
}

