/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.matcher.strategy;

import fr.erias.iamsystem.annotation.Annotation;
import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.fuzzy.base.ISynsProvider;
import fr.erias.iamsystem.fuzzy.base.SynAlgos;
import fr.erias.iamsystem.matcher.StateTransition;
import fr.erias.iamsystem.matcher.strategy.IMatchingStrategy;
import fr.erias.iamsystem.matcher.strategy.StrategyUtils;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class WindowMatching
implements IMatchingStrategy {
    @Override
    public List<IAnnotation> detect(List<IToken> tokens, int w, INode initialState, ISynsProvider synsProvider, IStopwords stopwords) {
        ArrayList<IAnnotation> annots = new ArrayList<IAnnotation>();
        HashSet<StateTransition> transitions = new HashSet<StateTransition>();
        StateTransition fistTrans = StateTransition.createFristTrans(initialState);
        transitions.add(fistTrans);
        int countNotStopword = 0;
        ArrayList<IToken> stopTokens = new ArrayList<IToken>();
        ArrayList<StateTransition> newTransitions = new ArrayList<StateTransition>();
        ArrayList<StateTransition> trans2remove = new ArrayList<StateTransition>();
        for (IToken token : tokens) {
            if (stopwords.isTokenAStopword(token)) {
                stopTokens.add(token);
                continue;
            }
            newTransitions.clear();
            trans2remove.clear();
            ++countNotStopword;
            Collection<SynAlgos> synAlgos = synsProvider.getSynonyms(tokens, token, transitions);
            for (StateTransition trans : transitions) {
                if (trans.isObsolete(countNotStopword, w)) {
                    trans2remove.add(trans);
                    continue;
                }
                for (SynAlgos synAlgo : synAlgos) {
                    INode node = trans.getNode().gotoNode(synAlgo.getSynToken());
                    if (node == EmptyNode.EMPTYNODE) continue;
                    StateTransition nextTrans = new StateTransition(trans, node, token, synAlgo.getAlgos(), countNotStopword);
                    newTransitions.add(nextTrans);
                    if (!node.isAfinalState() || transitions.contains(nextTrans)) continue;
                    Annotation annotation = StrategyUtils.createAnnot(nextTrans, stopTokens);
                    annots.add(annotation);
                }
            }
            for (StateTransition trans : trans2remove) {
                transitions.remove(trans);
            }
            for (StateTransition trans : newTransitions) {
                if (transitions.contains(trans)) {
                    transitions.remove(trans);
                }
                transitions.add(trans);
            }
        }
        annots.sort(Comparator.naturalOrder());
        return annots;
    }
}

