/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.stopwords;

import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.stopwords.IWord2keepF;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NegativeStopwords
implements IStopwords {
    private Set<String> words2keep = new HashSet<String>();
    private List<IWord2keepF> funs = new ArrayList<IWord2keepF>();

    public NegativeStopwords() {
    }

    public NegativeStopwords(Collection<String> words2keep) {
        this.add(words2keep);
    }

    public void add(Collection<String> words) {
        words.forEach(w -> this.words2keep.add((String)w));
    }

    public void add(IWord2keepF word2keepFunction) {
        this.funs.add(word2keepFunction);
    }

    public boolean isAtoken2keep(IToken token) {
        return this.words2keep.contains(token.normLabel()) || this.funs.stream().anyMatch(f -> f.isAword2keep(token));
    }

    @Override
    public boolean isTokenAStopword(IToken token) {
        return !this.isAtoken2keep(token);
    }
}

