/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.stopwords;

import fr.erias.iamsystem.fuzzy.CacheFuzzyAlgos;
import fr.erias.iamsystem.fuzzy.ExactMatch;
import fr.erias.iamsystem.fuzzy.base.ContextFreeAlgo;
import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.stopwords.IStopwords;
import fr.erias.iamsystem.stopwords.IWord2keepF;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class Word2KeepFuzzy
implements IWord2keepF {
    private final List<ContextFreeAlgo> contextFreeAlgos = new ArrayList<ContextFreeAlgo>();
    private final List<CacheFuzzyAlgos> caches = new ArrayList<CacheFuzzyAlgos>();
    private final IStopwords stopwords;

    public Word2KeepFuzzy(IStopwords stopwords, Iterable<FuzzyAlgo> fuzzyAlgos) {
        this.stopwords = stopwords;
        for (FuzzyAlgo algo : fuzzyAlgos) {
            if (algo instanceof CacheFuzzyAlgos) {
                this.caches.add((CacheFuzzyAlgos)algo);
            }
            if (!(algo instanceof ContextFreeAlgo) || algo instanceof ExactMatch) continue;
            this.contextFreeAlgos.add((ContextFreeAlgo)algo);
        }
    }

    @Override
    public boolean isAword2keep(IToken token) {
        if (this.stopwords.isTokenAStopword(token)) {
            return false;
        }
        List synsContextFreeAlgos = this.contextFreeAlgos.stream().map(algo -> algo.getSynonyms(token)).flatMap(Collection::stream).filter(synalgo -> synalgo != FuzzyAlgo.NO_SYN).collect(Collectors.toList());
        List synsCaches = this.caches.stream().map(algo -> algo.getSynonyms(token)).flatMap(Collection::stream).filter(synalgo -> synalgo != FuzzyAlgo.NO_SYN).collect(Collectors.toList());
        return synsContextFreeAlgos.size() != 0 || synsCaches.size() != 0;
    }
}

