/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.tokenize;

import java.util.Collection;
import java.util.stream.Collectors;

public interface IOffsets {
    public static int getMaxEnd(Collection<? extends IOffsets> offsets) {
        return offsets.stream().map(o -> o.end()).reduce(Math::max).get();
    }

    public static int getMinStart(Collection<? extends IOffsets> offsets) {
        return offsets.stream().map(o -> o.start()).reduce(Math::min).get();
    }

    public static String getSpanSeqId(Collection<? extends IOffsets> offsets) {
        return offsets.stream().map(o -> String.format("(%d,%d)", o.start(), o.end())).collect(Collectors.joining(";"));
    }

    public static boolean offsetsOverlap(IOffsets a, IOffsets b) {
        if (a == b) {
            return false;
        }
        return b.start() <= a.start() && a.start() <= b.end() || a.start() <= b.start() && b.start() <= a.end();
    }

    public int end();

    public int start();
}

