/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.tokenize;

import fr.erias.iamsystem.tokenize.INormalizeF;
import fr.erias.iamsystem.tokenize.IOffsets;
import fr.erias.iamsystem.tokenize.ISplitF;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.ITokenizer;
import fr.erias.iamsystem.tokenize.Token;
import java.util.Arrays;
import java.util.List;

public class TokenizerImp
implements ITokenizer {
    private final INormalizeF normalizeF;
    private final ISplitF splitF;

    public TokenizerImp(INormalizeF normalizeF, ISplitF splitF) {
        this.normalizeF = normalizeF;
        this.splitF = splitF;
    }

    @Override
    public List<IToken> tokenize(String text) {
        List<IOffsets> offsets = this.splitF.split(text);
        Token[] tokens = new Token[offsets.size()];
        for (int i = 0; i < offsets.size(); ++i) {
            Token token;
            IOffsets offset = offsets.get(i);
            int start = offset.start();
            int end = offset.end();
            String label = text.substring(start, end);
            String norm_label = this.normalizeF.normalize(label);
            tokens[i] = token = new Token(start, end, label, norm_label, i);
        }
        return Arrays.asList(tokens);
    }
}

