/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.tree;

import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import fr.erias.iamsystem.tree.Trie;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node
implements INode {
    private final INode parentNode;
    private final int nodeNumber;
    private final String token;
    private List<IKeyword> keywords = null;
    private final Map<String, INode> childNodes = new HashMap<String, INode>();

    public Node(String token, INode parentNode, int nodeNumber) {
        this.token = token;
        this.parentNode = parentNode;
        this.nodeNumber = nodeNumber;
        parentNode.addChildNode(this);
    }

    Node(String token, int nodeNumber) {
        this.token = token;
        this.parentNode = null;
        this.nodeNumber = nodeNumber;
    }

    @Override
    public void addChildNode(INode childNode) {
        String token = childNode.getToken();
        this.childNodes.put(token, childNode);
    }

    @Override
    public void addKeyword(IKeyword keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<IKeyword>(0);
        }
        this.keywords.add(keyword);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node c = (Node)o;
        return this.getNodeNumber() == c.getNodeNumber();
    }

    @Override
    public Collection<INode> getAncestors() {
        ArrayList<INode> ancestors = new ArrayList<INode>();
        INode ancest = this.parentNode;
        while (!Trie.isTheRootNode(ancest)) {
            ancestors.add(ancest);
            ancest = ancest.getParentNode();
        }
        return ancestors;
    }

    @Override
    public Collection<INode> getChildrenNodes() {
        return this.childNodes.values();
    }

    @Override
    public Collection<IKeyword> getKeywords() {
        if (this.keywords == null) {
            throw new InaccessibleObjectException("Can't access Keywords if not a final state");
        }
        return this.keywords;
    }

    @Override
    public int getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public INode getParentNode() {
        return this.parentNode;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public List<String> getTokenSequence() {
        ArrayList<String> sequence = new ArrayList<String>();
        sequence.add(this.token);
        INode currentNode = this;
        INode parentNode = null;
        while (!Trie.isTheRootNode(parentNode = currentNode.getParentNode())) {
            sequence.add(parentNode.getToken());
            currentNode = parentNode;
        }
        Collections.reverse(sequence);
        return sequence;
    }

    @Override
    public INode gotoNode(List<String> tokens) {
        INode node = this;
        for (String token : tokens) {
            node = node.gotoNode(token);
        }
        return node;
    }

    @Override
    public INode gotoNode(String token) {
        return this.childNodes.getOrDefault(token, EmptyNode.EMPTYNODE);
    }

    @Override
    public INode gotoNode(String[] tokens) {
        INode node = this;
        for (String token : tokens) {
            node = node.gotoNode(token);
        }
        return node;
    }

    public int hashCode() {
        return this.getNodeNumber();
    }

    @Override
    public boolean hasTransitionTo(String token) {
        return this.childNodes.containsKey(token);
    }

    @Override
    public boolean isAfinalState() {
        return this.keywords != null;
    }

    public String toString() {
        List<String> sequence = this.getTokenSequence();
        return sequence.toString();
    }
}

