/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.tree;

import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.keywords.Keyword;
import fr.erias.iamsystem.tokenize.ITokenizerStopwords;
import fr.erias.iamsystem.tree.EmptyNode;
import fr.erias.iamsystem.tree.INode;
import fr.erias.iamsystem.tree.Node;
import java.util.List;
import java.util.stream.Collectors;

public class Trie {
    public static final int nodeRootNumber = 0;
    private final Node rootNode = this.buildRootNode();
    private int nodeNumber = 1;

    public static boolean isTheEmptyNode(INode node) {
        return node == EmptyNode.EMPTYNODE;
    }

    public static boolean isTheRootNode(INode node) {
        return node.getNodeNumber() == 0;
    }

    public void addIKeyword(IKeyword keyword, ITokenizerStopwords tokstop) {
        List<String> stringSeq = ITokenizerStopwords.tokenizeRmStopwords(keyword.label(), tokstop).stream().map(token -> token.normLabel()).collect(Collectors.toList());
        this.addIKeyword(keyword, stringSeq);
    }

    public void addIKeyword(IKeyword keyword, List<String> stringSeq) {
        if (stringSeq.size() == 0) {
            return;
        }
        INode currentNode = this.rootNode;
        for (String normLabel : stringSeq) {
            if (currentNode.hasTransitionTo(normLabel)) {
                currentNode = currentNode.gotoNode(normLabel);
                continue;
            }
            Node newNode = new Node(normLabel, currentNode, this.nodeNumber);
            ++this.nodeNumber;
            currentNode = newNode;
        }
        currentNode.addKeyword(keyword);
    }

    public void addKeyword(String keyword, ITokenizerStopwords tokstop) {
        Keyword kw = new Keyword(keyword);
        this.addIKeyword((IKeyword)kw, tokstop);
    }

    public void addKeywords(Iterable<? extends IKeyword> keywords, ITokenizerStopwords tokstop) {
        for (IKeyword iKeyword : keywords) {
            this.addIKeyword(iKeyword, tokstop);
        }
    }

    protected Node buildRootNode() {
        return new Node("START_TOKEN", 0);
    }

    public Node getInitialState() {
        return this.rootNode;
    }

    public int getNumberOfNodes() {
        return this.nodeNumber;
    }
}

