/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package fr.flowarg.materialdesignfontfx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 *
 * Icon Enum based on Material Design Icons v7.2.96
 * https://materialdesignicons.com
 *
 * @author Jens Deters (mail@jensd.de)
 */
public class MaterialDesignIcon
{

    public enum A implements MaterialDesignIconGlyphs<A> {

        AB_TESTING(new String(Character.toChars(0xF01C9))),
        ABACUS(new String(Character.toChars(0xF16E0))),
        ABJAD_ARABIC(new String(Character.toChars(0xF1328))),
        ABJAD_HEBREW(new String(Character.toChars(0xF1329))),
        ABUGIDA_DEVANAGARI(new String(Character.toChars(0xF132A))),
        ABUGIDA_THAI(new String(Character.toChars(0xF132B))),
        ACCESS_POINT(new String(Character.toChars(0xF0003))),
        ACCESS_POINT_CHECK(new String(Character.toChars(0xF1538))),
        ACCESS_POINT_MINUS(new String(Character.toChars(0xF1539))),
        ACCESS_POINT_NETWORK(new String(Character.toChars(0xF0002))),
        ACCESS_POINT_NETWORK_OFF(new String(Character.toChars(0xF0BE1))),
        ACCESS_POINT_OFF(new String(Character.toChars(0xF1511))),
        ACCESS_POINT_PLUS(new String(Character.toChars(0xF153A))),
        ACCESS_POINT_REMOVE(new String(Character.toChars(0xF153B))),
        ACCOUNT(new String(Character.toChars(0xF0004))),
        ACCOUNT_ALERT(new String(Character.toChars(0xF0005))),
        ACCOUNT_ALERT_OUTLINE(new String(Character.toChars(0xF0B50))),
        ACCOUNT_ARROW_DOWN(new String(Character.toChars(0xF1868))),
        ACCOUNT_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF1869))),
        ACCOUNT_ARROW_LEFT(new String(Character.toChars(0xF0B51))),
        ACCOUNT_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF0B52))),
        ACCOUNT_ARROW_RIGHT(new String(Character.toChars(0xF0B53))),
        ACCOUNT_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF0B54))),
        ACCOUNT_ARROW_UP(new String(Character.toChars(0xF1867))),
        ACCOUNT_ARROW_UP_OUTLINE(new String(Character.toChars(0xF186A))),
        ACCOUNT_BADGE(new String(Character.toChars(0xF1B0A))),
        ACCOUNT_BADGE_OUTLINE(new String(Character.toChars(0xF1B0B))),
        ACCOUNT_BOX(new String(Character.toChars(0xF0006))),
        ACCOUNT_BOX_MULTIPLE(new String(Character.toChars(0xF0934))),
        ACCOUNT_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF100A))),
        ACCOUNT_BOX_OUTLINE(new String(Character.toChars(0xF0007))),
        ACCOUNT_CANCEL(new String(Character.toChars(0xF12DF))),
        ACCOUNT_CANCEL_OUTLINE(new String(Character.toChars(0xF12E0))),
        ACCOUNT_CARD(new String(Character.toChars(0xF1BA4))),
        ACCOUNT_CARD_OUTLINE(new String(Character.toChars(0xF1BA5))),
        ACCOUNT_CASH(new String(Character.toChars(0xF1097))),
        ACCOUNT_CASH_OUTLINE(new String(Character.toChars(0xF1098))),
        ACCOUNT_CHECK(new String(Character.toChars(0xF0008))),
        ACCOUNT_CHECK_OUTLINE(new String(Character.toChars(0xF0BE2))),
        ACCOUNT_CHILD(new String(Character.toChars(0xF0A89))),
        ACCOUNT_CHILD_CIRCLE(new String(Character.toChars(0xF0A8A))),
        ACCOUNT_CHILD_OUTLINE(new String(Character.toChars(0xF10C8))),
        ACCOUNT_CIRCLE(new String(Character.toChars(0xF0009))),
        ACCOUNT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B55))),
        ACCOUNT_CLOCK(new String(Character.toChars(0xF0B56))),
        ACCOUNT_CLOCK_OUTLINE(new String(Character.toChars(0xF0B57))),
        ACCOUNT_COG(new String(Character.toChars(0xF1370))),
        ACCOUNT_COG_OUTLINE(new String(Character.toChars(0xF1371))),
        ACCOUNT_CONVERT(new String(Character.toChars(0xF000A))),
        ACCOUNT_CONVERT_OUTLINE(new String(Character.toChars(0xF1301))),
        ACCOUNT_COWBOY_HAT(new String(Character.toChars(0xF0E9B))),
        ACCOUNT_COWBOY_HAT_OUTLINE(new String(Character.toChars(0xF17F3))),
        ACCOUNT_CREDIT_CARD(new String(Character.toChars(0xF1BA6))),
        ACCOUNT_CREDIT_CARD_OUTLINE(new String(Character.toChars(0xF1BA7))),
        ACCOUNT_DETAILS(new String(Character.toChars(0xF0631))),
        ACCOUNT_DETAILS_OUTLINE(new String(Character.toChars(0xF1372))),
        ACCOUNT_EDIT(new String(Character.toChars(0xF06BC))),
        ACCOUNT_EDIT_OUTLINE(new String(Character.toChars(0xF0FFB))),
        ACCOUNT_EYE(new String(Character.toChars(0xF0420))),
        ACCOUNT_EYE_OUTLINE(new String(Character.toChars(0xF127B))),
        ACCOUNT_FILTER(new String(Character.toChars(0xF0936))),
        ACCOUNT_FILTER_OUTLINE(new String(Character.toChars(0xF0F9D))),
        ACCOUNT_GROUP(new String(Character.toChars(0xF0849))),
        ACCOUNT_GROUP_OUTLINE(new String(Character.toChars(0xF0B58))),
        ACCOUNT_HARD_HAT(new String(Character.toChars(0xF05B5))),
        ACCOUNT_HARD_HAT_OUTLINE(new String(Character.toChars(0xF1A1F))),
        ACCOUNT_HEART(new String(Character.toChars(0xF0899))),
        ACCOUNT_HEART_OUTLINE(new String(Character.toChars(0xF0BE3))),
        ACCOUNT_INJURY(new String(Character.toChars(0xF1815))),
        ACCOUNT_INJURY_OUTLINE(new String(Character.toChars(0xF1816))),
        ACCOUNT_KEY(new String(Character.toChars(0xF000B))),
        ACCOUNT_KEY_OUTLINE(new String(Character.toChars(0xF0BE4))),
        ACCOUNT_LOCK(new String(Character.toChars(0xF115E))),
        ACCOUNT_LOCK_OPEN(new String(Character.toChars(0xF1960))),
        ACCOUNT_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1961))),
        ACCOUNT_LOCK_OUTLINE(new String(Character.toChars(0xF115F))),
        ACCOUNT_MINUS(new String(Character.toChars(0xF000D))),
        ACCOUNT_MINUS_OUTLINE(new String(Character.toChars(0xF0AEC))),
        ACCOUNT_MULTIPLE(new String(Character.toChars(0xF000E))),
        ACCOUNT_MULTIPLE_CHECK(new String(Character.toChars(0xF08C5))),
        ACCOUNT_MULTIPLE_CHECK_OUTLINE(new String(Character.toChars(0xF11FE))),
        ACCOUNT_MULTIPLE_MINUS(new String(Character.toChars(0xF05D3))),
        ACCOUNT_MULTIPLE_MINUS_OUTLINE(new String(Character.toChars(0xF0BE5))),
        ACCOUNT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF000F))),
        ACCOUNT_MULTIPLE_PLUS(new String(Character.toChars(0xF0010))),
        ACCOUNT_MULTIPLE_PLUS_OUTLINE(new String(Character.toChars(0xF0800))),
        ACCOUNT_MULTIPLE_REMOVE(new String(Character.toChars(0xF120A))),
        ACCOUNT_MULTIPLE_REMOVE_OUTLINE(new String(Character.toChars(0xF120B))),
        ACCOUNT_MUSIC(new String(Character.toChars(0xF0803))),
        ACCOUNT_MUSIC_OUTLINE(new String(Character.toChars(0xF0CE9))),
        ACCOUNT_NETWORK(new String(Character.toChars(0xF0011))),
        ACCOUNT_NETWORK_OFF(new String(Character.toChars(0xF1AF1))),
        ACCOUNT_NETWORK_OFF_OUTLINE(new String(Character.toChars(0xF1AF2))),
        ACCOUNT_NETWORK_OUTLINE(new String(Character.toChars(0xF0BE6))),
        ACCOUNT_OFF(new String(Character.toChars(0xF0012))),
        ACCOUNT_OFF_OUTLINE(new String(Character.toChars(0xF0BE7))),
        ACCOUNT_OUTLINE(new String(Character.toChars(0xF0013))),
        ACCOUNT_PLUS(new String(Character.toChars(0xF0014))),
        ACCOUNT_PLUS_OUTLINE(new String(Character.toChars(0xF0801))),
        ACCOUNT_QUESTION(new String(Character.toChars(0xF0B59))),
        ACCOUNT_QUESTION_OUTLINE(new String(Character.toChars(0xF0B5A))),
        ACCOUNT_REACTIVATE(new String(Character.toChars(0xF152B))),
        ACCOUNT_REACTIVATE_OUTLINE(new String(Character.toChars(0xF152C))),
        ACCOUNT_REMOVE(new String(Character.toChars(0xF0015))),
        ACCOUNT_REMOVE_OUTLINE(new String(Character.toChars(0xF0AED))),
        ACCOUNT_SCHOOL(new String(Character.toChars(0xF1A20))),
        ACCOUNT_SCHOOL_OUTLINE(new String(Character.toChars(0xF1A21))),
        ACCOUNT_SEARCH(new String(Character.toChars(0xF0016))),
        ACCOUNT_SEARCH_OUTLINE(new String(Character.toChars(0xF0935))),
        ACCOUNT_SETTINGS(new String(Character.toChars(0xF0630))),
        ACCOUNT_SETTINGS_OUTLINE(new String(Character.toChars(0xF10C9))),
        ACCOUNT_STAR(new String(Character.toChars(0xF0017))),
        ACCOUNT_STAR_OUTLINE(new String(Character.toChars(0xF0BE8))),
        ACCOUNT_SUPERVISOR(new String(Character.toChars(0xF0A8B))),
        ACCOUNT_SUPERVISOR_CIRCLE(new String(Character.toChars(0xF0A8C))),
        ACCOUNT_SUPERVISOR_CIRCLE_OUTLINE(new String(Character.toChars(0xF14EC))),
        ACCOUNT_SUPERVISOR_OUTLINE(new String(Character.toChars(0xF112D))),
        ACCOUNT_SWITCH(new String(Character.toChars(0xF0019))),
        ACCOUNT_SWITCH_OUTLINE(new String(Character.toChars(0xF04CB))),
        ACCOUNT_SYNC(new String(Character.toChars(0xF191B))),
        ACCOUNT_SYNC_OUTLINE(new String(Character.toChars(0xF191C))),
        ACCOUNT_TAG(new String(Character.toChars(0xF1C1B))),
        ACCOUNT_TAG_OUTLINE(new String(Character.toChars(0xF1C1C))),
        ACCOUNT_TIE(new String(Character.toChars(0xF0CE3))),
        ACCOUNT_TIE_HAT(new String(Character.toChars(0xF1898))),
        ACCOUNT_TIE_HAT_OUTLINE(new String(Character.toChars(0xF1899))),
        ACCOUNT_TIE_OUTLINE(new String(Character.toChars(0xF10CA))),
        ACCOUNT_TIE_VOICE(new String(Character.toChars(0xF1308))),
        ACCOUNT_TIE_VOICE_OFF(new String(Character.toChars(0xF130A))),
        ACCOUNT_TIE_VOICE_OFF_OUTLINE(new String(Character.toChars(0xF130B))),
        ACCOUNT_TIE_VOICE_OUTLINE(new String(Character.toChars(0xF1309))),
        ACCOUNT_TIE_WOMAN(new String(Character.toChars(0xF1A8C))),
        ACCOUNT_VOICE(new String(Character.toChars(0xF05CB))),
        ACCOUNT_VOICE_OFF(new String(Character.toChars(0xF0ED4))),
        ACCOUNT_WRENCH(new String(Character.toChars(0xF189A))),
        ACCOUNT_WRENCH_OUTLINE(new String(Character.toChars(0xF189B))),
        ADJUST(new String(Character.toChars(0xF001A))),
        ADVERTISEMENTS(new String(Character.toChars(0xF192A))),
        ADVERTISEMENTS_OFF(new String(Character.toChars(0xF192B))),
        AIR_CONDITIONER(new String(Character.toChars(0xF001B))),
        AIR_FILTER(new String(Character.toChars(0xF0D43))),
        AIR_HORN(new String(Character.toChars(0xF0DAC))),
        AIR_HUMIDIFIER(new String(Character.toChars(0xF1099))),
        AIR_HUMIDIFIER_OFF(new String(Character.toChars(0xF1466))),
        AIR_PURIFIER(new String(Character.toChars(0xF0D44))),
        AIR_PURIFIER_OFF(new String(Character.toChars(0xF1B57))),
        AIRBAG(new String(Character.toChars(0xF0BE9))),
        AIRBALLOON(new String(Character.toChars(0xF001C))),
        AIRBALLOON_OUTLINE(new String(Character.toChars(0xF100B))),
        AIRPLANE(new String(Character.toChars(0xF001D))),
        AIRPLANE_ALERT(new String(Character.toChars(0xF187A))),
        AIRPLANE_CHECK(new String(Character.toChars(0xF187B))),
        AIRPLANE_CLOCK(new String(Character.toChars(0xF187C))),
        AIRPLANE_COG(new String(Character.toChars(0xF187D))),
        AIRPLANE_EDIT(new String(Character.toChars(0xF187E))),
        AIRPLANE_LANDING(new String(Character.toChars(0xF05D4))),
        AIRPLANE_MARKER(new String(Character.toChars(0xF187F))),
        AIRPLANE_MINUS(new String(Character.toChars(0xF1880))),
        AIRPLANE_OFF(new String(Character.toChars(0xF001E))),
        AIRPLANE_PLUS(new String(Character.toChars(0xF1881))),
        AIRPLANE_REMOVE(new String(Character.toChars(0xF1882))),
        AIRPLANE_SEARCH(new String(Character.toChars(0xF1883))),
        AIRPLANE_SETTINGS(new String(Character.toChars(0xF1884))),
        AIRPLANE_TAKEOFF(new String(Character.toChars(0xF05D5))),
        AIRPORT(new String(Character.toChars(0xF084B))),
        ALARM(new String(Character.toChars(0xF0020))),
        ALARM_BELL(new String(Character.toChars(0xF078E))),
        ALARM_CHECK(new String(Character.toChars(0xF0021))),
        ALARM_LIGHT(new String(Character.toChars(0xF078F))),
        ALARM_LIGHT_OFF(new String(Character.toChars(0xF171E))),
        ALARM_LIGHT_OFF_OUTLINE(new String(Character.toChars(0xF171F))),
        ALARM_LIGHT_OUTLINE(new String(Character.toChars(0xF0BEA))),
        ALARM_MULTIPLE(new String(Character.toChars(0xF0022))),
        ALARM_NOTE(new String(Character.toChars(0xF0E71))),
        ALARM_NOTE_OFF(new String(Character.toChars(0xF0E72))),
        ALARM_OFF(new String(Character.toChars(0xF0023))),
        ALARM_PANEL(new String(Character.toChars(0xF15C4))),
        ALARM_PANEL_OUTLINE(new String(Character.toChars(0xF15C5))),
        ALARM_PLUS(new String(Character.toChars(0xF0024))),
        ALARM_SNOOZE(new String(Character.toChars(0xF068E))),
        ALBUM(new String(Character.toChars(0xF0025))),
        ALERT(new String(Character.toChars(0xF0026))),
        ALERT_BOX(new String(Character.toChars(0xF0027))),
        ALERT_BOX_OUTLINE(new String(Character.toChars(0xF0CE4))),
        ALERT_CIRCLE(new String(Character.toChars(0xF0028))),
        ALERT_CIRCLE_CHECK(new String(Character.toChars(0xF11ED))),
        ALERT_CIRCLE_CHECK_OUTLINE(new String(Character.toChars(0xF11EE))),
        ALERT_CIRCLE_OUTLINE(new String(Character.toChars(0xF05D6))),
        ALERT_DECAGRAM(new String(Character.toChars(0xF06BD))),
        ALERT_DECAGRAM_OUTLINE(new String(Character.toChars(0xF0CE5))),
        ALERT_MINUS(new String(Character.toChars(0xF14BB))),
        ALERT_MINUS_OUTLINE(new String(Character.toChars(0xF14BE))),
        ALERT_OCTAGON(new String(Character.toChars(0xF0029))),
        ALERT_OCTAGON_OUTLINE(new String(Character.toChars(0xF0CE6))),
        ALERT_OCTAGRAM(new String(Character.toChars(0xF0767))),
        ALERT_OCTAGRAM_OUTLINE(new String(Character.toChars(0xF0CE7))),
        ALERT_OUTLINE(new String(Character.toChars(0xF002A))),
        ALERT_PLUS(new String(Character.toChars(0xF14BA))),
        ALERT_PLUS_OUTLINE(new String(Character.toChars(0xF14BD))),
        ALERT_REMOVE(new String(Character.toChars(0xF14BC))),
        ALERT_REMOVE_OUTLINE(new String(Character.toChars(0xF14BF))),
        ALERT_RHOMBUS(new String(Character.toChars(0xF11CE))),
        ALERT_RHOMBUS_OUTLINE(new String(Character.toChars(0xF11CF))),
        ALIEN(new String(Character.toChars(0xF089A))),
        ALIEN_OUTLINE(new String(Character.toChars(0xF10CB))),
        ALIGN_HORIZONTAL_CENTER(new String(Character.toChars(0xF11C3))),
        ALIGN_HORIZONTAL_DISTRIBUTE(new String(Character.toChars(0xF1962))),
        ALIGN_HORIZONTAL_LEFT(new String(Character.toChars(0xF11C2))),
        ALIGN_HORIZONTAL_RIGHT(new String(Character.toChars(0xF11C4))),
        ALIGN_VERTICAL_BOTTOM(new String(Character.toChars(0xF11C5))),
        ALIGN_VERTICAL_CENTER(new String(Character.toChars(0xF11C6))),
        ALIGN_VERTICAL_DISTRIBUTE(new String(Character.toChars(0xF1963))),
        ALIGN_VERTICAL_TOP(new String(Character.toChars(0xF11C7))),
        ALL_INCLUSIVE(new String(Character.toChars(0xF06BE))),
        ALL_INCLUSIVE_BOX(new String(Character.toChars(0xF188D))),
        ALL_INCLUSIVE_BOX_OUTLINE(new String(Character.toChars(0xF188E))),
        ALLERGY(new String(Character.toChars(0xF1258))),
        ALPHA(new String(Character.toChars(0xF002B))),
        ALPHA_A(new String(Character.toChars(0xF0AEE))),
        ALPHA_A_BOX(new String(Character.toChars(0xF0B08))),
        ALPHA_A_BOX_OUTLINE(new String(Character.toChars(0xF0BEB))),
        ALPHA_A_CIRCLE(new String(Character.toChars(0xF0BEC))),
        ALPHA_A_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BED))),
        ALPHA_B(new String(Character.toChars(0xF0AEF))),
        ALPHA_B_BOX(new String(Character.toChars(0xF0B09))),
        ALPHA_B_BOX_OUTLINE(new String(Character.toChars(0xF0BEE))),
        ALPHA_B_CIRCLE(new String(Character.toChars(0xF0BEF))),
        ALPHA_B_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BF0))),
        ALPHA_C(new String(Character.toChars(0xF0AF0))),
        ALPHA_C_BOX(new String(Character.toChars(0xF0B0A))),
        ALPHA_C_BOX_OUTLINE(new String(Character.toChars(0xF0BF1))),
        ALPHA_C_CIRCLE(new String(Character.toChars(0xF0BF2))),
        ALPHA_C_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BF3))),
        ALPHA_D(new String(Character.toChars(0xF0AF1))),
        ALPHA_D_BOX(new String(Character.toChars(0xF0B0B))),
        ALPHA_D_BOX_OUTLINE(new String(Character.toChars(0xF0BF4))),
        ALPHA_D_CIRCLE(new String(Character.toChars(0xF0BF5))),
        ALPHA_D_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BF6))),
        ALPHA_E(new String(Character.toChars(0xF0AF2))),
        ALPHA_E_BOX(new String(Character.toChars(0xF0B0C))),
        ALPHA_E_BOX_OUTLINE(new String(Character.toChars(0xF0BF7))),
        ALPHA_E_CIRCLE(new String(Character.toChars(0xF0BF8))),
        ALPHA_E_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BF9))),
        ALPHA_F(new String(Character.toChars(0xF0AF3))),
        ALPHA_F_BOX(new String(Character.toChars(0xF0B0D))),
        ALPHA_F_BOX_OUTLINE(new String(Character.toChars(0xF0BFA))),
        ALPHA_F_CIRCLE(new String(Character.toChars(0xF0BFB))),
        ALPHA_F_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BFC))),
        ALPHA_G(new String(Character.toChars(0xF0AF4))),
        ALPHA_G_BOX(new String(Character.toChars(0xF0B0E))),
        ALPHA_G_BOX_OUTLINE(new String(Character.toChars(0xF0BFD))),
        ALPHA_G_CIRCLE(new String(Character.toChars(0xF0BFE))),
        ALPHA_G_CIRCLE_OUTLINE(new String(Character.toChars(0xF0BFF))),
        ALPHA_H(new String(Character.toChars(0xF0AF5))),
        ALPHA_H_BOX(new String(Character.toChars(0xF0B0F))),
        ALPHA_H_BOX_OUTLINE(new String(Character.toChars(0xF0C00))),
        ALPHA_H_CIRCLE(new String(Character.toChars(0xF0C01))),
        ALPHA_H_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C02))),
        ALPHA_I(new String(Character.toChars(0xF0AF6))),
        ALPHA_I_BOX(new String(Character.toChars(0xF0B10))),
        ALPHA_I_BOX_OUTLINE(new String(Character.toChars(0xF0C03))),
        ALPHA_I_CIRCLE(new String(Character.toChars(0xF0C04))),
        ALPHA_I_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C05))),
        ALPHA_J(new String(Character.toChars(0xF0AF7))),
        ALPHA_J_BOX(new String(Character.toChars(0xF0B11))),
        ALPHA_J_BOX_OUTLINE(new String(Character.toChars(0xF0C06))),
        ALPHA_J_CIRCLE(new String(Character.toChars(0xF0C07))),
        ALPHA_J_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C08))),
        ALPHA_K(new String(Character.toChars(0xF0AF8))),
        ALPHA_K_BOX(new String(Character.toChars(0xF0B12))),
        ALPHA_K_BOX_OUTLINE(new String(Character.toChars(0xF0C09))),
        ALPHA_K_CIRCLE(new String(Character.toChars(0xF0C0A))),
        ALPHA_K_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C0B))),
        ALPHA_L(new String(Character.toChars(0xF0AF9))),
        ALPHA_L_BOX(new String(Character.toChars(0xF0B13))),
        ALPHA_L_BOX_OUTLINE(new String(Character.toChars(0xF0C0C))),
        ALPHA_L_CIRCLE(new String(Character.toChars(0xF0C0D))),
        ALPHA_L_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C0E))),
        ALPHA_M(new String(Character.toChars(0xF0AFA))),
        ALPHA_M_BOX(new String(Character.toChars(0xF0B14))),
        ALPHA_M_BOX_OUTLINE(new String(Character.toChars(0xF0C0F))),
        ALPHA_M_CIRCLE(new String(Character.toChars(0xF0C10))),
        ALPHA_M_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C11))),
        ALPHA_N(new String(Character.toChars(0xF0AFB))),
        ALPHA_N_BOX(new String(Character.toChars(0xF0B15))),
        ALPHA_N_BOX_OUTLINE(new String(Character.toChars(0xF0C12))),
        ALPHA_N_CIRCLE(new String(Character.toChars(0xF0C13))),
        ALPHA_N_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C14))),
        ALPHA_O(new String(Character.toChars(0xF0AFC))),
        ALPHA_O_BOX(new String(Character.toChars(0xF0B16))),
        ALPHA_O_BOX_OUTLINE(new String(Character.toChars(0xF0C15))),
        ALPHA_O_CIRCLE(new String(Character.toChars(0xF0C16))),
        ALPHA_O_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C17))),
        ALPHA_P(new String(Character.toChars(0xF0AFD))),
        ALPHA_P_BOX(new String(Character.toChars(0xF0B17))),
        ALPHA_P_BOX_OUTLINE(new String(Character.toChars(0xF0C18))),
        ALPHA_P_CIRCLE(new String(Character.toChars(0xF0C19))),
        ALPHA_P_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C1A))),
        ALPHA_Q(new String(Character.toChars(0xF0AFE))),
        ALPHA_Q_BOX(new String(Character.toChars(0xF0B18))),
        ALPHA_Q_BOX_OUTLINE(new String(Character.toChars(0xF0C1B))),
        ALPHA_Q_CIRCLE(new String(Character.toChars(0xF0C1C))),
        ALPHA_Q_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C1D))),
        ALPHA_R(new String(Character.toChars(0xF0AFF))),
        ALPHA_R_BOX(new String(Character.toChars(0xF0B19))),
        ALPHA_R_BOX_OUTLINE(new String(Character.toChars(0xF0C1E))),
        ALPHA_R_CIRCLE(new String(Character.toChars(0xF0C1F))),
        ALPHA_R_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C20))),
        ALPHA_S(new String(Character.toChars(0xF0B00))),
        ALPHA_S_BOX(new String(Character.toChars(0xF0B1A))),
        ALPHA_S_BOX_OUTLINE(new String(Character.toChars(0xF0C21))),
        ALPHA_S_CIRCLE(new String(Character.toChars(0xF0C22))),
        ALPHA_S_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C23))),
        ALPHA_T(new String(Character.toChars(0xF0B01))),
        ALPHA_T_BOX(new String(Character.toChars(0xF0B1B))),
        ALPHA_T_BOX_OUTLINE(new String(Character.toChars(0xF0C24))),
        ALPHA_T_CIRCLE(new String(Character.toChars(0xF0C25))),
        ALPHA_T_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C26))),
        ALPHA_U(new String(Character.toChars(0xF0B02))),
        ALPHA_U_BOX(new String(Character.toChars(0xF0B1C))),
        ALPHA_U_BOX_OUTLINE(new String(Character.toChars(0xF0C27))),
        ALPHA_U_CIRCLE(new String(Character.toChars(0xF0C28))),
        ALPHA_U_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C29))),
        ALPHA_V(new String(Character.toChars(0xF0B03))),
        ALPHA_V_BOX(new String(Character.toChars(0xF0B1D))),
        ALPHA_V_BOX_OUTLINE(new String(Character.toChars(0xF0C2A))),
        ALPHA_V_CIRCLE(new String(Character.toChars(0xF0C2B))),
        ALPHA_V_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C2C))),
        ALPHA_W(new String(Character.toChars(0xF0B04))),
        ALPHA_W_BOX(new String(Character.toChars(0xF0B1E))),
        ALPHA_W_BOX_OUTLINE(new String(Character.toChars(0xF0C2D))),
        ALPHA_W_CIRCLE(new String(Character.toChars(0xF0C2E))),
        ALPHA_W_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C2F))),
        ALPHA_X(new String(Character.toChars(0xF0B05))),
        ALPHA_X_BOX(new String(Character.toChars(0xF0B1F))),
        ALPHA_X_BOX_OUTLINE(new String(Character.toChars(0xF0C30))),
        ALPHA_X_CIRCLE(new String(Character.toChars(0xF0C31))),
        ALPHA_X_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C32))),
        ALPHA_Y(new String(Character.toChars(0xF0B06))),
        ALPHA_Y_BOX(new String(Character.toChars(0xF0B20))),
        ALPHA_Y_BOX_OUTLINE(new String(Character.toChars(0xF0C33))),
        ALPHA_Y_CIRCLE(new String(Character.toChars(0xF0C34))),
        ALPHA_Y_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C35))),
        ALPHA_Z(new String(Character.toChars(0xF0B07))),
        ALPHA_Z_BOX(new String(Character.toChars(0xF0B21))),
        ALPHA_Z_BOX_OUTLINE(new String(Character.toChars(0xF0C36))),
        ALPHA_Z_CIRCLE(new String(Character.toChars(0xF0C37))),
        ALPHA_Z_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C38))),
        ALPHABET_AUREBESH(new String(Character.toChars(0xF132C))),
        ALPHABET_CYRILLIC(new String(Character.toChars(0xF132D))),
        ALPHABET_GREEK(new String(Character.toChars(0xF132E))),
        ALPHABET_LATIN(new String(Character.toChars(0xF132F))),
        ALPHABET_PIQAD(new String(Character.toChars(0xF1330))),
        ALPHABET_TENGWAR(new String(Character.toChars(0xF1337))),
        ALPHABETICAL(new String(Character.toChars(0xF002C))),
        ALPHABETICAL_OFF(new String(Character.toChars(0xF100C))),
        ALPHABETICAL_VARIANT(new String(Character.toChars(0xF100D))),
        ALPHABETICAL_VARIANT_OFF(new String(Character.toChars(0xF100E))),
        ALTIMETER(new String(Character.toChars(0xF05D7))),
        AMBULANCE(new String(Character.toChars(0xF002F))),
        AMMUNITION(new String(Character.toChars(0xF0CE8))),
        AMPERSAND(new String(Character.toChars(0xF0A8D))),
        AMPLIFIER(new String(Character.toChars(0xF0030))),
        AMPLIFIER_OFF(new String(Character.toChars(0xF11B5))),
        ANCHOR(new String(Character.toChars(0xF0031))),
        ANDROID(new String(Character.toChars(0xF0032))),
        ANDROID_STUDIO(new String(Character.toChars(0xF0034))),
        ANGLE_ACUTE(new String(Character.toChars(0xF0937))),
        ANGLE_OBTUSE(new String(Character.toChars(0xF0938))),
        ANGLE_RIGHT(new String(Character.toChars(0xF0939))),
        ANGULAR(new String(Character.toChars(0xF06B2))),
        ANGULARJS(new String(Character.toChars(0xF06BF))),
        ANIMATION(new String(Character.toChars(0xF05D8))),
        ANIMATION_OUTLINE(new String(Character.toChars(0xF0A8F))),
        ANIMATION_PLAY(new String(Character.toChars(0xF093A))),
        ANIMATION_PLAY_OUTLINE(new String(Character.toChars(0xF0A90))),
        ANSIBLE(new String(Character.toChars(0xF109A))),
        ANTENNA(new String(Character.toChars(0xF1119))),
        ANVIL(new String(Character.toChars(0xF089B))),
        APACHE_KAFKA(new String(Character.toChars(0xF100F))),
        API(new String(Character.toChars(0xF109B))),
        API_OFF(new String(Character.toChars(0xF1257))),
        APPLE(new String(Character.toChars(0xF0035))),
        APPLE_FINDER(new String(Character.toChars(0xF0036))),
        APPLE_ICLOUD(new String(Character.toChars(0xF0038))),
        APPLE_IOS(new String(Character.toChars(0xF0037))),
        APPLE_KEYBOARD_CAPS(new String(Character.toChars(0xF0632))),
        APPLE_KEYBOARD_COMMAND(new String(Character.toChars(0xF0633))),
        APPLE_KEYBOARD_CONTROL(new String(Character.toChars(0xF0634))),
        APPLE_KEYBOARD_OPTION(new String(Character.toChars(0xF0635))),
        APPLE_KEYBOARD_SHIFT(new String(Character.toChars(0xF0636))),
        APPLE_SAFARI(new String(Character.toChars(0xF0039))),
        APPLICATION(new String(Character.toChars(0xF08C6))),
        APPLICATION_ARRAY(new String(Character.toChars(0xF10F5))),
        APPLICATION_ARRAY_OUTLINE(new String(Character.toChars(0xF10F6))),
        APPLICATION_BRACES(new String(Character.toChars(0xF10F7))),
        APPLICATION_BRACES_OUTLINE(new String(Character.toChars(0xF10F8))),
        APPLICATION_BRACKETS(new String(Character.toChars(0xF0C8B))),
        APPLICATION_BRACKETS_OUTLINE(new String(Character.toChars(0xF0C8C))),
        APPLICATION_COG(new String(Character.toChars(0xF0675))),
        APPLICATION_COG_OUTLINE(new String(Character.toChars(0xF1577))),
        APPLICATION_EDIT(new String(Character.toChars(0xF00AE))),
        APPLICATION_EDIT_OUTLINE(new String(Character.toChars(0xF0619))),
        APPLICATION_EXPORT(new String(Character.toChars(0xF0DAD))),
        APPLICATION_IMPORT(new String(Character.toChars(0xF0DAE))),
        APPLICATION_OUTLINE(new String(Character.toChars(0xF0614))),
        APPLICATION_PARENTHESES(new String(Character.toChars(0xF10F9))),
        APPLICATION_PARENTHESES_OUTLINE(new String(Character.toChars(0xF10FA))),
        APPLICATION_SETTINGS(new String(Character.toChars(0xF0B60))),
        APPLICATION_SETTINGS_OUTLINE(new String(Character.toChars(0xF1555))),
        APPLICATION_VARIABLE(new String(Character.toChars(0xF10FB))),
        APPLICATION_VARIABLE_OUTLINE(new String(Character.toChars(0xF10FC))),
        APPROXIMATELY_EQUAL(new String(Character.toChars(0xF0F9E))),
        APPROXIMATELY_EQUAL_BOX(new String(Character.toChars(0xF0F9F))),
        APPS(new String(Character.toChars(0xF003B))),
        APPS_BOX(new String(Character.toChars(0xF0D46))),
        ARCH(new String(Character.toChars(0xF08C7))),
        ARCHIVE(new String(Character.toChars(0xF003C))),
        ARCHIVE_ALERT(new String(Character.toChars(0xF14FD))),
        ARCHIVE_ALERT_OUTLINE(new String(Character.toChars(0xF14FE))),
        ARCHIVE_ARROW_DOWN(new String(Character.toChars(0xF1259))),
        ARCHIVE_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF125A))),
        ARCHIVE_ARROW_UP(new String(Character.toChars(0xF125B))),
        ARCHIVE_ARROW_UP_OUTLINE(new String(Character.toChars(0xF125C))),
        ARCHIVE_CANCEL(new String(Character.toChars(0xF174B))),
        ARCHIVE_CANCEL_OUTLINE(new String(Character.toChars(0xF174C))),
        ARCHIVE_CHECK(new String(Character.toChars(0xF174D))),
        ARCHIVE_CHECK_OUTLINE(new String(Character.toChars(0xF174E))),
        ARCHIVE_CLOCK(new String(Character.toChars(0xF174F))),
        ARCHIVE_CLOCK_OUTLINE(new String(Character.toChars(0xF1750))),
        ARCHIVE_COG(new String(Character.toChars(0xF1751))),
        ARCHIVE_COG_OUTLINE(new String(Character.toChars(0xF1752))),
        ARCHIVE_EDIT(new String(Character.toChars(0xF1753))),
        ARCHIVE_EDIT_OUTLINE(new String(Character.toChars(0xF1754))),
        ARCHIVE_EYE(new String(Character.toChars(0xF1755))),
        ARCHIVE_EYE_OUTLINE(new String(Character.toChars(0xF1756))),
        ARCHIVE_LOCK(new String(Character.toChars(0xF1757))),
        ARCHIVE_LOCK_OPEN(new String(Character.toChars(0xF1758))),
        ARCHIVE_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1759))),
        ARCHIVE_LOCK_OUTLINE(new String(Character.toChars(0xF175A))),
        ARCHIVE_MARKER(new String(Character.toChars(0xF175B))),
        ARCHIVE_MARKER_OUTLINE(new String(Character.toChars(0xF175C))),
        ARCHIVE_MINUS(new String(Character.toChars(0xF175D))),
        ARCHIVE_MINUS_OUTLINE(new String(Character.toChars(0xF175E))),
        ARCHIVE_MUSIC(new String(Character.toChars(0xF175F))),
        ARCHIVE_MUSIC_OUTLINE(new String(Character.toChars(0xF1760))),
        ARCHIVE_OFF(new String(Character.toChars(0xF1761))),
        ARCHIVE_OFF_OUTLINE(new String(Character.toChars(0xF1762))),
        ARCHIVE_OUTLINE(new String(Character.toChars(0xF120E))),
        ARCHIVE_PLUS(new String(Character.toChars(0xF1763))),
        ARCHIVE_PLUS_OUTLINE(new String(Character.toChars(0xF1764))),
        ARCHIVE_REFRESH(new String(Character.toChars(0xF1765))),
        ARCHIVE_REFRESH_OUTLINE(new String(Character.toChars(0xF1766))),
        ARCHIVE_REMOVE(new String(Character.toChars(0xF1767))),
        ARCHIVE_REMOVE_OUTLINE(new String(Character.toChars(0xF1768))),
        ARCHIVE_SEARCH(new String(Character.toChars(0xF1769))),
        ARCHIVE_SEARCH_OUTLINE(new String(Character.toChars(0xF176A))),
        ARCHIVE_SETTINGS(new String(Character.toChars(0xF176B))),
        ARCHIVE_SETTINGS_OUTLINE(new String(Character.toChars(0xF176C))),
        ARCHIVE_STAR(new String(Character.toChars(0xF176D))),
        ARCHIVE_STAR_OUTLINE(new String(Character.toChars(0xF176E))),
        ARCHIVE_SYNC(new String(Character.toChars(0xF176F))),
        ARCHIVE_SYNC_OUTLINE(new String(Character.toChars(0xF1770))),
        ARM_FLEX(new String(Character.toChars(0xF0FD7))),
        ARM_FLEX_OUTLINE(new String(Character.toChars(0xF0FD6))),
        ARRANGE_BRING_FORWARD(new String(Character.toChars(0xF003D))),
        ARRANGE_BRING_TO_FRONT(new String(Character.toChars(0xF003E))),
        ARRANGE_SEND_BACKWARD(new String(Character.toChars(0xF003F))),
        ARRANGE_SEND_TO_BACK(new String(Character.toChars(0xF0040))),
        ARROW_ALL(new String(Character.toChars(0xF0041))),
        ARROW_BOTTOM_LEFT(new String(Character.toChars(0xF0042))),
        ARROW_BOTTOM_LEFT_BOLD_BOX(new String(Character.toChars(0xF1964))),
        ARROW_BOTTOM_LEFT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF1965))),
        ARROW_BOTTOM_LEFT_BOLD_OUTLINE(new String(Character.toChars(0xF09B7))),
        ARROW_BOTTOM_LEFT_THICK(new String(Character.toChars(0xF09B8))),
        ARROW_BOTTOM_LEFT_THIN(new String(Character.toChars(0xF19B6))),
        ARROW_BOTTOM_LEFT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1596))),
        ARROW_BOTTOM_RIGHT(new String(Character.toChars(0xF0043))),
        ARROW_BOTTOM_RIGHT_BOLD_BOX(new String(Character.toChars(0xF1966))),
        ARROW_BOTTOM_RIGHT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF1967))),
        ARROW_BOTTOM_RIGHT_BOLD_OUTLINE(new String(Character.toChars(0xF09B9))),
        ARROW_BOTTOM_RIGHT_THICK(new String(Character.toChars(0xF09BA))),
        ARROW_BOTTOM_RIGHT_THIN(new String(Character.toChars(0xF19B7))),
        ARROW_BOTTOM_RIGHT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1595))),
        ARROW_COLLAPSE(new String(Character.toChars(0xF0615))),
        ARROW_COLLAPSE_ALL(new String(Character.toChars(0xF0044))),
        ARROW_COLLAPSE_DOWN(new String(Character.toChars(0xF0792))),
        ARROW_COLLAPSE_HORIZONTAL(new String(Character.toChars(0xF084C))),
        ARROW_COLLAPSE_LEFT(new String(Character.toChars(0xF0793))),
        ARROW_COLLAPSE_RIGHT(new String(Character.toChars(0xF0794))),
        ARROW_COLLAPSE_UP(new String(Character.toChars(0xF0795))),
        ARROW_COLLAPSE_VERTICAL(new String(Character.toChars(0xF084D))),
        ARROW_DECISION(new String(Character.toChars(0xF09BB))),
        ARROW_DECISION_AUTO(new String(Character.toChars(0xF09BC))),
        ARROW_DECISION_AUTO_OUTLINE(new String(Character.toChars(0xF09BD))),
        ARROW_DECISION_OUTLINE(new String(Character.toChars(0xF09BE))),
        ARROW_DOWN(new String(Character.toChars(0xF0045))),
        ARROW_DOWN_BOLD(new String(Character.toChars(0xF072E))),
        ARROW_DOWN_BOLD_BOX(new String(Character.toChars(0xF072F))),
        ARROW_DOWN_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF0730))),
        ARROW_DOWN_BOLD_CIRCLE(new String(Character.toChars(0xF0047))),
        ARROW_DOWN_BOLD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0048))),
        ARROW_DOWN_BOLD_HEXAGON_OUTLINE(new String(Character.toChars(0xF0049))),
        ARROW_DOWN_BOLD_OUTLINE(new String(Character.toChars(0xF09BF))),
        ARROW_DOWN_BOX(new String(Character.toChars(0xF06C0))),
        ARROW_DOWN_CIRCLE(new String(Character.toChars(0xF0CDB))),
        ARROW_DOWN_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CDC))),
        ARROW_DOWN_DROP_CIRCLE(new String(Character.toChars(0xF004A))),
        ARROW_DOWN_DROP_CIRCLE_OUTLINE(new String(Character.toChars(0xF004B))),
        ARROW_DOWN_LEFT(new String(Character.toChars(0xF17A1))),
        ARROW_DOWN_LEFT_BOLD(new String(Character.toChars(0xF17A2))),
        ARROW_DOWN_RIGHT(new String(Character.toChars(0xF17A3))),
        ARROW_DOWN_RIGHT_BOLD(new String(Character.toChars(0xF17A4))),
        ARROW_DOWN_THICK(new String(Character.toChars(0xF0046))),
        ARROW_DOWN_THIN(new String(Character.toChars(0xF19B3))),
        ARROW_DOWN_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1599))),
        ARROW_EXPAND(new String(Character.toChars(0xF0616))),
        ARROW_EXPAND_ALL(new String(Character.toChars(0xF004C))),
        ARROW_EXPAND_DOWN(new String(Character.toChars(0xF0796))),
        ARROW_EXPAND_HORIZONTAL(new String(Character.toChars(0xF084E))),
        ARROW_EXPAND_LEFT(new String(Character.toChars(0xF0797))),
        ARROW_EXPAND_RIGHT(new String(Character.toChars(0xF0798))),
        ARROW_EXPAND_UP(new String(Character.toChars(0xF0799))),
        ARROW_EXPAND_VERTICAL(new String(Character.toChars(0xF084F))),
        ARROW_HORIZONTAL_LOCK(new String(Character.toChars(0xF115B))),
        ARROW_LEFT(new String(Character.toChars(0xF004D))),
        ARROW_LEFT_BOLD(new String(Character.toChars(0xF0731))),
        ARROW_LEFT_BOLD_BOX(new String(Character.toChars(0xF0732))),
        ARROW_LEFT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF0733))),
        ARROW_LEFT_BOLD_CIRCLE(new String(Character.toChars(0xF004F))),
        ARROW_LEFT_BOLD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0050))),
        ARROW_LEFT_BOLD_HEXAGON_OUTLINE(new String(Character.toChars(0xF0051))),
        ARROW_LEFT_BOLD_OUTLINE(new String(Character.toChars(0xF09C0))),
        ARROW_LEFT_BOTTOM(new String(Character.toChars(0xF17A5))),
        ARROW_LEFT_BOTTOM_BOLD(new String(Character.toChars(0xF17A6))),
        ARROW_LEFT_BOX(new String(Character.toChars(0xF06C1))),
        ARROW_LEFT_CIRCLE(new String(Character.toChars(0xF0CDD))),
        ARROW_LEFT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CDE))),
        ARROW_LEFT_DROP_CIRCLE(new String(Character.toChars(0xF0052))),
        ARROW_LEFT_DROP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0053))),
        ARROW_LEFT_RIGHT(new String(Character.toChars(0xF0E73))),
        ARROW_LEFT_RIGHT_BOLD(new String(Character.toChars(0xF0E74))),
        ARROW_LEFT_RIGHT_BOLD_OUTLINE(new String(Character.toChars(0xF09C1))),
        ARROW_LEFT_THICK(new String(Character.toChars(0xF004E))),
        ARROW_LEFT_THIN(new String(Character.toChars(0xF19B1))),
        ARROW_LEFT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF159A))),
        ARROW_LEFT_TOP(new String(Character.toChars(0xF17A7))),
        ARROW_LEFT_TOP_BOLD(new String(Character.toChars(0xF17A8))),
        ARROW_PROJECTILE(new String(Character.toChars(0xF1840))),
        ARROW_PROJECTILE_MULTIPLE(new String(Character.toChars(0xF183F))),
        ARROW_RIGHT(new String(Character.toChars(0xF0054))),
        ARROW_RIGHT_BOLD(new String(Character.toChars(0xF0734))),
        ARROW_RIGHT_BOLD_BOX(new String(Character.toChars(0xF0735))),
        ARROW_RIGHT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF0736))),
        ARROW_RIGHT_BOLD_CIRCLE(new String(Character.toChars(0xF0056))),
        ARROW_RIGHT_BOLD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0057))),
        ARROW_RIGHT_BOLD_HEXAGON_OUTLINE(new String(Character.toChars(0xF0058))),
        ARROW_RIGHT_BOLD_OUTLINE(new String(Character.toChars(0xF09C2))),
        ARROW_RIGHT_BOTTOM(new String(Character.toChars(0xF17A9))),
        ARROW_RIGHT_BOTTOM_BOLD(new String(Character.toChars(0xF17AA))),
        ARROW_RIGHT_BOX(new String(Character.toChars(0xF06C2))),
        ARROW_RIGHT_CIRCLE(new String(Character.toChars(0xF0CDF))),
        ARROW_RIGHT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CE0))),
        ARROW_RIGHT_DROP_CIRCLE(new String(Character.toChars(0xF0059))),
        ARROW_RIGHT_DROP_CIRCLE_OUTLINE(new String(Character.toChars(0xF005A))),
        ARROW_RIGHT_THICK(new String(Character.toChars(0xF0055))),
        ARROW_RIGHT_THIN(new String(Character.toChars(0xF19B0))),
        ARROW_RIGHT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1598))),
        ARROW_RIGHT_TOP(new String(Character.toChars(0xF17AB))),
        ARROW_RIGHT_TOP_BOLD(new String(Character.toChars(0xF17AC))),
        ARROW_SPLIT_HORIZONTAL(new String(Character.toChars(0xF093B))),
        ARROW_SPLIT_VERTICAL(new String(Character.toChars(0xF093C))),
        ARROW_TOP_LEFT(new String(Character.toChars(0xF005B))),
        ARROW_TOP_LEFT_BOLD_BOX(new String(Character.toChars(0xF1968))),
        ARROW_TOP_LEFT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF1969))),
        ARROW_TOP_LEFT_BOLD_OUTLINE(new String(Character.toChars(0xF09C3))),
        ARROW_TOP_LEFT_BOTTOM_RIGHT(new String(Character.toChars(0xF0E75))),
        ARROW_TOP_LEFT_BOTTOM_RIGHT_BOLD(new String(Character.toChars(0xF0E76))),
        ARROW_TOP_LEFT_THICK(new String(Character.toChars(0xF09C4))),
        ARROW_TOP_LEFT_THIN(new String(Character.toChars(0xF19B5))),
        ARROW_TOP_LEFT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1593))),
        ARROW_TOP_RIGHT(new String(Character.toChars(0xF005C))),
        ARROW_TOP_RIGHT_BOLD_BOX(new String(Character.toChars(0xF196A))),
        ARROW_TOP_RIGHT_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF196B))),
        ARROW_TOP_RIGHT_BOLD_OUTLINE(new String(Character.toChars(0xF09C5))),
        ARROW_TOP_RIGHT_BOTTOM_LEFT(new String(Character.toChars(0xF0E77))),
        ARROW_TOP_RIGHT_BOTTOM_LEFT_BOLD(new String(Character.toChars(0xF0E78))),
        ARROW_TOP_RIGHT_THICK(new String(Character.toChars(0xF09C6))),
        ARROW_TOP_RIGHT_THIN(new String(Character.toChars(0xF19B4))),
        ARROW_TOP_RIGHT_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1594))),
        ARROW_U_DOWN_LEFT(new String(Character.toChars(0xF17AD))),
        ARROW_U_DOWN_LEFT_BOLD(new String(Character.toChars(0xF17AE))),
        ARROW_U_DOWN_RIGHT(new String(Character.toChars(0xF17AF))),
        ARROW_U_DOWN_RIGHT_BOLD(new String(Character.toChars(0xF17B0))),
        ARROW_U_LEFT_BOTTOM(new String(Character.toChars(0xF17B1))),
        ARROW_U_LEFT_BOTTOM_BOLD(new String(Character.toChars(0xF17B2))),
        ARROW_U_LEFT_TOP(new String(Character.toChars(0xF17B3))),
        ARROW_U_LEFT_TOP_BOLD(new String(Character.toChars(0xF17B4))),
        ARROW_U_RIGHT_BOTTOM(new String(Character.toChars(0xF17B5))),
        ARROW_U_RIGHT_BOTTOM_BOLD(new String(Character.toChars(0xF17B6))),
        ARROW_U_RIGHT_TOP(new String(Character.toChars(0xF17B7))),
        ARROW_U_RIGHT_TOP_BOLD(new String(Character.toChars(0xF17B8))),
        ARROW_U_UP_LEFT(new String(Character.toChars(0xF17B9))),
        ARROW_U_UP_LEFT_BOLD(new String(Character.toChars(0xF17BA))),
        ARROW_U_UP_RIGHT(new String(Character.toChars(0xF17BB))),
        ARROW_U_UP_RIGHT_BOLD(new String(Character.toChars(0xF17BC))),
        ARROW_UP(new String(Character.toChars(0xF005D))),
        ARROW_UP_BOLD(new String(Character.toChars(0xF0737))),
        ARROW_UP_BOLD_BOX(new String(Character.toChars(0xF0738))),
        ARROW_UP_BOLD_BOX_OUTLINE(new String(Character.toChars(0xF0739))),
        ARROW_UP_BOLD_CIRCLE(new String(Character.toChars(0xF005F))),
        ARROW_UP_BOLD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0060))),
        ARROW_UP_BOLD_HEXAGON_OUTLINE(new String(Character.toChars(0xF0061))),
        ARROW_UP_BOLD_OUTLINE(new String(Character.toChars(0xF09C7))),
        ARROW_UP_BOX(new String(Character.toChars(0xF06C3))),
        ARROW_UP_CIRCLE(new String(Character.toChars(0xF0CE1))),
        ARROW_UP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CE2))),
        ARROW_UP_DOWN(new String(Character.toChars(0xF0E79))),
        ARROW_UP_DOWN_BOLD(new String(Character.toChars(0xF0E7A))),
        ARROW_UP_DOWN_BOLD_OUTLINE(new String(Character.toChars(0xF09C8))),
        ARROW_UP_DROP_CIRCLE(new String(Character.toChars(0xF0062))),
        ARROW_UP_DROP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0063))),
        ARROW_UP_LEFT(new String(Character.toChars(0xF17BD))),
        ARROW_UP_LEFT_BOLD(new String(Character.toChars(0xF17BE))),
        ARROW_UP_RIGHT(new String(Character.toChars(0xF17BF))),
        ARROW_UP_RIGHT_BOLD(new String(Character.toChars(0xF17C0))),
        ARROW_UP_THICK(new String(Character.toChars(0xF005E))),
        ARROW_UP_THIN(new String(Character.toChars(0xF19B2))),
        ARROW_UP_THIN_CIRCLE_OUTLINE(new String(Character.toChars(0xF1597))),
        ARROW_VERTICAL_LOCK(new String(Character.toChars(0xF115C))),
        ARTBOARD(new String(Character.toChars(0xF1B9A))),
        ARTSTATION(new String(Character.toChars(0xF0B5B))),
        ASPECT_RATIO(new String(Character.toChars(0xF0A24))),
        ASSISTANT(new String(Character.toChars(0xF0064))),
        ASTERISK(new String(Character.toChars(0xF06C4))),
        ASTERISK_CIRCLE_OUTLINE(new String(Character.toChars(0xF1A27))),
        AT(new String(Character.toChars(0xF0065))),
        ATLASSIAN(new String(Character.toChars(0xF0804))),
        ATM(new String(Character.toChars(0xF0D47))),
        ATOM(new String(Character.toChars(0xF0768))),
        ATOM_VARIANT(new String(Character.toChars(0xF0E7B))),
        ATTACHMENT(new String(Character.toChars(0xF0066))),
        ATTACHMENT_CHECK(new String(Character.toChars(0xF1AC1))),
        ATTACHMENT_LOCK(new String(Character.toChars(0xF19C4))),
        ATTACHMENT_MINUS(new String(Character.toChars(0xF1AC2))),
        ATTACHMENT_OFF(new String(Character.toChars(0xF1AC3))),
        ATTACHMENT_PLUS(new String(Character.toChars(0xF1AC4))),
        ATTACHMENT_REMOVE(new String(Character.toChars(0xF1AC5))),
        ATV(new String(Character.toChars(0xF1B70))),
        AUDIO_INPUT_RCA(new String(Character.toChars(0xF186B))),
        AUDIO_INPUT_STEREO_MINIJACK(new String(Character.toChars(0xF186C))),
        AUDIO_INPUT_XLR(new String(Character.toChars(0xF186D))),
        AUDIO_VIDEO(new String(Character.toChars(0xF093D))),
        AUDIO_VIDEO_OFF(new String(Character.toChars(0xF11B6))),
        AUGMENTED_REALITY(new String(Character.toChars(0xF0850))),
        AURORA(new String(Character.toChars(0xF1BB9))),
        AUTO_DOWNLOAD(new String(Character.toChars(0xF137E))),
        AUTO_FIX(new String(Character.toChars(0xF0068))),
        AUTO_MODE(new String(Character.toChars(0xF1C20))),
        AUTO_UPLOAD(new String(Character.toChars(0xF0069))),
        AUTORENEW(new String(Character.toChars(0xF006A))),
        AUTORENEW_OFF(new String(Character.toChars(0xF19E7))),
        AV_TIMER(new String(Character.toChars(0xF006B))),
        AWNING(new String(Character.toChars(0xF1B87))),
        AWNING_OUTLINE(new String(Character.toChars(0xF1B88))),
        AWS(new String(Character.toChars(0xF0E0F))),
        AXE(new String(Character.toChars(0xF08C8))),
        AXE_BATTLE(new String(Character.toChars(0xF1842))),
        AXIS(new String(Character.toChars(0xF0D48))),
        AXIS_ARROW(new String(Character.toChars(0xF0D49))),
        AXIS_ARROW_INFO(new String(Character.toChars(0xF140E))),
        AXIS_ARROW_LOCK(new String(Character.toChars(0xF0D4A))),
        AXIS_LOCK(new String(Character.toChars(0xF0D4B))),
        AXIS_X_ARROW(new String(Character.toChars(0xF0D4C))),
        AXIS_X_ARROW_LOCK(new String(Character.toChars(0xF0D4D))),
        AXIS_X_ROTATE_CLOCKWISE(new String(Character.toChars(0xF0D4E))),
        AXIS_X_ROTATE_COUNTERCLOCKWISE(new String(Character.toChars(0xF0D4F))),
        AXIS_X_Y_ARROW_LOCK(new String(Character.toChars(0xF0D50))),
        AXIS_Y_ARROW(new String(Character.toChars(0xF0D51))),
        AXIS_Y_ARROW_LOCK(new String(Character.toChars(0xF0D52))),
        AXIS_Y_ROTATE_CLOCKWISE(new String(Character.toChars(0xF0D53))),
        AXIS_Y_ROTATE_COUNTERCLOCKWISE(new String(Character.toChars(0xF0D54))),
        AXIS_Z_ARROW(new String(Character.toChars(0xF0D55))),
        AXIS_Z_ARROW_LOCK(new String(Character.toChars(0xF0D56))),
        AXIS_Z_ROTATE_CLOCKWISE(new String(Character.toChars(0xF0D57))),
        AXIS_Z_ROTATE_COUNTERCLOCKWISE(new String(Character.toChars(0xF0D58)));

        private final String unicode;

        A(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public A getDefaultGlyph()
        {
            return A.AB_TESTING;
        }
    }

    public enum B implements MaterialDesignIconGlyphs<B> {

        BABEL(new String(Character.toChars(0xF0A25))),
        BABY(new String(Character.toChars(0xF006C))),
        BABY_BOTTLE(new String(Character.toChars(0xF0F39))),
        BABY_BOTTLE_OUTLINE(new String(Character.toChars(0xF0F3A))),
        BABY_BUGGY(new String(Character.toChars(0xF13E0))),
        BABY_BUGGY_OFF(new String(Character.toChars(0xF1AF3))),
        BABY_CARRIAGE(new String(Character.toChars(0xF068F))),
        BABY_CARRIAGE_OFF(new String(Character.toChars(0xF0FA0))),
        BABY_FACE(new String(Character.toChars(0xF0E7C))),
        BABY_FACE_OUTLINE(new String(Character.toChars(0xF0E7D))),
        BACKBURGER(new String(Character.toChars(0xF006D))),
        BACKSPACE(new String(Character.toChars(0xF006E))),
        BACKSPACE_OUTLINE(new String(Character.toChars(0xF0B5C))),
        BACKSPACE_REVERSE(new String(Character.toChars(0xF0E7E))),
        BACKSPACE_REVERSE_OUTLINE(new String(Character.toChars(0xF0E7F))),
        BACKUP_RESTORE(new String(Character.toChars(0xF006F))),
        BACTERIA(new String(Character.toChars(0xF0ED5))),
        BACTERIA_OUTLINE(new String(Character.toChars(0xF0ED6))),
        BADGE_ACCOUNT(new String(Character.toChars(0xF0DA7))),
        BADGE_ACCOUNT_ALERT(new String(Character.toChars(0xF0DA8))),
        BADGE_ACCOUNT_ALERT_OUTLINE(new String(Character.toChars(0xF0DA9))),
        BADGE_ACCOUNT_HORIZONTAL(new String(Character.toChars(0xF0E0D))),
        BADGE_ACCOUNT_HORIZONTAL_OUTLINE(new String(Character.toChars(0xF0E0E))),
        BADGE_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0DAA))),
        BADMINTON(new String(Character.toChars(0xF0851))),
        BAG_CARRY_ON(new String(Character.toChars(0xF0F3B))),
        BAG_CARRY_ON_CHECK(new String(Character.toChars(0xF0D65))),
        BAG_CARRY_ON_OFF(new String(Character.toChars(0xF0F3C))),
        BAG_CHECKED(new String(Character.toChars(0xF0F3D))),
        BAG_PERSONAL(new String(Character.toChars(0xF0E10))),
        BAG_PERSONAL_OFF(new String(Character.toChars(0xF0E11))),
        BAG_PERSONAL_OFF_OUTLINE(new String(Character.toChars(0xF0E12))),
        BAG_PERSONAL_OUTLINE(new String(Character.toChars(0xF0E13))),
        BAG_PERSONAL_TAG(new String(Character.toChars(0xF1B0C))),
        BAG_PERSONAL_TAG_OUTLINE(new String(Character.toChars(0xF1B0D))),
        BAG_SUITCASE(new String(Character.toChars(0xF158B))),
        BAG_SUITCASE_OFF(new String(Character.toChars(0xF158D))),
        BAG_SUITCASE_OFF_OUTLINE(new String(Character.toChars(0xF158E))),
        BAG_SUITCASE_OUTLINE(new String(Character.toChars(0xF158C))),
        BAGUETTE(new String(Character.toChars(0xF0F3E))),
        BALCONY(new String(Character.toChars(0xF1817))),
        BALLOON(new String(Character.toChars(0xF0A26))),
        BALLOT(new String(Character.toChars(0xF09C9))),
        BALLOT_OUTLINE(new String(Character.toChars(0xF09CA))),
        BALLOT_RECOUNT(new String(Character.toChars(0xF0C39))),
        BALLOT_RECOUNT_OUTLINE(new String(Character.toChars(0xF0C3A))),
        BANDAGE(new String(Character.toChars(0xF0DAF))),
        BANK(new String(Character.toChars(0xF0070))),
        BANK_CHECK(new String(Character.toChars(0xF1655))),
        BANK_CIRCLE(new String(Character.toChars(0xF1C03))),
        BANK_CIRCLE_OUTLINE(new String(Character.toChars(0xF1C04))),
        BANK_MINUS(new String(Character.toChars(0xF0DB0))),
        BANK_OFF(new String(Character.toChars(0xF1656))),
        BANK_OFF_OUTLINE(new String(Character.toChars(0xF1657))),
        BANK_OUTLINE(new String(Character.toChars(0xF0E80))),
        BANK_PLUS(new String(Character.toChars(0xF0DB1))),
        BANK_REMOVE(new String(Character.toChars(0xF0DB2))),
        BANK_TRANSFER(new String(Character.toChars(0xF0A27))),
        BANK_TRANSFER_IN(new String(Character.toChars(0xF0A28))),
        BANK_TRANSFER_OUT(new String(Character.toChars(0xF0A29))),
        BARCODE(new String(Character.toChars(0xF0071))),
        BARCODE_OFF(new String(Character.toChars(0xF1236))),
        BARCODE_SCAN(new String(Character.toChars(0xF0072))),
        BARLEY(new String(Character.toChars(0xF0073))),
        BARLEY_OFF(new String(Character.toChars(0xF0B5D))),
        BARN(new String(Character.toChars(0xF0B5E))),
        BARREL(new String(Character.toChars(0xF0074))),
        BARREL_OUTLINE(new String(Character.toChars(0xF1A28))),
        BASEBALL(new String(Character.toChars(0xF0852))),
        BASEBALL_BAT(new String(Character.toChars(0xF0853))),
        BASEBALL_DIAMOND(new String(Character.toChars(0xF15EC))),
        BASEBALL_DIAMOND_OUTLINE(new String(Character.toChars(0xF15ED))),
        BASEBALL_OUTLINE(new String(Character.toChars(0xF1C5A))),
        BASH(new String(Character.toChars(0xF1183))),
        BASKET(new String(Character.toChars(0xF0076))),
        BASKET_CHECK(new String(Character.toChars(0xF18E5))),
        BASKET_CHECK_OUTLINE(new String(Character.toChars(0xF18E6))),
        BASKET_FILL(new String(Character.toChars(0xF0077))),
        BASKET_MINUS(new String(Character.toChars(0xF1523))),
        BASKET_MINUS_OUTLINE(new String(Character.toChars(0xF1524))),
        BASKET_OFF(new String(Character.toChars(0xF1525))),
        BASKET_OFF_OUTLINE(new String(Character.toChars(0xF1526))),
        BASKET_OUTLINE(new String(Character.toChars(0xF1181))),
        BASKET_PLUS(new String(Character.toChars(0xF1527))),
        BASKET_PLUS_OUTLINE(new String(Character.toChars(0xF1528))),
        BASKET_REMOVE(new String(Character.toChars(0xF1529))),
        BASKET_REMOVE_OUTLINE(new String(Character.toChars(0xF152A))),
        BASKET_UNFILL(new String(Character.toChars(0xF0078))),
        BASKETBALL(new String(Character.toChars(0xF0806))),
        BASKETBALL_HOOP(new String(Character.toChars(0xF0C3B))),
        BASKETBALL_HOOP_OUTLINE(new String(Character.toChars(0xF0C3C))),
        BAT(new String(Character.toChars(0xF0B5F))),
        BATHTUB(new String(Character.toChars(0xF1818))),
        BATHTUB_OUTLINE(new String(Character.toChars(0xF1819))),
        BATTERY(new String(Character.toChars(0xF0079))),
        BATTERY_10(new String(Character.toChars(0xF007A))),
        BATTERY_10_BLUETOOTH(new String(Character.toChars(0xF093E))),
        BATTERY_20(new String(Character.toChars(0xF007B))),
        BATTERY_20_BLUETOOTH(new String(Character.toChars(0xF093F))),
        BATTERY_30(new String(Character.toChars(0xF007C))),
        BATTERY_30_BLUETOOTH(new String(Character.toChars(0xF0940))),
        BATTERY_40(new String(Character.toChars(0xF007D))),
        BATTERY_40_BLUETOOTH(new String(Character.toChars(0xF0941))),
        BATTERY_50(new String(Character.toChars(0xF007E))),
        BATTERY_50_BLUETOOTH(new String(Character.toChars(0xF0942))),
        BATTERY_60(new String(Character.toChars(0xF007F))),
        BATTERY_60_BLUETOOTH(new String(Character.toChars(0xF0943))),
        BATTERY_70(new String(Character.toChars(0xF0080))),
        BATTERY_70_BLUETOOTH(new String(Character.toChars(0xF0944))),
        BATTERY_80(new String(Character.toChars(0xF0081))),
        BATTERY_80_BLUETOOTH(new String(Character.toChars(0xF0945))),
        BATTERY_90(new String(Character.toChars(0xF0082))),
        BATTERY_90_BLUETOOTH(new String(Character.toChars(0xF0946))),
        BATTERY_ALERT(new String(Character.toChars(0xF0083))),
        BATTERY_ALERT_BLUETOOTH(new String(Character.toChars(0xF0947))),
        BATTERY_ALERT_VARIANT(new String(Character.toChars(0xF10CC))),
        BATTERY_ALERT_VARIANT_OUTLINE(new String(Character.toChars(0xF10CD))),
        BATTERY_ARROW_DOWN(new String(Character.toChars(0xF17DE))),
        BATTERY_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF17DF))),
        BATTERY_ARROW_UP(new String(Character.toChars(0xF17E0))),
        BATTERY_ARROW_UP_OUTLINE(new String(Character.toChars(0xF17E1))),
        BATTERY_BLUETOOTH(new String(Character.toChars(0xF0948))),
        BATTERY_BLUETOOTH_VARIANT(new String(Character.toChars(0xF0949))),
        BATTERY_CHARGING(new String(Character.toChars(0xF0084))),
        BATTERY_CHARGING_10(new String(Character.toChars(0xF089C))),
        BATTERY_CHARGING_100(new String(Character.toChars(0xF0085))),
        BATTERY_CHARGING_20(new String(Character.toChars(0xF0086))),
        BATTERY_CHARGING_30(new String(Character.toChars(0xF0087))),
        BATTERY_CHARGING_40(new String(Character.toChars(0xF0088))),
        BATTERY_CHARGING_50(new String(Character.toChars(0xF089D))),
        BATTERY_CHARGING_60(new String(Character.toChars(0xF0089))),
        BATTERY_CHARGING_70(new String(Character.toChars(0xF089E))),
        BATTERY_CHARGING_80(new String(Character.toChars(0xF008A))),
        BATTERY_CHARGING_90(new String(Character.toChars(0xF008B))),
        BATTERY_CHARGING_HIGH(new String(Character.toChars(0xF12A6))),
        BATTERY_CHARGING_LOW(new String(Character.toChars(0xF12A4))),
        BATTERY_CHARGING_MEDIUM(new String(Character.toChars(0xF12A5))),
        BATTERY_CHARGING_OUTLINE(new String(Character.toChars(0xF089F))),
        BATTERY_CHARGING_WIRELESS(new String(Character.toChars(0xF0807))),
        BATTERY_CHARGING_WIRELESS_10(new String(Character.toChars(0xF0808))),
        BATTERY_CHARGING_WIRELESS_20(new String(Character.toChars(0xF0809))),
        BATTERY_CHARGING_WIRELESS_30(new String(Character.toChars(0xF080A))),
        BATTERY_CHARGING_WIRELESS_40(new String(Character.toChars(0xF080B))),
        BATTERY_CHARGING_WIRELESS_50(new String(Character.toChars(0xF080C))),
        BATTERY_CHARGING_WIRELESS_60(new String(Character.toChars(0xF080D))),
        BATTERY_CHARGING_WIRELESS_70(new String(Character.toChars(0xF080E))),
        BATTERY_CHARGING_WIRELESS_80(new String(Character.toChars(0xF080F))),
        BATTERY_CHARGING_WIRELESS_90(new String(Character.toChars(0xF0810))),
        BATTERY_CHARGING_WIRELESS_ALERT(new String(Character.toChars(0xF0811))),
        BATTERY_CHARGING_WIRELESS_OUTLINE(new String(Character.toChars(0xF0812))),
        BATTERY_CHECK(new String(Character.toChars(0xF17E2))),
        BATTERY_CHECK_OUTLINE(new String(Character.toChars(0xF17E3))),
        BATTERY_CLOCK(new String(Character.toChars(0xF19E5))),
        BATTERY_CLOCK_OUTLINE(new String(Character.toChars(0xF19E6))),
        BATTERY_HEART(new String(Character.toChars(0xF120F))),
        BATTERY_HEART_OUTLINE(new String(Character.toChars(0xF1210))),
        BATTERY_HEART_VARIANT(new String(Character.toChars(0xF1211))),
        BATTERY_HIGH(new String(Character.toChars(0xF12A3))),
        BATTERY_LOCK(new String(Character.toChars(0xF179C))),
        BATTERY_LOCK_OPEN(new String(Character.toChars(0xF179D))),
        BATTERY_LOW(new String(Character.toChars(0xF12A1))),
        BATTERY_MEDIUM(new String(Character.toChars(0xF12A2))),
        BATTERY_MINUS(new String(Character.toChars(0xF17E4))),
        BATTERY_MINUS_OUTLINE(new String(Character.toChars(0xF17E5))),
        BATTERY_MINUS_VARIANT(new String(Character.toChars(0xF008C))),
        BATTERY_NEGATIVE(new String(Character.toChars(0xF008D))),
        BATTERY_OFF(new String(Character.toChars(0xF125D))),
        BATTERY_OFF_OUTLINE(new String(Character.toChars(0xF125E))),
        BATTERY_OUTLINE(new String(Character.toChars(0xF008E))),
        BATTERY_PLUS(new String(Character.toChars(0xF17E6))),
        BATTERY_PLUS_OUTLINE(new String(Character.toChars(0xF17E7))),
        BATTERY_PLUS_VARIANT(new String(Character.toChars(0xF008F))),
        BATTERY_POSITIVE(new String(Character.toChars(0xF0090))),
        BATTERY_REMOVE(new String(Character.toChars(0xF17E8))),
        BATTERY_REMOVE_OUTLINE(new String(Character.toChars(0xF17E9))),
        BATTERY_SYNC(new String(Character.toChars(0xF1834))),
        BATTERY_SYNC_OUTLINE(new String(Character.toChars(0xF1835))),
        BATTERY_UNKNOWN(new String(Character.toChars(0xF0091))),
        BATTERY_UNKNOWN_BLUETOOTH(new String(Character.toChars(0xF094A))),
        BEACH(new String(Character.toChars(0xF0092))),
        BEAKER(new String(Character.toChars(0xF0CEA))),
        BEAKER_ALERT(new String(Character.toChars(0xF1229))),
        BEAKER_ALERT_OUTLINE(new String(Character.toChars(0xF122A))),
        BEAKER_CHECK(new String(Character.toChars(0xF122B))),
        BEAKER_CHECK_OUTLINE(new String(Character.toChars(0xF122C))),
        BEAKER_MINUS(new String(Character.toChars(0xF122D))),
        BEAKER_MINUS_OUTLINE(new String(Character.toChars(0xF122E))),
        BEAKER_OUTLINE(new String(Character.toChars(0xF0690))),
        BEAKER_PLUS(new String(Character.toChars(0xF122F))),
        BEAKER_PLUS_OUTLINE(new String(Character.toChars(0xF1230))),
        BEAKER_QUESTION(new String(Character.toChars(0xF1231))),
        BEAKER_QUESTION_OUTLINE(new String(Character.toChars(0xF1232))),
        BEAKER_REMOVE(new String(Character.toChars(0xF1233))),
        BEAKER_REMOVE_OUTLINE(new String(Character.toChars(0xF1234))),
        BED(new String(Character.toChars(0xF02E3))),
        BED_CLOCK(new String(Character.toChars(0xF1B94))),
        BED_DOUBLE(new String(Character.toChars(0xF0FD4))),
        BED_DOUBLE_OUTLINE(new String(Character.toChars(0xF0FD3))),
        BED_EMPTY(new String(Character.toChars(0xF08A0))),
        BED_KING(new String(Character.toChars(0xF0FD2))),
        BED_KING_OUTLINE(new String(Character.toChars(0xF0FD1))),
        BED_OUTLINE(new String(Character.toChars(0xF0099))),
        BED_QUEEN(new String(Character.toChars(0xF0FD0))),
        BED_QUEEN_OUTLINE(new String(Character.toChars(0xF0FDB))),
        BED_SINGLE(new String(Character.toChars(0xF106D))),
        BED_SINGLE_OUTLINE(new String(Character.toChars(0xF106E))),
        BEE(new String(Character.toChars(0xF0FA1))),
        BEE_FLOWER(new String(Character.toChars(0xF0FA2))),
        BEEHIVE_OFF_OUTLINE(new String(Character.toChars(0xF13ED))),
        BEEHIVE_OUTLINE(new String(Character.toChars(0xF10CE))),
        BEEKEEPER(new String(Character.toChars(0xF14E2))),
        BEER(new String(Character.toChars(0xF0098))),
        BEER_OUTLINE(new String(Character.toChars(0xF130C))),
        BELL(new String(Character.toChars(0xF009A))),
        BELL_ALERT(new String(Character.toChars(0xF0D59))),
        BELL_ALERT_OUTLINE(new String(Character.toChars(0xF0E81))),
        BELL_BADGE(new String(Character.toChars(0xF116B))),
        BELL_BADGE_OUTLINE(new String(Character.toChars(0xF0178))),
        BELL_CANCEL(new String(Character.toChars(0xF13E7))),
        BELL_CANCEL_OUTLINE(new String(Character.toChars(0xF13E8))),
        BELL_CHECK(new String(Character.toChars(0xF11E5))),
        BELL_CHECK_OUTLINE(new String(Character.toChars(0xF11E6))),
        BELL_CIRCLE(new String(Character.toChars(0xF0D5A))),
        BELL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0D5B))),
        BELL_COG(new String(Character.toChars(0xF1A29))),
        BELL_COG_OUTLINE(new String(Character.toChars(0xF1A2A))),
        BELL_MINUS(new String(Character.toChars(0xF13E9))),
        BELL_MINUS_OUTLINE(new String(Character.toChars(0xF13EA))),
        BELL_OFF(new String(Character.toChars(0xF009B))),
        BELL_OFF_OUTLINE(new String(Character.toChars(0xF0A91))),
        BELL_OUTLINE(new String(Character.toChars(0xF009C))),
        BELL_PLUS(new String(Character.toChars(0xF009D))),
        BELL_PLUS_OUTLINE(new String(Character.toChars(0xF0A92))),
        BELL_REMOVE(new String(Character.toChars(0xF13EB))),
        BELL_REMOVE_OUTLINE(new String(Character.toChars(0xF13EC))),
        BELL_RING(new String(Character.toChars(0xF009E))),
        BELL_RING_OUTLINE(new String(Character.toChars(0xF009F))),
        BELL_SLEEP(new String(Character.toChars(0xF00A0))),
        BELL_SLEEP_OUTLINE(new String(Character.toChars(0xF0A93))),
        BENCH(new String(Character.toChars(0xF1C21))),
        BENCH_BACK(new String(Character.toChars(0xF1C22))),
        BETA(new String(Character.toChars(0xF00A1))),
        BETAMAX(new String(Character.toChars(0xF09CB))),
        BIATHLON(new String(Character.toChars(0xF0E14))),
        BICYCLE(new String(Character.toChars(0xF109C))),
        BICYCLE_BASKET(new String(Character.toChars(0xF1235))),
        BICYCLE_CARGO(new String(Character.toChars(0xF189C))),
        BICYCLE_ELECTRIC(new String(Character.toChars(0xF15B4))),
        BICYCLE_PENNY_FARTHING(new String(Character.toChars(0xF15E9))),
        BIKE(new String(Character.toChars(0xF00A3))),
        BIKE_FAST(new String(Character.toChars(0xF111F))),
        BIKE_PEDAL(new String(Character.toChars(0xF1C23))),
        BIKE_PEDAL_CLIPLESS(new String(Character.toChars(0xF1C24))),
        BIKE_PEDAL_MOUNTAIN(new String(Character.toChars(0xF1C25))),
        BILLBOARD(new String(Character.toChars(0xF1010))),
        BILLIARDS(new String(Character.toChars(0xF0B61))),
        BILLIARDS_RACK(new String(Character.toChars(0xF0B62))),
        BINOCULARS(new String(Character.toChars(0xF00A5))),
        BIO(new String(Character.toChars(0xF00A6))),
        BIOHAZARD(new String(Character.toChars(0xF00A7))),
        BIRD(new String(Character.toChars(0xF15C6))),
        BITBUCKET(new String(Character.toChars(0xF00A8))),
        BITCOIN(new String(Character.toChars(0xF0813))),
        BLACK_MESA(new String(Character.toChars(0xF00A9))),
        BLENDER(new String(Character.toChars(0xF0CEB))),
        BLENDER_OUTLINE(new String(Character.toChars(0xF181A))),
        BLENDER_SOFTWARE(new String(Character.toChars(0xF00AB))),
        BLINDS(new String(Character.toChars(0xF00AC))),
        BLINDS_HORIZONTAL(new String(Character.toChars(0xF1A2B))),
        BLINDS_HORIZONTAL_CLOSED(new String(Character.toChars(0xF1A2C))),
        BLINDS_OPEN(new String(Character.toChars(0xF1011))),
        BLINDS_VERTICAL(new String(Character.toChars(0xF1A2D))),
        BLINDS_VERTICAL_CLOSED(new String(Character.toChars(0xF1A2E))),
        BLOCK_HELPER(new String(Character.toChars(0xF00AD))),
        BLOOD_BAG(new String(Character.toChars(0xF0CEC))),
        BLUETOOTH(new String(Character.toChars(0xF00AF))),
        BLUETOOTH_AUDIO(new String(Character.toChars(0xF00B0))),
        BLUETOOTH_CONNECT(new String(Character.toChars(0xF00B1))),
        BLUETOOTH_OFF(new String(Character.toChars(0xF00B2))),
        BLUETOOTH_SETTINGS(new String(Character.toChars(0xF00B3))),
        BLUETOOTH_TRANSFER(new String(Character.toChars(0xF00B4))),
        BLUR(new String(Character.toChars(0xF00B5))),
        BLUR_LINEAR(new String(Character.toChars(0xF00B6))),
        BLUR_OFF(new String(Character.toChars(0xF00B7))),
        BLUR_RADIAL(new String(Character.toChars(0xF00B8))),
        BOLT(new String(Character.toChars(0xF0DB3))),
        BOMB(new String(Character.toChars(0xF0691))),
        BOMB_OFF(new String(Character.toChars(0xF06C5))),
        BONE(new String(Character.toChars(0xF00B9))),
        BONE_OFF(new String(Character.toChars(0xF19E0))),
        BOOK(new String(Character.toChars(0xF00BA))),
        BOOK_ACCOUNT(new String(Character.toChars(0xF13AD))),
        BOOK_ACCOUNT_OUTLINE(new String(Character.toChars(0xF13AE))),
        BOOK_ALERT(new String(Character.toChars(0xF167C))),
        BOOK_ALERT_OUTLINE(new String(Character.toChars(0xF167D))),
        BOOK_ALPHABET(new String(Character.toChars(0xF061D))),
        BOOK_ARROW_DOWN(new String(Character.toChars(0xF167E))),
        BOOK_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF167F))),
        BOOK_ARROW_LEFT(new String(Character.toChars(0xF1680))),
        BOOK_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF1681))),
        BOOK_ARROW_RIGHT(new String(Character.toChars(0xF1682))),
        BOOK_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1683))),
        BOOK_ARROW_UP(new String(Character.toChars(0xF1684))),
        BOOK_ARROW_UP_OUTLINE(new String(Character.toChars(0xF1685))),
        BOOK_CANCEL(new String(Character.toChars(0xF1686))),
        BOOK_CANCEL_OUTLINE(new String(Character.toChars(0xF1687))),
        BOOK_CHECK(new String(Character.toChars(0xF14F3))),
        BOOK_CHECK_OUTLINE(new String(Character.toChars(0xF14F4))),
        BOOK_CLOCK(new String(Character.toChars(0xF1688))),
        BOOK_CLOCK_OUTLINE(new String(Character.toChars(0xF1689))),
        BOOK_COG(new String(Character.toChars(0xF168A))),
        BOOK_COG_OUTLINE(new String(Character.toChars(0xF168B))),
        BOOK_CROSS(new String(Character.toChars(0xF00A2))),
        BOOK_EDIT(new String(Character.toChars(0xF168C))),
        BOOK_EDIT_OUTLINE(new String(Character.toChars(0xF168D))),
        BOOK_EDUCATION(new String(Character.toChars(0xF16C9))),
        BOOK_EDUCATION_OUTLINE(new String(Character.toChars(0xF16CA))),
        BOOK_HEART(new String(Character.toChars(0xF1A1D))),
        BOOK_HEART_OUTLINE(new String(Character.toChars(0xF1A1E))),
        BOOK_INFORMATION_VARIANT(new String(Character.toChars(0xF106F))),
        BOOK_LOCK(new String(Character.toChars(0xF079A))),
        BOOK_LOCK_OPEN(new String(Character.toChars(0xF079B))),
        BOOK_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF168E))),
        BOOK_LOCK_OUTLINE(new String(Character.toChars(0xF168F))),
        BOOK_MARKER(new String(Character.toChars(0xF1690))),
        BOOK_MARKER_OUTLINE(new String(Character.toChars(0xF1691))),
        BOOK_MINUS(new String(Character.toChars(0xF05D9))),
        BOOK_MINUS_MULTIPLE(new String(Character.toChars(0xF0A94))),
        BOOK_MINUS_MULTIPLE_OUTLINE(new String(Character.toChars(0xF090B))),
        BOOK_MINUS_OUTLINE(new String(Character.toChars(0xF1692))),
        BOOK_MULTIPLE(new String(Character.toChars(0xF00BB))),
        BOOK_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0436))),
        BOOK_MUSIC(new String(Character.toChars(0xF0067))),
        BOOK_MUSIC_OUTLINE(new String(Character.toChars(0xF1693))),
        BOOK_OFF(new String(Character.toChars(0xF1694))),
        BOOK_OFF_OUTLINE(new String(Character.toChars(0xF1695))),
        BOOK_OPEN(new String(Character.toChars(0xF00BD))),
        BOOK_OPEN_BLANK_VARIANT(new String(Character.toChars(0xF00BE))),
        BOOK_OPEN_OUTLINE(new String(Character.toChars(0xF0B63))),
        BOOK_OPEN_PAGE_VARIANT(new String(Character.toChars(0xF05DA))),
        BOOK_OPEN_PAGE_VARIANT_OUTLINE(new String(Character.toChars(0xF15D6))),
        BOOK_OPEN_VARIANT(new String(Character.toChars(0xF14F7))),
        BOOK_OUTLINE(new String(Character.toChars(0xF0B64))),
        BOOK_PLAY(new String(Character.toChars(0xF0E82))),
        BOOK_PLAY_OUTLINE(new String(Character.toChars(0xF0E83))),
        BOOK_PLUS(new String(Character.toChars(0xF05DB))),
        BOOK_PLUS_MULTIPLE(new String(Character.toChars(0xF0A95))),
        BOOK_PLUS_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0ADE))),
        BOOK_PLUS_OUTLINE(new String(Character.toChars(0xF1696))),
        BOOK_REFRESH(new String(Character.toChars(0xF1697))),
        BOOK_REFRESH_OUTLINE(new String(Character.toChars(0xF1698))),
        BOOK_REMOVE(new String(Character.toChars(0xF0A97))),
        BOOK_REMOVE_MULTIPLE(new String(Character.toChars(0xF0A96))),
        BOOK_REMOVE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF04CA))),
        BOOK_REMOVE_OUTLINE(new String(Character.toChars(0xF1699))),
        BOOK_SEARCH(new String(Character.toChars(0xF0E84))),
        BOOK_SEARCH_OUTLINE(new String(Character.toChars(0xF0E85))),
        BOOK_SETTINGS(new String(Character.toChars(0xF169A))),
        BOOK_SETTINGS_OUTLINE(new String(Character.toChars(0xF169B))),
        BOOK_SYNC(new String(Character.toChars(0xF169C))),
        BOOK_SYNC_OUTLINE(new String(Character.toChars(0xF16C8))),
        BOOK_VARIANT(new String(Character.toChars(0xF00BF))),
        BOOKMARK(new String(Character.toChars(0xF00C0))),
        BOOKMARK_BOX(new String(Character.toChars(0xF1B75))),
        BOOKMARK_BOX_MULTIPLE(new String(Character.toChars(0xF196C))),
        BOOKMARK_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF196D))),
        BOOKMARK_BOX_OUTLINE(new String(Character.toChars(0xF1B76))),
        BOOKMARK_CHECK(new String(Character.toChars(0xF00C1))),
        BOOKMARK_CHECK_OUTLINE(new String(Character.toChars(0xF137B))),
        BOOKMARK_MINUS(new String(Character.toChars(0xF09CC))),
        BOOKMARK_MINUS_OUTLINE(new String(Character.toChars(0xF09CD))),
        BOOKMARK_MULTIPLE(new String(Character.toChars(0xF0E15))),
        BOOKMARK_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0E16))),
        BOOKMARK_MUSIC(new String(Character.toChars(0xF00C2))),
        BOOKMARK_MUSIC_OUTLINE(new String(Character.toChars(0xF1379))),
        BOOKMARK_OFF(new String(Character.toChars(0xF09CE))),
        BOOKMARK_OFF_OUTLINE(new String(Character.toChars(0xF09CF))),
        BOOKMARK_OUTLINE(new String(Character.toChars(0xF00C3))),
        BOOKMARK_PLUS(new String(Character.toChars(0xF00C5))),
        BOOKMARK_PLUS_OUTLINE(new String(Character.toChars(0xF00C4))),
        BOOKMARK_REMOVE(new String(Character.toChars(0xF00C6))),
        BOOKMARK_REMOVE_OUTLINE(new String(Character.toChars(0xF137A))),
        BOOKSHELF(new String(Character.toChars(0xF125F))),
        BOOM_GATE(new String(Character.toChars(0xF0E86))),
        BOOM_GATE_ALERT(new String(Character.toChars(0xF0E87))),
        BOOM_GATE_ALERT_OUTLINE(new String(Character.toChars(0xF0E88))),
        BOOM_GATE_ARROW_DOWN(new String(Character.toChars(0xF0E89))),
        BOOM_GATE_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF0E8A))),
        BOOM_GATE_ARROW_UP(new String(Character.toChars(0xF0E8C))),
        BOOM_GATE_ARROW_UP_OUTLINE(new String(Character.toChars(0xF0E8D))),
        BOOM_GATE_OUTLINE(new String(Character.toChars(0xF0E8B))),
        BOOM_GATE_UP(new String(Character.toChars(0xF17F9))),
        BOOM_GATE_UP_OUTLINE(new String(Character.toChars(0xF17FA))),
        BOOMBOX(new String(Character.toChars(0xF05DC))),
        BOOMERANG(new String(Character.toChars(0xF10CF))),
        BOOTSTRAP(new String(Character.toChars(0xF06C6))),
        BORDER_ALL(new String(Character.toChars(0xF00C7))),
        BORDER_ALL_VARIANT(new String(Character.toChars(0xF08A1))),
        BORDER_BOTTOM(new String(Character.toChars(0xF00C8))),
        BORDER_BOTTOM_VARIANT(new String(Character.toChars(0xF08A2))),
        BORDER_COLOR(new String(Character.toChars(0xF00C9))),
        BORDER_HORIZONTAL(new String(Character.toChars(0xF00CA))),
        BORDER_INSIDE(new String(Character.toChars(0xF00CB))),
        BORDER_LEFT(new String(Character.toChars(0xF00CC))),
        BORDER_LEFT_VARIANT(new String(Character.toChars(0xF08A3))),
        BORDER_NONE(new String(Character.toChars(0xF00CD))),
        BORDER_NONE_VARIANT(new String(Character.toChars(0xF08A4))),
        BORDER_OUTSIDE(new String(Character.toChars(0xF00CE))),
        BORDER_RADIUS(new String(Character.toChars(0xF1AF4))),
        BORDER_RIGHT(new String(Character.toChars(0xF00CF))),
        BORDER_RIGHT_VARIANT(new String(Character.toChars(0xF08A5))),
        BORDER_STYLE(new String(Character.toChars(0xF00D0))),
        BORDER_TOP(new String(Character.toChars(0xF00D1))),
        BORDER_TOP_VARIANT(new String(Character.toChars(0xF08A6))),
        BORDER_VERTICAL(new String(Character.toChars(0xF00D2))),
        BOTTLE_SODA(new String(Character.toChars(0xF1070))),
        BOTTLE_SODA_CLASSIC(new String(Character.toChars(0xF1071))),
        BOTTLE_SODA_CLASSIC_OUTLINE(new String(Character.toChars(0xF1363))),
        BOTTLE_SODA_OUTLINE(new String(Character.toChars(0xF1072))),
        BOTTLE_TONIC(new String(Character.toChars(0xF112E))),
        BOTTLE_TONIC_OUTLINE(new String(Character.toChars(0xF112F))),
        BOTTLE_TONIC_PLUS(new String(Character.toChars(0xF1130))),
        BOTTLE_TONIC_PLUS_OUTLINE(new String(Character.toChars(0xF1131))),
        BOTTLE_TONIC_SKULL(new String(Character.toChars(0xF1132))),
        BOTTLE_TONIC_SKULL_OUTLINE(new String(Character.toChars(0xF1133))),
        BOTTLE_WINE(new String(Character.toChars(0xF0854))),
        BOTTLE_WINE_OUTLINE(new String(Character.toChars(0xF1310))),
        BOW_ARROW(new String(Character.toChars(0xF1841))),
        BOW_TIE(new String(Character.toChars(0xF0678))),
        BOWL(new String(Character.toChars(0xF028E))),
        BOWL_MIX(new String(Character.toChars(0xF0617))),
        BOWL_MIX_OUTLINE(new String(Character.toChars(0xF02E4))),
        BOWL_OUTLINE(new String(Character.toChars(0xF02A9))),
        BOWLING(new String(Character.toChars(0xF00D3))),
        BOX(new String(Character.toChars(0xF00D4))),
        BOX_CUTTER(new String(Character.toChars(0xF00D5))),
        BOX_CUTTER_OFF(new String(Character.toChars(0xF0B4A))),
        BOX_SHADOW(new String(Character.toChars(0xF0637))),
        BOXING_GLOVE(new String(Character.toChars(0xF0B65))),
        BRAILLE(new String(Character.toChars(0xF09D0))),
        BRAIN(new String(Character.toChars(0xF09D1))),
        BREAD_SLICE(new String(Character.toChars(0xF0CEE))),
        BREAD_SLICE_OUTLINE(new String(Character.toChars(0xF0CEF))),
        BRIDGE(new String(Character.toChars(0xF0618))),
        BRIEFCASE(new String(Character.toChars(0xF00D6))),
        BRIEFCASE_ACCOUNT(new String(Character.toChars(0xF0CF0))),
        BRIEFCASE_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0CF1))),
        BRIEFCASE_ARROW_LEFT_RIGHT(new String(Character.toChars(0xF1A8D))),
        BRIEFCASE_ARROW_LEFT_RIGHT_OUTLINE(new String(Character.toChars(0xF1A8E))),
        BRIEFCASE_ARROW_UP_DOWN(new String(Character.toChars(0xF1A8F))),
        BRIEFCASE_ARROW_UP_DOWN_OUTLINE(new String(Character.toChars(0xF1A90))),
        BRIEFCASE_CHECK(new String(Character.toChars(0xF00D7))),
        BRIEFCASE_CHECK_OUTLINE(new String(Character.toChars(0xF131E))),
        BRIEFCASE_CLOCK(new String(Character.toChars(0xF10D0))),
        BRIEFCASE_CLOCK_OUTLINE(new String(Character.toChars(0xF10D1))),
        BRIEFCASE_DOWNLOAD(new String(Character.toChars(0xF00D8))),
        BRIEFCASE_DOWNLOAD_OUTLINE(new String(Character.toChars(0xF0C3D))),
        BRIEFCASE_EDIT(new String(Character.toChars(0xF0A98))),
        BRIEFCASE_EDIT_OUTLINE(new String(Character.toChars(0xF0C3E))),
        BRIEFCASE_EYE(new String(Character.toChars(0xF17D9))),
        BRIEFCASE_EYE_OUTLINE(new String(Character.toChars(0xF17DA))),
        BRIEFCASE_MINUS(new String(Character.toChars(0xF0A2A))),
        BRIEFCASE_MINUS_OUTLINE(new String(Character.toChars(0xF0C3F))),
        BRIEFCASE_OFF(new String(Character.toChars(0xF1658))),
        BRIEFCASE_OFF_OUTLINE(new String(Character.toChars(0xF1659))),
        BRIEFCASE_OUTLINE(new String(Character.toChars(0xF0814))),
        BRIEFCASE_PLUS(new String(Character.toChars(0xF0A2B))),
        BRIEFCASE_PLUS_OUTLINE(new String(Character.toChars(0xF0C40))),
        BRIEFCASE_REMOVE(new String(Character.toChars(0xF0A2C))),
        BRIEFCASE_REMOVE_OUTLINE(new String(Character.toChars(0xF0C41))),
        BRIEFCASE_SEARCH(new String(Character.toChars(0xF0A2D))),
        BRIEFCASE_SEARCH_OUTLINE(new String(Character.toChars(0xF0C42))),
        BRIEFCASE_UPLOAD(new String(Character.toChars(0xF00D9))),
        BRIEFCASE_UPLOAD_OUTLINE(new String(Character.toChars(0xF0C43))),
        BRIEFCASE_VARIANT(new String(Character.toChars(0xF1494))),
        BRIEFCASE_VARIANT_OFF(new String(Character.toChars(0xF165A))),
        BRIEFCASE_VARIANT_OFF_OUTLINE(new String(Character.toChars(0xF165B))),
        BRIEFCASE_VARIANT_OUTLINE(new String(Character.toChars(0xF1495))),
        BRIGHTNESS_1(new String(Character.toChars(0xF00DA))),
        BRIGHTNESS_2(new String(Character.toChars(0xF00DB))),
        BRIGHTNESS_3(new String(Character.toChars(0xF00DC))),
        BRIGHTNESS_4(new String(Character.toChars(0xF00DD))),
        BRIGHTNESS_5(new String(Character.toChars(0xF00DE))),
        BRIGHTNESS_6(new String(Character.toChars(0xF00DF))),
        BRIGHTNESS_7(new String(Character.toChars(0xF00E0))),
        BRIGHTNESS_AUTO(new String(Character.toChars(0xF00E1))),
        BRIGHTNESS_PERCENT(new String(Character.toChars(0xF0CF2))),
        BROADCAST(new String(Character.toChars(0xF1720))),
        BROADCAST_OFF(new String(Character.toChars(0xF1721))),
        BROOM(new String(Character.toChars(0xF00E2))),
        BRUSH(new String(Character.toChars(0xF00E3))),
        BRUSH_OFF(new String(Character.toChars(0xF1771))),
        BRUSH_OUTLINE(new String(Character.toChars(0xF1A0D))),
        BRUSH_VARIANT(new String(Character.toChars(0xF1813))),
        BUCKET(new String(Character.toChars(0xF1415))),
        BUCKET_OUTLINE(new String(Character.toChars(0xF1416))),
        BUFFET(new String(Character.toChars(0xF0578))),
        BUG(new String(Character.toChars(0xF00E4))),
        BUG_CHECK(new String(Character.toChars(0xF0A2E))),
        BUG_CHECK_OUTLINE(new String(Character.toChars(0xF0A2F))),
        BUG_OUTLINE(new String(Character.toChars(0xF0A30))),
        BUG_PAUSE(new String(Character.toChars(0xF1AF5))),
        BUG_PAUSE_OUTLINE(new String(Character.toChars(0xF1AF6))),
        BUG_PLAY(new String(Character.toChars(0xF1AF7))),
        BUG_PLAY_OUTLINE(new String(Character.toChars(0xF1AF8))),
        BUG_STOP(new String(Character.toChars(0xF1AF9))),
        BUG_STOP_OUTLINE(new String(Character.toChars(0xF1AFA))),
        BUGLE(new String(Character.toChars(0xF0DB4))),
        BULKHEAD_LIGHT(new String(Character.toChars(0xF1A2F))),
        BULLDOZER(new String(Character.toChars(0xF0B22))),
        BULLET(new String(Character.toChars(0xF0CF3))),
        BULLETIN_BOARD(new String(Character.toChars(0xF00E5))),
        BULLHORN(new String(Character.toChars(0xF00E6))),
        BULLHORN_OUTLINE(new String(Character.toChars(0xF0B23))),
        BULLHORN_VARIANT(new String(Character.toChars(0xF196E))),
        BULLHORN_VARIANT_OUTLINE(new String(Character.toChars(0xF196F))),
        BULLSEYE(new String(Character.toChars(0xF05DD))),
        BULLSEYE_ARROW(new String(Character.toChars(0xF08C9))),
        BULMA(new String(Character.toChars(0xF12E7))),
        BUNK_BED(new String(Character.toChars(0xF1302))),
        BUNK_BED_OUTLINE(new String(Character.toChars(0xF0097))),
        BUS(new String(Character.toChars(0xF00E7))),
        BUS_ALERT(new String(Character.toChars(0xF0A99))),
        BUS_ARTICULATED_END(new String(Character.toChars(0xF079C))),
        BUS_ARTICULATED_FRONT(new String(Character.toChars(0xF079D))),
        BUS_CLOCK(new String(Character.toChars(0xF08CA))),
        BUS_DOUBLE_DECKER(new String(Character.toChars(0xF079E))),
        BUS_ELECTRIC(new String(Character.toChars(0xF191D))),
        BUS_MARKER(new String(Character.toChars(0xF1212))),
        BUS_MULTIPLE(new String(Character.toChars(0xF0F3F))),
        BUS_SCHOOL(new String(Character.toChars(0xF079F))),
        BUS_SIDE(new String(Character.toChars(0xF07A0))),
        BUS_STOP(new String(Character.toChars(0xF1012))),
        BUS_STOP_COVERED(new String(Character.toChars(0xF1013))),
        BUS_STOP_UNCOVERED(new String(Character.toChars(0xF1014))),
        BUTTERFLY(new String(Character.toChars(0xF1589))),
        BUTTERFLY_OUTLINE(new String(Character.toChars(0xF158A))),
        BUTTON_CURSOR(new String(Character.toChars(0xF1B4F))),
        BUTTON_POINTER(new String(Character.toChars(0xF1B50)));

        private final String unicode;

        B(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public B getDefaultGlyph()
        {
            return B.BABEL;
        }
    }

    public enum C implements MaterialDesignIconGlyphs<C> {

        CABIN_A_FRAME(new String(Character.toChars(0xF188C))),
        CABLE_DATA(new String(Character.toChars(0xF1394))),
        CACHED(new String(Character.toChars(0xF00E8))),
        CACTUS(new String(Character.toChars(0xF0DB5))),
        CAKE(new String(Character.toChars(0xF00E9))),
        CAKE_LAYERED(new String(Character.toChars(0xF00EA))),
        CAKE_VARIANT(new String(Character.toChars(0xF00EB))),
        CAKE_VARIANT_OUTLINE(new String(Character.toChars(0xF17F0))),
        CALCULATOR(new String(Character.toChars(0xF00EC))),
        CALCULATOR_VARIANT(new String(Character.toChars(0xF0A9A))),
        CALCULATOR_VARIANT_OUTLINE(new String(Character.toChars(0xF15A6))),
        CALENDAR(new String(Character.toChars(0xF00ED))),
        CALENDAR_ACCOUNT(new String(Character.toChars(0xF0ED7))),
        CALENDAR_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0ED8))),
        CALENDAR_ALERT(new String(Character.toChars(0xF0A31))),
        CALENDAR_ALERT_OUTLINE(new String(Character.toChars(0xF1B62))),
        CALENDAR_ARROW_LEFT(new String(Character.toChars(0xF1134))),
        CALENDAR_ARROW_RIGHT(new String(Character.toChars(0xF1135))),
        CALENDAR_BADGE(new String(Character.toChars(0xF1B9D))),
        CALENDAR_BADGE_OUTLINE(new String(Character.toChars(0xF1B9E))),
        CALENDAR_BLANK(new String(Character.toChars(0xF00EE))),
        CALENDAR_BLANK_MULTIPLE(new String(Character.toChars(0xF1073))),
        CALENDAR_BLANK_OUTLINE(new String(Character.toChars(0xF0B66))),
        CALENDAR_CHECK(new String(Character.toChars(0xF00EF))),
        CALENDAR_CHECK_OUTLINE(new String(Character.toChars(0xF0C44))),
        CALENDAR_CLOCK(new String(Character.toChars(0xF00F0))),
        CALENDAR_CLOCK_OUTLINE(new String(Character.toChars(0xF16E1))),
        CALENDAR_COLLAPSE_HORIZONTAL(new String(Character.toChars(0xF189D))),
        CALENDAR_COLLAPSE_HORIZONTAL_OUTLINE(new String(Character.toChars(0xF1B63))),
        CALENDAR_CURSOR(new String(Character.toChars(0xF157B))),
        CALENDAR_CURSOR_OUTLINE(new String(Character.toChars(0xF1B64))),
        CALENDAR_EDIT(new String(Character.toChars(0xF08A7))),
        CALENDAR_EDIT_OUTLINE(new String(Character.toChars(0xF1B65))),
        CALENDAR_END(new String(Character.toChars(0xF166C))),
        CALENDAR_END_OUTLINE(new String(Character.toChars(0xF1B66))),
        CALENDAR_EXPAND_HORIZONTAL(new String(Character.toChars(0xF189E))),
        CALENDAR_EXPAND_HORIZONTAL_OUTLINE(new String(Character.toChars(0xF1B67))),
        CALENDAR_EXPORT(new String(Character.toChars(0xF0B24))),
        CALENDAR_EXPORT_OUTLINE(new String(Character.toChars(0xF1B68))),
        CALENDAR_FILTER(new String(Character.toChars(0xF1A32))),
        CALENDAR_FILTER_OUTLINE(new String(Character.toChars(0xF1A33))),
        CALENDAR_HEART(new String(Character.toChars(0xF09D2))),
        CALENDAR_HEART_OUTLINE(new String(Character.toChars(0xF1B69))),
        CALENDAR_IMPORT(new String(Character.toChars(0xF0B25))),
        CALENDAR_IMPORT_OUTLINE(new String(Character.toChars(0xF1B6A))),
        CALENDAR_LOCK(new String(Character.toChars(0xF1641))),
        CALENDAR_LOCK_OPEN(new String(Character.toChars(0xF1B5B))),
        CALENDAR_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1B5C))),
        CALENDAR_LOCK_OUTLINE(new String(Character.toChars(0xF1642))),
        CALENDAR_MINUS(new String(Character.toChars(0xF0D5C))),
        CALENDAR_MINUS_OUTLINE(new String(Character.toChars(0xF1B6B))),
        CALENDAR_MONTH(new String(Character.toChars(0xF0E17))),
        CALENDAR_MONTH_OUTLINE(new String(Character.toChars(0xF0E18))),
        CALENDAR_MULTIPLE(new String(Character.toChars(0xF00F1))),
        CALENDAR_MULTIPLE_CHECK(new String(Character.toChars(0xF00F2))),
        CALENDAR_MULTISELECT(new String(Character.toChars(0xF0A32))),
        CALENDAR_MULTISELECT_OUTLINE(new String(Character.toChars(0xF1B55))),
        CALENDAR_OUTLINE(new String(Character.toChars(0xF0B67))),
        CALENDAR_PLUS(new String(Character.toChars(0xF00F3))),
        CALENDAR_PLUS_OUTLINE(new String(Character.toChars(0xF1B6C))),
        CALENDAR_QUESTION(new String(Character.toChars(0xF0692))),
        CALENDAR_QUESTION_OUTLINE(new String(Character.toChars(0xF1B6D))),
        CALENDAR_RANGE(new String(Character.toChars(0xF0679))),
        CALENDAR_RANGE_OUTLINE(new String(Character.toChars(0xF0B68))),
        CALENDAR_REFRESH(new String(Character.toChars(0xF01E1))),
        CALENDAR_REFRESH_OUTLINE(new String(Character.toChars(0xF0203))),
        CALENDAR_REMOVE(new String(Character.toChars(0xF00F4))),
        CALENDAR_REMOVE_OUTLINE(new String(Character.toChars(0xF0C45))),
        CALENDAR_SEARCH(new String(Character.toChars(0xF094C))),
        CALENDAR_SEARCH_OUTLINE(new String(Character.toChars(0xF1B6E))),
        CALENDAR_STAR(new String(Character.toChars(0xF09D3))),
        CALENDAR_STAR_FOUR_POINTS(new String(Character.toChars(0xF1C1F))),
        CALENDAR_STAR_OUTLINE(new String(Character.toChars(0xF1B53))),
        CALENDAR_START(new String(Character.toChars(0xF166D))),
        CALENDAR_START_OUTLINE(new String(Character.toChars(0xF1B6F))),
        CALENDAR_SYNC(new String(Character.toChars(0xF0E8E))),
        CALENDAR_SYNC_OUTLINE(new String(Character.toChars(0xF0E8F))),
        CALENDAR_TEXT(new String(Character.toChars(0xF00F5))),
        CALENDAR_TEXT_OUTLINE(new String(Character.toChars(0xF0C46))),
        CALENDAR_TODAY(new String(Character.toChars(0xF00F6))),
        CALENDAR_TODAY_OUTLINE(new String(Character.toChars(0xF1A30))),
        CALENDAR_WEEK(new String(Character.toChars(0xF0A33))),
        CALENDAR_WEEK_BEGIN(new String(Character.toChars(0xF0A34))),
        CALENDAR_WEEK_BEGIN_OUTLINE(new String(Character.toChars(0xF1A31))),
        CALENDAR_WEEK_OUTLINE(new String(Character.toChars(0xF1A34))),
        CALENDAR_WEEKEND(new String(Character.toChars(0xF0ED9))),
        CALENDAR_WEEKEND_OUTLINE(new String(Character.toChars(0xF0EDA))),
        CALL_MADE(new String(Character.toChars(0xF00F7))),
        CALL_MERGE(new String(Character.toChars(0xF00F8))),
        CALL_MISSED(new String(Character.toChars(0xF00F9))),
        CALL_RECEIVED(new String(Character.toChars(0xF00FA))),
        CALL_SPLIT(new String(Character.toChars(0xF00FB))),
        CAMCORDER(new String(Character.toChars(0xF00FC))),
        CAMCORDER_OFF(new String(Character.toChars(0xF00FF))),
        CAMERA(new String(Character.toChars(0xF0100))),
        CAMERA_ACCOUNT(new String(Character.toChars(0xF08CB))),
        CAMERA_BURST(new String(Character.toChars(0xF0693))),
        CAMERA_CONTROL(new String(Character.toChars(0xF0B69))),
        CAMERA_DOCUMENT(new String(Character.toChars(0xF1871))),
        CAMERA_DOCUMENT_OFF(new String(Character.toChars(0xF1872))),
        CAMERA_ENHANCE(new String(Character.toChars(0xF0101))),
        CAMERA_ENHANCE_OUTLINE(new String(Character.toChars(0xF0B6A))),
        CAMERA_FLIP(new String(Character.toChars(0xF15D9))),
        CAMERA_FLIP_OUTLINE(new String(Character.toChars(0xF15DA))),
        CAMERA_FRONT(new String(Character.toChars(0xF0102))),
        CAMERA_FRONT_VARIANT(new String(Character.toChars(0xF0103))),
        CAMERA_GOPRO(new String(Character.toChars(0xF07A1))),
        CAMERA_IMAGE(new String(Character.toChars(0xF08CC))),
        CAMERA_IRIS(new String(Character.toChars(0xF0104))),
        CAMERA_LOCK(new String(Character.toChars(0xF1A14))),
        CAMERA_LOCK_OPEN(new String(Character.toChars(0xF1C0D))),
        CAMERA_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1C0E))),
        CAMERA_LOCK_OUTLINE(new String(Character.toChars(0xF1A15))),
        CAMERA_MARKER(new String(Character.toChars(0xF19A7))),
        CAMERA_MARKER_OUTLINE(new String(Character.toChars(0xF19A8))),
        CAMERA_METERING_CENTER(new String(Character.toChars(0xF07A2))),
        CAMERA_METERING_MATRIX(new String(Character.toChars(0xF07A3))),
        CAMERA_METERING_PARTIAL(new String(Character.toChars(0xF07A4))),
        CAMERA_METERING_SPOT(new String(Character.toChars(0xF07A5))),
        CAMERA_OFF(new String(Character.toChars(0xF05DF))),
        CAMERA_OFF_OUTLINE(new String(Character.toChars(0xF19BF))),
        CAMERA_OUTLINE(new String(Character.toChars(0xF0D5D))),
        CAMERA_PARTY_MODE(new String(Character.toChars(0xF0105))),
        CAMERA_PLUS(new String(Character.toChars(0xF0EDB))),
        CAMERA_PLUS_OUTLINE(new String(Character.toChars(0xF0EDC))),
        CAMERA_REAR(new String(Character.toChars(0xF0106))),
        CAMERA_REAR_VARIANT(new String(Character.toChars(0xF0107))),
        CAMERA_RETAKE(new String(Character.toChars(0xF0E19))),
        CAMERA_RETAKE_OUTLINE(new String(Character.toChars(0xF0E1A))),
        CAMERA_SWITCH(new String(Character.toChars(0xF0108))),
        CAMERA_SWITCH_OUTLINE(new String(Character.toChars(0xF084A))),
        CAMERA_TIMER(new String(Character.toChars(0xF0109))),
        CAMERA_WIRELESS(new String(Character.toChars(0xF0DB6))),
        CAMERA_WIRELESS_OUTLINE(new String(Character.toChars(0xF0DB7))),
        CAMPFIRE(new String(Character.toChars(0xF0EDD))),
        CANCEL(new String(Character.toChars(0xF073A))),
        CANDELABRA(new String(Character.toChars(0xF17D2))),
        CANDELABRA_FIRE(new String(Character.toChars(0xF17D3))),
        CANDLE(new String(Character.toChars(0xF05E2))),
        CANDY(new String(Character.toChars(0xF1970))),
        CANDY_OFF(new String(Character.toChars(0xF1971))),
        CANDY_OFF_OUTLINE(new String(Character.toChars(0xF1972))),
        CANDY_OUTLINE(new String(Character.toChars(0xF1973))),
        CANDYCANE(new String(Character.toChars(0xF010A))),
        CANNABIS(new String(Character.toChars(0xF07A6))),
        CANNABIS_OFF(new String(Character.toChars(0xF166E))),
        CAPS_LOCK(new String(Character.toChars(0xF0A9B))),
        CAR(new String(Character.toChars(0xF010B))),
        CAR_2_PLUS(new String(Character.toChars(0xF1015))),
        CAR_3_PLUS(new String(Character.toChars(0xF1016))),
        CAR_ARROW_LEFT(new String(Character.toChars(0xF13B2))),
        CAR_ARROW_RIGHT(new String(Character.toChars(0xF13B3))),
        CAR_BACK(new String(Character.toChars(0xF0E1B))),
        CAR_BATTERY(new String(Character.toChars(0xF010C))),
        CAR_BRAKE_ABS(new String(Character.toChars(0xF0C47))),
        CAR_BRAKE_ALERT(new String(Character.toChars(0xF0C48))),
        CAR_BRAKE_FLUID_LEVEL(new String(Character.toChars(0xF1909))),
        CAR_BRAKE_HOLD(new String(Character.toChars(0xF0D5E))),
        CAR_BRAKE_LOW_PRESSURE(new String(Character.toChars(0xF190A))),
        CAR_BRAKE_PARKING(new String(Character.toChars(0xF0D5F))),
        CAR_BRAKE_RETARDER(new String(Character.toChars(0xF1017))),
        CAR_BRAKE_TEMPERATURE(new String(Character.toChars(0xF190B))),
        CAR_BRAKE_WORN_LININGS(new String(Character.toChars(0xF190C))),
        CAR_CHILD_SEAT(new String(Character.toChars(0xF0FA3))),
        CAR_CLOCK(new String(Character.toChars(0xF1974))),
        CAR_CLUTCH(new String(Character.toChars(0xF1018))),
        CAR_COG(new String(Character.toChars(0xF13CC))),
        CAR_CONNECTED(new String(Character.toChars(0xF010D))),
        CAR_CONVERTIBLE(new String(Character.toChars(0xF07A7))),
        CAR_COOLANT_LEVEL(new String(Character.toChars(0xF1019))),
        CAR_CRUISE_CONTROL(new String(Character.toChars(0xF0D60))),
        CAR_DEFROST_FRONT(new String(Character.toChars(0xF0D61))),
        CAR_DEFROST_REAR(new String(Character.toChars(0xF0D62))),
        CAR_DOOR(new String(Character.toChars(0xF0B6B))),
        CAR_DOOR_LOCK(new String(Character.toChars(0xF109D))),
        CAR_ELECTRIC(new String(Character.toChars(0xF0B6C))),
        CAR_ELECTRIC_OUTLINE(new String(Character.toChars(0xF15B5))),
        CAR_EMERGENCY(new String(Character.toChars(0xF160F))),
        CAR_ESP(new String(Character.toChars(0xF0C49))),
        CAR_ESTATE(new String(Character.toChars(0xF07A8))),
        CAR_HATCHBACK(new String(Character.toChars(0xF07A9))),
        CAR_INFO(new String(Character.toChars(0xF11BE))),
        CAR_KEY(new String(Character.toChars(0xF0B6D))),
        CAR_LIFTED_PICKUP(new String(Character.toChars(0xF152D))),
        CAR_LIGHT_ALERT(new String(Character.toChars(0xF190D))),
        CAR_LIGHT_DIMMED(new String(Character.toChars(0xF0C4A))),
        CAR_LIGHT_FOG(new String(Character.toChars(0xF0C4B))),
        CAR_LIGHT_HIGH(new String(Character.toChars(0xF0C4C))),
        CAR_LIMOUSINE(new String(Character.toChars(0xF08CD))),
        CAR_MULTIPLE(new String(Character.toChars(0xF0B6E))),
        CAR_OFF(new String(Character.toChars(0xF0E1C))),
        CAR_OUTLINE(new String(Character.toChars(0xF14ED))),
        CAR_PARKING_LIGHTS(new String(Character.toChars(0xF0D63))),
        CAR_PICKUP(new String(Character.toChars(0xF07AA))),
        CAR_SEARCH(new String(Character.toChars(0xF1B8D))),
        CAR_SEARCH_OUTLINE(new String(Character.toChars(0xF1B8E))),
        CAR_SEAT(new String(Character.toChars(0xF0FA4))),
        CAR_SEAT_COOLER(new String(Character.toChars(0xF0FA5))),
        CAR_SEAT_HEATER(new String(Character.toChars(0xF0FA6))),
        CAR_SELECT(new String(Character.toChars(0xF1879))),
        CAR_SETTINGS(new String(Character.toChars(0xF13CD))),
        CAR_SHIFT_PATTERN(new String(Character.toChars(0xF0F40))),
        CAR_SIDE(new String(Character.toChars(0xF07AB))),
        CAR_SPEED_LIMITER(new String(Character.toChars(0xF190E))),
        CAR_SPORTS(new String(Character.toChars(0xF07AC))),
        CAR_TIRE_ALERT(new String(Character.toChars(0xF0C4D))),
        CAR_TRACTION_CONTROL(new String(Character.toChars(0xF0D64))),
        CAR_TURBOCHARGER(new String(Character.toChars(0xF101A))),
        CAR_WASH(new String(Character.toChars(0xF010E))),
        CAR_WINDSHIELD(new String(Character.toChars(0xF101B))),
        CAR_WINDSHIELD_OUTLINE(new String(Character.toChars(0xF101C))),
        CAR_WIRELESS(new String(Character.toChars(0xF1878))),
        CAR_WRENCH(new String(Character.toChars(0xF1814))),
        CARABINER(new String(Character.toChars(0xF14C0))),
        CARAVAN(new String(Character.toChars(0xF07AD))),
        CARD(new String(Character.toChars(0xF0B6F))),
        CARD_ACCOUNT_DETAILS(new String(Character.toChars(0xF05D2))),
        CARD_ACCOUNT_DETAILS_OUTLINE(new String(Character.toChars(0xF0DAB))),
        CARD_ACCOUNT_DETAILS_STAR(new String(Character.toChars(0xF02A3))),
        CARD_ACCOUNT_DETAILS_STAR_OUTLINE(new String(Character.toChars(0xF06DB))),
        CARD_ACCOUNT_MAIL(new String(Character.toChars(0xF018E))),
        CARD_ACCOUNT_MAIL_OUTLINE(new String(Character.toChars(0xF0E98))),
        CARD_ACCOUNT_PHONE(new String(Character.toChars(0xF0E99))),
        CARD_ACCOUNT_PHONE_OUTLINE(new String(Character.toChars(0xF0E9A))),
        CARD_BULLETED(new String(Character.toChars(0xF0B70))),
        CARD_BULLETED_OFF(new String(Character.toChars(0xF0B71))),
        CARD_BULLETED_OFF_OUTLINE(new String(Character.toChars(0xF0B72))),
        CARD_BULLETED_OUTLINE(new String(Character.toChars(0xF0B73))),
        CARD_BULLETED_SETTINGS(new String(Character.toChars(0xF0B74))),
        CARD_BULLETED_SETTINGS_OUTLINE(new String(Character.toChars(0xF0B75))),
        CARD_MINUS(new String(Character.toChars(0xF1600))),
        CARD_MINUS_OUTLINE(new String(Character.toChars(0xF1601))),
        CARD_MULTIPLE(new String(Character.toChars(0xF17F1))),
        CARD_MULTIPLE_OUTLINE(new String(Character.toChars(0xF17F2))),
        CARD_OFF(new String(Character.toChars(0xF1602))),
        CARD_OFF_OUTLINE(new String(Character.toChars(0xF1603))),
        CARD_OUTLINE(new String(Character.toChars(0xF0B76))),
        CARD_PLUS(new String(Character.toChars(0xF11FF))),
        CARD_PLUS_OUTLINE(new String(Character.toChars(0xF1200))),
        CARD_REMOVE(new String(Character.toChars(0xF1604))),
        CARD_REMOVE_OUTLINE(new String(Character.toChars(0xF1605))),
        CARD_SEARCH(new String(Character.toChars(0xF1074))),
        CARD_SEARCH_OUTLINE(new String(Character.toChars(0xF1075))),
        CARD_TEXT(new String(Character.toChars(0xF0B77))),
        CARD_TEXT_OUTLINE(new String(Character.toChars(0xF0B78))),
        CARDS(new String(Character.toChars(0xF0638))),
        CARDS_CLUB(new String(Character.toChars(0xF08CE))),
        CARDS_CLUB_OUTLINE(new String(Character.toChars(0xF189F))),
        CARDS_DIAMOND(new String(Character.toChars(0xF08CF))),
        CARDS_DIAMOND_OUTLINE(new String(Character.toChars(0xF101D))),
        CARDS_HEART(new String(Character.toChars(0xF08D0))),
        CARDS_HEART_OUTLINE(new String(Character.toChars(0xF18A0))),
        CARDS_OUTLINE(new String(Character.toChars(0xF0639))),
        CARDS_PLAYING(new String(Character.toChars(0xF18A1))),
        CARDS_PLAYING_CLUB(new String(Character.toChars(0xF18A2))),
        CARDS_PLAYING_CLUB_MULTIPLE(new String(Character.toChars(0xF18A3))),
        CARDS_PLAYING_CLUB_MULTIPLE_OUTLINE(new String(Character.toChars(0xF18A4))),
        CARDS_PLAYING_CLUB_OUTLINE(new String(Character.toChars(0xF18A5))),
        CARDS_PLAYING_DIAMOND(new String(Character.toChars(0xF18A6))),
        CARDS_PLAYING_DIAMOND_MULTIPLE(new String(Character.toChars(0xF18A7))),
        CARDS_PLAYING_DIAMOND_MULTIPLE_OUTLINE(new String(Character.toChars(0xF18A8))),
        CARDS_PLAYING_DIAMOND_OUTLINE(new String(Character.toChars(0xF18A9))),
        CARDS_PLAYING_HEART(new String(Character.toChars(0xF18AA))),
        CARDS_PLAYING_HEART_MULTIPLE(new String(Character.toChars(0xF18AB))),
        CARDS_PLAYING_HEART_MULTIPLE_OUTLINE(new String(Character.toChars(0xF18AC))),
        CARDS_PLAYING_HEART_OUTLINE(new String(Character.toChars(0xF18AD))),
        CARDS_PLAYING_OUTLINE(new String(Character.toChars(0xF063A))),
        CARDS_PLAYING_SPADE(new String(Character.toChars(0xF18AE))),
        CARDS_PLAYING_SPADE_MULTIPLE(new String(Character.toChars(0xF18AF))),
        CARDS_PLAYING_SPADE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF18B0))),
        CARDS_PLAYING_SPADE_OUTLINE(new String(Character.toChars(0xF18B1))),
        CARDS_SPADE(new String(Character.toChars(0xF08D1))),
        CARDS_SPADE_OUTLINE(new String(Character.toChars(0xF18B2))),
        CARDS_VARIANT(new String(Character.toChars(0xF06C7))),
        CARROT(new String(Character.toChars(0xF010F))),
        CART(new String(Character.toChars(0xF0110))),
        CART_ARROW_DOWN(new String(Character.toChars(0xF0D66))),
        CART_ARROW_RIGHT(new String(Character.toChars(0xF0C4E))),
        CART_ARROW_UP(new String(Character.toChars(0xF0D67))),
        CART_CHECK(new String(Character.toChars(0xF15EA))),
        CART_HEART(new String(Character.toChars(0xF18E0))),
        CART_MINUS(new String(Character.toChars(0xF0D68))),
        CART_OFF(new String(Character.toChars(0xF066B))),
        CART_OUTLINE(new String(Character.toChars(0xF0111))),
        CART_PERCENT(new String(Character.toChars(0xF1BAE))),
        CART_PLUS(new String(Character.toChars(0xF0112))),
        CART_REMOVE(new String(Character.toChars(0xF0D69))),
        CART_VARIANT(new String(Character.toChars(0xF15EB))),
        CASE_SENSITIVE_ALT(new String(Character.toChars(0xF0113))),
        CASH(new String(Character.toChars(0xF0114))),
        CASH_100(new String(Character.toChars(0xF0115))),
        CASH_CHECK(new String(Character.toChars(0xF14EE))),
        CASH_CLOCK(new String(Character.toChars(0xF1A91))),
        CASH_FAST(new String(Character.toChars(0xF185C))),
        CASH_LOCK(new String(Character.toChars(0xF14EA))),
        CASH_LOCK_OPEN(new String(Character.toChars(0xF14EB))),
        CASH_MARKER(new String(Character.toChars(0xF0DB8))),
        CASH_MINUS(new String(Character.toChars(0xF1260))),
        CASH_MULTIPLE(new String(Character.toChars(0xF0116))),
        CASH_OFF(new String(Character.toChars(0xF1C79))),
        CASH_PLUS(new String(Character.toChars(0xF1261))),
        CASH_REFUND(new String(Character.toChars(0xF0A9C))),
        CASH_REGISTER(new String(Character.toChars(0xF0CF4))),
        CASH_REMOVE(new String(Character.toChars(0xF1262))),
        CASH_SYNC(new String(Character.toChars(0xF1A92))),
        CASSETTE(new String(Character.toChars(0xF09D4))),
        CAST(new String(Character.toChars(0xF0118))),
        CAST_AUDIO(new String(Character.toChars(0xF101E))),
        CAST_AUDIO_VARIANT(new String(Character.toChars(0xF1749))),
        CAST_CONNECTED(new String(Character.toChars(0xF0119))),
        CAST_EDUCATION(new String(Character.toChars(0xF0E1D))),
        CAST_OFF(new String(Character.toChars(0xF078A))),
        CAST_VARIANT(new String(Character.toChars(0xF001F))),
        CASTLE(new String(Character.toChars(0xF011A))),
        CAT(new String(Character.toChars(0xF011B))),
        CCTV(new String(Character.toChars(0xF07AE))),
        CCTV_OFF(new String(Character.toChars(0xF185F))),
        CEILING_FAN(new String(Character.toChars(0xF1797))),
        CEILING_FAN_LIGHT(new String(Character.toChars(0xF1798))),
        CEILING_LIGHT(new String(Character.toChars(0xF0769))),
        CEILING_LIGHT_MULTIPLE(new String(Character.toChars(0xF18DD))),
        CEILING_LIGHT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF18DE))),
        CEILING_LIGHT_OUTLINE(new String(Character.toChars(0xF17C7))),
        CELLPHONE(new String(Character.toChars(0xF011C))),
        CELLPHONE_ARROW_DOWN(new String(Character.toChars(0xF09D5))),
        CELLPHONE_ARROW_DOWN_VARIANT(new String(Character.toChars(0xF19C5))),
        CELLPHONE_BASIC(new String(Character.toChars(0xF011E))),
        CELLPHONE_CHARGING(new String(Character.toChars(0xF1397))),
        CELLPHONE_CHECK(new String(Character.toChars(0xF17FD))),
        CELLPHONE_COG(new String(Character.toChars(0xF0951))),
        CELLPHONE_DOCK(new String(Character.toChars(0xF011F))),
        CELLPHONE_INFORMATION(new String(Character.toChars(0xF0F41))),
        CELLPHONE_KEY(new String(Character.toChars(0xF094E))),
        CELLPHONE_LINK(new String(Character.toChars(0xF0121))),
        CELLPHONE_LINK_OFF(new String(Character.toChars(0xF0122))),
        CELLPHONE_LOCK(new String(Character.toChars(0xF094F))),
        CELLPHONE_MARKER(new String(Character.toChars(0xF183A))),
        CELLPHONE_MESSAGE(new String(Character.toChars(0xF08D3))),
        CELLPHONE_MESSAGE_OFF(new String(Character.toChars(0xF10D2))),
        CELLPHONE_NFC(new String(Character.toChars(0xF0E90))),
        CELLPHONE_NFC_OFF(new String(Character.toChars(0xF12D8))),
        CELLPHONE_OFF(new String(Character.toChars(0xF0950))),
        CELLPHONE_PLAY(new String(Character.toChars(0xF101F))),
        CELLPHONE_REMOVE(new String(Character.toChars(0xF094D))),
        CELLPHONE_SCREENSHOT(new String(Character.toChars(0xF0A35))),
        CELLPHONE_SETTINGS(new String(Character.toChars(0xF0123))),
        CELLPHONE_SOUND(new String(Character.toChars(0xF0952))),
        CELLPHONE_TEXT(new String(Character.toChars(0xF08D2))),
        CELLPHONE_WIRELESS(new String(Character.toChars(0xF0815))),
        CENTOS(new String(Character.toChars(0xF111A))),
        CERTIFICATE(new String(Character.toChars(0xF0124))),
        CERTIFICATE_OUTLINE(new String(Character.toChars(0xF1188))),
        CHAIR_ROLLING(new String(Character.toChars(0xF0F48))),
        CHAIR_SCHOOL(new String(Character.toChars(0xF0125))),
        CHANDELIER(new String(Character.toChars(0xF1793))),
        CHARITY(new String(Character.toChars(0xF0C4F))),
        CHART_ARC(new String(Character.toChars(0xF0126))),
        CHART_AREASPLINE(new String(Character.toChars(0xF0127))),
        CHART_AREASPLINE_VARIANT(new String(Character.toChars(0xF0E91))),
        CHART_BAR(new String(Character.toChars(0xF0128))),
        CHART_BAR_STACKED(new String(Character.toChars(0xF076A))),
        CHART_BELL_CURVE(new String(Character.toChars(0xF0C50))),
        CHART_BELL_CURVE_CUMULATIVE(new String(Character.toChars(0xF0FA7))),
        CHART_BOX(new String(Character.toChars(0xF154D))),
        CHART_BOX_OUTLINE(new String(Character.toChars(0xF154E))),
        CHART_BOX_PLUS_OUTLINE(new String(Character.toChars(0xF154F))),
        CHART_BUBBLE(new String(Character.toChars(0xF05E3))),
        CHART_DONUT(new String(Character.toChars(0xF07AF))),
        CHART_DONUT_VARIANT(new String(Character.toChars(0xF07B0))),
        CHART_GANTT(new String(Character.toChars(0xF066C))),
        CHART_HISTOGRAM(new String(Character.toChars(0xF0129))),
        CHART_LINE(new String(Character.toChars(0xF012A))),
        CHART_LINE_STACKED(new String(Character.toChars(0xF076B))),
        CHART_LINE_VARIANT(new String(Character.toChars(0xF07B1))),
        CHART_MULTILINE(new String(Character.toChars(0xF08D4))),
        CHART_MULTIPLE(new String(Character.toChars(0xF1213))),
        CHART_PIE(new String(Character.toChars(0xF012B))),
        CHART_PIE_OUTLINE(new String(Character.toChars(0xF1BDF))),
        CHART_PPF(new String(Character.toChars(0xF1380))),
        CHART_SANKEY(new String(Character.toChars(0xF11DF))),
        CHART_SANKEY_VARIANT(new String(Character.toChars(0xF11E0))),
        CHART_SCATTER_PLOT(new String(Character.toChars(0xF0E92))),
        CHART_SCATTER_PLOT_HEXBIN(new String(Character.toChars(0xF066D))),
        CHART_TIMELINE(new String(Character.toChars(0xF066E))),
        CHART_TIMELINE_VARIANT(new String(Character.toChars(0xF0E93))),
        CHART_TIMELINE_VARIANT_SHIMMER(new String(Character.toChars(0xF15B6))),
        CHART_TREE(new String(Character.toChars(0xF0E94))),
        CHART_WATERFALL(new String(Character.toChars(0xF1918))),
        CHAT(new String(Character.toChars(0xF0B79))),
        CHAT_ALERT(new String(Character.toChars(0xF0B7A))),
        CHAT_ALERT_OUTLINE(new String(Character.toChars(0xF12C9))),
        CHAT_MINUS(new String(Character.toChars(0xF1410))),
        CHAT_MINUS_OUTLINE(new String(Character.toChars(0xF1413))),
        CHAT_OUTLINE(new String(Character.toChars(0xF0EDE))),
        CHAT_PLUS(new String(Character.toChars(0xF140F))),
        CHAT_PLUS_OUTLINE(new String(Character.toChars(0xF1412))),
        CHAT_PROCESSING(new String(Character.toChars(0xF0B7B))),
        CHAT_PROCESSING_OUTLINE(new String(Character.toChars(0xF12CA))),
        CHAT_QUESTION(new String(Character.toChars(0xF1738))),
        CHAT_QUESTION_OUTLINE(new String(Character.toChars(0xF1739))),
        CHAT_REMOVE(new String(Character.toChars(0xF1411))),
        CHAT_REMOVE_OUTLINE(new String(Character.toChars(0xF1414))),
        CHAT_SLEEP(new String(Character.toChars(0xF12D1))),
        CHAT_SLEEP_OUTLINE(new String(Character.toChars(0xF12D2))),
        CHECK(new String(Character.toChars(0xF012C))),
        CHECK_ALL(new String(Character.toChars(0xF012D))),
        CHECK_BOLD(new String(Character.toChars(0xF0E1E))),
        CHECK_CIRCLE(new String(Character.toChars(0xF05E0))),
        CHECK_CIRCLE_OUTLINE(new String(Character.toChars(0xF05E1))),
        CHECK_DECAGRAM(new String(Character.toChars(0xF0791))),
        CHECK_DECAGRAM_OUTLINE(new String(Character.toChars(0xF1740))),
        CHECK_NETWORK(new String(Character.toChars(0xF0C53))),
        CHECK_NETWORK_OUTLINE(new String(Character.toChars(0xF0C54))),
        CHECK_OUTLINE(new String(Character.toChars(0xF0855))),
        CHECK_UNDERLINE(new String(Character.toChars(0xF0E1F))),
        CHECK_UNDERLINE_CIRCLE(new String(Character.toChars(0xF0E20))),
        CHECK_UNDERLINE_CIRCLE_OUTLINE(new String(Character.toChars(0xF0E21))),
        CHECKBOOK(new String(Character.toChars(0xF0A9D))),
        CHECKBOOK_ARROW_LEFT(new String(Character.toChars(0xF1C1D))),
        CHECKBOOK_ARROW_RIGHT(new String(Character.toChars(0xF1C1E))),
        CHECKBOX_BLANK(new String(Character.toChars(0xF012E))),
        CHECKBOX_BLANK_BADGE(new String(Character.toChars(0xF1176))),
        CHECKBOX_BLANK_BADGE_OUTLINE(new String(Character.toChars(0xF0117))),
        CHECKBOX_BLANK_CIRCLE(new String(Character.toChars(0xF012F))),
        CHECKBOX_BLANK_CIRCLE_OUTLINE(new String(Character.toChars(0xF0130))),
        CHECKBOX_BLANK_OFF(new String(Character.toChars(0xF12EC))),
        CHECKBOX_BLANK_OFF_OUTLINE(new String(Character.toChars(0xF12ED))),
        CHECKBOX_BLANK_OUTLINE(new String(Character.toChars(0xF0131))),
        CHECKBOX_INTERMEDIATE(new String(Character.toChars(0xF0856))),
        CHECKBOX_INTERMEDIATE_VARIANT(new String(Character.toChars(0xF1B54))),
        CHECKBOX_MARKED(new String(Character.toChars(0xF0132))),
        CHECKBOX_MARKED_CIRCLE(new String(Character.toChars(0xF0133))),
        CHECKBOX_MARKED_CIRCLE_AUTO_OUTLINE(new String(Character.toChars(0xF1C26))),
        CHECKBOX_MARKED_CIRCLE_MINUS_OUTLINE(new String(Character.toChars(0xF1C27))),
        CHECKBOX_MARKED_CIRCLE_OUTLINE(new String(Character.toChars(0xF0134))),
        CHECKBOX_MARKED_CIRCLE_PLUS_OUTLINE(new String(Character.toChars(0xF1927))),
        CHECKBOX_MARKED_OUTLINE(new String(Character.toChars(0xF0135))),
        CHECKBOX_MULTIPLE_BLANK(new String(Character.toChars(0xF0136))),
        CHECKBOX_MULTIPLE_BLANK_CIRCLE(new String(Character.toChars(0xF063B))),
        CHECKBOX_MULTIPLE_BLANK_CIRCLE_OUTLINE(new String(Character.toChars(0xF063C))),
        CHECKBOX_MULTIPLE_BLANK_OUTLINE(new String(Character.toChars(0xF0137))),
        CHECKBOX_MULTIPLE_MARKED(new String(Character.toChars(0xF0138))),
        CHECKBOX_MULTIPLE_MARKED_CIRCLE(new String(Character.toChars(0xF063D))),
        CHECKBOX_MULTIPLE_MARKED_CIRCLE_OUTLINE(new String(Character.toChars(0xF063E))),
        CHECKBOX_MULTIPLE_MARKED_OUTLINE(new String(Character.toChars(0xF0139))),
        CHECKBOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0C51))),
        CHECKBOX_OUTLINE(new String(Character.toChars(0xF0C52))),
        CHECKERBOARD(new String(Character.toChars(0xF013A))),
        CHECKERBOARD_MINUS(new String(Character.toChars(0xF1202))),
        CHECKERBOARD_PLUS(new String(Character.toChars(0xF1201))),
        CHECKERBOARD_REMOVE(new String(Character.toChars(0xF1203))),
        CHEESE(new String(Character.toChars(0xF12B9))),
        CHEESE_OFF(new String(Character.toChars(0xF13EE))),
        CHEF_HAT(new String(Character.toChars(0xF0B7C))),
        CHEMICAL_WEAPON(new String(Character.toChars(0xF013B))),
        CHESS_BISHOP(new String(Character.toChars(0xF085C))),
        CHESS_KING(new String(Character.toChars(0xF0857))),
        CHESS_KNIGHT(new String(Character.toChars(0xF0858))),
        CHESS_PAWN(new String(Character.toChars(0xF0859))),
        CHESS_QUEEN(new String(Character.toChars(0xF085A))),
        CHESS_ROOK(new String(Character.toChars(0xF085B))),
        CHEVRON_DOUBLE_DOWN(new String(Character.toChars(0xF013C))),
        CHEVRON_DOUBLE_LEFT(new String(Character.toChars(0xF013D))),
        CHEVRON_DOUBLE_RIGHT(new String(Character.toChars(0xF013E))),
        CHEVRON_DOUBLE_UP(new String(Character.toChars(0xF013F))),
        CHEVRON_DOWN(new String(Character.toChars(0xF0140))),
        CHEVRON_DOWN_BOX(new String(Character.toChars(0xF09D6))),
        CHEVRON_DOWN_BOX_OUTLINE(new String(Character.toChars(0xF09D7))),
        CHEVRON_DOWN_CIRCLE(new String(Character.toChars(0xF0B26))),
        CHEVRON_DOWN_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B27))),
        CHEVRON_LEFT(new String(Character.toChars(0xF0141))),
        CHEVRON_LEFT_BOX(new String(Character.toChars(0xF09D8))),
        CHEVRON_LEFT_BOX_OUTLINE(new String(Character.toChars(0xF09D9))),
        CHEVRON_LEFT_CIRCLE(new String(Character.toChars(0xF0B28))),
        CHEVRON_LEFT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B29))),
        CHEVRON_RIGHT(new String(Character.toChars(0xF0142))),
        CHEVRON_RIGHT_BOX(new String(Character.toChars(0xF09DA))),
        CHEVRON_RIGHT_BOX_OUTLINE(new String(Character.toChars(0xF09DB))),
        CHEVRON_RIGHT_CIRCLE(new String(Character.toChars(0xF0B2A))),
        CHEVRON_RIGHT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B2B))),
        CHEVRON_TRIPLE_DOWN(new String(Character.toChars(0xF0DB9))),
        CHEVRON_TRIPLE_LEFT(new String(Character.toChars(0xF0DBA))),
        CHEVRON_TRIPLE_RIGHT(new String(Character.toChars(0xF0DBB))),
        CHEVRON_TRIPLE_UP(new String(Character.toChars(0xF0DBC))),
        CHEVRON_UP(new String(Character.toChars(0xF0143))),
        CHEVRON_UP_BOX(new String(Character.toChars(0xF09DC))),
        CHEVRON_UP_BOX_OUTLINE(new String(Character.toChars(0xF09DD))),
        CHEVRON_UP_CIRCLE(new String(Character.toChars(0xF0B2C))),
        CHEVRON_UP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B2D))),
        CHILI_ALERT(new String(Character.toChars(0xF17EA))),
        CHILI_ALERT_OUTLINE(new String(Character.toChars(0xF17EB))),
        CHILI_HOT(new String(Character.toChars(0xF07B2))),
        CHILI_HOT_OUTLINE(new String(Character.toChars(0xF17EC))),
        CHILI_MEDIUM(new String(Character.toChars(0xF07B3))),
        CHILI_MEDIUM_OUTLINE(new String(Character.toChars(0xF17ED))),
        CHILI_MILD(new String(Character.toChars(0xF07B4))),
        CHILI_MILD_OUTLINE(new String(Character.toChars(0xF17EE))),
        CHILI_OFF(new String(Character.toChars(0xF1467))),
        CHILI_OFF_OUTLINE(new String(Character.toChars(0xF17EF))),
        CHIP(new String(Character.toChars(0xF061A))),
        CHURCH(new String(Character.toChars(0xF0144))),
        CHURCH_OUTLINE(new String(Character.toChars(0xF1B02))),
        CIGAR(new String(Character.toChars(0xF1189))),
        CIGAR_OFF(new String(Character.toChars(0xF141B))),
        CIRCLE(new String(Character.toChars(0xF0765))),
        CIRCLE_BOX(new String(Character.toChars(0xF15DC))),
        CIRCLE_BOX_OUTLINE(new String(Character.toChars(0xF15DD))),
        CIRCLE_DOUBLE(new String(Character.toChars(0xF0E95))),
        CIRCLE_EDIT_OUTLINE(new String(Character.toChars(0xF08D5))),
        CIRCLE_EXPAND(new String(Character.toChars(0xF0E96))),
        CIRCLE_HALF(new String(Character.toChars(0xF1395))),
        CIRCLE_HALF_FULL(new String(Character.toChars(0xF1396))),
        CIRCLE_MEDIUM(new String(Character.toChars(0xF09DE))),
        CIRCLE_MULTIPLE(new String(Character.toChars(0xF0B38))),
        CIRCLE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0695))),
        CIRCLE_OFF_OUTLINE(new String(Character.toChars(0xF10D3))),
        CIRCLE_OPACITY(new String(Character.toChars(0xF1853))),
        CIRCLE_OUTLINE(new String(Character.toChars(0xF0766))),
        CIRCLE_SLICE_1(new String(Character.toChars(0xF0A9E))),
        CIRCLE_SLICE_2(new String(Character.toChars(0xF0A9F))),
        CIRCLE_SLICE_3(new String(Character.toChars(0xF0AA0))),
        CIRCLE_SLICE_4(new String(Character.toChars(0xF0AA1))),
        CIRCLE_SLICE_5(new String(Character.toChars(0xF0AA2))),
        CIRCLE_SLICE_6(new String(Character.toChars(0xF0AA3))),
        CIRCLE_SLICE_7(new String(Character.toChars(0xF0AA4))),
        CIRCLE_SLICE_8(new String(Character.toChars(0xF0AA5))),
        CIRCLE_SMALL(new String(Character.toChars(0xF09DF))),
        CIRCULAR_SAW(new String(Character.toChars(0xF0E22))),
        CITY(new String(Character.toChars(0xF0146))),
        CITY_SWITCH(new String(Character.toChars(0xF1C28))),
        CITY_VARIANT(new String(Character.toChars(0xF0A36))),
        CITY_VARIANT_OUTLINE(new String(Character.toChars(0xF0A37))),
        CLIPBOARD(new String(Character.toChars(0xF0147))),
        CLIPBOARD_ACCOUNT(new String(Character.toChars(0xF0148))),
        CLIPBOARD_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0C55))),
        CLIPBOARD_ALERT(new String(Character.toChars(0xF0149))),
        CLIPBOARD_ALERT_OUTLINE(new String(Character.toChars(0xF0CF7))),
        CLIPBOARD_ARROW_DOWN(new String(Character.toChars(0xF014A))),
        CLIPBOARD_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF0C56))),
        CLIPBOARD_ARROW_LEFT(new String(Character.toChars(0xF014B))),
        CLIPBOARD_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF0CF8))),
        CLIPBOARD_ARROW_RIGHT(new String(Character.toChars(0xF0CF9))),
        CLIPBOARD_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF0CFA))),
        CLIPBOARD_ARROW_UP(new String(Character.toChars(0xF0C57))),
        CLIPBOARD_ARROW_UP_OUTLINE(new String(Character.toChars(0xF0C58))),
        CLIPBOARD_CHECK(new String(Character.toChars(0xF014E))),
        CLIPBOARD_CHECK_MULTIPLE(new String(Character.toChars(0xF1263))),
        CLIPBOARD_CHECK_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1264))),
        CLIPBOARD_CHECK_OUTLINE(new String(Character.toChars(0xF08A8))),
        CLIPBOARD_CLOCK(new String(Character.toChars(0xF16E2))),
        CLIPBOARD_CLOCK_OUTLINE(new String(Character.toChars(0xF16E3))),
        CLIPBOARD_EDIT(new String(Character.toChars(0xF14E5))),
        CLIPBOARD_EDIT_OUTLINE(new String(Character.toChars(0xF14E6))),
        CLIPBOARD_FILE(new String(Character.toChars(0xF1265))),
        CLIPBOARD_FILE_OUTLINE(new String(Character.toChars(0xF1266))),
        CLIPBOARD_FLOW(new String(Character.toChars(0xF06C8))),
        CLIPBOARD_FLOW_OUTLINE(new String(Character.toChars(0xF1117))),
        CLIPBOARD_LIST(new String(Character.toChars(0xF10D4))),
        CLIPBOARD_LIST_OUTLINE(new String(Character.toChars(0xF10D5))),
        CLIPBOARD_MINUS(new String(Character.toChars(0xF1618))),
        CLIPBOARD_MINUS_OUTLINE(new String(Character.toChars(0xF1619))),
        CLIPBOARD_MULTIPLE(new String(Character.toChars(0xF1267))),
        CLIPBOARD_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1268))),
        CLIPBOARD_OFF(new String(Character.toChars(0xF161A))),
        CLIPBOARD_OFF_OUTLINE(new String(Character.toChars(0xF161B))),
        CLIPBOARD_OUTLINE(new String(Character.toChars(0xF014C))),
        CLIPBOARD_PLAY(new String(Character.toChars(0xF0C59))),
        CLIPBOARD_PLAY_MULTIPLE(new String(Character.toChars(0xF1269))),
        CLIPBOARD_PLAY_MULTIPLE_OUTLINE(new String(Character.toChars(0xF126A))),
        CLIPBOARD_PLAY_OUTLINE(new String(Character.toChars(0xF0C5A))),
        CLIPBOARD_PLUS(new String(Character.toChars(0xF0751))),
        CLIPBOARD_PLUS_OUTLINE(new String(Character.toChars(0xF131F))),
        CLIPBOARD_PULSE(new String(Character.toChars(0xF085D))),
        CLIPBOARD_PULSE_OUTLINE(new String(Character.toChars(0xF085E))),
        CLIPBOARD_REMOVE(new String(Character.toChars(0xF161C))),
        CLIPBOARD_REMOVE_OUTLINE(new String(Character.toChars(0xF161D))),
        CLIPBOARD_SEARCH(new String(Character.toChars(0xF161E))),
        CLIPBOARD_SEARCH_OUTLINE(new String(Character.toChars(0xF161F))),
        CLIPBOARD_TEXT(new String(Character.toChars(0xF014D))),
        CLIPBOARD_TEXT_CLOCK(new String(Character.toChars(0xF18F9))),
        CLIPBOARD_TEXT_CLOCK_OUTLINE(new String(Character.toChars(0xF18FA))),
        CLIPBOARD_TEXT_MULTIPLE(new String(Character.toChars(0xF126B))),
        CLIPBOARD_TEXT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF126C))),
        CLIPBOARD_TEXT_OFF(new String(Character.toChars(0xF1620))),
        CLIPBOARD_TEXT_OFF_OUTLINE(new String(Character.toChars(0xF1621))),
        CLIPBOARD_TEXT_OUTLINE(new String(Character.toChars(0xF0A38))),
        CLIPBOARD_TEXT_PLAY(new String(Character.toChars(0xF0C5B))),
        CLIPBOARD_TEXT_PLAY_OUTLINE(new String(Character.toChars(0xF0C5C))),
        CLIPBOARD_TEXT_SEARCH(new String(Character.toChars(0xF1622))),
        CLIPBOARD_TEXT_SEARCH_OUTLINE(new String(Character.toChars(0xF1623))),
        CLIPPY(new String(Character.toChars(0xF014F))),
        CLOCK(new String(Character.toChars(0xF0954))),
        CLOCK_ALERT(new String(Character.toChars(0xF0955))),
        CLOCK_ALERT_OUTLINE(new String(Character.toChars(0xF05CE))),
        CLOCK_CHECK(new String(Character.toChars(0xF0FA8))),
        CLOCK_CHECK_OUTLINE(new String(Character.toChars(0xF0FA9))),
        CLOCK_DIGITAL(new String(Character.toChars(0xF0E97))),
        CLOCK_EDIT(new String(Character.toChars(0xF19BA))),
        CLOCK_EDIT_OUTLINE(new String(Character.toChars(0xF19BB))),
        CLOCK_END(new String(Character.toChars(0xF0151))),
        CLOCK_FAST(new String(Character.toChars(0xF0152))),
        CLOCK_IN(new String(Character.toChars(0xF0153))),
        CLOCK_MINUS(new String(Character.toChars(0xF1863))),
        CLOCK_MINUS_OUTLINE(new String(Character.toChars(0xF1864))),
        CLOCK_OUT(new String(Character.toChars(0xF0154))),
        CLOCK_OUTLINE(new String(Character.toChars(0xF0150))),
        CLOCK_PLUS(new String(Character.toChars(0xF1861))),
        CLOCK_PLUS_OUTLINE(new String(Character.toChars(0xF1862))),
        CLOCK_REMOVE(new String(Character.toChars(0xF1865))),
        CLOCK_REMOVE_OUTLINE(new String(Character.toChars(0xF1866))),
        CLOCK_STAR_FOUR_POINTS(new String(Character.toChars(0xF1C29))),
        CLOCK_STAR_FOUR_POINTS_OUTLINE(new String(Character.toChars(0xF1C2A))),
        CLOCK_START(new String(Character.toChars(0xF0155))),
        CLOCK_TIME_EIGHT(new String(Character.toChars(0xF1446))),
        CLOCK_TIME_EIGHT_OUTLINE(new String(Character.toChars(0xF1452))),
        CLOCK_TIME_ELEVEN(new String(Character.toChars(0xF1449))),
        CLOCK_TIME_ELEVEN_OUTLINE(new String(Character.toChars(0xF1455))),
        CLOCK_TIME_FIVE(new String(Character.toChars(0xF1443))),
        CLOCK_TIME_FIVE_OUTLINE(new String(Character.toChars(0xF144F))),
        CLOCK_TIME_FOUR(new String(Character.toChars(0xF1442))),
        CLOCK_TIME_FOUR_OUTLINE(new String(Character.toChars(0xF144E))),
        CLOCK_TIME_NINE(new String(Character.toChars(0xF1447))),
        CLOCK_TIME_NINE_OUTLINE(new String(Character.toChars(0xF1453))),
        CLOCK_TIME_ONE(new String(Character.toChars(0xF143F))),
        CLOCK_TIME_ONE_OUTLINE(new String(Character.toChars(0xF144B))),
        CLOCK_TIME_SEVEN(new String(Character.toChars(0xF1445))),
        CLOCK_TIME_SEVEN_OUTLINE(new String(Character.toChars(0xF1451))),
        CLOCK_TIME_SIX(new String(Character.toChars(0xF1444))),
        CLOCK_TIME_SIX_OUTLINE(new String(Character.toChars(0xF1450))),
        CLOCK_TIME_TEN(new String(Character.toChars(0xF1448))),
        CLOCK_TIME_TEN_OUTLINE(new String(Character.toChars(0xF1454))),
        CLOCK_TIME_THREE(new String(Character.toChars(0xF1441))),
        CLOCK_TIME_THREE_OUTLINE(new String(Character.toChars(0xF144D))),
        CLOCK_TIME_TWELVE(new String(Character.toChars(0xF144A))),
        CLOCK_TIME_TWELVE_OUTLINE(new String(Character.toChars(0xF1456))),
        CLOCK_TIME_TWO(new String(Character.toChars(0xF1440))),
        CLOCK_TIME_TWO_OUTLINE(new String(Character.toChars(0xF144C))),
        CLOSE(new String(Character.toChars(0xF0156))),
        CLOSE_BOX(new String(Character.toChars(0xF0157))),
        CLOSE_BOX_MULTIPLE(new String(Character.toChars(0xF0C5D))),
        CLOSE_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0C5E))),
        CLOSE_BOX_OUTLINE(new String(Character.toChars(0xF0158))),
        CLOSE_CIRCLE(new String(Character.toChars(0xF0159))),
        CLOSE_CIRCLE_MULTIPLE(new String(Character.toChars(0xF062A))),
        CLOSE_CIRCLE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0883))),
        CLOSE_CIRCLE_OUTLINE(new String(Character.toChars(0xF015A))),
        CLOSE_NETWORK(new String(Character.toChars(0xF015B))),
        CLOSE_NETWORK_OUTLINE(new String(Character.toChars(0xF0C5F))),
        CLOSE_OCTAGON(new String(Character.toChars(0xF015C))),
        CLOSE_OCTAGON_OUTLINE(new String(Character.toChars(0xF015D))),
        CLOSE_OUTLINE(new String(Character.toChars(0xF06C9))),
        CLOSE_THICK(new String(Character.toChars(0xF1398))),
        CLOSED_CAPTION(new String(Character.toChars(0xF015E))),
        CLOSED_CAPTION_OUTLINE(new String(Character.toChars(0xF0DBD))),
        CLOUD(new String(Character.toChars(0xF015F))),
        CLOUD_ALERT(new String(Character.toChars(0xF09E0))),
        CLOUD_ALERT_OUTLINE(new String(Character.toChars(0xF1BE0))),
        CLOUD_ARROW_DOWN(new String(Character.toChars(0xF1BE1))),
        CLOUD_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF1BE2))),
        CLOUD_ARROW_LEFT(new String(Character.toChars(0xF1BE3))),
        CLOUD_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF1BE4))),
        CLOUD_ARROW_RIGHT(new String(Character.toChars(0xF1BE5))),
        CLOUD_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1BE6))),
        CLOUD_ARROW_UP(new String(Character.toChars(0xF1BE7))),
        CLOUD_ARROW_UP_OUTLINE(new String(Character.toChars(0xF1BE8))),
        CLOUD_BRACES(new String(Character.toChars(0xF07B5))),
        CLOUD_CANCEL(new String(Character.toChars(0xF1BE9))),
        CLOUD_CANCEL_OUTLINE(new String(Character.toChars(0xF1BEA))),
        CLOUD_CHECK(new String(Character.toChars(0xF1BEB))),
        CLOUD_CHECK_OUTLINE(new String(Character.toChars(0xF1BEC))),
        CLOUD_CHECK_VARIANT(new String(Character.toChars(0xF0160))),
        CLOUD_CHECK_VARIANT_OUTLINE(new String(Character.toChars(0xF12CC))),
        CLOUD_CIRCLE(new String(Character.toChars(0xF0161))),
        CLOUD_CIRCLE_OUTLINE(new String(Character.toChars(0xF1BED))),
        CLOUD_CLOCK(new String(Character.toChars(0xF1BEE))),
        CLOUD_CLOCK_OUTLINE(new String(Character.toChars(0xF1BEF))),
        CLOUD_COG(new String(Character.toChars(0xF1BF0))),
        CLOUD_COG_OUTLINE(new String(Character.toChars(0xF1BF1))),
        CLOUD_DOWNLOAD(new String(Character.toChars(0xF0162))),
        CLOUD_DOWNLOAD_OUTLINE(new String(Character.toChars(0xF0B7D))),
        CLOUD_LOCK(new String(Character.toChars(0xF11F1))),
        CLOUD_LOCK_OPEN(new String(Character.toChars(0xF1BF2))),
        CLOUD_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1BF3))),
        CLOUD_LOCK_OUTLINE(new String(Character.toChars(0xF11F2))),
        CLOUD_MINUS(new String(Character.toChars(0xF1BF4))),
        CLOUD_MINUS_OUTLINE(new String(Character.toChars(0xF1BF5))),
        CLOUD_OFF(new String(Character.toChars(0xF1BF6))),
        CLOUD_OFF_OUTLINE(new String(Character.toChars(0xF0164))),
        CLOUD_OUTLINE(new String(Character.toChars(0xF0163))),
        CLOUD_PERCENT(new String(Character.toChars(0xF1A35))),
        CLOUD_PERCENT_OUTLINE(new String(Character.toChars(0xF1A36))),
        CLOUD_PLUS(new String(Character.toChars(0xF1BF7))),
        CLOUD_PLUS_OUTLINE(new String(Character.toChars(0xF1BF8))),
        CLOUD_PRINT(new String(Character.toChars(0xF0165))),
        CLOUD_PRINT_OUTLINE(new String(Character.toChars(0xF0166))),
        CLOUD_QUESTION(new String(Character.toChars(0xF0A39))),
        CLOUD_QUESTION_OUTLINE(new String(Character.toChars(0xF1BF9))),
        CLOUD_REFRESH(new String(Character.toChars(0xF1BFA))),
        CLOUD_REFRESH_OUTLINE(new String(Character.toChars(0xF1BFB))),
        CLOUD_REFRESH_VARIANT(new String(Character.toChars(0xF052A))),
        CLOUD_REFRESH_VARIANT_OUTLINE(new String(Character.toChars(0xF1BFC))),
        CLOUD_REMOVE(new String(Character.toChars(0xF1BFD))),
        CLOUD_REMOVE_OUTLINE(new String(Character.toChars(0xF1BFE))),
        CLOUD_SEARCH(new String(Character.toChars(0xF0956))),
        CLOUD_SEARCH_OUTLINE(new String(Character.toChars(0xF0957))),
        CLOUD_SYNC(new String(Character.toChars(0xF063F))),
        CLOUD_SYNC_OUTLINE(new String(Character.toChars(0xF12D6))),
        CLOUD_TAGS(new String(Character.toChars(0xF07B6))),
        CLOUD_UPLOAD(new String(Character.toChars(0xF0167))),
        CLOUD_UPLOAD_OUTLINE(new String(Character.toChars(0xF0B7E))),
        CLOUDS(new String(Character.toChars(0xF1B95))),
        CLOVER(new String(Character.toChars(0xF0816))),
        CLOVER_OUTLINE(new String(Character.toChars(0xF1C62))),
        COACH_LAMP(new String(Character.toChars(0xF1020))),
        COACH_LAMP_VARIANT(new String(Character.toChars(0xF1A37))),
        COAT_RACK(new String(Character.toChars(0xF109E))),
        CODE_ARRAY(new String(Character.toChars(0xF0168))),
        CODE_BRACES(new String(Character.toChars(0xF0169))),
        CODE_BRACES_BOX(new String(Character.toChars(0xF10D6))),
        CODE_BRACKETS(new String(Character.toChars(0xF016A))),
        CODE_EQUAL(new String(Character.toChars(0xF016B))),
        CODE_GREATER_THAN(new String(Character.toChars(0xF016C))),
        CODE_GREATER_THAN_OR_EQUAL(new String(Character.toChars(0xF016D))),
        CODE_JSON(new String(Character.toChars(0xF0626))),
        CODE_LESS_THAN(new String(Character.toChars(0xF016E))),
        CODE_LESS_THAN_OR_EQUAL(new String(Character.toChars(0xF016F))),
        CODE_NOT_EQUAL(new String(Character.toChars(0xF0170))),
        CODE_NOT_EQUAL_VARIANT(new String(Character.toChars(0xF0171))),
        CODE_PARENTHESES(new String(Character.toChars(0xF0172))),
        CODE_PARENTHESES_BOX(new String(Character.toChars(0xF10D7))),
        CODE_STRING(new String(Character.toChars(0xF0173))),
        CODE_TAGS(new String(Character.toChars(0xF0174))),
        CODE_TAGS_CHECK(new String(Character.toChars(0xF0694))),
        CODEPEN(new String(Character.toChars(0xF0175))),
        COFFEE(new String(Character.toChars(0xF0176))),
        COFFEE_MAKER(new String(Character.toChars(0xF109F))),
        COFFEE_MAKER_CHECK(new String(Character.toChars(0xF1931))),
        COFFEE_MAKER_CHECK_OUTLINE(new String(Character.toChars(0xF1932))),
        COFFEE_MAKER_OUTLINE(new String(Character.toChars(0xF181B))),
        COFFEE_OFF(new String(Character.toChars(0xF0FAA))),
        COFFEE_OFF_OUTLINE(new String(Character.toChars(0xF0FAB))),
        COFFEE_OUTLINE(new String(Character.toChars(0xF06CA))),
        COFFEE_TO_GO(new String(Character.toChars(0xF0177))),
        COFFEE_TO_GO_OUTLINE(new String(Character.toChars(0xF130E))),
        COFFIN(new String(Character.toChars(0xF0B7F))),
        COG(new String(Character.toChars(0xF0493))),
        COG_BOX(new String(Character.toChars(0xF0494))),
        COG_CLOCKWISE(new String(Character.toChars(0xF11DD))),
        COG_COUNTERCLOCKWISE(new String(Character.toChars(0xF11DE))),
        COG_OFF(new String(Character.toChars(0xF13CE))),
        COG_OFF_OUTLINE(new String(Character.toChars(0xF13CF))),
        COG_OUTLINE(new String(Character.toChars(0xF08BB))),
        COG_PAUSE(new String(Character.toChars(0xF1933))),
        COG_PAUSE_OUTLINE(new String(Character.toChars(0xF1934))),
        COG_PLAY(new String(Character.toChars(0xF1935))),
        COG_PLAY_OUTLINE(new String(Character.toChars(0xF1936))),
        COG_REFRESH(new String(Character.toChars(0xF145E))),
        COG_REFRESH_OUTLINE(new String(Character.toChars(0xF145F))),
        COG_STOP(new String(Character.toChars(0xF1937))),
        COG_STOP_OUTLINE(new String(Character.toChars(0xF1938))),
        COG_SYNC(new String(Character.toChars(0xF1460))),
        COG_SYNC_OUTLINE(new String(Character.toChars(0xF1461))),
        COG_TRANSFER(new String(Character.toChars(0xF105B))),
        COG_TRANSFER_OUTLINE(new String(Character.toChars(0xF105C))),
        COGS(new String(Character.toChars(0xF08D6))),
        COLLAGE(new String(Character.toChars(0xF0640))),
        COLLAPSE_ALL(new String(Character.toChars(0xF0AA6))),
        COLLAPSE_ALL_OUTLINE(new String(Character.toChars(0xF0AA7))),
        COLOR_HELPER(new String(Character.toChars(0xF0179))),
        COMMA(new String(Character.toChars(0xF0E23))),
        COMMA_BOX(new String(Character.toChars(0xF0E2B))),
        COMMA_BOX_OUTLINE(new String(Character.toChars(0xF0E24))),
        COMMA_CIRCLE(new String(Character.toChars(0xF0E25))),
        COMMA_CIRCLE_OUTLINE(new String(Character.toChars(0xF0E26))),
        COMMENT(new String(Character.toChars(0xF017A))),
        COMMENT_ACCOUNT(new String(Character.toChars(0xF017B))),
        COMMENT_ACCOUNT_OUTLINE(new String(Character.toChars(0xF017C))),
        COMMENT_ALERT(new String(Character.toChars(0xF017D))),
        COMMENT_ALERT_OUTLINE(new String(Character.toChars(0xF017E))),
        COMMENT_ARROW_LEFT(new String(Character.toChars(0xF09E1))),
        COMMENT_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF09E2))),
        COMMENT_ARROW_RIGHT(new String(Character.toChars(0xF09E3))),
        COMMENT_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF09E4))),
        COMMENT_BOOKMARK(new String(Character.toChars(0xF15AE))),
        COMMENT_BOOKMARK_OUTLINE(new String(Character.toChars(0xF15AF))),
        COMMENT_CHECK(new String(Character.toChars(0xF017F))),
        COMMENT_CHECK_OUTLINE(new String(Character.toChars(0xF0180))),
        COMMENT_EDIT(new String(Character.toChars(0xF11BF))),
        COMMENT_EDIT_OUTLINE(new String(Character.toChars(0xF12C4))),
        COMMENT_EYE(new String(Character.toChars(0xF0A3A))),
        COMMENT_EYE_OUTLINE(new String(Character.toChars(0xF0A3B))),
        COMMENT_FLASH(new String(Character.toChars(0xF15B0))),
        COMMENT_FLASH_OUTLINE(new String(Character.toChars(0xF15B1))),
        COMMENT_MINUS(new String(Character.toChars(0xF15DF))),
        COMMENT_MINUS_OUTLINE(new String(Character.toChars(0xF15E0))),
        COMMENT_MULTIPLE(new String(Character.toChars(0xF085F))),
        COMMENT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0181))),
        COMMENT_OFF(new String(Character.toChars(0xF15E1))),
        COMMENT_OFF_OUTLINE(new String(Character.toChars(0xF15E2))),
        COMMENT_OUTLINE(new String(Character.toChars(0xF0182))),
        COMMENT_PLUS(new String(Character.toChars(0xF09E5))),
        COMMENT_PLUS_OUTLINE(new String(Character.toChars(0xF0183))),
        COMMENT_PROCESSING(new String(Character.toChars(0xF0184))),
        COMMENT_PROCESSING_OUTLINE(new String(Character.toChars(0xF0185))),
        COMMENT_QUESTION(new String(Character.toChars(0xF0817))),
        COMMENT_QUESTION_OUTLINE(new String(Character.toChars(0xF0186))),
        COMMENT_QUOTE(new String(Character.toChars(0xF1021))),
        COMMENT_QUOTE_OUTLINE(new String(Character.toChars(0xF1022))),
        COMMENT_REMOVE(new String(Character.toChars(0xF05DE))),
        COMMENT_REMOVE_OUTLINE(new String(Character.toChars(0xF0187))),
        COMMENT_SEARCH(new String(Character.toChars(0xF0A3C))),
        COMMENT_SEARCH_OUTLINE(new String(Character.toChars(0xF0A3D))),
        COMMENT_TEXT(new String(Character.toChars(0xF0188))),
        COMMENT_TEXT_MULTIPLE(new String(Character.toChars(0xF0860))),
        COMMENT_TEXT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0861))),
        COMMENT_TEXT_OUTLINE(new String(Character.toChars(0xF0189))),
        COMPARE(new String(Character.toChars(0xF018A))),
        COMPARE_HORIZONTAL(new String(Character.toChars(0xF1492))),
        COMPARE_REMOVE(new String(Character.toChars(0xF18B3))),
        COMPARE_VERTICAL(new String(Character.toChars(0xF1493))),
        COMPASS(new String(Character.toChars(0xF018B))),
        COMPASS_OFF(new String(Character.toChars(0xF0B80))),
        COMPASS_OFF_OUTLINE(new String(Character.toChars(0xF0B81))),
        COMPASS_OUTLINE(new String(Character.toChars(0xF018C))),
        COMPASS_ROSE(new String(Character.toChars(0xF1382))),
        COMPOST(new String(Character.toChars(0xF1A38))),
        CONE(new String(Character.toChars(0xF194C))),
        CONE_OFF(new String(Character.toChars(0xF194D))),
        CONNECTION(new String(Character.toChars(0xF1616))),
        CONSOLE(new String(Character.toChars(0xF018D))),
        CONSOLE_LINE(new String(Character.toChars(0xF07B7))),
        CONSOLE_NETWORK(new String(Character.toChars(0xF08A9))),
        CONSOLE_NETWORK_OUTLINE(new String(Character.toChars(0xF0C60))),
        CONSOLIDATE(new String(Character.toChars(0xF10D8))),
        CONTACTLESS_PAYMENT(new String(Character.toChars(0xF0D6A))),
        CONTACTLESS_PAYMENT_CIRCLE(new String(Character.toChars(0xF0321))),
        CONTACTLESS_PAYMENT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0408))),
        CONTACTS(new String(Character.toChars(0xF06CB))),
        CONTACTS_OUTLINE(new String(Character.toChars(0xF05B8))),
        CONTAIN(new String(Character.toChars(0xF0A3E))),
        CONTAIN_END(new String(Character.toChars(0xF0A3F))),
        CONTAIN_START(new String(Character.toChars(0xF0A40))),
        CONTENT_COPY(new String(Character.toChars(0xF018F))),
        CONTENT_CUT(new String(Character.toChars(0xF0190))),
        CONTENT_DUPLICATE(new String(Character.toChars(0xF0191))),
        CONTENT_PASTE(new String(Character.toChars(0xF0192))),
        CONTENT_SAVE(new String(Character.toChars(0xF0193))),
        CONTENT_SAVE_ALERT(new String(Character.toChars(0xF0F42))),
        CONTENT_SAVE_ALERT_OUTLINE(new String(Character.toChars(0xF0F43))),
        CONTENT_SAVE_ALL(new String(Character.toChars(0xF0194))),
        CONTENT_SAVE_ALL_OUTLINE(new String(Character.toChars(0xF0F44))),
        CONTENT_SAVE_CHECK(new String(Character.toChars(0xF18EA))),
        CONTENT_SAVE_CHECK_OUTLINE(new String(Character.toChars(0xF18EB))),
        CONTENT_SAVE_COG(new String(Character.toChars(0xF145B))),
        CONTENT_SAVE_COG_OUTLINE(new String(Character.toChars(0xF145C))),
        CONTENT_SAVE_EDIT(new String(Character.toChars(0xF0CFB))),
        CONTENT_SAVE_EDIT_OUTLINE(new String(Character.toChars(0xF0CFC))),
        CONTENT_SAVE_MINUS(new String(Character.toChars(0xF1B43))),
        CONTENT_SAVE_MINUS_OUTLINE(new String(Character.toChars(0xF1B44))),
        CONTENT_SAVE_MOVE(new String(Character.toChars(0xF0E27))),
        CONTENT_SAVE_MOVE_OUTLINE(new String(Character.toChars(0xF0E28))),
        CONTENT_SAVE_OFF(new String(Character.toChars(0xF1643))),
        CONTENT_SAVE_OFF_OUTLINE(new String(Character.toChars(0xF1644))),
        CONTENT_SAVE_OUTLINE(new String(Character.toChars(0xF0818))),
        CONTENT_SAVE_PLUS(new String(Character.toChars(0xF1B41))),
        CONTENT_SAVE_PLUS_OUTLINE(new String(Character.toChars(0xF1B42))),
        CONTENT_SAVE_SETTINGS(new String(Character.toChars(0xF061B))),
        CONTENT_SAVE_SETTINGS_OUTLINE(new String(Character.toChars(0xF0B2E))),
        CONTRAST(new String(Character.toChars(0xF0195))),
        CONTRAST_BOX(new String(Character.toChars(0xF0196))),
        CONTRAST_CIRCLE(new String(Character.toChars(0xF0197))),
        CONTROLLER(new String(Character.toChars(0xF02B4))),
        CONTROLLER_CLASSIC(new String(Character.toChars(0xF0B82))),
        CONTROLLER_CLASSIC_OUTLINE(new String(Character.toChars(0xF0B83))),
        CONTROLLER_OFF(new String(Character.toChars(0xF02B5))),
        COOKIE(new String(Character.toChars(0xF0198))),
        COOKIE_ALERT(new String(Character.toChars(0xF16D0))),
        COOKIE_ALERT_OUTLINE(new String(Character.toChars(0xF16D1))),
        COOKIE_CHECK(new String(Character.toChars(0xF16D2))),
        COOKIE_CHECK_OUTLINE(new String(Character.toChars(0xF16D3))),
        COOKIE_CLOCK(new String(Character.toChars(0xF16E4))),
        COOKIE_CLOCK_OUTLINE(new String(Character.toChars(0xF16E5))),
        COOKIE_COG(new String(Character.toChars(0xF16D4))),
        COOKIE_COG_OUTLINE(new String(Character.toChars(0xF16D5))),
        COOKIE_EDIT(new String(Character.toChars(0xF16E6))),
        COOKIE_EDIT_OUTLINE(new String(Character.toChars(0xF16E7))),
        COOKIE_LOCK(new String(Character.toChars(0xF16E8))),
        COOKIE_LOCK_OUTLINE(new String(Character.toChars(0xF16E9))),
        COOKIE_MINUS(new String(Character.toChars(0xF16DA))),
        COOKIE_MINUS_OUTLINE(new String(Character.toChars(0xF16DB))),
        COOKIE_OFF(new String(Character.toChars(0xF16EA))),
        COOKIE_OFF_OUTLINE(new String(Character.toChars(0xF16EB))),
        COOKIE_OUTLINE(new String(Character.toChars(0xF16DE))),
        COOKIE_PLUS(new String(Character.toChars(0xF16D6))),
        COOKIE_PLUS_OUTLINE(new String(Character.toChars(0xF16D7))),
        COOKIE_REFRESH(new String(Character.toChars(0xF16EC))),
        COOKIE_REFRESH_OUTLINE(new String(Character.toChars(0xF16ED))),
        COOKIE_REMOVE(new String(Character.toChars(0xF16D8))),
        COOKIE_REMOVE_OUTLINE(new String(Character.toChars(0xF16D9))),
        COOKIE_SETTINGS(new String(Character.toChars(0xF16DC))),
        COOKIE_SETTINGS_OUTLINE(new String(Character.toChars(0xF16DD))),
        COOLANT_TEMPERATURE(new String(Character.toChars(0xF03C8))),
        COPYLEFT(new String(Character.toChars(0xF1939))),
        COPYRIGHT(new String(Character.toChars(0xF05E6))),
        CORDOVA(new String(Character.toChars(0xF0958))),
        CORN(new String(Character.toChars(0xF07B8))),
        CORN_OFF(new String(Character.toChars(0xF13EF))),
        COSINE_WAVE(new String(Character.toChars(0xF1479))),
        COUNTER(new String(Character.toChars(0xF0199))),
        COUNTERTOP(new String(Character.toChars(0xF181C))),
        COUNTERTOP_OUTLINE(new String(Character.toChars(0xF181D))),
        COW(new String(Character.toChars(0xF019A))),
        COW_OFF(new String(Character.toChars(0xF18FC))),
        CPU_32_BIT(new String(Character.toChars(0xF0EDF))),
        CPU_64_BIT(new String(Character.toChars(0xF0EE0))),
        CRADLE(new String(Character.toChars(0xF198B))),
        CRADLE_OUTLINE(new String(Character.toChars(0xF1991))),
        CRANE(new String(Character.toChars(0xF0862))),
        CREATION(new String(Character.toChars(0xF0674))),
        CREATION_OUTLINE(new String(Character.toChars(0xF1C2B))),
        CREATIVE_COMMONS(new String(Character.toChars(0xF0D6B))),
        CREDIT_CARD(new String(Character.toChars(0xF0FEF))),
        CREDIT_CARD_CHECK(new String(Character.toChars(0xF13D0))),
        CREDIT_CARD_CHECK_OUTLINE(new String(Character.toChars(0xF13D1))),
        CREDIT_CARD_CHIP(new String(Character.toChars(0xF190F))),
        CREDIT_CARD_CHIP_OUTLINE(new String(Character.toChars(0xF1910))),
        CREDIT_CARD_CLOCK(new String(Character.toChars(0xF0EE1))),
        CREDIT_CARD_CLOCK_OUTLINE(new String(Character.toChars(0xF0EE2))),
        CREDIT_CARD_EDIT(new String(Character.toChars(0xF17D7))),
        CREDIT_CARD_EDIT_OUTLINE(new String(Character.toChars(0xF17D8))),
        CREDIT_CARD_FAST(new String(Character.toChars(0xF1911))),
        CREDIT_CARD_FAST_OUTLINE(new String(Character.toChars(0xF1912))),
        CREDIT_CARD_LOCK(new String(Character.toChars(0xF18E7))),
        CREDIT_CARD_LOCK_OUTLINE(new String(Character.toChars(0xF18E8))),
        CREDIT_CARD_MARKER(new String(Character.toChars(0xF06A8))),
        CREDIT_CARD_MARKER_OUTLINE(new String(Character.toChars(0xF0DBE))),
        CREDIT_CARD_MINUS(new String(Character.toChars(0xF0FAC))),
        CREDIT_CARD_MINUS_OUTLINE(new String(Character.toChars(0xF0FAD))),
        CREDIT_CARD_MULTIPLE(new String(Character.toChars(0xF0FF0))),
        CREDIT_CARD_MULTIPLE_OUTLINE(new String(Character.toChars(0xF019C))),
        CREDIT_CARD_OFF(new String(Character.toChars(0xF0FF1))),
        CREDIT_CARD_OFF_OUTLINE(new String(Character.toChars(0xF05E4))),
        CREDIT_CARD_OUTLINE(new String(Character.toChars(0xF019B))),
        CREDIT_CARD_PLUS(new String(Character.toChars(0xF0FF2))),
        CREDIT_CARD_PLUS_OUTLINE(new String(Character.toChars(0xF0676))),
        CREDIT_CARD_REFRESH(new String(Character.toChars(0xF1645))),
        CREDIT_CARD_REFRESH_OUTLINE(new String(Character.toChars(0xF1646))),
        CREDIT_CARD_REFUND(new String(Character.toChars(0xF0FF3))),
        CREDIT_CARD_REFUND_OUTLINE(new String(Character.toChars(0xF0AA8))),
        CREDIT_CARD_REMOVE(new String(Character.toChars(0xF0FAE))),
        CREDIT_CARD_REMOVE_OUTLINE(new String(Character.toChars(0xF0FAF))),
        CREDIT_CARD_SCAN(new String(Character.toChars(0xF0FF4))),
        CREDIT_CARD_SCAN_OUTLINE(new String(Character.toChars(0xF019D))),
        CREDIT_CARD_SEARCH(new String(Character.toChars(0xF1647))),
        CREDIT_CARD_SEARCH_OUTLINE(new String(Character.toChars(0xF1648))),
        CREDIT_CARD_SETTINGS(new String(Character.toChars(0xF0FF5))),
        CREDIT_CARD_SETTINGS_OUTLINE(new String(Character.toChars(0xF08D7))),
        CREDIT_CARD_SYNC(new String(Character.toChars(0xF1649))),
        CREDIT_CARD_SYNC_OUTLINE(new String(Character.toChars(0xF164A))),
        CREDIT_CARD_WIRELESS(new String(Character.toChars(0xF0802))),
        CREDIT_CARD_WIRELESS_OFF(new String(Character.toChars(0xF057A))),
        CREDIT_CARD_WIRELESS_OFF_OUTLINE(new String(Character.toChars(0xF057B))),
        CREDIT_CARD_WIRELESS_OUTLINE(new String(Character.toChars(0xF0D6C))),
        CRICKET(new String(Character.toChars(0xF0D6D))),
        CROP(new String(Character.toChars(0xF019E))),
        CROP_FREE(new String(Character.toChars(0xF019F))),
        CROP_LANDSCAPE(new String(Character.toChars(0xF01A0))),
        CROP_PORTRAIT(new String(Character.toChars(0xF01A1))),
        CROP_ROTATE(new String(Character.toChars(0xF0696))),
        CROP_SQUARE(new String(Character.toChars(0xF01A2))),
        CROSS(new String(Character.toChars(0xF0953))),
        CROSS_BOLNISI(new String(Character.toChars(0xF0CED))),
        CROSS_CELTIC(new String(Character.toChars(0xF0CF5))),
        CROSS_OUTLINE(new String(Character.toChars(0xF0CF6))),
        CROSSHAIRS(new String(Character.toChars(0xF01A3))),
        CROSSHAIRS_GPS(new String(Character.toChars(0xF01A4))),
        CROSSHAIRS_OFF(new String(Character.toChars(0xF0F45))),
        CROSSHAIRS_QUESTION(new String(Character.toChars(0xF1136))),
        CROWD(new String(Character.toChars(0xF1975))),
        CROWN(new String(Character.toChars(0xF01A5))),
        CROWN_CIRCLE(new String(Character.toChars(0xF17DC))),
        CROWN_CIRCLE_OUTLINE(new String(Character.toChars(0xF17DD))),
        CROWN_OUTLINE(new String(Character.toChars(0xF11D0))),
        CRYENGINE(new String(Character.toChars(0xF0959))),
        CRYSTAL_BALL(new String(Character.toChars(0xF0B2F))),
        CUBE(new String(Character.toChars(0xF01A6))),
        CUBE_OFF(new String(Character.toChars(0xF141C))),
        CUBE_OFF_OUTLINE(new String(Character.toChars(0xF141D))),
        CUBE_OUTLINE(new String(Character.toChars(0xF01A7))),
        CUBE_SCAN(new String(Character.toChars(0xF0B84))),
        CUBE_SEND(new String(Character.toChars(0xF01A8))),
        CUBE_UNFOLDED(new String(Character.toChars(0xF01A9))),
        CUP(new String(Character.toChars(0xF01AA))),
        CUP_OFF(new String(Character.toChars(0xF05E5))),
        CUP_OFF_OUTLINE(new String(Character.toChars(0xF137D))),
        CUP_OUTLINE(new String(Character.toChars(0xF130F))),
        CUP_WATER(new String(Character.toChars(0xF01AB))),
        CUPBOARD(new String(Character.toChars(0xF0F46))),
        CUPBOARD_OUTLINE(new String(Character.toChars(0xF0F47))),
        CUPCAKE(new String(Character.toChars(0xF095A))),
        CURLING(new String(Character.toChars(0xF0863))),
        CURRENCY_BDT(new String(Character.toChars(0xF0864))),
        CURRENCY_BRL(new String(Character.toChars(0xF0B85))),
        CURRENCY_BTC(new String(Character.toChars(0xF01AC))),
        CURRENCY_CNY(new String(Character.toChars(0xF07BA))),
        CURRENCY_ETH(new String(Character.toChars(0xF07BB))),
        CURRENCY_EUR(new String(Character.toChars(0xF01AD))),
        CURRENCY_EUR_OFF(new String(Character.toChars(0xF1315))),
        CURRENCY_FRA(new String(Character.toChars(0xF1A39))),
        CURRENCY_GBP(new String(Character.toChars(0xF01AE))),
        CURRENCY_ILS(new String(Character.toChars(0xF0C61))),
        CURRENCY_INR(new String(Character.toChars(0xF01AF))),
        CURRENCY_JPY(new String(Character.toChars(0xF07BC))),
        CURRENCY_KRW(new String(Character.toChars(0xF07BD))),
        CURRENCY_KZT(new String(Character.toChars(0xF0865))),
        CURRENCY_MNT(new String(Character.toChars(0xF1512))),
        CURRENCY_NGN(new String(Character.toChars(0xF01B0))),
        CURRENCY_PHP(new String(Character.toChars(0xF09E6))),
        CURRENCY_RIAL(new String(Character.toChars(0xF0E9C))),
        CURRENCY_RUB(new String(Character.toChars(0xF01B1))),
        CURRENCY_RUPEE(new String(Character.toChars(0xF1976))),
        CURRENCY_SIGN(new String(Character.toChars(0xF07BE))),
        CURRENCY_THB(new String(Character.toChars(0xF1C05))),
        CURRENCY_TRY(new String(Character.toChars(0xF01B2))),
        CURRENCY_TWD(new String(Character.toChars(0xF07BF))),
        CURRENCY_UAH(new String(Character.toChars(0xF1B9B))),
        CURRENCY_USD(new String(Character.toChars(0xF01C1))),
        CURRENCY_USD_OFF(new String(Character.toChars(0xF067A))),
        CURRENT_AC(new String(Character.toChars(0xF1480))),
        CURRENT_DC(new String(Character.toChars(0xF095C))),
        CURSOR_DEFAULT(new String(Character.toChars(0xF01C0))),
        CURSOR_DEFAULT_CLICK(new String(Character.toChars(0xF0CFD))),
        CURSOR_DEFAULT_CLICK_OUTLINE(new String(Character.toChars(0xF0CFE))),
        CURSOR_DEFAULT_GESTURE(new String(Character.toChars(0xF1127))),
        CURSOR_DEFAULT_GESTURE_OUTLINE(new String(Character.toChars(0xF1128))),
        CURSOR_DEFAULT_OUTLINE(new String(Character.toChars(0xF01BF))),
        CURSOR_MOVE(new String(Character.toChars(0xF01BE))),
        CURSOR_POINTER(new String(Character.toChars(0xF01BD))),
        CURSOR_TEXT(new String(Character.toChars(0xF05E7))),
        CURTAINS(new String(Character.toChars(0xF1846))),
        CURTAINS_CLOSED(new String(Character.toChars(0xF1847))),
        CYLINDER(new String(Character.toChars(0xF194E))),
        CYLINDER_OFF(new String(Character.toChars(0xF194F)));

        private final String unicode;

        C(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public C getDefaultGlyph()
        {
            return C.CABIN_A_FRAME;
        }
    }

    public enum D implements MaterialDesignIconGlyphs<D> {

        DANCE_BALLROOM(new String(Character.toChars(0xF15FB))),
        DANCE_POLE(new String(Character.toChars(0xF1578))),
        DATA_MATRIX(new String(Character.toChars(0xF153C))),
        DATA_MATRIX_EDIT(new String(Character.toChars(0xF153D))),
        DATA_MATRIX_MINUS(new String(Character.toChars(0xF153E))),
        DATA_MATRIX_PLUS(new String(Character.toChars(0xF153F))),
        DATA_MATRIX_REMOVE(new String(Character.toChars(0xF1540))),
        DATA_MATRIX_SCAN(new String(Character.toChars(0xF1541))),
        DATABASE(new String(Character.toChars(0xF01BC))),
        DATABASE_ALERT(new String(Character.toChars(0xF163A))),
        DATABASE_ALERT_OUTLINE(new String(Character.toChars(0xF1624))),
        DATABASE_ARROW_DOWN(new String(Character.toChars(0xF163B))),
        DATABASE_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF1625))),
        DATABASE_ARROW_LEFT(new String(Character.toChars(0xF163C))),
        DATABASE_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF1626))),
        DATABASE_ARROW_RIGHT(new String(Character.toChars(0xF163D))),
        DATABASE_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1627))),
        DATABASE_ARROW_UP(new String(Character.toChars(0xF163E))),
        DATABASE_ARROW_UP_OUTLINE(new String(Character.toChars(0xF1628))),
        DATABASE_CHECK(new String(Character.toChars(0xF0AA9))),
        DATABASE_CHECK_OUTLINE(new String(Character.toChars(0xF1629))),
        DATABASE_CLOCK(new String(Character.toChars(0xF163F))),
        DATABASE_CLOCK_OUTLINE(new String(Character.toChars(0xF162A))),
        DATABASE_COG(new String(Character.toChars(0xF164B))),
        DATABASE_COG_OUTLINE(new String(Character.toChars(0xF164C))),
        DATABASE_EDIT(new String(Character.toChars(0xF0B86))),
        DATABASE_EDIT_OUTLINE(new String(Character.toChars(0xF162B))),
        DATABASE_EXPORT(new String(Character.toChars(0xF095E))),
        DATABASE_EXPORT_OUTLINE(new String(Character.toChars(0xF162C))),
        DATABASE_EYE(new String(Character.toChars(0xF191F))),
        DATABASE_EYE_OFF(new String(Character.toChars(0xF1920))),
        DATABASE_EYE_OFF_OUTLINE(new String(Character.toChars(0xF1921))),
        DATABASE_EYE_OUTLINE(new String(Character.toChars(0xF1922))),
        DATABASE_IMPORT(new String(Character.toChars(0xF095D))),
        DATABASE_IMPORT_OUTLINE(new String(Character.toChars(0xF162D))),
        DATABASE_LOCK(new String(Character.toChars(0xF0AAA))),
        DATABASE_LOCK_OUTLINE(new String(Character.toChars(0xF162E))),
        DATABASE_MARKER(new String(Character.toChars(0xF12F6))),
        DATABASE_MARKER_OUTLINE(new String(Character.toChars(0xF162F))),
        DATABASE_MINUS(new String(Character.toChars(0xF01BB))),
        DATABASE_MINUS_OUTLINE(new String(Character.toChars(0xF1630))),
        DATABASE_OFF(new String(Character.toChars(0xF1640))),
        DATABASE_OFF_OUTLINE(new String(Character.toChars(0xF1631))),
        DATABASE_OUTLINE(new String(Character.toChars(0xF1632))),
        DATABASE_PLUS(new String(Character.toChars(0xF01BA))),
        DATABASE_PLUS_OUTLINE(new String(Character.toChars(0xF1633))),
        DATABASE_REFRESH(new String(Character.toChars(0xF05C2))),
        DATABASE_REFRESH_OUTLINE(new String(Character.toChars(0xF1634))),
        DATABASE_REMOVE(new String(Character.toChars(0xF0D00))),
        DATABASE_REMOVE_OUTLINE(new String(Character.toChars(0xF1635))),
        DATABASE_SEARCH(new String(Character.toChars(0xF0866))),
        DATABASE_SEARCH_OUTLINE(new String(Character.toChars(0xF1636))),
        DATABASE_SETTINGS(new String(Character.toChars(0xF0D01))),
        DATABASE_SETTINGS_OUTLINE(new String(Character.toChars(0xF1637))),
        DATABASE_SYNC(new String(Character.toChars(0xF0CFF))),
        DATABASE_SYNC_OUTLINE(new String(Character.toChars(0xF1638))),
        DEATH_STAR(new String(Character.toChars(0xF08D8))),
        DEATH_STAR_VARIANT(new String(Character.toChars(0xF08D9))),
        DEATHLY_HALLOWS(new String(Character.toChars(0xF0B87))),
        DEBIAN(new String(Character.toChars(0xF08DA))),
        DEBUG_STEP_INTO(new String(Character.toChars(0xF01B9))),
        DEBUG_STEP_OUT(new String(Character.toChars(0xF01B8))),
        DEBUG_STEP_OVER(new String(Character.toChars(0xF01B7))),
        DECAGRAM(new String(Character.toChars(0xF076C))),
        DECAGRAM_OUTLINE(new String(Character.toChars(0xF076D))),
        DECIMAL(new String(Character.toChars(0xF10A1))),
        DECIMAL_COMMA(new String(Character.toChars(0xF10A2))),
        DECIMAL_COMMA_DECREASE(new String(Character.toChars(0xF10A3))),
        DECIMAL_COMMA_INCREASE(new String(Character.toChars(0xF10A4))),
        DECIMAL_DECREASE(new String(Character.toChars(0xF01B6))),
        DECIMAL_INCREASE(new String(Character.toChars(0xF01B5))),
        DELETE(new String(Character.toChars(0xF01B4))),
        DELETE_ALERT(new String(Character.toChars(0xF10A5))),
        DELETE_ALERT_OUTLINE(new String(Character.toChars(0xF10A6))),
        DELETE_CIRCLE(new String(Character.toChars(0xF0683))),
        DELETE_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B88))),
        DELETE_CLOCK(new String(Character.toChars(0xF1556))),
        DELETE_CLOCK_OUTLINE(new String(Character.toChars(0xF1557))),
        DELETE_EMPTY(new String(Character.toChars(0xF06CC))),
        DELETE_EMPTY_OUTLINE(new String(Character.toChars(0xF0E9D))),
        DELETE_FOREVER(new String(Character.toChars(0xF05E8))),
        DELETE_FOREVER_OUTLINE(new String(Character.toChars(0xF0B89))),
        DELETE_OFF(new String(Character.toChars(0xF10A7))),
        DELETE_OFF_OUTLINE(new String(Character.toChars(0xF10A8))),
        DELETE_OUTLINE(new String(Character.toChars(0xF09E7))),
        DELETE_RESTORE(new String(Character.toChars(0xF0819))),
        DELETE_SWEEP(new String(Character.toChars(0xF05E9))),
        DELETE_SWEEP_OUTLINE(new String(Character.toChars(0xF0C62))),
        DELETE_VARIANT(new String(Character.toChars(0xF01B3))),
        DELTA(new String(Character.toChars(0xF01C2))),
        DESK(new String(Character.toChars(0xF1239))),
        DESK_LAMP(new String(Character.toChars(0xF095F))),
        DESK_LAMP_OFF(new String(Character.toChars(0xF1B1F))),
        DESK_LAMP_ON(new String(Character.toChars(0xF1B20))),
        DESKPHONE(new String(Character.toChars(0xF01C3))),
        DESKTOP_CLASSIC(new String(Character.toChars(0xF07C0))),
        DESKTOP_TOWER(new String(Character.toChars(0xF01C5))),
        DESKTOP_TOWER_MONITOR(new String(Character.toChars(0xF0AAB))),
        DETAILS(new String(Character.toChars(0xF01C6))),
        DEV_TO(new String(Character.toChars(0xF0D6E))),
        DEVELOPER_BOARD(new String(Character.toChars(0xF0697))),
        DEVIANTART(new String(Character.toChars(0xF01C7))),
        DEVICES(new String(Character.toChars(0xF0FB0))),
        DHARMACHAKRA(new String(Character.toChars(0xF094B))),
        DIABETES(new String(Character.toChars(0xF1126))),
        DIALPAD(new String(Character.toChars(0xF061C))),
        DIAMETER(new String(Character.toChars(0xF0C63))),
        DIAMETER_OUTLINE(new String(Character.toChars(0xF0C64))),
        DIAMETER_VARIANT(new String(Character.toChars(0xF0C65))),
        DIAMOND(new String(Character.toChars(0xF0B8A))),
        DIAMOND_OUTLINE(new String(Character.toChars(0xF0B8B))),
        DIAMOND_STONE(new String(Character.toChars(0xF01C8))),
        DICE_1(new String(Character.toChars(0xF01CA))),
        DICE_1_OUTLINE(new String(Character.toChars(0xF114A))),
        DICE_2(new String(Character.toChars(0xF01CB))),
        DICE_2_OUTLINE(new String(Character.toChars(0xF114B))),
        DICE_3(new String(Character.toChars(0xF01CC))),
        DICE_3_OUTLINE(new String(Character.toChars(0xF114C))),
        DICE_4(new String(Character.toChars(0xF01CD))),
        DICE_4_OUTLINE(new String(Character.toChars(0xF114D))),
        DICE_5(new String(Character.toChars(0xF01CE))),
        DICE_5_OUTLINE(new String(Character.toChars(0xF114E))),
        DICE_6(new String(Character.toChars(0xF01CF))),
        DICE_6_OUTLINE(new String(Character.toChars(0xF114F))),
        DICE_D10(new String(Character.toChars(0xF1153))),
        DICE_D10_OUTLINE(new String(Character.toChars(0xF076F))),
        DICE_D12(new String(Character.toChars(0xF1154))),
        DICE_D12_OUTLINE(new String(Character.toChars(0xF0867))),
        DICE_D20(new String(Character.toChars(0xF1155))),
        DICE_D20_OUTLINE(new String(Character.toChars(0xF05EA))),
        DICE_D4(new String(Character.toChars(0xF1150))),
        DICE_D4_OUTLINE(new String(Character.toChars(0xF05EB))),
        DICE_D6(new String(Character.toChars(0xF1151))),
        DICE_D6_OUTLINE(new String(Character.toChars(0xF05ED))),
        DICE_D8(new String(Character.toChars(0xF1152))),
        DICE_D8_OUTLINE(new String(Character.toChars(0xF05EC))),
        DICE_MULTIPLE(new String(Character.toChars(0xF076E))),
        DICE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1156))),
        DIGITAL_OCEAN(new String(Character.toChars(0xF1237))),
        DIP_SWITCH(new String(Character.toChars(0xF07C1))),
        DIRECTIONS(new String(Character.toChars(0xF01D0))),
        DIRECTIONS_FORK(new String(Character.toChars(0xF0641))),
        DISC(new String(Character.toChars(0xF05EE))),
        DISC_ALERT(new String(Character.toChars(0xF01D1))),
        DISC_PLAYER(new String(Character.toChars(0xF0960))),
        DISHWASHER(new String(Character.toChars(0xF0AAC))),
        DISHWASHER_ALERT(new String(Character.toChars(0xF11B8))),
        DISHWASHER_OFF(new String(Character.toChars(0xF11B9))),
        DISQUS(new String(Character.toChars(0xF01D2))),
        DISTRIBUTE_HORIZONTAL_CENTER(new String(Character.toChars(0xF11C9))),
        DISTRIBUTE_HORIZONTAL_LEFT(new String(Character.toChars(0xF11C8))),
        DISTRIBUTE_HORIZONTAL_RIGHT(new String(Character.toChars(0xF11CA))),
        DISTRIBUTE_VERTICAL_BOTTOM(new String(Character.toChars(0xF11CB))),
        DISTRIBUTE_VERTICAL_CENTER(new String(Character.toChars(0xF11CC))),
        DISTRIBUTE_VERTICAL_TOP(new String(Character.toChars(0xF11CD))),
        DIVERSIFY(new String(Character.toChars(0xF1877))),
        DIVING(new String(Character.toChars(0xF1977))),
        DIVING_FLIPPERS(new String(Character.toChars(0xF0DBF))),
        DIVING_HELMET(new String(Character.toChars(0xF0DC0))),
        DIVING_SCUBA(new String(Character.toChars(0xF1B77))),
        DIVING_SCUBA_FLAG(new String(Character.toChars(0xF0DC2))),
        DIVING_SCUBA_MASK(new String(Character.toChars(0xF0DC1))),
        DIVING_SCUBA_TANK(new String(Character.toChars(0xF0DC3))),
        DIVING_SCUBA_TANK_MULTIPLE(new String(Character.toChars(0xF0DC4))),
        DIVING_SNORKEL(new String(Character.toChars(0xF0DC5))),
        DIVISION(new String(Character.toChars(0xF01D4))),
        DIVISION_BOX(new String(Character.toChars(0xF01D5))),
        DLNA(new String(Character.toChars(0xF0A41))),
        DNA(new String(Character.toChars(0xF0684))),
        DNS(new String(Character.toChars(0xF01D6))),
        DNS_OUTLINE(new String(Character.toChars(0xF0B8C))),
        DOCK_BOTTOM(new String(Character.toChars(0xF10A9))),
        DOCK_LEFT(new String(Character.toChars(0xF10AA))),
        DOCK_RIGHT(new String(Character.toChars(0xF10AB))),
        DOCK_TOP(new String(Character.toChars(0xF1513))),
        DOCK_WINDOW(new String(Character.toChars(0xF10AC))),
        DOCKER(new String(Character.toChars(0xF0868))),
        DOCTOR(new String(Character.toChars(0xF0A42))),
        DOG(new String(Character.toChars(0xF0A43))),
        DOG_SERVICE(new String(Character.toChars(0xF0AAD))),
        DOG_SIDE(new String(Character.toChars(0xF0A44))),
        DOG_SIDE_OFF(new String(Character.toChars(0xF16EE))),
        DOLBY(new String(Character.toChars(0xF06B3))),
        DOLLY(new String(Character.toChars(0xF0E9E))),
        DOLPHIN(new String(Character.toChars(0xF18B4))),
        DOMAIN(new String(Character.toChars(0xF01D7))),
        DOMAIN_OFF(new String(Character.toChars(0xF0D6F))),
        DOMAIN_PLUS(new String(Character.toChars(0xF10AD))),
        DOMAIN_REMOVE(new String(Character.toChars(0xF10AE))),
        DOMAIN_SWITCH(new String(Character.toChars(0xF1C2C))),
        DOME_LIGHT(new String(Character.toChars(0xF141E))),
        DOMINO_MASK(new String(Character.toChars(0xF1023))),
        DONKEY(new String(Character.toChars(0xF07C2))),
        DOOR(new String(Character.toChars(0xF081A))),
        DOOR_CLOSED(new String(Character.toChars(0xF081B))),
        DOOR_CLOSED_LOCK(new String(Character.toChars(0xF10AF))),
        DOOR_OPEN(new String(Character.toChars(0xF081C))),
        DOOR_SLIDING(new String(Character.toChars(0xF181E))),
        DOOR_SLIDING_LOCK(new String(Character.toChars(0xF181F))),
        DOOR_SLIDING_OPEN(new String(Character.toChars(0xF1820))),
        DOORBELL(new String(Character.toChars(0xF12E6))),
        DOORBELL_VIDEO(new String(Character.toChars(0xF0869))),
        DOT_NET(new String(Character.toChars(0xF0AAE))),
        DOTS_CIRCLE(new String(Character.toChars(0xF1978))),
        DOTS_GRID(new String(Character.toChars(0xF15FC))),
        DOTS_HEXAGON(new String(Character.toChars(0xF15FF))),
        DOTS_HORIZONTAL(new String(Character.toChars(0xF01D8))),
        DOTS_HORIZONTAL_CIRCLE(new String(Character.toChars(0xF07C3))),
        DOTS_HORIZONTAL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B8D))),
        DOTS_SQUARE(new String(Character.toChars(0xF15FD))),
        DOTS_TRIANGLE(new String(Character.toChars(0xF15FE))),
        DOTS_VERTICAL(new String(Character.toChars(0xF01D9))),
        DOTS_VERTICAL_CIRCLE(new String(Character.toChars(0xF07C4))),
        DOTS_VERTICAL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B8E))),
        DOWNLOAD(new String(Character.toChars(0xF01DA))),
        DOWNLOAD_BOX(new String(Character.toChars(0xF1462))),
        DOWNLOAD_BOX_OUTLINE(new String(Character.toChars(0xF1463))),
        DOWNLOAD_CIRCLE(new String(Character.toChars(0xF1464))),
        DOWNLOAD_CIRCLE_OUTLINE(new String(Character.toChars(0xF1465))),
        DOWNLOAD_LOCK(new String(Character.toChars(0xF1320))),
        DOWNLOAD_LOCK_OUTLINE(new String(Character.toChars(0xF1321))),
        DOWNLOAD_MULTIPLE(new String(Character.toChars(0xF09E9))),
        DOWNLOAD_NETWORK(new String(Character.toChars(0xF06F4))),
        DOWNLOAD_NETWORK_OUTLINE(new String(Character.toChars(0xF0C66))),
        DOWNLOAD_OFF(new String(Character.toChars(0xF10B0))),
        DOWNLOAD_OFF_OUTLINE(new String(Character.toChars(0xF10B1))),
        DOWNLOAD_OUTLINE(new String(Character.toChars(0xF0B8F))),
        DRAG(new String(Character.toChars(0xF01DB))),
        DRAG_HORIZONTAL(new String(Character.toChars(0xF01DC))),
        DRAG_HORIZONTAL_VARIANT(new String(Character.toChars(0xF12F0))),
        DRAG_VARIANT(new String(Character.toChars(0xF0B90))),
        DRAG_VERTICAL(new String(Character.toChars(0xF01DD))),
        DRAG_VERTICAL_VARIANT(new String(Character.toChars(0xF12F1))),
        DRAMA_MASKS(new String(Character.toChars(0xF0D02))),
        DRAW(new String(Character.toChars(0xF0F49))),
        DRAW_PEN(new String(Character.toChars(0xF19B9))),
        DRAWING(new String(Character.toChars(0xF01DE))),
        DRAWING_BOX(new String(Character.toChars(0xF01DF))),
        DRESSER(new String(Character.toChars(0xF0F4A))),
        DRESSER_OUTLINE(new String(Character.toChars(0xF0F4B))),
        DRONE(new String(Character.toChars(0xF01E2))),
        DROPBOX(new String(Character.toChars(0xF01E3))),
        DRUPAL(new String(Character.toChars(0xF01E4))),
        DUCK(new String(Character.toChars(0xF01E5))),
        DUMBBELL(new String(Character.toChars(0xF01E6))),
        DUMP_TRUCK(new String(Character.toChars(0xF0C67)));

        private final String unicode;

        D(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public D getDefaultGlyph()
        {
            return D.DANCE_BALLROOM;
        }
    }

    public enum E implements MaterialDesignIconGlyphs<E> {

        EAR_HEARING(new String(Character.toChars(0xF07C5))),
        EAR_HEARING_LOOP(new String(Character.toChars(0xF1AEE))),
        EAR_HEARING_OFF(new String(Character.toChars(0xF0A45))),
        EARBUDS(new String(Character.toChars(0xF184F))),
        EARBUDS_OFF(new String(Character.toChars(0xF1850))),
        EARBUDS_OFF_OUTLINE(new String(Character.toChars(0xF1851))),
        EARBUDS_OUTLINE(new String(Character.toChars(0xF1852))),
        EARTH(new String(Character.toChars(0xF01E7))),
        EARTH_ARROW_RIGHT(new String(Character.toChars(0xF1311))),
        EARTH_BOX(new String(Character.toChars(0xF06CD))),
        EARTH_BOX_MINUS(new String(Character.toChars(0xF1407))),
        EARTH_BOX_OFF(new String(Character.toChars(0xF06CE))),
        EARTH_BOX_PLUS(new String(Character.toChars(0xF1406))),
        EARTH_BOX_REMOVE(new String(Character.toChars(0xF1408))),
        EARTH_MINUS(new String(Character.toChars(0xF1404))),
        EARTH_OFF(new String(Character.toChars(0xF01E8))),
        EARTH_PLUS(new String(Character.toChars(0xF1403))),
        EARTH_REMOVE(new String(Character.toChars(0xF1405))),
        EGG(new String(Character.toChars(0xF0AAF))),
        EGG_EASTER(new String(Character.toChars(0xF0AB0))),
        EGG_FRIED(new String(Character.toChars(0xF184A))),
        EGG_OFF(new String(Character.toChars(0xF13F0))),
        EGG_OFF_OUTLINE(new String(Character.toChars(0xF13F1))),
        EGG_OUTLINE(new String(Character.toChars(0xF13F2))),
        EIFFEL_TOWER(new String(Character.toChars(0xF156B))),
        EIGHT_TRACK(new String(Character.toChars(0xF09EA))),
        EJECT(new String(Character.toChars(0xF01EA))),
        EJECT_CIRCLE(new String(Character.toChars(0xF1B23))),
        EJECT_CIRCLE_OUTLINE(new String(Character.toChars(0xF1B24))),
        EJECT_OUTLINE(new String(Character.toChars(0xF0B91))),
        ELECTRIC_SWITCH(new String(Character.toChars(0xF0E9F))),
        ELECTRIC_SWITCH_CLOSED(new String(Character.toChars(0xF10D9))),
        ELECTRON_FRAMEWORK(new String(Character.toChars(0xF1024))),
        ELEPHANT(new String(Character.toChars(0xF07C6))),
        ELEVATION_DECLINE(new String(Character.toChars(0xF01EB))),
        ELEVATION_RISE(new String(Character.toChars(0xF01EC))),
        ELEVATOR(new String(Character.toChars(0xF01ED))),
        ELEVATOR_DOWN(new String(Character.toChars(0xF12C2))),
        ELEVATOR_PASSENGER(new String(Character.toChars(0xF1381))),
        ELEVATOR_PASSENGER_OFF(new String(Character.toChars(0xF1979))),
        ELEVATOR_PASSENGER_OFF_OUTLINE(new String(Character.toChars(0xF197A))),
        ELEVATOR_PASSENGER_OUTLINE(new String(Character.toChars(0xF197B))),
        ELEVATOR_UP(new String(Character.toChars(0xF12C1))),
        ELLIPSE(new String(Character.toChars(0xF0EA0))),
        ELLIPSE_OUTLINE(new String(Character.toChars(0xF0EA1))),
        EMAIL(new String(Character.toChars(0xF01EE))),
        EMAIL_ALERT(new String(Character.toChars(0xF06CF))),
        EMAIL_ALERT_OUTLINE(new String(Character.toChars(0xF0D42))),
        EMAIL_ARROW_LEFT(new String(Character.toChars(0xF10DA))),
        EMAIL_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF10DB))),
        EMAIL_ARROW_RIGHT(new String(Character.toChars(0xF10DC))),
        EMAIL_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF10DD))),
        EMAIL_BOX(new String(Character.toChars(0xF0D03))),
        EMAIL_CHECK(new String(Character.toChars(0xF0AB1))),
        EMAIL_CHECK_OUTLINE(new String(Character.toChars(0xF0AB2))),
        EMAIL_EDIT(new String(Character.toChars(0xF0EE3))),
        EMAIL_EDIT_OUTLINE(new String(Character.toChars(0xF0EE4))),
        EMAIL_FAST(new String(Character.toChars(0xF186F))),
        EMAIL_FAST_OUTLINE(new String(Character.toChars(0xF1870))),
        EMAIL_HEART_OUTLINE(new String(Character.toChars(0xF1C5B))),
        EMAIL_LOCK(new String(Character.toChars(0xF01F1))),
        EMAIL_LOCK_OUTLINE(new String(Character.toChars(0xF1B61))),
        EMAIL_MARK_AS_UNREAD(new String(Character.toChars(0xF0B92))),
        EMAIL_MINUS(new String(Character.toChars(0xF0EE5))),
        EMAIL_MINUS_OUTLINE(new String(Character.toChars(0xF0EE6))),
        EMAIL_MULTIPLE(new String(Character.toChars(0xF0EE7))),
        EMAIL_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0EE8))),
        EMAIL_NEWSLETTER(new String(Character.toChars(0xF0FB1))),
        EMAIL_OFF(new String(Character.toChars(0xF13E3))),
        EMAIL_OFF_OUTLINE(new String(Character.toChars(0xF13E4))),
        EMAIL_OPEN(new String(Character.toChars(0xF01EF))),
        EMAIL_OPEN_HEART_OUTLINE(new String(Character.toChars(0xF1C5C))),
        EMAIL_OPEN_MULTIPLE(new String(Character.toChars(0xF0EE9))),
        EMAIL_OPEN_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0EEA))),
        EMAIL_OPEN_OUTLINE(new String(Character.toChars(0xF05EF))),
        EMAIL_OUTLINE(new String(Character.toChars(0xF01F0))),
        EMAIL_PLUS(new String(Character.toChars(0xF09EB))),
        EMAIL_PLUS_OUTLINE(new String(Character.toChars(0xF09EC))),
        EMAIL_REMOVE(new String(Character.toChars(0xF1661))),
        EMAIL_REMOVE_OUTLINE(new String(Character.toChars(0xF1662))),
        EMAIL_SEAL(new String(Character.toChars(0xF195B))),
        EMAIL_SEAL_OUTLINE(new String(Character.toChars(0xF195C))),
        EMAIL_SEARCH(new String(Character.toChars(0xF0961))),
        EMAIL_SEARCH_OUTLINE(new String(Character.toChars(0xF0962))),
        EMAIL_SYNC(new String(Character.toChars(0xF12C7))),
        EMAIL_SYNC_OUTLINE(new String(Character.toChars(0xF12C8))),
        EMAIL_VARIANT(new String(Character.toChars(0xF05F0))),
        EMBER(new String(Character.toChars(0xF0B30))),
        EMBY(new String(Character.toChars(0xF06B4))),
        EMOTICON(new String(Character.toChars(0xF0C68))),
        EMOTICON_ANGRY(new String(Character.toChars(0xF0C69))),
        EMOTICON_ANGRY_OUTLINE(new String(Character.toChars(0xF0C6A))),
        EMOTICON_CONFUSED(new String(Character.toChars(0xF10DE))),
        EMOTICON_CONFUSED_OUTLINE(new String(Character.toChars(0xF10DF))),
        EMOTICON_COOL(new String(Character.toChars(0xF0C6B))),
        EMOTICON_COOL_OUTLINE(new String(Character.toChars(0xF01F3))),
        EMOTICON_CRY(new String(Character.toChars(0xF0C6C))),
        EMOTICON_CRY_OUTLINE(new String(Character.toChars(0xF0C6D))),
        EMOTICON_DEAD(new String(Character.toChars(0xF0C6E))),
        EMOTICON_DEAD_OUTLINE(new String(Character.toChars(0xF069B))),
        EMOTICON_DEVIL(new String(Character.toChars(0xF0C6F))),
        EMOTICON_DEVIL_OUTLINE(new String(Character.toChars(0xF01F4))),
        EMOTICON_EXCITED(new String(Character.toChars(0xF0C70))),
        EMOTICON_EXCITED_OUTLINE(new String(Character.toChars(0xF069C))),
        EMOTICON_FROWN(new String(Character.toChars(0xF0F4C))),
        EMOTICON_FROWN_OUTLINE(new String(Character.toChars(0xF0F4D))),
        EMOTICON_HAPPY(new String(Character.toChars(0xF0C71))),
        EMOTICON_HAPPY_OUTLINE(new String(Character.toChars(0xF01F5))),
        EMOTICON_KISS(new String(Character.toChars(0xF0C72))),
        EMOTICON_KISS_OUTLINE(new String(Character.toChars(0xF0C73))),
        EMOTICON_LOL(new String(Character.toChars(0xF1214))),
        EMOTICON_LOL_OUTLINE(new String(Character.toChars(0xF1215))),
        EMOTICON_NEUTRAL(new String(Character.toChars(0xF0C74))),
        EMOTICON_NEUTRAL_OUTLINE(new String(Character.toChars(0xF01F6))),
        EMOTICON_OUTLINE(new String(Character.toChars(0xF01F2))),
        EMOTICON_POOP(new String(Character.toChars(0xF01F7))),
        EMOTICON_POOP_OUTLINE(new String(Character.toChars(0xF0C75))),
        EMOTICON_SAD(new String(Character.toChars(0xF0C76))),
        EMOTICON_SAD_OUTLINE(new String(Character.toChars(0xF01F8))),
        EMOTICON_SICK(new String(Character.toChars(0xF157C))),
        EMOTICON_SICK_OUTLINE(new String(Character.toChars(0xF157D))),
        EMOTICON_TONGUE(new String(Character.toChars(0xF01F9))),
        EMOTICON_TONGUE_OUTLINE(new String(Character.toChars(0xF0C77))),
        EMOTICON_WINK(new String(Character.toChars(0xF0C78))),
        EMOTICON_WINK_OUTLINE(new String(Character.toChars(0xF0C79))),
        ENGINE(new String(Character.toChars(0xF01FA))),
        ENGINE_OFF(new String(Character.toChars(0xF0A46))),
        ENGINE_OFF_OUTLINE(new String(Character.toChars(0xF0A47))),
        ENGINE_OUTLINE(new String(Character.toChars(0xF01FB))),
        EPSILON(new String(Character.toChars(0xF10E0))),
        EQUAL(new String(Character.toChars(0xF01FC))),
        EQUAL_BOX(new String(Character.toChars(0xF01FD))),
        EQUALIZER(new String(Character.toChars(0xF0EA2))),
        EQUALIZER_OUTLINE(new String(Character.toChars(0xF0EA3))),
        ERASER(new String(Character.toChars(0xF01FE))),
        ERASER_VARIANT(new String(Character.toChars(0xF0642))),
        ESCALATOR(new String(Character.toChars(0xF01FF))),
        ESCALATOR_BOX(new String(Character.toChars(0xF1399))),
        ESCALATOR_DOWN(new String(Character.toChars(0xF12C0))),
        ESCALATOR_UP(new String(Character.toChars(0xF12BF))),
        ESLINT(new String(Character.toChars(0xF0C7A))),
        ET(new String(Character.toChars(0xF0AB3))),
        ETHEREUM(new String(Character.toChars(0xF086A))),
        ETHERNET(new String(Character.toChars(0xF0200))),
        ETHERNET_CABLE(new String(Character.toChars(0xF0201))),
        ETHERNET_CABLE_OFF(new String(Character.toChars(0xF0202))),
        EV_PLUG_CCS1(new String(Character.toChars(0xF1519))),
        EV_PLUG_CCS2(new String(Character.toChars(0xF151A))),
        EV_PLUG_CHADEMO(new String(Character.toChars(0xF151B))),
        EV_PLUG_TESLA(new String(Character.toChars(0xF151C))),
        EV_PLUG_TYPE1(new String(Character.toChars(0xF151D))),
        EV_PLUG_TYPE2(new String(Character.toChars(0xF151E))),
        EV_STATION(new String(Character.toChars(0xF05F1))),
        EVERNOTE(new String(Character.toChars(0xF0204))),
        EXCAVATOR(new String(Character.toChars(0xF1025))),
        EXCLAMATION(new String(Character.toChars(0xF0205))),
        EXCLAMATION_THICK(new String(Character.toChars(0xF1238))),
        EXIT_RUN(new String(Character.toChars(0xF0A48))),
        EXIT_TO_APP(new String(Character.toChars(0xF0206))),
        EXPAND_ALL(new String(Character.toChars(0xF0AB4))),
        EXPAND_ALL_OUTLINE(new String(Character.toChars(0xF0AB5))),
        EXPANSION_CARD(new String(Character.toChars(0xF08AE))),
        EXPANSION_CARD_VARIANT(new String(Character.toChars(0xF0FB2))),
        EXPONENT(new String(Character.toChars(0xF0963))),
        EXPONENT_BOX(new String(Character.toChars(0xF0964))),
        EXPORT(new String(Character.toChars(0xF0207))),
        EXPORT_VARIANT(new String(Character.toChars(0xF0B93))),
        EYE(new String(Character.toChars(0xF0208))),
        EYE_ARROW_LEFT(new String(Character.toChars(0xF18FD))),
        EYE_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF18FE))),
        EYE_ARROW_RIGHT(new String(Character.toChars(0xF18FF))),
        EYE_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1900))),
        EYE_CHECK(new String(Character.toChars(0xF0D04))),
        EYE_CHECK_OUTLINE(new String(Character.toChars(0xF0D05))),
        EYE_CIRCLE(new String(Character.toChars(0xF0B94))),
        EYE_CIRCLE_OUTLINE(new String(Character.toChars(0xF0B95))),
        EYE_LOCK(new String(Character.toChars(0xF1C06))),
        EYE_LOCK_OPEN(new String(Character.toChars(0xF1C07))),
        EYE_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1C08))),
        EYE_LOCK_OUTLINE(new String(Character.toChars(0xF1C09))),
        EYE_MINUS(new String(Character.toChars(0xF1026))),
        EYE_MINUS_OUTLINE(new String(Character.toChars(0xF1027))),
        EYE_OFF(new String(Character.toChars(0xF0209))),
        EYE_OFF_OUTLINE(new String(Character.toChars(0xF06D1))),
        EYE_OUTLINE(new String(Character.toChars(0xF06D0))),
        EYE_PLUS(new String(Character.toChars(0xF086B))),
        EYE_PLUS_OUTLINE(new String(Character.toChars(0xF086C))),
        EYE_REFRESH(new String(Character.toChars(0xF197C))),
        EYE_REFRESH_OUTLINE(new String(Character.toChars(0xF197D))),
        EYE_REMOVE(new String(Character.toChars(0xF15E3))),
        EYE_REMOVE_OUTLINE(new String(Character.toChars(0xF15E4))),
        EYE_SETTINGS(new String(Character.toChars(0xF086D))),
        EYE_SETTINGS_OUTLINE(new String(Character.toChars(0xF086E))),
        EYEDROPPER(new String(Character.toChars(0xF020A))),
        EYEDROPPER_MINUS(new String(Character.toChars(0xF13DD))),
        EYEDROPPER_OFF(new String(Character.toChars(0xF13DF))),
        EYEDROPPER_PLUS(new String(Character.toChars(0xF13DC))),
        EYEDROPPER_REMOVE(new String(Character.toChars(0xF13DE))),
        EYEDROPPER_VARIANT(new String(Character.toChars(0xF020B)));

        private final String unicode;

        E(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public E getDefaultGlyph()
        {
            return E.EAR_HEARING;
        }
    }

    public enum F implements MaterialDesignIconGlyphs<F> {

        FACE_AGENT(new String(Character.toChars(0xF0D70))),
        FACE_MAN(new String(Character.toChars(0xF0643))),
        FACE_MAN_OUTLINE(new String(Character.toChars(0xF0B96))),
        FACE_MAN_PROFILE(new String(Character.toChars(0xF0644))),
        FACE_MAN_SHIMMER(new String(Character.toChars(0xF15CC))),
        FACE_MAN_SHIMMER_OUTLINE(new String(Character.toChars(0xF15CD))),
        FACE_MASK(new String(Character.toChars(0xF1586))),
        FACE_MASK_OUTLINE(new String(Character.toChars(0xF1587))),
        FACE_RECOGNITION(new String(Character.toChars(0xF0C7B))),
        FACE_WOMAN(new String(Character.toChars(0xF1077))),
        FACE_WOMAN_OUTLINE(new String(Character.toChars(0xF1078))),
        FACE_WOMAN_PROFILE(new String(Character.toChars(0xF1076))),
        FACE_WOMAN_SHIMMER(new String(Character.toChars(0xF15CE))),
        FACE_WOMAN_SHIMMER_OUTLINE(new String(Character.toChars(0xF15CF))),
        FACEBOOK(new String(Character.toChars(0xF020C))),
        FACEBOOK_GAMING(new String(Character.toChars(0xF07DD))),
        FACEBOOK_MESSENGER(new String(Character.toChars(0xF020E))),
        FACEBOOK_WORKPLACE(new String(Character.toChars(0xF0B31))),
        FACTORY(new String(Character.toChars(0xF020F))),
        FAMILY_TREE(new String(Character.toChars(0xF160E))),
        FAN(new String(Character.toChars(0xF0210))),
        FAN_ALERT(new String(Character.toChars(0xF146C))),
        FAN_AUTO(new String(Character.toChars(0xF171D))),
        FAN_CHEVRON_DOWN(new String(Character.toChars(0xF146D))),
        FAN_CHEVRON_UP(new String(Character.toChars(0xF146E))),
        FAN_CLOCK(new String(Character.toChars(0xF1A3A))),
        FAN_MINUS(new String(Character.toChars(0xF1470))),
        FAN_OFF(new String(Character.toChars(0xF081D))),
        FAN_PLUS(new String(Character.toChars(0xF146F))),
        FAN_REMOVE(new String(Character.toChars(0xF1471))),
        FAN_SPEED_1(new String(Character.toChars(0xF1472))),
        FAN_SPEED_2(new String(Character.toChars(0xF1473))),
        FAN_SPEED_3(new String(Character.toChars(0xF1474))),
        FAST_FORWARD(new String(Character.toChars(0xF0211))),
        FAST_FORWARD_10(new String(Character.toChars(0xF0D71))),
        FAST_FORWARD_15(new String(Character.toChars(0xF193A))),
        FAST_FORWARD_30(new String(Character.toChars(0xF0D06))),
        FAST_FORWARD_45(new String(Character.toChars(0xF1B12))),
        FAST_FORWARD_5(new String(Character.toChars(0xF11F8))),
        FAST_FORWARD_60(new String(Character.toChars(0xF160B))),
        FAST_FORWARD_OUTLINE(new String(Character.toChars(0xF06D2))),
        FAUCET(new String(Character.toChars(0xF1B29))),
        FAUCET_VARIANT(new String(Character.toChars(0xF1B2A))),
        FAX(new String(Character.toChars(0xF0212))),
        FEATHER(new String(Character.toChars(0xF06D3))),
        FEATURE_SEARCH(new String(Character.toChars(0xF0A49))),
        FEATURE_SEARCH_OUTLINE(new String(Character.toChars(0xF0A4A))),
        FEDORA(new String(Character.toChars(0xF08DB))),
        FENCE(new String(Character.toChars(0xF179A))),
        FENCE_ELECTRIC(new String(Character.toChars(0xF17F6))),
        FENCING(new String(Character.toChars(0xF14C1))),
        FERRIS_WHEEL(new String(Character.toChars(0xF0EA4))),
        FERRY(new String(Character.toChars(0xF0213))),
        FILE(new String(Character.toChars(0xF0214))),
        FILE_ACCOUNT(new String(Character.toChars(0xF073B))),
        FILE_ACCOUNT_OUTLINE(new String(Character.toChars(0xF1028))),
        FILE_ALERT(new String(Character.toChars(0xF0A4B))),
        FILE_ALERT_OUTLINE(new String(Character.toChars(0xF0A4C))),
        FILE_ARROW_LEFT_RIGHT(new String(Character.toChars(0xF1A93))),
        FILE_ARROW_LEFT_RIGHT_OUTLINE(new String(Character.toChars(0xF1A94))),
        FILE_ARROW_UP_DOWN(new String(Character.toChars(0xF1A95))),
        FILE_ARROW_UP_DOWN_OUTLINE(new String(Character.toChars(0xF1A96))),
        FILE_CABINET(new String(Character.toChars(0xF0AB6))),
        FILE_CAD(new String(Character.toChars(0xF0EEB))),
        FILE_CAD_BOX(new String(Character.toChars(0xF0EEC))),
        FILE_CANCEL(new String(Character.toChars(0xF0DC6))),
        FILE_CANCEL_OUTLINE(new String(Character.toChars(0xF0DC7))),
        FILE_CERTIFICATE(new String(Character.toChars(0xF1186))),
        FILE_CERTIFICATE_OUTLINE(new String(Character.toChars(0xF1187))),
        FILE_CHART(new String(Character.toChars(0xF0215))),
        FILE_CHART_CHECK(new String(Character.toChars(0xF19C6))),
        FILE_CHART_CHECK_OUTLINE(new String(Character.toChars(0xF19C7))),
        FILE_CHART_OUTLINE(new String(Character.toChars(0xF1029))),
        FILE_CHECK(new String(Character.toChars(0xF0216))),
        FILE_CHECK_OUTLINE(new String(Character.toChars(0xF0E29))),
        FILE_CLOCK(new String(Character.toChars(0xF12E1))),
        FILE_CLOCK_OUTLINE(new String(Character.toChars(0xF12E2))),
        FILE_CLOUD(new String(Character.toChars(0xF0217))),
        FILE_CLOUD_OUTLINE(new String(Character.toChars(0xF102A))),
        FILE_CODE(new String(Character.toChars(0xF022E))),
        FILE_CODE_OUTLINE(new String(Character.toChars(0xF102B))),
        FILE_COG(new String(Character.toChars(0xF107B))),
        FILE_COG_OUTLINE(new String(Character.toChars(0xF107C))),
        FILE_COMPARE(new String(Character.toChars(0xF08AA))),
        FILE_DELIMITED(new String(Character.toChars(0xF0218))),
        FILE_DELIMITED_OUTLINE(new String(Character.toChars(0xF0EA5))),
        FILE_DOCUMENT(new String(Character.toChars(0xF0219))),
        FILE_DOCUMENT_ALERT(new String(Character.toChars(0xF1A97))),
        FILE_DOCUMENT_ALERT_OUTLINE(new String(Character.toChars(0xF1A98))),
        FILE_DOCUMENT_ARROW_RIGHT(new String(Character.toChars(0xF1C0F))),
        FILE_DOCUMENT_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1C10))),
        FILE_DOCUMENT_CHECK(new String(Character.toChars(0xF1A99))),
        FILE_DOCUMENT_CHECK_OUTLINE(new String(Character.toChars(0xF1A9A))),
        FILE_DOCUMENT_EDIT(new String(Character.toChars(0xF0DC8))),
        FILE_DOCUMENT_EDIT_OUTLINE(new String(Character.toChars(0xF0DC9))),
        FILE_DOCUMENT_MINUS(new String(Character.toChars(0xF1A9B))),
        FILE_DOCUMENT_MINUS_OUTLINE(new String(Character.toChars(0xF1A9C))),
        FILE_DOCUMENT_MULTIPLE(new String(Character.toChars(0xF1517))),
        FILE_DOCUMENT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1518))),
        FILE_DOCUMENT_OUTLINE(new String(Character.toChars(0xF09EE))),
        FILE_DOCUMENT_PLUS(new String(Character.toChars(0xF1A9D))),
        FILE_DOCUMENT_PLUS_OUTLINE(new String(Character.toChars(0xF1A9E))),
        FILE_DOCUMENT_REFRESH(new String(Character.toChars(0xF1C7A))),
        FILE_DOCUMENT_REFRESH_OUTLINE(new String(Character.toChars(0xF1C7B))),
        FILE_DOCUMENT_REMOVE(new String(Character.toChars(0xF1A9F))),
        FILE_DOCUMENT_REMOVE_OUTLINE(new String(Character.toChars(0xF1AA0))),
        FILE_DOWNLOAD(new String(Character.toChars(0xF0965))),
        FILE_DOWNLOAD_OUTLINE(new String(Character.toChars(0xF0966))),
        FILE_EDIT(new String(Character.toChars(0xF11E7))),
        FILE_EDIT_OUTLINE(new String(Character.toChars(0xF11E8))),
        FILE_EXCEL(new String(Character.toChars(0xF021B))),
        FILE_EXCEL_BOX(new String(Character.toChars(0xF021C))),
        FILE_EXCEL_BOX_OUTLINE(new String(Character.toChars(0xF102C))),
        FILE_EXCEL_OUTLINE(new String(Character.toChars(0xF102D))),
        FILE_EXPORT(new String(Character.toChars(0xF021D))),
        FILE_EXPORT_OUTLINE(new String(Character.toChars(0xF102E))),
        FILE_EYE(new String(Character.toChars(0xF0DCA))),
        FILE_EYE_OUTLINE(new String(Character.toChars(0xF0DCB))),
        FILE_FIND(new String(Character.toChars(0xF021E))),
        FILE_FIND_OUTLINE(new String(Character.toChars(0xF0B97))),
        FILE_GIF_BOX(new String(Character.toChars(0xF0D78))),
        FILE_HIDDEN(new String(Character.toChars(0xF0613))),
        FILE_IMAGE(new String(Character.toChars(0xF021F))),
        FILE_IMAGE_MARKER(new String(Character.toChars(0xF1772))),
        FILE_IMAGE_MARKER_OUTLINE(new String(Character.toChars(0xF1773))),
        FILE_IMAGE_MINUS(new String(Character.toChars(0xF193B))),
        FILE_IMAGE_MINUS_OUTLINE(new String(Character.toChars(0xF193C))),
        FILE_IMAGE_OUTLINE(new String(Character.toChars(0xF0EB0))),
        FILE_IMAGE_PLUS(new String(Character.toChars(0xF193D))),
        FILE_IMAGE_PLUS_OUTLINE(new String(Character.toChars(0xF193E))),
        FILE_IMAGE_REMOVE(new String(Character.toChars(0xF193F))),
        FILE_IMAGE_REMOVE_OUTLINE(new String(Character.toChars(0xF1940))),
        FILE_IMPORT(new String(Character.toChars(0xF0220))),
        FILE_IMPORT_OUTLINE(new String(Character.toChars(0xF102F))),
        FILE_JPG_BOX(new String(Character.toChars(0xF0225))),
        FILE_KEY(new String(Character.toChars(0xF1184))),
        FILE_KEY_OUTLINE(new String(Character.toChars(0xF1185))),
        FILE_LINK(new String(Character.toChars(0xF1177))),
        FILE_LINK_OUTLINE(new String(Character.toChars(0xF1178))),
        FILE_LOCK(new String(Character.toChars(0xF0221))),
        FILE_LOCK_OPEN(new String(Character.toChars(0xF19C8))),
        FILE_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF19C9))),
        FILE_LOCK_OUTLINE(new String(Character.toChars(0xF1030))),
        FILE_MARKER(new String(Character.toChars(0xF1774))),
        FILE_MARKER_OUTLINE(new String(Character.toChars(0xF1775))),
        FILE_MINUS(new String(Character.toChars(0xF1AA1))),
        FILE_MINUS_OUTLINE(new String(Character.toChars(0xF1AA2))),
        FILE_MOVE(new String(Character.toChars(0xF0AB9))),
        FILE_MOVE_OUTLINE(new String(Character.toChars(0xF1031))),
        FILE_MULTIPLE(new String(Character.toChars(0xF0222))),
        FILE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1032))),
        FILE_MUSIC(new String(Character.toChars(0xF0223))),
        FILE_MUSIC_OUTLINE(new String(Character.toChars(0xF0E2A))),
        FILE_OUTLINE(new String(Character.toChars(0xF0224))),
        FILE_PDF_BOX(new String(Character.toChars(0xF0226))),
        FILE_PERCENT(new String(Character.toChars(0xF081E))),
        FILE_PERCENT_OUTLINE(new String(Character.toChars(0xF1033))),
        FILE_PHONE(new String(Character.toChars(0xF1179))),
        FILE_PHONE_OUTLINE(new String(Character.toChars(0xF117A))),
        FILE_PLUS(new String(Character.toChars(0xF0752))),
        FILE_PLUS_OUTLINE(new String(Character.toChars(0xF0EED))),
        FILE_PNG_BOX(new String(Character.toChars(0xF0E2D))),
        FILE_POWERPOINT(new String(Character.toChars(0xF0227))),
        FILE_POWERPOINT_BOX(new String(Character.toChars(0xF0228))),
        FILE_POWERPOINT_BOX_OUTLINE(new String(Character.toChars(0xF1034))),
        FILE_POWERPOINT_OUTLINE(new String(Character.toChars(0xF1035))),
        FILE_PRESENTATION_BOX(new String(Character.toChars(0xF0229))),
        FILE_QUESTION(new String(Character.toChars(0xF086F))),
        FILE_QUESTION_OUTLINE(new String(Character.toChars(0xF1036))),
        FILE_REFRESH(new String(Character.toChars(0xF0918))),
        FILE_REFRESH_OUTLINE(new String(Character.toChars(0xF0541))),
        FILE_REMOVE(new String(Character.toChars(0xF0B98))),
        FILE_REMOVE_OUTLINE(new String(Character.toChars(0xF1037))),
        FILE_REPLACE(new String(Character.toChars(0xF0B32))),
        FILE_REPLACE_OUTLINE(new String(Character.toChars(0xF0B33))),
        FILE_RESTORE(new String(Character.toChars(0xF0670))),
        FILE_RESTORE_OUTLINE(new String(Character.toChars(0xF1038))),
        FILE_ROTATE_LEFT(new String(Character.toChars(0xF1A3B))),
        FILE_ROTATE_LEFT_OUTLINE(new String(Character.toChars(0xF1A3C))),
        FILE_ROTATE_RIGHT(new String(Character.toChars(0xF1A3D))),
        FILE_ROTATE_RIGHT_OUTLINE(new String(Character.toChars(0xF1A3E))),
        FILE_SEARCH(new String(Character.toChars(0xF0C7C))),
        FILE_SEARCH_OUTLINE(new String(Character.toChars(0xF0C7D))),
        FILE_SEND(new String(Character.toChars(0xF022A))),
        FILE_SEND_OUTLINE(new String(Character.toChars(0xF1039))),
        FILE_SETTINGS(new String(Character.toChars(0xF1079))),
        FILE_SETTINGS_OUTLINE(new String(Character.toChars(0xF107A))),
        FILE_SIGN(new String(Character.toChars(0xF19C3))),
        FILE_STAR(new String(Character.toChars(0xF103A))),
        FILE_STAR_FOUR_POINTS(new String(Character.toChars(0xF1C2D))),
        FILE_STAR_FOUR_POINTS_OUTLINE(new String(Character.toChars(0xF1C2E))),
        FILE_STAR_OUTLINE(new String(Character.toChars(0xF103B))),
        FILE_SWAP(new String(Character.toChars(0xF0FB4))),
        FILE_SWAP_OUTLINE(new String(Character.toChars(0xF0FB5))),
        FILE_SYNC(new String(Character.toChars(0xF1216))),
        FILE_SYNC_OUTLINE(new String(Character.toChars(0xF1217))),
        FILE_TABLE(new String(Character.toChars(0xF0C7E))),
        FILE_TABLE_BOX(new String(Character.toChars(0xF10E1))),
        FILE_TABLE_BOX_MULTIPLE(new String(Character.toChars(0xF10E2))),
        FILE_TABLE_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF10E3))),
        FILE_TABLE_BOX_OUTLINE(new String(Character.toChars(0xF10E4))),
        FILE_TABLE_OUTLINE(new String(Character.toChars(0xF0C7F))),
        FILE_TREE(new String(Character.toChars(0xF0645))),
        FILE_TREE_OUTLINE(new String(Character.toChars(0xF13D2))),
        FILE_UNDO(new String(Character.toChars(0xF08DC))),
        FILE_UNDO_OUTLINE(new String(Character.toChars(0xF103C))),
        FILE_UPLOAD(new String(Character.toChars(0xF0A4D))),
        FILE_UPLOAD_OUTLINE(new String(Character.toChars(0xF0A4E))),
        FILE_VIDEO(new String(Character.toChars(0xF022B))),
        FILE_VIDEO_OUTLINE(new String(Character.toChars(0xF0E2C))),
        FILE_WORD(new String(Character.toChars(0xF022C))),
        FILE_WORD_BOX(new String(Character.toChars(0xF022D))),
        FILE_WORD_BOX_OUTLINE(new String(Character.toChars(0xF103D))),
        FILE_WORD_OUTLINE(new String(Character.toChars(0xF103E))),
        FILE_XML_BOX(new String(Character.toChars(0xF1B4B))),
        FILM(new String(Character.toChars(0xF022F))),
        FILMSTRIP(new String(Character.toChars(0xF0230))),
        FILMSTRIP_BOX(new String(Character.toChars(0xF0332))),
        FILMSTRIP_BOX_MULTIPLE(new String(Character.toChars(0xF0D18))),
        FILMSTRIP_OFF(new String(Character.toChars(0xF0231))),
        FILTER(new String(Character.toChars(0xF0232))),
        FILTER_CHECK(new String(Character.toChars(0xF18EC))),
        FILTER_CHECK_OUTLINE(new String(Character.toChars(0xF18ED))),
        FILTER_COG(new String(Character.toChars(0xF1AA3))),
        FILTER_COG_OUTLINE(new String(Character.toChars(0xF1AA4))),
        FILTER_MENU(new String(Character.toChars(0xF10E5))),
        FILTER_MENU_OUTLINE(new String(Character.toChars(0xF10E6))),
        FILTER_MINUS(new String(Character.toChars(0xF0EEE))),
        FILTER_MINUS_OUTLINE(new String(Character.toChars(0xF0EEF))),
        FILTER_MULTIPLE(new String(Character.toChars(0xF1A3F))),
        FILTER_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1A40))),
        FILTER_OFF(new String(Character.toChars(0xF14EF))),
        FILTER_OFF_OUTLINE(new String(Character.toChars(0xF14F0))),
        FILTER_OUTLINE(new String(Character.toChars(0xF0233))),
        FILTER_PLUS(new String(Character.toChars(0xF0EF0))),
        FILTER_PLUS_OUTLINE(new String(Character.toChars(0xF0EF1))),
        FILTER_REMOVE(new String(Character.toChars(0xF0234))),
        FILTER_REMOVE_OUTLINE(new String(Character.toChars(0xF0235))),
        FILTER_SETTINGS(new String(Character.toChars(0xF1AA5))),
        FILTER_SETTINGS_OUTLINE(new String(Character.toChars(0xF1AA6))),
        FILTER_VARIANT(new String(Character.toChars(0xF0236))),
        FILTER_VARIANT_MINUS(new String(Character.toChars(0xF1112))),
        FILTER_VARIANT_PLUS(new String(Character.toChars(0xF1113))),
        FILTER_VARIANT_REMOVE(new String(Character.toChars(0xF103F))),
        FINANCE(new String(Character.toChars(0xF081F))),
        FIND_REPLACE(new String(Character.toChars(0xF06D4))),
        FINGERPRINT(new String(Character.toChars(0xF0237))),
        FINGERPRINT_OFF(new String(Character.toChars(0xF0EB1))),
        FIRE(new String(Character.toChars(0xF0238))),
        FIRE_ALERT(new String(Character.toChars(0xF15D7))),
        FIRE_CIRCLE(new String(Character.toChars(0xF1807))),
        FIRE_EXTINGUISHER(new String(Character.toChars(0xF0EF2))),
        FIRE_HYDRANT(new String(Character.toChars(0xF1137))),
        FIRE_HYDRANT_ALERT(new String(Character.toChars(0xF1138))),
        FIRE_HYDRANT_OFF(new String(Character.toChars(0xF1139))),
        FIRE_OFF(new String(Character.toChars(0xF1722))),
        FIRE_TRUCK(new String(Character.toChars(0xF08AB))),
        FIREBASE(new String(Character.toChars(0xF0967))),
        FIREFOX(new String(Character.toChars(0xF0239))),
        FIREPLACE(new String(Character.toChars(0xF0E2E))),
        FIREPLACE_OFF(new String(Character.toChars(0xF0E2F))),
        FIREWIRE(new String(Character.toChars(0xF05BE))),
        FIREWORK(new String(Character.toChars(0xF0E30))),
        FIREWORK_OFF(new String(Character.toChars(0xF1723))),
        FISH(new String(Character.toChars(0xF023A))),
        FISH_OFF(new String(Character.toChars(0xF13F3))),
        FISHBOWL(new String(Character.toChars(0xF0EF3))),
        FISHBOWL_OUTLINE(new String(Character.toChars(0xF0EF4))),
        FIT_TO_PAGE(new String(Character.toChars(0xF0EF5))),
        FIT_TO_PAGE_OUTLINE(new String(Character.toChars(0xF0EF6))),
        FIT_TO_SCREEN(new String(Character.toChars(0xF18F4))),
        FIT_TO_SCREEN_OUTLINE(new String(Character.toChars(0xF18F5))),
        FLAG(new String(Character.toChars(0xF023B))),
        FLAG_CHECKERED(new String(Character.toChars(0xF023C))),
        FLAG_MINUS(new String(Character.toChars(0xF0B99))),
        FLAG_MINUS_OUTLINE(new String(Character.toChars(0xF10B2))),
        FLAG_OFF(new String(Character.toChars(0xF18EE))),
        FLAG_OFF_OUTLINE(new String(Character.toChars(0xF18EF))),
        FLAG_OUTLINE(new String(Character.toChars(0xF023D))),
        FLAG_PLUS(new String(Character.toChars(0xF0B9A))),
        FLAG_PLUS_OUTLINE(new String(Character.toChars(0xF10B3))),
        FLAG_REMOVE(new String(Character.toChars(0xF0B9B))),
        FLAG_REMOVE_OUTLINE(new String(Character.toChars(0xF10B4))),
        FLAG_TRIANGLE(new String(Character.toChars(0xF023F))),
        FLAG_VARIANT(new String(Character.toChars(0xF0240))),
        FLAG_VARIANT_MINUS(new String(Character.toChars(0xF1BB4))),
        FLAG_VARIANT_MINUS_OUTLINE(new String(Character.toChars(0xF1BB5))),
        FLAG_VARIANT_OFF(new String(Character.toChars(0xF1BB0))),
        FLAG_VARIANT_OFF_OUTLINE(new String(Character.toChars(0xF1BB1))),
        FLAG_VARIANT_OUTLINE(new String(Character.toChars(0xF023E))),
        FLAG_VARIANT_PLUS(new String(Character.toChars(0xF1BB2))),
        FLAG_VARIANT_PLUS_OUTLINE(new String(Character.toChars(0xF1BB3))),
        FLAG_VARIANT_REMOVE(new String(Character.toChars(0xF1BB6))),
        FLAG_VARIANT_REMOVE_OUTLINE(new String(Character.toChars(0xF1BB7))),
        FLARE(new String(Character.toChars(0xF0D72))),
        FLASH(new String(Character.toChars(0xF0241))),
        FLASH_ALERT(new String(Character.toChars(0xF0EF7))),
        FLASH_ALERT_OUTLINE(new String(Character.toChars(0xF0EF8))),
        FLASH_AUTO(new String(Character.toChars(0xF0242))),
        FLASH_OFF(new String(Character.toChars(0xF0243))),
        FLASH_OFF_OUTLINE(new String(Character.toChars(0xF1B45))),
        FLASH_OUTLINE(new String(Character.toChars(0xF06D5))),
        FLASH_RED_EYE(new String(Character.toChars(0xF067B))),
        FLASH_TRIANGLE(new String(Character.toChars(0xF1B1D))),
        FLASH_TRIANGLE_OUTLINE(new String(Character.toChars(0xF1B1E))),
        FLASHLIGHT(new String(Character.toChars(0xF0244))),
        FLASHLIGHT_OFF(new String(Character.toChars(0xF0245))),
        FLASK(new String(Character.toChars(0xF0093))),
        FLASK_EMPTY(new String(Character.toChars(0xF0094))),
        FLASK_EMPTY_MINUS(new String(Character.toChars(0xF123A))),
        FLASK_EMPTY_MINUS_OUTLINE(new String(Character.toChars(0xF123B))),
        FLASK_EMPTY_OFF(new String(Character.toChars(0xF13F4))),
        FLASK_EMPTY_OFF_OUTLINE(new String(Character.toChars(0xF13F5))),
        FLASK_EMPTY_OUTLINE(new String(Character.toChars(0xF0095))),
        FLASK_EMPTY_PLUS(new String(Character.toChars(0xF123C))),
        FLASK_EMPTY_PLUS_OUTLINE(new String(Character.toChars(0xF123D))),
        FLASK_EMPTY_REMOVE(new String(Character.toChars(0xF123E))),
        FLASK_EMPTY_REMOVE_OUTLINE(new String(Character.toChars(0xF123F))),
        FLASK_MINUS(new String(Character.toChars(0xF1240))),
        FLASK_MINUS_OUTLINE(new String(Character.toChars(0xF1241))),
        FLASK_OFF(new String(Character.toChars(0xF13F6))),
        FLASK_OFF_OUTLINE(new String(Character.toChars(0xF13F7))),
        FLASK_OUTLINE(new String(Character.toChars(0xF0096))),
        FLASK_PLUS(new String(Character.toChars(0xF1242))),
        FLASK_PLUS_OUTLINE(new String(Character.toChars(0xF1243))),
        FLASK_REMOVE(new String(Character.toChars(0xF1244))),
        FLASK_REMOVE_OUTLINE(new String(Character.toChars(0xF1245))),
        FLASK_ROUND_BOTTOM(new String(Character.toChars(0xF124B))),
        FLASK_ROUND_BOTTOM_EMPTY(new String(Character.toChars(0xF124C))),
        FLASK_ROUND_BOTTOM_EMPTY_OUTLINE(new String(Character.toChars(0xF124D))),
        FLASK_ROUND_BOTTOM_OUTLINE(new String(Character.toChars(0xF124E))),
        FLEUR_DE_LIS(new String(Character.toChars(0xF1303))),
        FLIP_HORIZONTAL(new String(Character.toChars(0xF10E7))),
        FLIP_TO_BACK(new String(Character.toChars(0xF0247))),
        FLIP_TO_FRONT(new String(Character.toChars(0xF0248))),
        FLIP_VERTICAL(new String(Character.toChars(0xF10E8))),
        FLOOR_LAMP(new String(Character.toChars(0xF08DD))),
        FLOOR_LAMP_DUAL(new String(Character.toChars(0xF1040))),
        FLOOR_LAMP_DUAL_OUTLINE(new String(Character.toChars(0xF17CE))),
        FLOOR_LAMP_OUTLINE(new String(Character.toChars(0xF17C8))),
        FLOOR_LAMP_TORCHIERE(new String(Character.toChars(0xF1747))),
        FLOOR_LAMP_TORCHIERE_OUTLINE(new String(Character.toChars(0xF17D6))),
        FLOOR_LAMP_TORCHIERE_VARIANT(new String(Character.toChars(0xF1041))),
        FLOOR_LAMP_TORCHIERE_VARIANT_OUTLINE(new String(Character.toChars(0xF17CF))),
        FLOOR_PLAN(new String(Character.toChars(0xF0821))),
        FLOPPY(new String(Character.toChars(0xF0249))),
        FLOPPY_VARIANT(new String(Character.toChars(0xF09EF))),
        FLOWER(new String(Character.toChars(0xF024A))),
        FLOWER_OUTLINE(new String(Character.toChars(0xF09F0))),
        FLOWER_POLLEN(new String(Character.toChars(0xF1885))),
        FLOWER_POLLEN_OUTLINE(new String(Character.toChars(0xF1886))),
        FLOWER_POPPY(new String(Character.toChars(0xF0D08))),
        FLOWER_TULIP(new String(Character.toChars(0xF09F1))),
        FLOWER_TULIP_OUTLINE(new String(Character.toChars(0xF09F2))),
        FOCUS_AUTO(new String(Character.toChars(0xF0F4E))),
        FOCUS_FIELD(new String(Character.toChars(0xF0F4F))),
        FOCUS_FIELD_HORIZONTAL(new String(Character.toChars(0xF0F50))),
        FOCUS_FIELD_VERTICAL(new String(Character.toChars(0xF0F51))),
        FOLDER(new String(Character.toChars(0xF024B))),
        FOLDER_ACCOUNT(new String(Character.toChars(0xF024C))),
        FOLDER_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0B9C))),
        FOLDER_ALERT(new String(Character.toChars(0xF0DCC))),
        FOLDER_ALERT_OUTLINE(new String(Character.toChars(0xF0DCD))),
        FOLDER_ARROW_DOWN(new String(Character.toChars(0xF19E8))),
        FOLDER_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF19E9))),
        FOLDER_ARROW_LEFT(new String(Character.toChars(0xF19EA))),
        FOLDER_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF19EB))),
        FOLDER_ARROW_LEFT_RIGHT(new String(Character.toChars(0xF19EC))),
        FOLDER_ARROW_LEFT_RIGHT_OUTLINE(new String(Character.toChars(0xF19ED))),
        FOLDER_ARROW_RIGHT(new String(Character.toChars(0xF19EE))),
        FOLDER_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF19EF))),
        FOLDER_ARROW_UP(new String(Character.toChars(0xF19F0))),
        FOLDER_ARROW_UP_DOWN(new String(Character.toChars(0xF19F1))),
        FOLDER_ARROW_UP_DOWN_OUTLINE(new String(Character.toChars(0xF19F2))),
        FOLDER_ARROW_UP_OUTLINE(new String(Character.toChars(0xF19F3))),
        FOLDER_CANCEL(new String(Character.toChars(0xF19F4))),
        FOLDER_CANCEL_OUTLINE(new String(Character.toChars(0xF19F5))),
        FOLDER_CHECK(new String(Character.toChars(0xF197E))),
        FOLDER_CHECK_OUTLINE(new String(Character.toChars(0xF197F))),
        FOLDER_CLOCK(new String(Character.toChars(0xF0ABA))),
        FOLDER_CLOCK_OUTLINE(new String(Character.toChars(0xF0ABB))),
        FOLDER_COG(new String(Character.toChars(0xF107F))),
        FOLDER_COG_OUTLINE(new String(Character.toChars(0xF1080))),
        FOLDER_DOWNLOAD(new String(Character.toChars(0xF024D))),
        FOLDER_DOWNLOAD_OUTLINE(new String(Character.toChars(0xF10E9))),
        FOLDER_EDIT(new String(Character.toChars(0xF08DE))),
        FOLDER_EDIT_OUTLINE(new String(Character.toChars(0xF0DCE))),
        FOLDER_EYE(new String(Character.toChars(0xF178A))),
        FOLDER_EYE_OUTLINE(new String(Character.toChars(0xF178B))),
        FOLDER_FILE(new String(Character.toChars(0xF19F6))),
        FOLDER_FILE_OUTLINE(new String(Character.toChars(0xF19F7))),
        FOLDER_GOOGLE_DRIVE(new String(Character.toChars(0xF024E))),
        FOLDER_HEART(new String(Character.toChars(0xF10EA))),
        FOLDER_HEART_OUTLINE(new String(Character.toChars(0xF10EB))),
        FOLDER_HIDDEN(new String(Character.toChars(0xF179E))),
        FOLDER_HOME(new String(Character.toChars(0xF10B5))),
        FOLDER_HOME_OUTLINE(new String(Character.toChars(0xF10B6))),
        FOLDER_IMAGE(new String(Character.toChars(0xF024F))),
        FOLDER_INFORMATION(new String(Character.toChars(0xF10B7))),
        FOLDER_INFORMATION_OUTLINE(new String(Character.toChars(0xF10B8))),
        FOLDER_KEY(new String(Character.toChars(0xF08AC))),
        FOLDER_KEY_NETWORK(new String(Character.toChars(0xF08AD))),
        FOLDER_KEY_NETWORK_OUTLINE(new String(Character.toChars(0xF0C80))),
        FOLDER_KEY_OUTLINE(new String(Character.toChars(0xF10EC))),
        FOLDER_LOCK(new String(Character.toChars(0xF0250))),
        FOLDER_LOCK_OPEN(new String(Character.toChars(0xF0251))),
        FOLDER_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1AA7))),
        FOLDER_LOCK_OUTLINE(new String(Character.toChars(0xF1AA8))),
        FOLDER_MARKER(new String(Character.toChars(0xF126D))),
        FOLDER_MARKER_OUTLINE(new String(Character.toChars(0xF126E))),
        FOLDER_MINUS(new String(Character.toChars(0xF1B49))),
        FOLDER_MINUS_OUTLINE(new String(Character.toChars(0xF1B4A))),
        FOLDER_MOVE(new String(Character.toChars(0xF0252))),
        FOLDER_MOVE_OUTLINE(new String(Character.toChars(0xF1246))),
        FOLDER_MULTIPLE(new String(Character.toChars(0xF0253))),
        FOLDER_MULTIPLE_IMAGE(new String(Character.toChars(0xF0254))),
        FOLDER_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0255))),
        FOLDER_MULTIPLE_PLUS(new String(Character.toChars(0xF147E))),
        FOLDER_MULTIPLE_PLUS_OUTLINE(new String(Character.toChars(0xF147F))),
        FOLDER_MUSIC(new String(Character.toChars(0xF1359))),
        FOLDER_MUSIC_OUTLINE(new String(Character.toChars(0xF135A))),
        FOLDER_NETWORK(new String(Character.toChars(0xF0870))),
        FOLDER_NETWORK_OUTLINE(new String(Character.toChars(0xF0C81))),
        FOLDER_OFF(new String(Character.toChars(0xF19F8))),
        FOLDER_OFF_OUTLINE(new String(Character.toChars(0xF19F9))),
        FOLDER_OPEN(new String(Character.toChars(0xF0770))),
        FOLDER_OPEN_OUTLINE(new String(Character.toChars(0xF0DCF))),
        FOLDER_OUTLINE(new String(Character.toChars(0xF0256))),
        FOLDER_PLAY(new String(Character.toChars(0xF19FA))),
        FOLDER_PLAY_OUTLINE(new String(Character.toChars(0xF19FB))),
        FOLDER_PLUS(new String(Character.toChars(0xF0257))),
        FOLDER_PLUS_OUTLINE(new String(Character.toChars(0xF0B9D))),
        FOLDER_POUND(new String(Character.toChars(0xF0D09))),
        FOLDER_POUND_OUTLINE(new String(Character.toChars(0xF0D0A))),
        FOLDER_QUESTION(new String(Character.toChars(0xF19CA))),
        FOLDER_QUESTION_OUTLINE(new String(Character.toChars(0xF19CB))),
        FOLDER_REFRESH(new String(Character.toChars(0xF0749))),
        FOLDER_REFRESH_OUTLINE(new String(Character.toChars(0xF0542))),
        FOLDER_REMOVE(new String(Character.toChars(0xF0258))),
        FOLDER_REMOVE_OUTLINE(new String(Character.toChars(0xF0B9E))),
        FOLDER_SEARCH(new String(Character.toChars(0xF0968))),
        FOLDER_SEARCH_OUTLINE(new String(Character.toChars(0xF0969))),
        FOLDER_SETTINGS(new String(Character.toChars(0xF107D))),
        FOLDER_SETTINGS_OUTLINE(new String(Character.toChars(0xF107E))),
        FOLDER_STAR(new String(Character.toChars(0xF069D))),
        FOLDER_STAR_MULTIPLE(new String(Character.toChars(0xF13D3))),
        FOLDER_STAR_MULTIPLE_OUTLINE(new String(Character.toChars(0xF13D4))),
        FOLDER_STAR_OUTLINE(new String(Character.toChars(0xF0B9F))),
        FOLDER_SWAP(new String(Character.toChars(0xF0FB6))),
        FOLDER_SWAP_OUTLINE(new String(Character.toChars(0xF0FB7))),
        FOLDER_SYNC(new String(Character.toChars(0xF0D0B))),
        FOLDER_SYNC_OUTLINE(new String(Character.toChars(0xF0D0C))),
        FOLDER_TABLE(new String(Character.toChars(0xF12E3))),
        FOLDER_TABLE_OUTLINE(new String(Character.toChars(0xF12E4))),
        FOLDER_TEXT(new String(Character.toChars(0xF0C82))),
        FOLDER_TEXT_OUTLINE(new String(Character.toChars(0xF0C83))),
        FOLDER_UPLOAD(new String(Character.toChars(0xF0259))),
        FOLDER_UPLOAD_OUTLINE(new String(Character.toChars(0xF10ED))),
        FOLDER_WRENCH(new String(Character.toChars(0xF19FC))),
        FOLDER_WRENCH_OUTLINE(new String(Character.toChars(0xF19FD))),
        FOLDER_ZIP(new String(Character.toChars(0xF06EB))),
        FOLDER_ZIP_OUTLINE(new String(Character.toChars(0xF07B9))),
        FONT_AWESOME(new String(Character.toChars(0xF003A))),
        FOOD(new String(Character.toChars(0xF025A))),
        FOOD_APPLE(new String(Character.toChars(0xF025B))),
        FOOD_APPLE_OUTLINE(new String(Character.toChars(0xF0C84))),
        FOOD_CROISSANT(new String(Character.toChars(0xF07C8))),
        FOOD_DRUMSTICK(new String(Character.toChars(0xF141F))),
        FOOD_DRUMSTICK_OFF(new String(Character.toChars(0xF1468))),
        FOOD_DRUMSTICK_OFF_OUTLINE(new String(Character.toChars(0xF1469))),
        FOOD_DRUMSTICK_OUTLINE(new String(Character.toChars(0xF1420))),
        FOOD_FORK_DRINK(new String(Character.toChars(0xF05F2))),
        FOOD_HALAL(new String(Character.toChars(0xF1572))),
        FOOD_HOT_DOG(new String(Character.toChars(0xF184B))),
        FOOD_KOSHER(new String(Character.toChars(0xF1573))),
        FOOD_OFF(new String(Character.toChars(0xF05F3))),
        FOOD_OFF_OUTLINE(new String(Character.toChars(0xF1915))),
        FOOD_OUTLINE(new String(Character.toChars(0xF1916))),
        FOOD_STEAK(new String(Character.toChars(0xF146A))),
        FOOD_STEAK_OFF(new String(Character.toChars(0xF146B))),
        FOOD_TAKEOUT_BOX(new String(Character.toChars(0xF1836))),
        FOOD_TAKEOUT_BOX_OUTLINE(new String(Character.toChars(0xF1837))),
        FOOD_TURKEY(new String(Character.toChars(0xF171C))),
        FOOD_VARIANT(new String(Character.toChars(0xF025C))),
        FOOD_VARIANT_OFF(new String(Character.toChars(0xF13E5))),
        FOOT_PRINT(new String(Character.toChars(0xF0F52))),
        FOOTBALL(new String(Character.toChars(0xF025D))),
        FOOTBALL_AUSTRALIAN(new String(Character.toChars(0xF025E))),
        FOOTBALL_HELMET(new String(Character.toChars(0xF025F))),
        FOREST(new String(Character.toChars(0xF1897))),
        FOREST_OUTLINE(new String(Character.toChars(0xF1C63))),
        FORKLIFT(new String(Character.toChars(0xF07C9))),
        FORM_DROPDOWN(new String(Character.toChars(0xF1400))),
        FORM_SELECT(new String(Character.toChars(0xF1401))),
        FORM_TEXTAREA(new String(Character.toChars(0xF1095))),
        FORM_TEXTBOX(new String(Character.toChars(0xF060E))),
        FORM_TEXTBOX_LOCK(new String(Character.toChars(0xF135D))),
        FORM_TEXTBOX_PASSWORD(new String(Character.toChars(0xF07F5))),
        FORMAT_ALIGN_BOTTOM(new String(Character.toChars(0xF0753))),
        FORMAT_ALIGN_CENTER(new String(Character.toChars(0xF0260))),
        FORMAT_ALIGN_JUSTIFY(new String(Character.toChars(0xF0261))),
        FORMAT_ALIGN_LEFT(new String(Character.toChars(0xF0262))),
        FORMAT_ALIGN_MIDDLE(new String(Character.toChars(0xF0754))),
        FORMAT_ALIGN_RIGHT(new String(Character.toChars(0xF0263))),
        FORMAT_ALIGN_TOP(new String(Character.toChars(0xF0755))),
        FORMAT_ANNOTATION_MINUS(new String(Character.toChars(0xF0ABC))),
        FORMAT_ANNOTATION_PLUS(new String(Character.toChars(0xF0646))),
        FORMAT_BOLD(new String(Character.toChars(0xF0264))),
        FORMAT_CLEAR(new String(Character.toChars(0xF0265))),
        FORMAT_COLOR_FILL(new String(Character.toChars(0xF0266))),
        FORMAT_COLOR_HIGHLIGHT(new String(Character.toChars(0xF0E31))),
        FORMAT_COLOR_MARKER_CANCEL(new String(Character.toChars(0xF1313))),
        FORMAT_COLOR_TEXT(new String(Character.toChars(0xF069E))),
        FORMAT_COLUMNS(new String(Character.toChars(0xF08DF))),
        FORMAT_FLOAT_CENTER(new String(Character.toChars(0xF0267))),
        FORMAT_FLOAT_LEFT(new String(Character.toChars(0xF0268))),
        FORMAT_FLOAT_NONE(new String(Character.toChars(0xF0269))),
        FORMAT_FLOAT_RIGHT(new String(Character.toChars(0xF026A))),
        FORMAT_FONT(new String(Character.toChars(0xF06D6))),
        FORMAT_FONT_SIZE_DECREASE(new String(Character.toChars(0xF09F3))),
        FORMAT_FONT_SIZE_INCREASE(new String(Character.toChars(0xF09F4))),
        FORMAT_HEADER_1(new String(Character.toChars(0xF026B))),
        FORMAT_HEADER_2(new String(Character.toChars(0xF026C))),
        FORMAT_HEADER_3(new String(Character.toChars(0xF026D))),
        FORMAT_HEADER_4(new String(Character.toChars(0xF026E))),
        FORMAT_HEADER_5(new String(Character.toChars(0xF026F))),
        FORMAT_HEADER_6(new String(Character.toChars(0xF0270))),
        FORMAT_HEADER_DECREASE(new String(Character.toChars(0xF0271))),
        FORMAT_HEADER_EQUAL(new String(Character.toChars(0xF0272))),
        FORMAT_HEADER_INCREASE(new String(Character.toChars(0xF0273))),
        FORMAT_HEADER_POUND(new String(Character.toChars(0xF0274))),
        FORMAT_HORIZONTAL_ALIGN_CENTER(new String(Character.toChars(0xF061E))),
        FORMAT_HORIZONTAL_ALIGN_LEFT(new String(Character.toChars(0xF061F))),
        FORMAT_HORIZONTAL_ALIGN_RIGHT(new String(Character.toChars(0xF0620))),
        FORMAT_INDENT_DECREASE(new String(Character.toChars(0xF0275))),
        FORMAT_INDENT_INCREASE(new String(Character.toChars(0xF0276))),
        FORMAT_ITALIC(new String(Character.toChars(0xF0277))),
        FORMAT_LETTER_CASE(new String(Character.toChars(0xF0B34))),
        FORMAT_LETTER_CASE_LOWER(new String(Character.toChars(0xF0B35))),
        FORMAT_LETTER_CASE_UPPER(new String(Character.toChars(0xF0B36))),
        FORMAT_LETTER_ENDS_WITH(new String(Character.toChars(0xF0FB8))),
        FORMAT_LETTER_MATCHES(new String(Character.toChars(0xF0FB9))),
        FORMAT_LETTER_SPACING(new String(Character.toChars(0xF1956))),
        FORMAT_LETTER_SPACING_VARIANT(new String(Character.toChars(0xF1AFB))),
        FORMAT_LETTER_STARTS_WITH(new String(Character.toChars(0xF0FBA))),
        FORMAT_LINE_HEIGHT(new String(Character.toChars(0xF1AFC))),
        FORMAT_LINE_SPACING(new String(Character.toChars(0xF0278))),
        FORMAT_LINE_STYLE(new String(Character.toChars(0xF05C8))),
        FORMAT_LINE_WEIGHT(new String(Character.toChars(0xF05C9))),
        FORMAT_LIST_BULLETED(new String(Character.toChars(0xF0279))),
        FORMAT_LIST_BULLETED_SQUARE(new String(Character.toChars(0xF0DD0))),
        FORMAT_LIST_BULLETED_TRIANGLE(new String(Character.toChars(0xF0EB2))),
        FORMAT_LIST_BULLETED_TYPE(new String(Character.toChars(0xF027A))),
        FORMAT_LIST_CHECKBOX(new String(Character.toChars(0xF096A))),
        FORMAT_LIST_CHECKS(new String(Character.toChars(0xF0756))),
        FORMAT_LIST_GROUP(new String(Character.toChars(0xF1860))),
        FORMAT_LIST_GROUP_PLUS(new String(Character.toChars(0xF1B56))),
        FORMAT_LIST_NUMBERED(new String(Character.toChars(0xF027B))),
        FORMAT_LIST_NUMBERED_RTL(new String(Character.toChars(0xF0D0D))),
        FORMAT_LIST_TEXT(new String(Character.toChars(0xF126F))),
        FORMAT_OVERLINE(new String(Character.toChars(0xF0EB3))),
        FORMAT_PAGE_BREAK(new String(Character.toChars(0xF06D7))),
        FORMAT_PAGE_SPLIT(new String(Character.toChars(0xF1917))),
        FORMAT_PAINT(new String(Character.toChars(0xF027C))),
        FORMAT_PARAGRAPH(new String(Character.toChars(0xF027D))),
        FORMAT_PARAGRAPH_SPACING(new String(Character.toChars(0xF1AFD))),
        FORMAT_PILCROW(new String(Character.toChars(0xF06D8))),
        FORMAT_PILCROW_ARROW_LEFT(new String(Character.toChars(0xF0286))),
        FORMAT_PILCROW_ARROW_RIGHT(new String(Character.toChars(0xF0285))),
        FORMAT_QUOTE_CLOSE(new String(Character.toChars(0xF027E))),
        FORMAT_QUOTE_CLOSE_OUTLINE(new String(Character.toChars(0xF11A8))),
        FORMAT_QUOTE_OPEN(new String(Character.toChars(0xF0757))),
        FORMAT_QUOTE_OPEN_OUTLINE(new String(Character.toChars(0xF11A7))),
        FORMAT_ROTATE_90(new String(Character.toChars(0xF06AA))),
        FORMAT_SECTION(new String(Character.toChars(0xF069F))),
        FORMAT_SIZE(new String(Character.toChars(0xF027F))),
        FORMAT_STRIKETHROUGH(new String(Character.toChars(0xF0280))),
        FORMAT_STRIKETHROUGH_VARIANT(new String(Character.toChars(0xF0281))),
        FORMAT_SUBSCRIPT(new String(Character.toChars(0xF0282))),
        FORMAT_SUPERSCRIPT(new String(Character.toChars(0xF0283))),
        FORMAT_TEXT(new String(Character.toChars(0xF0284))),
        FORMAT_TEXT_ROTATION_ANGLE_DOWN(new String(Character.toChars(0xF0FBB))),
        FORMAT_TEXT_ROTATION_ANGLE_UP(new String(Character.toChars(0xF0FBC))),
        FORMAT_TEXT_ROTATION_DOWN(new String(Character.toChars(0xF0D73))),
        FORMAT_TEXT_ROTATION_DOWN_VERTICAL(new String(Character.toChars(0xF0FBD))),
        FORMAT_TEXT_ROTATION_NONE(new String(Character.toChars(0xF0D74))),
        FORMAT_TEXT_ROTATION_UP(new String(Character.toChars(0xF0FBE))),
        FORMAT_TEXT_ROTATION_VERTICAL(new String(Character.toChars(0xF0FBF))),
        FORMAT_TEXT_VARIANT(new String(Character.toChars(0xF0E32))),
        FORMAT_TEXT_VARIANT_OUTLINE(new String(Character.toChars(0xF150F))),
        FORMAT_TEXT_WRAPPING_CLIP(new String(Character.toChars(0xF0D0E))),
        FORMAT_TEXT_WRAPPING_OVERFLOW(new String(Character.toChars(0xF0D0F))),
        FORMAT_TEXT_WRAPPING_WRAP(new String(Character.toChars(0xF0D10))),
        FORMAT_TEXTBOX(new String(Character.toChars(0xF0D11))),
        FORMAT_TITLE(new String(Character.toChars(0xF05F4))),
        FORMAT_UNDERLINE(new String(Character.toChars(0xF0287))),
        FORMAT_UNDERLINE_WAVY(new String(Character.toChars(0xF18E9))),
        FORMAT_VERTICAL_ALIGN_BOTTOM(new String(Character.toChars(0xF0621))),
        FORMAT_VERTICAL_ALIGN_CENTER(new String(Character.toChars(0xF0622))),
        FORMAT_VERTICAL_ALIGN_TOP(new String(Character.toChars(0xF0623))),
        FORMAT_WRAP_INLINE(new String(Character.toChars(0xF0288))),
        FORMAT_WRAP_SQUARE(new String(Character.toChars(0xF0289))),
        FORMAT_WRAP_TIGHT(new String(Character.toChars(0xF028A))),
        FORMAT_WRAP_TOP_BOTTOM(new String(Character.toChars(0xF028B))),
        FORUM(new String(Character.toChars(0xF028C))),
        FORUM_MINUS(new String(Character.toChars(0xF1AA9))),
        FORUM_MINUS_OUTLINE(new String(Character.toChars(0xF1AAA))),
        FORUM_OUTLINE(new String(Character.toChars(0xF0822))),
        FORUM_PLUS(new String(Character.toChars(0xF1AAB))),
        FORUM_PLUS_OUTLINE(new String(Character.toChars(0xF1AAC))),
        FORUM_REMOVE(new String(Character.toChars(0xF1AAD))),
        FORUM_REMOVE_OUTLINE(new String(Character.toChars(0xF1AAE))),
        FORWARD(new String(Character.toChars(0xF028D))),
        FORWARDBURGER(new String(Character.toChars(0xF0D75))),
        FOUNTAIN(new String(Character.toChars(0xF096B))),
        FOUNTAIN_PEN(new String(Character.toChars(0xF0D12))),
        FOUNTAIN_PEN_TIP(new String(Character.toChars(0xF0D13))),
        FRACTION_ONE_HALF(new String(Character.toChars(0xF1992))),
        FREEBSD(new String(Character.toChars(0xF08E0))),
        FRENCH_FRIES(new String(Character.toChars(0xF1957))),
        FREQUENTLY_ASKED_QUESTIONS(new String(Character.toChars(0xF0EB4))),
        FRIDGE(new String(Character.toChars(0xF0290))),
        FRIDGE_ALERT(new String(Character.toChars(0xF11B1))),
        FRIDGE_ALERT_OUTLINE(new String(Character.toChars(0xF11B2))),
        FRIDGE_BOTTOM(new String(Character.toChars(0xF0292))),
        FRIDGE_INDUSTRIAL(new String(Character.toChars(0xF15EE))),
        FRIDGE_INDUSTRIAL_ALERT(new String(Character.toChars(0xF15EF))),
        FRIDGE_INDUSTRIAL_ALERT_OUTLINE(new String(Character.toChars(0xF15F0))),
        FRIDGE_INDUSTRIAL_OFF(new String(Character.toChars(0xF15F1))),
        FRIDGE_INDUSTRIAL_OFF_OUTLINE(new String(Character.toChars(0xF15F2))),
        FRIDGE_INDUSTRIAL_OUTLINE(new String(Character.toChars(0xF15F3))),
        FRIDGE_OFF(new String(Character.toChars(0xF11AF))),
        FRIDGE_OFF_OUTLINE(new String(Character.toChars(0xF11B0))),
        FRIDGE_OUTLINE(new String(Character.toChars(0xF028F))),
        FRIDGE_TOP(new String(Character.toChars(0xF0291))),
        FRIDGE_VARIANT(new String(Character.toChars(0xF15F4))),
        FRIDGE_VARIANT_ALERT(new String(Character.toChars(0xF15F5))),
        FRIDGE_VARIANT_ALERT_OUTLINE(new String(Character.toChars(0xF15F6))),
        FRIDGE_VARIANT_OFF(new String(Character.toChars(0xF15F7))),
        FRIDGE_VARIANT_OFF_OUTLINE(new String(Character.toChars(0xF15F8))),
        FRIDGE_VARIANT_OUTLINE(new String(Character.toChars(0xF15F9))),
        FRUIT_CHERRIES(new String(Character.toChars(0xF1042))),
        FRUIT_CHERRIES_OFF(new String(Character.toChars(0xF13F8))),
        FRUIT_CITRUS(new String(Character.toChars(0xF1043))),
        FRUIT_CITRUS_OFF(new String(Character.toChars(0xF13F9))),
        FRUIT_GRAPES(new String(Character.toChars(0xF1044))),
        FRUIT_GRAPES_OUTLINE(new String(Character.toChars(0xF1045))),
        FRUIT_PEAR(new String(Character.toChars(0xF1A0E))),
        FRUIT_PINEAPPLE(new String(Character.toChars(0xF1046))),
        FRUIT_WATERMELON(new String(Character.toChars(0xF1047))),
        FUEL(new String(Character.toChars(0xF07CA))),
        FUEL_CELL(new String(Character.toChars(0xF18B5))),
        FULLSCREEN(new String(Character.toChars(0xF0293))),
        FULLSCREEN_EXIT(new String(Character.toChars(0xF0294))),
        FUNCTION(new String(Character.toChars(0xF0295))),
        FUNCTION_VARIANT(new String(Character.toChars(0xF0871))),
        FURIGANA_HORIZONTAL(new String(Character.toChars(0xF1081))),
        FURIGANA_VERTICAL(new String(Character.toChars(0xF1082))),
        FUSE(new String(Character.toChars(0xF0C85))),
        FUSE_ALERT(new String(Character.toChars(0xF142D))),
        FUSE_BLADE(new String(Character.toChars(0xF0C86))),
        FUSE_OFF(new String(Character.toChars(0xF142C)));

        private final String unicode;

        F(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public F getDefaultGlyph()
        {
            return F.FACE_AGENT;
        }
    }

    public enum G implements MaterialDesignIconGlyphs<G> {

        GAMEPAD(new String(Character.toChars(0xF0296))),
        GAMEPAD_CIRCLE(new String(Character.toChars(0xF0E33))),
        GAMEPAD_CIRCLE_DOWN(new String(Character.toChars(0xF0E34))),
        GAMEPAD_CIRCLE_LEFT(new String(Character.toChars(0xF0E35))),
        GAMEPAD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0E36))),
        GAMEPAD_CIRCLE_RIGHT(new String(Character.toChars(0xF0E37))),
        GAMEPAD_CIRCLE_UP(new String(Character.toChars(0xF0E38))),
        GAMEPAD_DOWN(new String(Character.toChars(0xF0E39))),
        GAMEPAD_LEFT(new String(Character.toChars(0xF0E3A))),
        GAMEPAD_OUTLINE(new String(Character.toChars(0xF1919))),
        GAMEPAD_RIGHT(new String(Character.toChars(0xF0E3B))),
        GAMEPAD_ROUND(new String(Character.toChars(0xF0E3C))),
        GAMEPAD_ROUND_DOWN(new String(Character.toChars(0xF0E3D))),
        GAMEPAD_ROUND_LEFT(new String(Character.toChars(0xF0E3E))),
        GAMEPAD_ROUND_OUTLINE(new String(Character.toChars(0xF0E3F))),
        GAMEPAD_ROUND_RIGHT(new String(Character.toChars(0xF0E40))),
        GAMEPAD_ROUND_UP(new String(Character.toChars(0xF0E41))),
        GAMEPAD_SQUARE(new String(Character.toChars(0xF0EB5))),
        GAMEPAD_SQUARE_OUTLINE(new String(Character.toChars(0xF0EB6))),
        GAMEPAD_UP(new String(Character.toChars(0xF0E42))),
        GAMEPAD_VARIANT(new String(Character.toChars(0xF0297))),
        GAMEPAD_VARIANT_OUTLINE(new String(Character.toChars(0xF0EB7))),
        GAMMA(new String(Character.toChars(0xF10EE))),
        GANTRY_CRANE(new String(Character.toChars(0xF0DD1))),
        GARAGE(new String(Character.toChars(0xF06D9))),
        GARAGE_ALERT(new String(Character.toChars(0xF0872))),
        GARAGE_ALERT_VARIANT(new String(Character.toChars(0xF12D5))),
        GARAGE_LOCK(new String(Character.toChars(0xF17FB))),
        GARAGE_OPEN(new String(Character.toChars(0xF06DA))),
        GARAGE_OPEN_VARIANT(new String(Character.toChars(0xF12D4))),
        GARAGE_VARIANT(new String(Character.toChars(0xF12D3))),
        GARAGE_VARIANT_LOCK(new String(Character.toChars(0xF17FC))),
        GAS_BURNER(new String(Character.toChars(0xF1A1B))),
        GAS_CYLINDER(new String(Character.toChars(0xF0647))),
        GAS_STATION(new String(Character.toChars(0xF0298))),
        GAS_STATION_OFF(new String(Character.toChars(0xF1409))),
        GAS_STATION_OFF_OUTLINE(new String(Character.toChars(0xF140A))),
        GAS_STATION_OUTLINE(new String(Character.toChars(0xF0EB8))),
        GATE(new String(Character.toChars(0xF0299))),
        GATE_ALERT(new String(Character.toChars(0xF17F8))),
        GATE_AND(new String(Character.toChars(0xF08E1))),
        GATE_ARROW_LEFT(new String(Character.toChars(0xF17F7))),
        GATE_ARROW_RIGHT(new String(Character.toChars(0xF1169))),
        GATE_BUFFER(new String(Character.toChars(0xF1AFE))),
        GATE_NAND(new String(Character.toChars(0xF08E2))),
        GATE_NOR(new String(Character.toChars(0xF08E3))),
        GATE_NOT(new String(Character.toChars(0xF08E4))),
        GATE_OPEN(new String(Character.toChars(0xF116A))),
        GATE_OR(new String(Character.toChars(0xF08E5))),
        GATE_XNOR(new String(Character.toChars(0xF08E6))),
        GATE_XOR(new String(Character.toChars(0xF08E7))),
        GATSBY(new String(Character.toChars(0xF0E43))),
        GAUGE(new String(Character.toChars(0xF029A))),
        GAUGE_EMPTY(new String(Character.toChars(0xF0873))),
        GAUGE_FULL(new String(Character.toChars(0xF0874))),
        GAUGE_LOW(new String(Character.toChars(0xF0875))),
        GAVEL(new String(Character.toChars(0xF029B))),
        GENDER_FEMALE(new String(Character.toChars(0xF029C))),
        GENDER_MALE(new String(Character.toChars(0xF029D))),
        GENDER_MALE_FEMALE(new String(Character.toChars(0xF029E))),
        GENDER_MALE_FEMALE_VARIANT(new String(Character.toChars(0xF113F))),
        GENDER_NON_BINARY(new String(Character.toChars(0xF1140))),
        GENDER_TRANSGENDER(new String(Character.toChars(0xF029F))),
        GENTOO(new String(Character.toChars(0xF08E8))),
        GESTURE(new String(Character.toChars(0xF07CB))),
        GESTURE_DOUBLE_TAP(new String(Character.toChars(0xF073C))),
        GESTURE_PINCH(new String(Character.toChars(0xF0ABD))),
        GESTURE_SPREAD(new String(Character.toChars(0xF0ABE))),
        GESTURE_SWIPE(new String(Character.toChars(0xF0D76))),
        GESTURE_SWIPE_DOWN(new String(Character.toChars(0xF073D))),
        GESTURE_SWIPE_HORIZONTAL(new String(Character.toChars(0xF0ABF))),
        GESTURE_SWIPE_LEFT(new String(Character.toChars(0xF073E))),
        GESTURE_SWIPE_RIGHT(new String(Character.toChars(0xF073F))),
        GESTURE_SWIPE_UP(new String(Character.toChars(0xF0740))),
        GESTURE_SWIPE_VERTICAL(new String(Character.toChars(0xF0AC0))),
        GESTURE_TAP(new String(Character.toChars(0xF0741))),
        GESTURE_TAP_BOX(new String(Character.toChars(0xF12A9))),
        GESTURE_TAP_BUTTON(new String(Character.toChars(0xF12A8))),
        GESTURE_TAP_HOLD(new String(Character.toChars(0xF0D77))),
        GESTURE_TWO_DOUBLE_TAP(new String(Character.toChars(0xF0742))),
        GESTURE_TWO_TAP(new String(Character.toChars(0xF0743))),
        GHOST(new String(Character.toChars(0xF02A0))),
        GHOST_OFF(new String(Character.toChars(0xF09F5))),
        GHOST_OFF_OUTLINE(new String(Character.toChars(0xF165C))),
        GHOST_OUTLINE(new String(Character.toChars(0xF165D))),
        GIFT(new String(Character.toChars(0xF0E44))),
        GIFT_OFF(new String(Character.toChars(0xF16EF))),
        GIFT_OFF_OUTLINE(new String(Character.toChars(0xF16F0))),
        GIFT_OPEN(new String(Character.toChars(0xF16F1))),
        GIFT_OPEN_OUTLINE(new String(Character.toChars(0xF16F2))),
        GIFT_OUTLINE(new String(Character.toChars(0xF02A1))),
        GIT(new String(Character.toChars(0xF02A2))),
        GITHUB(new String(Character.toChars(0xF02A4))),
        GITLAB(new String(Character.toChars(0xF0BA0))),
        GLASS_COCKTAIL(new String(Character.toChars(0xF0356))),
        GLASS_COCKTAIL_OFF(new String(Character.toChars(0xF15E6))),
        GLASS_FLUTE(new String(Character.toChars(0xF02A5))),
        GLASS_FRAGILE(new String(Character.toChars(0xF1873))),
        GLASS_MUG(new String(Character.toChars(0xF02A6))),
        GLASS_MUG_OFF(new String(Character.toChars(0xF15E7))),
        GLASS_MUG_VARIANT(new String(Character.toChars(0xF1116))),
        GLASS_MUG_VARIANT_OFF(new String(Character.toChars(0xF15E8))),
        GLASS_PINT_OUTLINE(new String(Character.toChars(0xF130D))),
        GLASS_STANGE(new String(Character.toChars(0xF02A7))),
        GLASS_TULIP(new String(Character.toChars(0xF02A8))),
        GLASS_WINE(new String(Character.toChars(0xF0876))),
        GLASSES(new String(Character.toChars(0xF02AA))),
        GLOBE_LIGHT(new String(Character.toChars(0xF066F))),
        GLOBE_LIGHT_OUTLINE(new String(Character.toChars(0xF12D7))),
        GLOBE_MODEL(new String(Character.toChars(0xF08E9))),
        GMAIL(new String(Character.toChars(0xF02AB))),
        GNOME(new String(Character.toChars(0xF02AC))),
        GO_KART(new String(Character.toChars(0xF0D79))),
        GO_KART_TRACK(new String(Character.toChars(0xF0D7A))),
        GOG(new String(Character.toChars(0xF0BA1))),
        GOLD(new String(Character.toChars(0xF124F))),
        GOLF(new String(Character.toChars(0xF0823))),
        GOLF_CART(new String(Character.toChars(0xF11A4))),
        GOLF_TEE(new String(Character.toChars(0xF1083))),
        GONDOLA(new String(Character.toChars(0xF0686))),
        GOODREADS(new String(Character.toChars(0xF0D7B))),
        GOOGLE(new String(Character.toChars(0xF02AD))),
        GOOGLE_ADS(new String(Character.toChars(0xF0C87))),
        GOOGLE_ANALYTICS(new String(Character.toChars(0xF07CC))),
        GOOGLE_ASSISTANT(new String(Character.toChars(0xF07CD))),
        GOOGLE_CARDBOARD(new String(Character.toChars(0xF02AE))),
        GOOGLE_CHROME(new String(Character.toChars(0xF02AF))),
        GOOGLE_CIRCLES(new String(Character.toChars(0xF02B0))),
        GOOGLE_CIRCLES_COMMUNITIES(new String(Character.toChars(0xF02B1))),
        GOOGLE_CIRCLES_EXTENDED(new String(Character.toChars(0xF02B2))),
        GOOGLE_CIRCLES_GROUP(new String(Character.toChars(0xF02B3))),
        GOOGLE_CLASSROOM(new String(Character.toChars(0xF02C0))),
        GOOGLE_CLOUD(new String(Character.toChars(0xF11F6))),
        GOOGLE_DOWNASAUR(new String(Character.toChars(0xF1362))),
        GOOGLE_DRIVE(new String(Character.toChars(0xF02B6))),
        GOOGLE_EARTH(new String(Character.toChars(0xF02B7))),
        GOOGLE_FIT(new String(Character.toChars(0xF096C))),
        GOOGLE_GLASS(new String(Character.toChars(0xF02B8))),
        GOOGLE_HANGOUTS(new String(Character.toChars(0xF02C9))),
        GOOGLE_KEEP(new String(Character.toChars(0xF06DC))),
        GOOGLE_LENS(new String(Character.toChars(0xF09F6))),
        GOOGLE_MAPS(new String(Character.toChars(0xF05F5))),
        GOOGLE_MY_BUSINESS(new String(Character.toChars(0xF1048))),
        GOOGLE_NEARBY(new String(Character.toChars(0xF02B9))),
        GOOGLE_PLAY(new String(Character.toChars(0xF02BC))),
        GOOGLE_PLUS(new String(Character.toChars(0xF02BD))),
        GOOGLE_PODCAST(new String(Character.toChars(0xF0EB9))),
        GOOGLE_SPREADSHEET(new String(Character.toChars(0xF09F7))),
        GOOGLE_STREET_VIEW(new String(Character.toChars(0xF0C88))),
        GOOGLE_TRANSLATE(new String(Character.toChars(0xF02BF))),
        GRADIENT_HORIZONTAL(new String(Character.toChars(0xF174A))),
        GRADIENT_VERTICAL(new String(Character.toChars(0xF06A0))),
        GRAIN(new String(Character.toChars(0xF0D7C))),
        GRAPH(new String(Character.toChars(0xF1049))),
        GRAPH_OUTLINE(new String(Character.toChars(0xF104A))),
        GRAPHQL(new String(Character.toChars(0xF0877))),
        GRASS(new String(Character.toChars(0xF1510))),
        GRAVE_STONE(new String(Character.toChars(0xF0BA2))),
        GREASE_PENCIL(new String(Character.toChars(0xF0648))),
        GREATER_THAN(new String(Character.toChars(0xF096D))),
        GREATER_THAN_OR_EQUAL(new String(Character.toChars(0xF096E))),
        GREENHOUSE(new String(Character.toChars(0xF002D))),
        GRID(new String(Character.toChars(0xF02C1))),
        GRID_LARGE(new String(Character.toChars(0xF0758))),
        GRID_OFF(new String(Character.toChars(0xF02C2))),
        GRILL(new String(Character.toChars(0xF0E45))),
        GRILL_OUTLINE(new String(Character.toChars(0xF118A))),
        GROUP(new String(Character.toChars(0xF02C3))),
        GUITAR_ACOUSTIC(new String(Character.toChars(0xF0771))),
        GUITAR_ELECTRIC(new String(Character.toChars(0xF02C4))),
        GUITAR_PICK(new String(Character.toChars(0xF02C5))),
        GUITAR_PICK_OUTLINE(new String(Character.toChars(0xF02C6))),
        GUY_FAWKES_MASK(new String(Character.toChars(0xF0825))),
        GYMNASTICS(new String(Character.toChars(0xF1A41)));

        private final String unicode;

        G(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public G getDefaultGlyph()
        {
            return G.GAMEPAD;
        }
    }

    public enum H implements MaterialDesignIconGlyphs<H> {

        HAIL(new String(Character.toChars(0xF0AC1))),
        HAIR_DRYER(new String(Character.toChars(0xF10EF))),
        HAIR_DRYER_OUTLINE(new String(Character.toChars(0xF10F0))),
        HALLOWEEN(new String(Character.toChars(0xF0BA3))),
        HAMBURGER(new String(Character.toChars(0xF0685))),
        HAMBURGER_CHECK(new String(Character.toChars(0xF1776))),
        HAMBURGER_MINUS(new String(Character.toChars(0xF1777))),
        HAMBURGER_OFF(new String(Character.toChars(0xF1778))),
        HAMBURGER_PLUS(new String(Character.toChars(0xF1779))),
        HAMBURGER_REMOVE(new String(Character.toChars(0xF177A))),
        HAMMER(new String(Character.toChars(0xF08EA))),
        HAMMER_SCREWDRIVER(new String(Character.toChars(0xF1322))),
        HAMMER_SICKLE(new String(Character.toChars(0xF1887))),
        HAMMER_WRENCH(new String(Character.toChars(0xF1323))),
        HAND_BACK_LEFT(new String(Character.toChars(0xF0E46))),
        HAND_BACK_LEFT_OFF(new String(Character.toChars(0xF1830))),
        HAND_BACK_LEFT_OFF_OUTLINE(new String(Character.toChars(0xF1832))),
        HAND_BACK_LEFT_OUTLINE(new String(Character.toChars(0xF182C))),
        HAND_BACK_RIGHT(new String(Character.toChars(0xF0E47))),
        HAND_BACK_RIGHT_OFF(new String(Character.toChars(0xF1831))),
        HAND_BACK_RIGHT_OFF_OUTLINE(new String(Character.toChars(0xF1833))),
        HAND_BACK_RIGHT_OUTLINE(new String(Character.toChars(0xF182D))),
        HAND_CLAP(new String(Character.toChars(0xF194B))),
        HAND_CLAP_OFF(new String(Character.toChars(0xF1A42))),
        HAND_COIN(new String(Character.toChars(0xF188F))),
        HAND_COIN_OUTLINE(new String(Character.toChars(0xF1890))),
        HAND_CYCLE(new String(Character.toChars(0xF1B9C))),
        HAND_EXTENDED(new String(Character.toChars(0xF18B6))),
        HAND_EXTENDED_OUTLINE(new String(Character.toChars(0xF18B7))),
        HAND_FRONT_LEFT(new String(Character.toChars(0xF182B))),
        HAND_FRONT_LEFT_OUTLINE(new String(Character.toChars(0xF182E))),
        HAND_FRONT_RIGHT(new String(Character.toChars(0xF0A4F))),
        HAND_FRONT_RIGHT_OUTLINE(new String(Character.toChars(0xF182F))),
        HAND_HEART(new String(Character.toChars(0xF10F1))),
        HAND_HEART_OUTLINE(new String(Character.toChars(0xF157E))),
        HAND_OKAY(new String(Character.toChars(0xF0A50))),
        HAND_PEACE(new String(Character.toChars(0xF0A51))),
        HAND_PEACE_VARIANT(new String(Character.toChars(0xF0A52))),
        HAND_POINTING_DOWN(new String(Character.toChars(0xF0A53))),
        HAND_POINTING_LEFT(new String(Character.toChars(0xF0A54))),
        HAND_POINTING_RIGHT(new String(Character.toChars(0xF02C7))),
        HAND_POINTING_UP(new String(Character.toChars(0xF0A55))),
        HAND_SAW(new String(Character.toChars(0xF0E48))),
        HAND_WASH(new String(Character.toChars(0xF157F))),
        HAND_WASH_OUTLINE(new String(Character.toChars(0xF1580))),
        HAND_WATER(new String(Character.toChars(0xF139F))),
        HAND_WAVE(new String(Character.toChars(0xF1821))),
        HAND_WAVE_OUTLINE(new String(Character.toChars(0xF1822))),
        HANDBALL(new String(Character.toChars(0xF0F53))),
        HANDCUFFS(new String(Character.toChars(0xF113E))),
        HANDS_PRAY(new String(Character.toChars(0xF0579))),
        HANDSHAKE(new String(Character.toChars(0xF1218))),
        HANDSHAKE_OUTLINE(new String(Character.toChars(0xF15A1))),
        HANGER(new String(Character.toChars(0xF02C8))),
        HARD_HAT(new String(Character.toChars(0xF096F))),
        HARDDISK(new String(Character.toChars(0xF02CA))),
        HARDDISK_PLUS(new String(Character.toChars(0xF104B))),
        HARDDISK_REMOVE(new String(Character.toChars(0xF104C))),
        HAT_FEDORA(new String(Character.toChars(0xF0BA4))),
        HAZARD_LIGHTS(new String(Character.toChars(0xF0C89))),
        HDMI_PORT(new String(Character.toChars(0xF1BB8))),
        HDR(new String(Character.toChars(0xF0D7D))),
        HDR_OFF(new String(Character.toChars(0xF0D7E))),
        HEAD(new String(Character.toChars(0xF135E))),
        HEAD_ALERT(new String(Character.toChars(0xF1338))),
        HEAD_ALERT_OUTLINE(new String(Character.toChars(0xF1339))),
        HEAD_CHECK(new String(Character.toChars(0xF133A))),
        HEAD_CHECK_OUTLINE(new String(Character.toChars(0xF133B))),
        HEAD_COG(new String(Character.toChars(0xF133C))),
        HEAD_COG_OUTLINE(new String(Character.toChars(0xF133D))),
        HEAD_DOTS_HORIZONTAL(new String(Character.toChars(0xF133E))),
        HEAD_DOTS_HORIZONTAL_OUTLINE(new String(Character.toChars(0xF133F))),
        HEAD_FLASH(new String(Character.toChars(0xF1340))),
        HEAD_FLASH_OUTLINE(new String(Character.toChars(0xF1341))),
        HEAD_HEART(new String(Character.toChars(0xF1342))),
        HEAD_HEART_OUTLINE(new String(Character.toChars(0xF1343))),
        HEAD_LIGHTBULB(new String(Character.toChars(0xF1344))),
        HEAD_LIGHTBULB_OUTLINE(new String(Character.toChars(0xF1345))),
        HEAD_MINUS(new String(Character.toChars(0xF1346))),
        HEAD_MINUS_OUTLINE(new String(Character.toChars(0xF1347))),
        HEAD_OUTLINE(new String(Character.toChars(0xF135F))),
        HEAD_PLUS(new String(Character.toChars(0xF1348))),
        HEAD_PLUS_OUTLINE(new String(Character.toChars(0xF1349))),
        HEAD_QUESTION(new String(Character.toChars(0xF134A))),
        HEAD_QUESTION_OUTLINE(new String(Character.toChars(0xF134B))),
        HEAD_REMOVE(new String(Character.toChars(0xF134C))),
        HEAD_REMOVE_OUTLINE(new String(Character.toChars(0xF134D))),
        HEAD_SNOWFLAKE(new String(Character.toChars(0xF134E))),
        HEAD_SNOWFLAKE_OUTLINE(new String(Character.toChars(0xF134F))),
        HEAD_SYNC(new String(Character.toChars(0xF1350))),
        HEAD_SYNC_OUTLINE(new String(Character.toChars(0xF1351))),
        HEADPHONES(new String(Character.toChars(0xF02CB))),
        HEADPHONES_BLUETOOTH(new String(Character.toChars(0xF0970))),
        HEADPHONES_BOX(new String(Character.toChars(0xF02CC))),
        HEADPHONES_OFF(new String(Character.toChars(0xF07CE))),
        HEADPHONES_SETTINGS(new String(Character.toChars(0xF02CD))),
        HEADSET(new String(Character.toChars(0xF02CE))),
        HEADSET_DOCK(new String(Character.toChars(0xF02CF))),
        HEADSET_OFF(new String(Character.toChars(0xF02D0))),
        HEART(new String(Character.toChars(0xF02D1))),
        HEART_BOX(new String(Character.toChars(0xF02D2))),
        HEART_BOX_OUTLINE(new String(Character.toChars(0xF02D3))),
        HEART_BROKEN(new String(Character.toChars(0xF02D4))),
        HEART_BROKEN_OUTLINE(new String(Character.toChars(0xF0D14))),
        HEART_CIRCLE(new String(Character.toChars(0xF0971))),
        HEART_CIRCLE_OUTLINE(new String(Character.toChars(0xF0972))),
        HEART_COG(new String(Character.toChars(0xF1663))),
        HEART_COG_OUTLINE(new String(Character.toChars(0xF1664))),
        HEART_FLASH(new String(Character.toChars(0xF0EF9))),
        HEART_HALF(new String(Character.toChars(0xF06DF))),
        HEART_HALF_FULL(new String(Character.toChars(0xF06DE))),
        HEART_HALF_OUTLINE(new String(Character.toChars(0xF06E0))),
        HEART_MINUS(new String(Character.toChars(0xF142F))),
        HEART_MINUS_OUTLINE(new String(Character.toChars(0xF1432))),
        HEART_MULTIPLE(new String(Character.toChars(0xF0A56))),
        HEART_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0A57))),
        HEART_OFF(new String(Character.toChars(0xF0759))),
        HEART_OFF_OUTLINE(new String(Character.toChars(0xF1434))),
        HEART_OUTLINE(new String(Character.toChars(0xF02D5))),
        HEART_PLUS(new String(Character.toChars(0xF142E))),
        HEART_PLUS_OUTLINE(new String(Character.toChars(0xF1431))),
        HEART_PULSE(new String(Character.toChars(0xF05F6))),
        HEART_REMOVE(new String(Character.toChars(0xF1430))),
        HEART_REMOVE_OUTLINE(new String(Character.toChars(0xF1433))),
        HEART_SETTINGS(new String(Character.toChars(0xF1665))),
        HEART_SETTINGS_OUTLINE(new String(Character.toChars(0xF1666))),
        HEAT_PUMP(new String(Character.toChars(0xF1A43))),
        HEAT_PUMP_OUTLINE(new String(Character.toChars(0xF1A44))),
        HEAT_WAVE(new String(Character.toChars(0xF1A45))),
        HEATING_COIL(new String(Character.toChars(0xF1AAF))),
        HELICOPTER(new String(Character.toChars(0xF0AC2))),
        HELP(new String(Character.toChars(0xF02D6))),
        HELP_BOX(new String(Character.toChars(0xF078B))),
        HELP_BOX_MULTIPLE(new String(Character.toChars(0xF1C0A))),
        HELP_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1C0B))),
        HELP_BOX_OUTLINE(new String(Character.toChars(0xF1C0C))),
        HELP_CIRCLE(new String(Character.toChars(0xF02D7))),
        HELP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0625))),
        HELP_NETWORK(new String(Character.toChars(0xF06F5))),
        HELP_NETWORK_OUTLINE(new String(Character.toChars(0xF0C8A))),
        HELP_RHOMBUS(new String(Character.toChars(0xF0BA5))),
        HELP_RHOMBUS_OUTLINE(new String(Character.toChars(0xF0BA6))),
        HEXADECIMAL(new String(Character.toChars(0xF12A7))),
        HEXAGON(new String(Character.toChars(0xF02D8))),
        HEXAGON_MULTIPLE(new String(Character.toChars(0xF06E1))),
        HEXAGON_MULTIPLE_OUTLINE(new String(Character.toChars(0xF10F2))),
        HEXAGON_OUTLINE(new String(Character.toChars(0xF02D9))),
        HEXAGON_SLICE_1(new String(Character.toChars(0xF0AC3))),
        HEXAGON_SLICE_2(new String(Character.toChars(0xF0AC4))),
        HEXAGON_SLICE_3(new String(Character.toChars(0xF0AC5))),
        HEXAGON_SLICE_4(new String(Character.toChars(0xF0AC6))),
        HEXAGON_SLICE_5(new String(Character.toChars(0xF0AC7))),
        HEXAGON_SLICE_6(new String(Character.toChars(0xF0AC8))),
        HEXAGRAM(new String(Character.toChars(0xF0AC9))),
        HEXAGRAM_OUTLINE(new String(Character.toChars(0xF0ACA))),
        HIGH_DEFINITION(new String(Character.toChars(0xF07CF))),
        HIGH_DEFINITION_BOX(new String(Character.toChars(0xF0878))),
        HIGHWAY(new String(Character.toChars(0xF05F7))),
        HIKING(new String(Character.toChars(0xF0D7F))),
        HISTORY(new String(Character.toChars(0xF02DA))),
        HOCKEY_PUCK(new String(Character.toChars(0xF0879))),
        HOCKEY_STICKS(new String(Character.toChars(0xF087A))),
        HOLOLENS(new String(Character.toChars(0xF02DB))),
        HOME(new String(Character.toChars(0xF02DC))),
        HOME_ACCOUNT(new String(Character.toChars(0xF0826))),
        HOME_ALERT(new String(Character.toChars(0xF087B))),
        HOME_ALERT_OUTLINE(new String(Character.toChars(0xF15D0))),
        HOME_ANALYTICS(new String(Character.toChars(0xF0EBA))),
        HOME_ASSISTANT(new String(Character.toChars(0xF07D0))),
        HOME_AUTOMATION(new String(Character.toChars(0xF07D1))),
        HOME_BATTERY(new String(Character.toChars(0xF1901))),
        HOME_BATTERY_OUTLINE(new String(Character.toChars(0xF1902))),
        HOME_CIRCLE(new String(Character.toChars(0xF07D2))),
        HOME_CIRCLE_OUTLINE(new String(Character.toChars(0xF104D))),
        HOME_CITY(new String(Character.toChars(0xF0D15))),
        HOME_CITY_OUTLINE(new String(Character.toChars(0xF0D16))),
        HOME_CLOCK(new String(Character.toChars(0xF1A12))),
        HOME_CLOCK_OUTLINE(new String(Character.toChars(0xF1A13))),
        HOME_EDIT(new String(Character.toChars(0xF1159))),
        HOME_EDIT_OUTLINE(new String(Character.toChars(0xF115A))),
        HOME_EXPORT_OUTLINE(new String(Character.toChars(0xF0F9B))),
        HOME_FLOOD(new String(Character.toChars(0xF0EFA))),
        HOME_FLOOR_0(new String(Character.toChars(0xF0DD2))),
        HOME_FLOOR_1(new String(Character.toChars(0xF0D80))),
        HOME_FLOOR_2(new String(Character.toChars(0xF0D81))),
        HOME_FLOOR_3(new String(Character.toChars(0xF0D82))),
        HOME_FLOOR_A(new String(Character.toChars(0xF0D83))),
        HOME_FLOOR_B(new String(Character.toChars(0xF0D84))),
        HOME_FLOOR_G(new String(Character.toChars(0xF0D85))),
        HOME_FLOOR_L(new String(Character.toChars(0xF0D86))),
        HOME_FLOOR_NEGATIVE_1(new String(Character.toChars(0xF0DD3))),
        HOME_GROUP(new String(Character.toChars(0xF0DD4))),
        HOME_GROUP_MINUS(new String(Character.toChars(0xF19C1))),
        HOME_GROUP_PLUS(new String(Character.toChars(0xF19C0))),
        HOME_GROUP_REMOVE(new String(Character.toChars(0xF19C2))),
        HOME_HEART(new String(Character.toChars(0xF0827))),
        HOME_IMPORT_OUTLINE(new String(Character.toChars(0xF0F9C))),
        HOME_LIGHTBULB(new String(Character.toChars(0xF1251))),
        HOME_LIGHTBULB_OUTLINE(new String(Character.toChars(0xF1252))),
        HOME_LIGHTNING_BOLT(new String(Character.toChars(0xF1903))),
        HOME_LIGHTNING_BOLT_OUTLINE(new String(Character.toChars(0xF1904))),
        HOME_LOCK(new String(Character.toChars(0xF08EB))),
        HOME_LOCK_OPEN(new String(Character.toChars(0xF08EC))),
        HOME_MAP_MARKER(new String(Character.toChars(0xF05F8))),
        HOME_MINUS(new String(Character.toChars(0xF0974))),
        HOME_MINUS_OUTLINE(new String(Character.toChars(0xF13D5))),
        HOME_MODERN(new String(Character.toChars(0xF02DD))),
        HOME_OFF(new String(Character.toChars(0xF1A46))),
        HOME_OFF_OUTLINE(new String(Character.toChars(0xF1A47))),
        HOME_OUTLINE(new String(Character.toChars(0xF06A1))),
        HOME_PERCENT(new String(Character.toChars(0xF1C7C))),
        HOME_PERCENT_OUTLINE(new String(Character.toChars(0xF1C7D))),
        HOME_PLUS(new String(Character.toChars(0xF0975))),
        HOME_PLUS_OUTLINE(new String(Character.toChars(0xF13D6))),
        HOME_REMOVE(new String(Character.toChars(0xF1247))),
        HOME_REMOVE_OUTLINE(new String(Character.toChars(0xF13D7))),
        HOME_ROOF(new String(Character.toChars(0xF112B))),
        HOME_SEARCH(new String(Character.toChars(0xF13B0))),
        HOME_SEARCH_OUTLINE(new String(Character.toChars(0xF13B1))),
        HOME_SILO(new String(Character.toChars(0xF1BA0))),
        HOME_SILO_OUTLINE(new String(Character.toChars(0xF1BA1))),
        HOME_SOUND_IN(new String(Character.toChars(0xF1C2F))),
        HOME_SOUND_IN_OUTLINE(new String(Character.toChars(0xF1C30))),
        HOME_SOUND_OUT(new String(Character.toChars(0xF1C31))),
        HOME_SOUND_OUT_OUTLINE(new String(Character.toChars(0xF1C32))),
        HOME_SWITCH(new String(Character.toChars(0xF1794))),
        HOME_SWITCH_OUTLINE(new String(Character.toChars(0xF1795))),
        HOME_THERMOMETER(new String(Character.toChars(0xF0F54))),
        HOME_THERMOMETER_OUTLINE(new String(Character.toChars(0xF0F55))),
        HOME_VARIANT(new String(Character.toChars(0xF02DE))),
        HOME_VARIANT_OUTLINE(new String(Character.toChars(0xF0BA7))),
        HOOK(new String(Character.toChars(0xF06E2))),
        HOOK_OFF(new String(Character.toChars(0xF06E3))),
        HOOP_HOUSE(new String(Character.toChars(0xF0E56))),
        HOPS(new String(Character.toChars(0xF02DF))),
        HORIZONTAL_ROTATE_CLOCKWISE(new String(Character.toChars(0xF10F3))),
        HORIZONTAL_ROTATE_COUNTERCLOCKWISE(new String(Character.toChars(0xF10F4))),
        HORSE(new String(Character.toChars(0xF15BF))),
        HORSE_HUMAN(new String(Character.toChars(0xF15C0))),
        HORSE_VARIANT(new String(Character.toChars(0xF15C1))),
        HORSE_VARIANT_FAST(new String(Character.toChars(0xF186E))),
        HORSESHOE(new String(Character.toChars(0xF0A58))),
        HOSPITAL(new String(Character.toChars(0xF0FF6))),
        HOSPITAL_BOX(new String(Character.toChars(0xF02E0))),
        HOSPITAL_BOX_OUTLINE(new String(Character.toChars(0xF0FF7))),
        HOSPITAL_BUILDING(new String(Character.toChars(0xF02E1))),
        HOSPITAL_MARKER(new String(Character.toChars(0xF02E2))),
        HOT_TUB(new String(Character.toChars(0xF0828))),
        HOURS_24(new String(Character.toChars(0xF1478))),
        HUBSPOT(new String(Character.toChars(0xF0D17))),
        HULU(new String(Character.toChars(0xF0829))),
        HUMAN(new String(Character.toChars(0xF02E6))),
        HUMAN_BABY_CHANGING_TABLE(new String(Character.toChars(0xF138B))),
        HUMAN_CANE(new String(Character.toChars(0xF1581))),
        HUMAN_CAPACITY_DECREASE(new String(Character.toChars(0xF159B))),
        HUMAN_CAPACITY_INCREASE(new String(Character.toChars(0xF159C))),
        HUMAN_CHILD(new String(Character.toChars(0xF02E7))),
        HUMAN_DOLLY(new String(Character.toChars(0xF1980))),
        HUMAN_EDIT(new String(Character.toChars(0xF14E8))),
        HUMAN_FEMALE(new String(Character.toChars(0xF0649))),
        HUMAN_FEMALE_BOY(new String(Character.toChars(0xF0A59))),
        HUMAN_FEMALE_DANCE(new String(Character.toChars(0xF15C9))),
        HUMAN_FEMALE_FEMALE(new String(Character.toChars(0xF0A5A))),
        HUMAN_FEMALE_GIRL(new String(Character.toChars(0xF0A5B))),
        HUMAN_GREETING(new String(Character.toChars(0xF17C4))),
        HUMAN_GREETING_PROXIMITY(new String(Character.toChars(0xF159D))),
        HUMAN_GREETING_VARIANT(new String(Character.toChars(0xF064A))),
        HUMAN_HANDSDOWN(new String(Character.toChars(0xF064B))),
        HUMAN_HANDSUP(new String(Character.toChars(0xF064C))),
        HUMAN_MALE(new String(Character.toChars(0xF064D))),
        HUMAN_MALE_BOARD(new String(Character.toChars(0xF0890))),
        HUMAN_MALE_BOARD_POLL(new String(Character.toChars(0xF0846))),
        HUMAN_MALE_BOY(new String(Character.toChars(0xF0A5C))),
        HUMAN_MALE_CHILD(new String(Character.toChars(0xF138C))),
        HUMAN_MALE_FEMALE(new String(Character.toChars(0xF02E8))),
        HUMAN_MALE_FEMALE_CHILD(new String(Character.toChars(0xF1823))),
        HUMAN_MALE_GIRL(new String(Character.toChars(0xF0A5D))),
        HUMAN_MALE_HEIGHT(new String(Character.toChars(0xF0EFB))),
        HUMAN_MALE_HEIGHT_VARIANT(new String(Character.toChars(0xF0EFC))),
        HUMAN_MALE_MALE(new String(Character.toChars(0xF0A5E))),
        HUMAN_NON_BINARY(new String(Character.toChars(0xF1848))),
        HUMAN_PREGNANT(new String(Character.toChars(0xF05CF))),
        HUMAN_QUEUE(new String(Character.toChars(0xF1571))),
        HUMAN_SCOOTER(new String(Character.toChars(0xF11E9))),
        HUMAN_WALKER(new String(Character.toChars(0xF1B71))),
        HUMAN_WHEELCHAIR(new String(Character.toChars(0xF138D))),
        HUMAN_WHITE_CANE(new String(Character.toChars(0xF1981))),
        HUMBLE_BUNDLE(new String(Character.toChars(0xF0744))),
        HVAC(new String(Character.toChars(0xF1352))),
        HVAC_OFF(new String(Character.toChars(0xF159E))),
        HYDRAULIC_OIL_LEVEL(new String(Character.toChars(0xF1324))),
        HYDRAULIC_OIL_TEMPERATURE(new String(Character.toChars(0xF1325))),
        HYDRO_POWER(new String(Character.toChars(0xF12E5))),
        HYDROGEN_STATION(new String(Character.toChars(0xF1894)));

        private final String unicode;

        H(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public H getDefaultGlyph()
        {
            return H.HAIL;
        }
    }

    public enum I implements MaterialDesignIconGlyphs<I> {

        ICE_CREAM(new String(Character.toChars(0xF082A))),
        ICE_CREAM_OFF(new String(Character.toChars(0xF0E52))),
        ICE_POP(new String(Character.toChars(0xF0EFD))),
        ID_CARD(new String(Character.toChars(0xF0FC0))),
        IDENTIFIER(new String(Character.toChars(0xF0EFE))),
        IDEOGRAM_CJK(new String(Character.toChars(0xF1331))),
        IDEOGRAM_CJK_VARIANT(new String(Character.toChars(0xF1332))),
        IMAGE(new String(Character.toChars(0xF02E9))),
        IMAGE_ALBUM(new String(Character.toChars(0xF02EA))),
        IMAGE_AREA(new String(Character.toChars(0xF02EB))),
        IMAGE_AREA_CLOSE(new String(Character.toChars(0xF02EC))),
        IMAGE_AUTO_ADJUST(new String(Character.toChars(0xF0FC1))),
        IMAGE_BROKEN(new String(Character.toChars(0xF02ED))),
        IMAGE_BROKEN_VARIANT(new String(Character.toChars(0xF02EE))),
        IMAGE_CHECK(new String(Character.toChars(0xF1B25))),
        IMAGE_CHECK_OUTLINE(new String(Character.toChars(0xF1B26))),
        IMAGE_EDIT(new String(Character.toChars(0xF11E3))),
        IMAGE_EDIT_OUTLINE(new String(Character.toChars(0xF11E4))),
        IMAGE_FILTER_BLACK_WHITE(new String(Character.toChars(0xF02F0))),
        IMAGE_FILTER_CENTER_FOCUS(new String(Character.toChars(0xF02F1))),
        IMAGE_FILTER_CENTER_FOCUS_STRONG(new String(Character.toChars(0xF0EFF))),
        IMAGE_FILTER_CENTER_FOCUS_STRONG_OUTLINE(new String(Character.toChars(0xF0F00))),
        IMAGE_FILTER_CENTER_FOCUS_WEAK(new String(Character.toChars(0xF02F2))),
        IMAGE_FILTER_DRAMA(new String(Character.toChars(0xF02F3))),
        IMAGE_FILTER_DRAMA_OUTLINE(new String(Character.toChars(0xF1BFF))),
        IMAGE_FILTER_FRAMES(new String(Character.toChars(0xF02F4))),
        IMAGE_FILTER_HDR(new String(Character.toChars(0xF02F5))),
        IMAGE_FILTER_HDR_OUTLINE(new String(Character.toChars(0xF1C64))),
        IMAGE_FILTER_NONE(new String(Character.toChars(0xF02F6))),
        IMAGE_FILTER_TILT_SHIFT(new String(Character.toChars(0xF02F7))),
        IMAGE_FILTER_VINTAGE(new String(Character.toChars(0xF02F8))),
        IMAGE_FRAME(new String(Character.toChars(0xF0E49))),
        IMAGE_LOCK(new String(Character.toChars(0xF1AB0))),
        IMAGE_LOCK_OUTLINE(new String(Character.toChars(0xF1AB1))),
        IMAGE_MARKER(new String(Character.toChars(0xF177B))),
        IMAGE_MARKER_OUTLINE(new String(Character.toChars(0xF177C))),
        IMAGE_MINUS(new String(Character.toChars(0xF1419))),
        IMAGE_MINUS_OUTLINE(new String(Character.toChars(0xF1B47))),
        IMAGE_MOVE(new String(Character.toChars(0xF09F8))),
        IMAGE_MULTIPLE(new String(Character.toChars(0xF02F9))),
        IMAGE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF02EF))),
        IMAGE_OFF(new String(Character.toChars(0xF082B))),
        IMAGE_OFF_OUTLINE(new String(Character.toChars(0xF11D1))),
        IMAGE_OUTLINE(new String(Character.toChars(0xF0976))),
        IMAGE_PLUS(new String(Character.toChars(0xF087C))),
        IMAGE_PLUS_OUTLINE(new String(Character.toChars(0xF1B46))),
        IMAGE_REFRESH(new String(Character.toChars(0xF19FE))),
        IMAGE_REFRESH_OUTLINE(new String(Character.toChars(0xF19FF))),
        IMAGE_REMOVE(new String(Character.toChars(0xF1418))),
        IMAGE_REMOVE_OUTLINE(new String(Character.toChars(0xF1B48))),
        IMAGE_SEARCH(new String(Character.toChars(0xF0977))),
        IMAGE_SEARCH_OUTLINE(new String(Character.toChars(0xF0978))),
        IMAGE_SIZE_SELECT_ACTUAL(new String(Character.toChars(0xF0C8D))),
        IMAGE_SIZE_SELECT_LARGE(new String(Character.toChars(0xF0C8E))),
        IMAGE_SIZE_SELECT_SMALL(new String(Character.toChars(0xF0C8F))),
        IMAGE_SYNC(new String(Character.toChars(0xF1A00))),
        IMAGE_SYNC_OUTLINE(new String(Character.toChars(0xF1A01))),
        IMAGE_TEXT(new String(Character.toChars(0xF160D))),
        IMPORT(new String(Character.toChars(0xF02FA))),
        INBOX(new String(Character.toChars(0xF0687))),
        INBOX_ARROW_DOWN(new String(Character.toChars(0xF02FB))),
        INBOX_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF1270))),
        INBOX_ARROW_UP(new String(Character.toChars(0xF03D1))),
        INBOX_ARROW_UP_OUTLINE(new String(Character.toChars(0xF1271))),
        INBOX_FULL(new String(Character.toChars(0xF1272))),
        INBOX_FULL_OUTLINE(new String(Character.toChars(0xF1273))),
        INBOX_MULTIPLE(new String(Character.toChars(0xF08B0))),
        INBOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0BA8))),
        INBOX_OUTLINE(new String(Character.toChars(0xF1274))),
        INBOX_REMOVE(new String(Character.toChars(0xF159F))),
        INBOX_REMOVE_OUTLINE(new String(Character.toChars(0xF15A0))),
        INCOGNITO(new String(Character.toChars(0xF05F9))),
        INCOGNITO_CIRCLE(new String(Character.toChars(0xF1421))),
        INCOGNITO_CIRCLE_OFF(new String(Character.toChars(0xF1422))),
        INCOGNITO_OFF(new String(Character.toChars(0xF0075))),
        INDUCTION(new String(Character.toChars(0xF184C))),
        INFINITY(new String(Character.toChars(0xF06E4))),
        INFORMATION(new String(Character.toChars(0xF02FC))),
        INFORMATION_BOX(new String(Character.toChars(0xF1C65))),
        INFORMATION_BOX_OUTLINE(new String(Character.toChars(0xF1C66))),
        INFORMATION_OFF(new String(Character.toChars(0xF178C))),
        INFORMATION_OFF_OUTLINE(new String(Character.toChars(0xF178D))),
        INFORMATION_OUTLINE(new String(Character.toChars(0xF02FD))),
        INFORMATION_SLAB_BOX(new String(Character.toChars(0xF1C67))),
        INFORMATION_SLAB_BOX_OUTLINE(new String(Character.toChars(0xF1C68))),
        INFORMATION_SLAB_CIRCLE(new String(Character.toChars(0xF1C69))),
        INFORMATION_SLAB_CIRCLE_OUTLINE(new String(Character.toChars(0xF1C6A))),
        INFORMATION_SLAB_SYMBOL(new String(Character.toChars(0xF1C6B))),
        INFORMATION_SYMBOL(new String(Character.toChars(0xF1C6C))),
        INFORMATION_VARIANT(new String(Character.toChars(0xF064E))),
        INFORMATION_VARIANT_BOX(new String(Character.toChars(0xF1C6D))),
        INFORMATION_VARIANT_BOX_OUTLINE(new String(Character.toChars(0xF1C6E))),
        INFORMATION_VARIANT_CIRCLE(new String(Character.toChars(0xF1C6F))),
        INFORMATION_VARIANT_CIRCLE_OUTLINE(new String(Character.toChars(0xF1C70))),
        INSTAGRAM(new String(Character.toChars(0xF02FE))),
        INSTRUMENT_TRIANGLE(new String(Character.toChars(0xF104E))),
        INTEGRATED_CIRCUIT_CHIP(new String(Character.toChars(0xF1913))),
        INVERT_COLORS(new String(Character.toChars(0xF0301))),
        INVERT_COLORS_OFF(new String(Character.toChars(0xF0E4A))),
        IOBROKER(new String(Character.toChars(0xF12E8))),
        IP(new String(Character.toChars(0xF0A5F))),
        IP_NETWORK(new String(Character.toChars(0xF0A60))),
        IP_NETWORK_OUTLINE(new String(Character.toChars(0xF0C90))),
        IP_OUTLINE(new String(Character.toChars(0xF1982))),
        IPOD(new String(Character.toChars(0xF0C91))),
        IRON(new String(Character.toChars(0xF1824))),
        IRON_BOARD(new String(Character.toChars(0xF1838))),
        IRON_OUTLINE(new String(Character.toChars(0xF1825))),
        ISLAND(new String(Character.toChars(0xF104F))),
        IV_BAG(new String(Character.toChars(0xF10B9)));

        private final String unicode;

        I(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public I getDefaultGlyph()
        {
            return I.ICE_CREAM;
        }
    }

    public enum J implements MaterialDesignIconGlyphs<J> {

        JABBER(new String(Character.toChars(0xF0DD5))),
        JEEPNEY(new String(Character.toChars(0xF0302))),
        JELLYFISH(new String(Character.toChars(0xF0F01))),
        JELLYFISH_OUTLINE(new String(Character.toChars(0xF0F02))),
        JIRA(new String(Character.toChars(0xF0303))),
        JQUERY(new String(Character.toChars(0xF087D))),
        JSFIDDLE(new String(Character.toChars(0xF0304))),
        JUMP_ROPE(new String(Character.toChars(0xF12FF)));

        private final String unicode;

        J(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public J getDefaultGlyph()
        {
            return J.JABBER;
        }
    }

    public enum K implements MaterialDesignIconGlyphs<K> {

        KABADDI(new String(Character.toChars(0xF0D87))),
        KANGAROO(new String(Character.toChars(0xF1558))),
        KARATE(new String(Character.toChars(0xF082C))),
        KAYAKING(new String(Character.toChars(0xF08AF))),
        KEG(new String(Character.toChars(0xF0305))),
        KETTLE(new String(Character.toChars(0xF05FA))),
        KETTLE_ALERT(new String(Character.toChars(0xF1317))),
        KETTLE_ALERT_OUTLINE(new String(Character.toChars(0xF1318))),
        KETTLE_OFF(new String(Character.toChars(0xF131B))),
        KETTLE_OFF_OUTLINE(new String(Character.toChars(0xF131C))),
        KETTLE_OUTLINE(new String(Character.toChars(0xF0F56))),
        KETTLE_POUR_OVER(new String(Character.toChars(0xF173C))),
        KETTLE_STEAM(new String(Character.toChars(0xF1319))),
        KETTLE_STEAM_OUTLINE(new String(Character.toChars(0xF131A))),
        KETTLEBELL(new String(Character.toChars(0xF1300))),
        KEY(new String(Character.toChars(0xF0306))),
        KEY_ALERT(new String(Character.toChars(0xF1983))),
        KEY_ALERT_OUTLINE(new String(Character.toChars(0xF1984))),
        KEY_ARROW_RIGHT(new String(Character.toChars(0xF1312))),
        KEY_CHAIN(new String(Character.toChars(0xF1574))),
        KEY_CHAIN_VARIANT(new String(Character.toChars(0xF1575))),
        KEY_CHANGE(new String(Character.toChars(0xF0307))),
        KEY_LINK(new String(Character.toChars(0xF119F))),
        KEY_MINUS(new String(Character.toChars(0xF0308))),
        KEY_OUTLINE(new String(Character.toChars(0xF0DD6))),
        KEY_PLUS(new String(Character.toChars(0xF0309))),
        KEY_REMOVE(new String(Character.toChars(0xF030A))),
        KEY_STAR(new String(Character.toChars(0xF119E))),
        KEY_VARIANT(new String(Character.toChars(0xF030B))),
        KEY_WIRELESS(new String(Character.toChars(0xF0FC2))),
        KEYBOARD(new String(Character.toChars(0xF030C))),
        KEYBOARD_BACKSPACE(new String(Character.toChars(0xF030D))),
        KEYBOARD_CAPS(new String(Character.toChars(0xF030E))),
        KEYBOARD_CLOSE(new String(Character.toChars(0xF030F))),
        KEYBOARD_CLOSE_OUTLINE(new String(Character.toChars(0xF1C00))),
        KEYBOARD_ESC(new String(Character.toChars(0xF12B7))),
        KEYBOARD_F1(new String(Character.toChars(0xF12AB))),
        KEYBOARD_F10(new String(Character.toChars(0xF12B4))),
        KEYBOARD_F11(new String(Character.toChars(0xF12B5))),
        KEYBOARD_F12(new String(Character.toChars(0xF12B6))),
        KEYBOARD_F2(new String(Character.toChars(0xF12AC))),
        KEYBOARD_F3(new String(Character.toChars(0xF12AD))),
        KEYBOARD_F4(new String(Character.toChars(0xF12AE))),
        KEYBOARD_F5(new String(Character.toChars(0xF12AF))),
        KEYBOARD_F6(new String(Character.toChars(0xF12B0))),
        KEYBOARD_F7(new String(Character.toChars(0xF12B1))),
        KEYBOARD_F8(new String(Character.toChars(0xF12B2))),
        KEYBOARD_F9(new String(Character.toChars(0xF12B3))),
        KEYBOARD_OFF(new String(Character.toChars(0xF0310))),
        KEYBOARD_OFF_OUTLINE(new String(Character.toChars(0xF0E4B))),
        KEYBOARD_OUTLINE(new String(Character.toChars(0xF097B))),
        KEYBOARD_RETURN(new String(Character.toChars(0xF0311))),
        KEYBOARD_SETTINGS(new String(Character.toChars(0xF09F9))),
        KEYBOARD_SETTINGS_OUTLINE(new String(Character.toChars(0xF09FA))),
        KEYBOARD_SPACE(new String(Character.toChars(0xF1050))),
        KEYBOARD_TAB(new String(Character.toChars(0xF0312))),
        KEYBOARD_TAB_REVERSE(new String(Character.toChars(0xF0325))),
        KEYBOARD_VARIANT(new String(Character.toChars(0xF0313))),
        KHANDA(new String(Character.toChars(0xF10FD))),
        KICKSTARTER(new String(Character.toChars(0xF0745))),
        KITE(new String(Character.toChars(0xF1985))),
        KITE_OUTLINE(new String(Character.toChars(0xF1986))),
        KITESURFING(new String(Character.toChars(0xF1744))),
        KLINGON(new String(Character.toChars(0xF135B))),
        KNIFE(new String(Character.toChars(0xF09FB))),
        KNIFE_MILITARY(new String(Character.toChars(0xF09FC))),
        KNOB(new String(Character.toChars(0xF1B96))),
        KOALA(new String(Character.toChars(0xF173F))),
        KODI(new String(Character.toChars(0xF0314))),
        KUBERNETES(new String(Character.toChars(0xF10FE)));

        private final String unicode;

        K(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public K getDefaultGlyph()
        {
            return K.KABADDI;
        }
    }

    public enum L implements MaterialDesignIconGlyphs<L> {

        LABEL(new String(Character.toChars(0xF0315))),
        LABEL_MULTIPLE(new String(Character.toChars(0xF1375))),
        LABEL_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1376))),
        LABEL_OFF(new String(Character.toChars(0xF0ACB))),
        LABEL_OFF_OUTLINE(new String(Character.toChars(0xF0ACC))),
        LABEL_OUTLINE(new String(Character.toChars(0xF0316))),
        LABEL_PERCENT(new String(Character.toChars(0xF12EA))),
        LABEL_PERCENT_OUTLINE(new String(Character.toChars(0xF12EB))),
        LABEL_VARIANT(new String(Character.toChars(0xF0ACD))),
        LABEL_VARIANT_OUTLINE(new String(Character.toChars(0xF0ACE))),
        LADDER(new String(Character.toChars(0xF15A2))),
        LADYBUG(new String(Character.toChars(0xF082D))),
        LAMBDA(new String(Character.toChars(0xF0627))),
        LAMP(new String(Character.toChars(0xF06B5))),
        LAMP_OUTLINE(new String(Character.toChars(0xF17D0))),
        LAMPS(new String(Character.toChars(0xF1576))),
        LAMPS_OUTLINE(new String(Character.toChars(0xF17D1))),
        LAN(new String(Character.toChars(0xF0317))),
        LAN_CHECK(new String(Character.toChars(0xF12AA))),
        LAN_CONNECT(new String(Character.toChars(0xF0318))),
        LAN_DISCONNECT(new String(Character.toChars(0xF0319))),
        LAN_PENDING(new String(Character.toChars(0xF031A))),
        LAND_FIELDS(new String(Character.toChars(0xF1AB2))),
        LAND_PLOTS(new String(Character.toChars(0xF1AB3))),
        LAND_PLOTS_CIRCLE(new String(Character.toChars(0xF1AB4))),
        LAND_PLOTS_CIRCLE_VARIANT(new String(Character.toChars(0xF1AB5))),
        LAND_PLOTS_MARKER(new String(Character.toChars(0xF1C5D))),
        LAND_ROWS_HORIZONTAL(new String(Character.toChars(0xF1AB6))),
        LAND_ROWS_VERTICAL(new String(Character.toChars(0xF1AB7))),
        LANDSLIDE(new String(Character.toChars(0xF1A48))),
        LANDSLIDE_OUTLINE(new String(Character.toChars(0xF1A49))),
        LANGUAGE_C(new String(Character.toChars(0xF0671))),
        LANGUAGE_CPP(new String(Character.toChars(0xF0672))),
        LANGUAGE_CSHARP(new String(Character.toChars(0xF031B))),
        LANGUAGE_CSS3(new String(Character.toChars(0xF031C))),
        LANGUAGE_FORTRAN(new String(Character.toChars(0xF121A))),
        LANGUAGE_GO(new String(Character.toChars(0xF07D3))),
        LANGUAGE_HASKELL(new String(Character.toChars(0xF0C92))),
        LANGUAGE_HTML5(new String(Character.toChars(0xF031D))),
        LANGUAGE_JAVA(new String(Character.toChars(0xF0B37))),
        LANGUAGE_JAVASCRIPT(new String(Character.toChars(0xF031E))),
        LANGUAGE_KOTLIN(new String(Character.toChars(0xF1219))),
        LANGUAGE_LUA(new String(Character.toChars(0xF08B1))),
        LANGUAGE_MARKDOWN(new String(Character.toChars(0xF0354))),
        LANGUAGE_MARKDOWN_OUTLINE(new String(Character.toChars(0xF0F5B))),
        LANGUAGE_PHP(new String(Character.toChars(0xF031F))),
        LANGUAGE_PYTHON(new String(Character.toChars(0xF0320))),
        LANGUAGE_R(new String(Character.toChars(0xF07D4))),
        LANGUAGE_RUBY(new String(Character.toChars(0xF0D2D))),
        LANGUAGE_RUBY_ON_RAILS(new String(Character.toChars(0xF0ACF))),
        LANGUAGE_RUST(new String(Character.toChars(0xF1617))),
        LANGUAGE_SWIFT(new String(Character.toChars(0xF06E5))),
        LANGUAGE_TYPESCRIPT(new String(Character.toChars(0xF06E6))),
        LANGUAGE_XAML(new String(Character.toChars(0xF0673))),
        LAPTOP(new String(Character.toChars(0xF0322))),
        LAPTOP_ACCOUNT(new String(Character.toChars(0xF1A4A))),
        LAPTOP_OFF(new String(Character.toChars(0xF06E7))),
        LARAVEL(new String(Character.toChars(0xF0AD0))),
        LASER_POINTER(new String(Character.toChars(0xF1484))),
        LASSO(new String(Character.toChars(0xF0F03))),
        LASTPASS(new String(Character.toChars(0xF0446))),
        LATITUDE(new String(Character.toChars(0xF0F57))),
        LAUNCH(new String(Character.toChars(0xF0327))),
        LAVA_LAMP(new String(Character.toChars(0xF07D5))),
        LAYERS(new String(Character.toChars(0xF0328))),
        LAYERS_EDIT(new String(Character.toChars(0xF1892))),
        LAYERS_MINUS(new String(Character.toChars(0xF0E4C))),
        LAYERS_OFF(new String(Character.toChars(0xF0329))),
        LAYERS_OFF_OUTLINE(new String(Character.toChars(0xF09FD))),
        LAYERS_OUTLINE(new String(Character.toChars(0xF09FE))),
        LAYERS_PLUS(new String(Character.toChars(0xF0E4D))),
        LAYERS_REMOVE(new String(Character.toChars(0xF0E4E))),
        LAYERS_SEARCH(new String(Character.toChars(0xF1206))),
        LAYERS_SEARCH_OUTLINE(new String(Character.toChars(0xF1207))),
        LAYERS_TRIPLE(new String(Character.toChars(0xF0F58))),
        LAYERS_TRIPLE_OUTLINE(new String(Character.toChars(0xF0F59))),
        LEAD_PENCIL(new String(Character.toChars(0xF064F))),
        LEAF(new String(Character.toChars(0xF032A))),
        LEAF_CIRCLE(new String(Character.toChars(0xF1905))),
        LEAF_CIRCLE_OUTLINE(new String(Character.toChars(0xF1906))),
        LEAF_MAPLE(new String(Character.toChars(0xF0C93))),
        LEAF_MAPLE_OFF(new String(Character.toChars(0xF12DA))),
        LEAF_OFF(new String(Character.toChars(0xF12D9))),
        LEAK(new String(Character.toChars(0xF0DD7))),
        LEAK_OFF(new String(Character.toChars(0xF0DD8))),
        LECTERN(new String(Character.toChars(0xF1AF0))),
        LED_OFF(new String(Character.toChars(0xF032B))),
        LED_ON(new String(Character.toChars(0xF032C))),
        LED_OUTLINE(new String(Character.toChars(0xF032D))),
        LED_STRIP(new String(Character.toChars(0xF07D6))),
        LED_STRIP_VARIANT(new String(Character.toChars(0xF1051))),
        LED_STRIP_VARIANT_OFF(new String(Character.toChars(0xF1A4B))),
        LED_VARIANT_OFF(new String(Character.toChars(0xF032E))),
        LED_VARIANT_ON(new String(Character.toChars(0xF032F))),
        LED_VARIANT_OUTLINE(new String(Character.toChars(0xF0330))),
        LEEK(new String(Character.toChars(0xF117D))),
        LESS_THAN(new String(Character.toChars(0xF097C))),
        LESS_THAN_OR_EQUAL(new String(Character.toChars(0xF097D))),
        LIBRARY(new String(Character.toChars(0xF0331))),
        LIBRARY_OUTLINE(new String(Character.toChars(0xF1A22))),
        LIBRARY_SHELVES(new String(Character.toChars(0xF0BA9))),
        LICENSE(new String(Character.toChars(0xF0FC3))),
        LIFEBUOY(new String(Character.toChars(0xF087E))),
        LIGHT_FLOOD_DOWN(new String(Character.toChars(0xF1987))),
        LIGHT_FLOOD_UP(new String(Character.toChars(0xF1988))),
        LIGHT_RECESSED(new String(Character.toChars(0xF179B))),
        LIGHT_SWITCH(new String(Character.toChars(0xF097E))),
        LIGHT_SWITCH_OFF(new String(Character.toChars(0xF1A24))),
        LIGHTBULB(new String(Character.toChars(0xF0335))),
        LIGHTBULB_ALERT(new String(Character.toChars(0xF19E1))),
        LIGHTBULB_ALERT_OUTLINE(new String(Character.toChars(0xF19E2))),
        LIGHTBULB_AUTO(new String(Character.toChars(0xF1800))),
        LIGHTBULB_AUTO_OUTLINE(new String(Character.toChars(0xF1801))),
        LIGHTBULB_CFL(new String(Character.toChars(0xF1208))),
        LIGHTBULB_CFL_OFF(new String(Character.toChars(0xF1209))),
        LIGHTBULB_CFL_SPIRAL(new String(Character.toChars(0xF1275))),
        LIGHTBULB_CFL_SPIRAL_OFF(new String(Character.toChars(0xF12C3))),
        LIGHTBULB_FLUORESCENT_TUBE(new String(Character.toChars(0xF1804))),
        LIGHTBULB_FLUORESCENT_TUBE_OUTLINE(new String(Character.toChars(0xF1805))),
        LIGHTBULB_GROUP(new String(Character.toChars(0xF1253))),
        LIGHTBULB_GROUP_OFF(new String(Character.toChars(0xF12CD))),
        LIGHTBULB_GROUP_OFF_OUTLINE(new String(Character.toChars(0xF12CE))),
        LIGHTBULB_GROUP_OUTLINE(new String(Character.toChars(0xF1254))),
        LIGHTBULB_MULTIPLE(new String(Character.toChars(0xF1255))),
        LIGHTBULB_MULTIPLE_OFF(new String(Character.toChars(0xF12CF))),
        LIGHTBULB_MULTIPLE_OFF_OUTLINE(new String(Character.toChars(0xF12D0))),
        LIGHTBULB_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1256))),
        LIGHTBULB_NIGHT(new String(Character.toChars(0xF1A4C))),
        LIGHTBULB_NIGHT_OUTLINE(new String(Character.toChars(0xF1A4D))),
        LIGHTBULB_OFF(new String(Character.toChars(0xF0E4F))),
        LIGHTBULB_OFF_OUTLINE(new String(Character.toChars(0xF0E50))),
        LIGHTBULB_ON(new String(Character.toChars(0xF06E8))),
        LIGHTBULB_ON_10(new String(Character.toChars(0xF1A4E))),
        LIGHTBULB_ON_20(new String(Character.toChars(0xF1A4F))),
        LIGHTBULB_ON_30(new String(Character.toChars(0xF1A50))),
        LIGHTBULB_ON_40(new String(Character.toChars(0xF1A51))),
        LIGHTBULB_ON_50(new String(Character.toChars(0xF1A52))),
        LIGHTBULB_ON_60(new String(Character.toChars(0xF1A53))),
        LIGHTBULB_ON_70(new String(Character.toChars(0xF1A54))),
        LIGHTBULB_ON_80(new String(Character.toChars(0xF1A55))),
        LIGHTBULB_ON_90(new String(Character.toChars(0xF1A56))),
        LIGHTBULB_ON_OUTLINE(new String(Character.toChars(0xF06E9))),
        LIGHTBULB_OUTLINE(new String(Character.toChars(0xF0336))),
        LIGHTBULB_QUESTION(new String(Character.toChars(0xF19E3))),
        LIGHTBULB_QUESTION_OUTLINE(new String(Character.toChars(0xF19E4))),
        LIGHTBULB_SPOT(new String(Character.toChars(0xF17F4))),
        LIGHTBULB_SPOT_OFF(new String(Character.toChars(0xF17F5))),
        LIGHTBULB_VARIANT(new String(Character.toChars(0xF1802))),
        LIGHTBULB_VARIANT_OUTLINE(new String(Character.toChars(0xF1803))),
        LIGHTHOUSE(new String(Character.toChars(0xF09FF))),
        LIGHTHOUSE_ON(new String(Character.toChars(0xF0A00))),
        LIGHTNING_BOLT(new String(Character.toChars(0xF140B))),
        LIGHTNING_BOLT_CIRCLE(new String(Character.toChars(0xF0820))),
        LIGHTNING_BOLT_OUTLINE(new String(Character.toChars(0xF140C))),
        LINE_SCAN(new String(Character.toChars(0xF0624))),
        LINGERIE(new String(Character.toChars(0xF1476))),
        LINK(new String(Character.toChars(0xF0337))),
        LINK_BOX(new String(Character.toChars(0xF0D1A))),
        LINK_BOX_OUTLINE(new String(Character.toChars(0xF0D1B))),
        LINK_BOX_VARIANT(new String(Character.toChars(0xF0D1C))),
        LINK_BOX_VARIANT_OUTLINE(new String(Character.toChars(0xF0D1D))),
        LINK_LOCK(new String(Character.toChars(0xF10BA))),
        LINK_OFF(new String(Character.toChars(0xF0338))),
        LINK_PLUS(new String(Character.toChars(0xF0C94))),
        LINK_VARIANT(new String(Character.toChars(0xF0339))),
        LINK_VARIANT_MINUS(new String(Character.toChars(0xF10FF))),
        LINK_VARIANT_OFF(new String(Character.toChars(0xF033A))),
        LINK_VARIANT_PLUS(new String(Character.toChars(0xF1100))),
        LINK_VARIANT_REMOVE(new String(Character.toChars(0xF1101))),
        LINKEDIN(new String(Character.toChars(0xF033B))),
        LINUX(new String(Character.toChars(0xF033D))),
        LINUX_MINT(new String(Character.toChars(0xF08ED))),
        LIPSTICK(new String(Character.toChars(0xF13B5))),
        LIQUID_SPOT(new String(Character.toChars(0xF1826))),
        LIQUOR(new String(Character.toChars(0xF191E))),
        LIST_BOX(new String(Character.toChars(0xF1B7B))),
        LIST_BOX_OUTLINE(new String(Character.toChars(0xF1B7C))),
        LIST_STATUS(new String(Character.toChars(0xF15AB))),
        LITECOIN(new String(Character.toChars(0xF0A61))),
        LOADING(new String(Character.toChars(0xF0772))),
        LOCATION_ENTER(new String(Character.toChars(0xF0FC4))),
        LOCATION_EXIT(new String(Character.toChars(0xF0FC5))),
        LOCK(new String(Character.toChars(0xF033E))),
        LOCK_ALERT(new String(Character.toChars(0xF08EE))),
        LOCK_ALERT_OUTLINE(new String(Character.toChars(0xF15D1))),
        LOCK_CHECK(new String(Character.toChars(0xF139A))),
        LOCK_CHECK_OUTLINE(new String(Character.toChars(0xF16A8))),
        LOCK_CLOCK(new String(Character.toChars(0xF097F))),
        LOCK_MINUS(new String(Character.toChars(0xF16A9))),
        LOCK_MINUS_OUTLINE(new String(Character.toChars(0xF16AA))),
        LOCK_OFF(new String(Character.toChars(0xF1671))),
        LOCK_OFF_OUTLINE(new String(Character.toChars(0xF1672))),
        LOCK_OPEN(new String(Character.toChars(0xF033F))),
        LOCK_OPEN_ALERT(new String(Character.toChars(0xF139B))),
        LOCK_OPEN_ALERT_OUTLINE(new String(Character.toChars(0xF15D2))),
        LOCK_OPEN_CHECK(new String(Character.toChars(0xF139C))),
        LOCK_OPEN_CHECK_OUTLINE(new String(Character.toChars(0xF16AB))),
        LOCK_OPEN_MINUS(new String(Character.toChars(0xF16AC))),
        LOCK_OPEN_MINUS_OUTLINE(new String(Character.toChars(0xF16AD))),
        LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF0340))),
        LOCK_OPEN_PLUS(new String(Character.toChars(0xF16AE))),
        LOCK_OPEN_PLUS_OUTLINE(new String(Character.toChars(0xF16AF))),
        LOCK_OPEN_REMOVE(new String(Character.toChars(0xF16B0))),
        LOCK_OPEN_REMOVE_OUTLINE(new String(Character.toChars(0xF16B1))),
        LOCK_OPEN_VARIANT(new String(Character.toChars(0xF0FC6))),
        LOCK_OPEN_VARIANT_OUTLINE(new String(Character.toChars(0xF0FC7))),
        LOCK_OUTLINE(new String(Character.toChars(0xF0341))),
        LOCK_PATTERN(new String(Character.toChars(0xF06EA))),
        LOCK_PERCENT(new String(Character.toChars(0xF1C12))),
        LOCK_PERCENT_OPEN(new String(Character.toChars(0xF1C13))),
        LOCK_PERCENT_OPEN_OUTLINE(new String(Character.toChars(0xF1C14))),
        LOCK_PERCENT_OPEN_VARIANT(new String(Character.toChars(0xF1C15))),
        LOCK_PERCENT_OPEN_VARIANT_OUTLINE(new String(Character.toChars(0xF1C16))),
        LOCK_PERCENT_OUTLINE(new String(Character.toChars(0xF1C17))),
        LOCK_PLUS(new String(Character.toChars(0xF05FB))),
        LOCK_PLUS_OUTLINE(new String(Character.toChars(0xF16B2))),
        LOCK_QUESTION(new String(Character.toChars(0xF08EF))),
        LOCK_REMOVE(new String(Character.toChars(0xF16B3))),
        LOCK_REMOVE_OUTLINE(new String(Character.toChars(0xF16B4))),
        LOCK_RESET(new String(Character.toChars(0xF0773))),
        LOCK_SMART(new String(Character.toChars(0xF08B2))),
        LOCKER(new String(Character.toChars(0xF07D7))),
        LOCKER_MULTIPLE(new String(Character.toChars(0xF07D8))),
        LOGIN(new String(Character.toChars(0xF0342))),
        LOGIN_VARIANT(new String(Character.toChars(0xF05FC))),
        LOGOUT(new String(Character.toChars(0xF0343))),
        LOGOUT_VARIANT(new String(Character.toChars(0xF05FD))),
        LONGITUDE(new String(Character.toChars(0xF0F5A))),
        LOOKS(new String(Character.toChars(0xF0344))),
        LOTION(new String(Character.toChars(0xF1582))),
        LOTION_OUTLINE(new String(Character.toChars(0xF1583))),
        LOTION_PLUS(new String(Character.toChars(0xF1584))),
        LOTION_PLUS_OUTLINE(new String(Character.toChars(0xF1585))),
        LOUPE(new String(Character.toChars(0xF0345))),
        LUMX(new String(Character.toChars(0xF0346))),
        LUNGS(new String(Character.toChars(0xF1084)));

        private final String unicode;

        L(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public L getDefaultGlyph()
        {
            return L.LABEL;
        }
    }

    public enum M implements MaterialDesignIconGlyphs<M> {

        MACE(new String(Character.toChars(0xF1843))),
        MAGAZINE_PISTOL(new String(Character.toChars(0xF0324))),
        MAGAZINE_RIFLE(new String(Character.toChars(0xF0323))),
        MAGIC_STAFF(new String(Character.toChars(0xF1844))),
        MAGNET(new String(Character.toChars(0xF0347))),
        MAGNET_ON(new String(Character.toChars(0xF0348))),
        MAGNIFY(new String(Character.toChars(0xF0349))),
        MAGNIFY_CLOSE(new String(Character.toChars(0xF0980))),
        MAGNIFY_EXPAND(new String(Character.toChars(0xF1874))),
        MAGNIFY_MINUS(new String(Character.toChars(0xF034A))),
        MAGNIFY_MINUS_CURSOR(new String(Character.toChars(0xF0A62))),
        MAGNIFY_MINUS_OUTLINE(new String(Character.toChars(0xF06EC))),
        MAGNIFY_PLUS(new String(Character.toChars(0xF034B))),
        MAGNIFY_PLUS_CURSOR(new String(Character.toChars(0xF0A63))),
        MAGNIFY_PLUS_OUTLINE(new String(Character.toChars(0xF06ED))),
        MAGNIFY_REMOVE_CURSOR(new String(Character.toChars(0xF120C))),
        MAGNIFY_REMOVE_OUTLINE(new String(Character.toChars(0xF120D))),
        MAGNIFY_SCAN(new String(Character.toChars(0xF1276))),
        MAIL(new String(Character.toChars(0xF0EBB))),
        MAILBOX(new String(Character.toChars(0xF06EE))),
        MAILBOX_OPEN(new String(Character.toChars(0xF0D88))),
        MAILBOX_OPEN_OUTLINE(new String(Character.toChars(0xF0D89))),
        MAILBOX_OPEN_UP(new String(Character.toChars(0xF0D8A))),
        MAILBOX_OPEN_UP_OUTLINE(new String(Character.toChars(0xF0D8B))),
        MAILBOX_OUTLINE(new String(Character.toChars(0xF0D8C))),
        MAILBOX_UP(new String(Character.toChars(0xF0D8D))),
        MAILBOX_UP_OUTLINE(new String(Character.toChars(0xF0D8E))),
        MANJARO(new String(Character.toChars(0xF160A))),
        MAP(new String(Character.toChars(0xF034D))),
        MAP_CHECK(new String(Character.toChars(0xF0EBC))),
        MAP_CHECK_OUTLINE(new String(Character.toChars(0xF0EBD))),
        MAP_CLOCK(new String(Character.toChars(0xF0D1E))),
        MAP_CLOCK_OUTLINE(new String(Character.toChars(0xF0D1F))),
        MAP_LEGEND(new String(Character.toChars(0xF0A01))),
        MAP_MARKER(new String(Character.toChars(0xF034E))),
        MAP_MARKER_ACCOUNT(new String(Character.toChars(0xF18E3))),
        MAP_MARKER_ACCOUNT_OUTLINE(new String(Character.toChars(0xF18E4))),
        MAP_MARKER_ALERT(new String(Character.toChars(0xF0F05))),
        MAP_MARKER_ALERT_OUTLINE(new String(Character.toChars(0xF0F06))),
        MAP_MARKER_CHECK(new String(Character.toChars(0xF0C95))),
        MAP_MARKER_CHECK_OUTLINE(new String(Character.toChars(0xF12FB))),
        MAP_MARKER_CIRCLE(new String(Character.toChars(0xF034F))),
        MAP_MARKER_DISTANCE(new String(Character.toChars(0xF08F0))),
        MAP_MARKER_DOWN(new String(Character.toChars(0xF1102))),
        MAP_MARKER_LEFT(new String(Character.toChars(0xF12DB))),
        MAP_MARKER_LEFT_OUTLINE(new String(Character.toChars(0xF12DD))),
        MAP_MARKER_MINUS(new String(Character.toChars(0xF0650))),
        MAP_MARKER_MINUS_OUTLINE(new String(Character.toChars(0xF12F9))),
        MAP_MARKER_MULTIPLE(new String(Character.toChars(0xF0350))),
        MAP_MARKER_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1277))),
        MAP_MARKER_OFF(new String(Character.toChars(0xF0351))),
        MAP_MARKER_OFF_OUTLINE(new String(Character.toChars(0xF12FD))),
        MAP_MARKER_OUTLINE(new String(Character.toChars(0xF07D9))),
        MAP_MARKER_PATH(new String(Character.toChars(0xF0D20))),
        MAP_MARKER_PLUS(new String(Character.toChars(0xF0651))),
        MAP_MARKER_PLUS_OUTLINE(new String(Character.toChars(0xF12F8))),
        MAP_MARKER_QUESTION(new String(Character.toChars(0xF0F07))),
        MAP_MARKER_QUESTION_OUTLINE(new String(Character.toChars(0xF0F08))),
        MAP_MARKER_RADIUS(new String(Character.toChars(0xF0352))),
        MAP_MARKER_RADIUS_OUTLINE(new String(Character.toChars(0xF12FC))),
        MAP_MARKER_REMOVE(new String(Character.toChars(0xF0F09))),
        MAP_MARKER_REMOVE_OUTLINE(new String(Character.toChars(0xF12FA))),
        MAP_MARKER_REMOVE_VARIANT(new String(Character.toChars(0xF0F0A))),
        MAP_MARKER_RIGHT(new String(Character.toChars(0xF12DC))),
        MAP_MARKER_RIGHT_OUTLINE(new String(Character.toChars(0xF12DE))),
        MAP_MARKER_STAR(new String(Character.toChars(0xF1608))),
        MAP_MARKER_STAR_OUTLINE(new String(Character.toChars(0xF1609))),
        MAP_MARKER_UP(new String(Character.toChars(0xF1103))),
        MAP_MINUS(new String(Character.toChars(0xF0981))),
        MAP_OUTLINE(new String(Character.toChars(0xF0982))),
        MAP_PLUS(new String(Character.toChars(0xF0983))),
        MAP_SEARCH(new String(Character.toChars(0xF0984))),
        MAP_SEARCH_OUTLINE(new String(Character.toChars(0xF0985))),
        MAPBOX(new String(Character.toChars(0xF0BAA))),
        MARGIN(new String(Character.toChars(0xF0353))),
        MARKER(new String(Character.toChars(0xF0652))),
        MARKER_CANCEL(new String(Character.toChars(0xF0DD9))),
        MARKER_CHECK(new String(Character.toChars(0xF0355))),
        MASTODON(new String(Character.toChars(0xF0AD1))),
        MATERIAL_DESIGN(new String(Character.toChars(0xF0986))),
        MATERIAL_UI(new String(Character.toChars(0xF0357))),
        MATH_COMPASS(new String(Character.toChars(0xF0358))),
        MATH_COS(new String(Character.toChars(0xF0C96))),
        MATH_INTEGRAL(new String(Character.toChars(0xF0FC8))),
        MATH_INTEGRAL_BOX(new String(Character.toChars(0xF0FC9))),
        MATH_LOG(new String(Character.toChars(0xF1085))),
        MATH_NORM(new String(Character.toChars(0xF0FCA))),
        MATH_NORM_BOX(new String(Character.toChars(0xF0FCB))),
        MATH_SIN(new String(Character.toChars(0xF0C97))),
        MATH_TAN(new String(Character.toChars(0xF0C98))),
        MATRIX(new String(Character.toChars(0xF0628))),
        MEDAL(new String(Character.toChars(0xF0987))),
        MEDAL_OUTLINE(new String(Character.toChars(0xF1326))),
        MEDICAL_BAG(new String(Character.toChars(0xF06EF))),
        MEDICAL_COTTON_SWAB(new String(Character.toChars(0xF1AB8))),
        MEDICATION(new String(Character.toChars(0xF1B14))),
        MEDICATION_OUTLINE(new String(Character.toChars(0xF1B15))),
        MEDITATION(new String(Character.toChars(0xF117B))),
        MEMORY(new String(Character.toChars(0xF035B))),
        MENORAH(new String(Character.toChars(0xF17D4))),
        MENORAH_FIRE(new String(Character.toChars(0xF17D5))),
        MENU(new String(Character.toChars(0xF035C))),
        MENU_DOWN(new String(Character.toChars(0xF035D))),
        MENU_DOWN_OUTLINE(new String(Character.toChars(0xF06B6))),
        MENU_LEFT(new String(Character.toChars(0xF035E))),
        MENU_LEFT_OUTLINE(new String(Character.toChars(0xF0A02))),
        MENU_OPEN(new String(Character.toChars(0xF0BAB))),
        MENU_RIGHT(new String(Character.toChars(0xF035F))),
        MENU_RIGHT_OUTLINE(new String(Character.toChars(0xF0A03))),
        MENU_SWAP(new String(Character.toChars(0xF0A64))),
        MENU_SWAP_OUTLINE(new String(Character.toChars(0xF0A65))),
        MENU_UP(new String(Character.toChars(0xF0360))),
        MENU_UP_OUTLINE(new String(Character.toChars(0xF06B7))),
        MERGE(new String(Character.toChars(0xF0F5C))),
        MESSAGE(new String(Character.toChars(0xF0361))),
        MESSAGE_ALERT(new String(Character.toChars(0xF0362))),
        MESSAGE_ALERT_OUTLINE(new String(Character.toChars(0xF0A04))),
        MESSAGE_ARROW_LEFT(new String(Character.toChars(0xF12F2))),
        MESSAGE_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF12F3))),
        MESSAGE_ARROW_RIGHT(new String(Character.toChars(0xF12F4))),
        MESSAGE_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF12F5))),
        MESSAGE_BADGE(new String(Character.toChars(0xF1941))),
        MESSAGE_BADGE_OUTLINE(new String(Character.toChars(0xF1942))),
        MESSAGE_BOOKMARK(new String(Character.toChars(0xF15AC))),
        MESSAGE_BOOKMARK_OUTLINE(new String(Character.toChars(0xF15AD))),
        MESSAGE_BULLETED(new String(Character.toChars(0xF06A2))),
        MESSAGE_BULLETED_OFF(new String(Character.toChars(0xF06A3))),
        MESSAGE_CHECK(new String(Character.toChars(0xF1B8A))),
        MESSAGE_CHECK_OUTLINE(new String(Character.toChars(0xF1B8B))),
        MESSAGE_COG(new String(Character.toChars(0xF06F1))),
        MESSAGE_COG_OUTLINE(new String(Character.toChars(0xF1172))),
        MESSAGE_DRAW(new String(Character.toChars(0xF0363))),
        MESSAGE_FAST(new String(Character.toChars(0xF19CC))),
        MESSAGE_FAST_OUTLINE(new String(Character.toChars(0xF19CD))),
        MESSAGE_FLASH(new String(Character.toChars(0xF15A9))),
        MESSAGE_FLASH_OUTLINE(new String(Character.toChars(0xF15AA))),
        MESSAGE_IMAGE(new String(Character.toChars(0xF0364))),
        MESSAGE_IMAGE_OUTLINE(new String(Character.toChars(0xF116C))),
        MESSAGE_LOCK(new String(Character.toChars(0xF0FCC))),
        MESSAGE_LOCK_OUTLINE(new String(Character.toChars(0xF116D))),
        MESSAGE_MINUS(new String(Character.toChars(0xF116E))),
        MESSAGE_MINUS_OUTLINE(new String(Character.toChars(0xF116F))),
        MESSAGE_OFF(new String(Character.toChars(0xF164D))),
        MESSAGE_OFF_OUTLINE(new String(Character.toChars(0xF164E))),
        MESSAGE_OUTLINE(new String(Character.toChars(0xF0365))),
        MESSAGE_PLUS(new String(Character.toChars(0xF0653))),
        MESSAGE_PLUS_OUTLINE(new String(Character.toChars(0xF10BB))),
        MESSAGE_PROCESSING(new String(Character.toChars(0xF0366))),
        MESSAGE_PROCESSING_OUTLINE(new String(Character.toChars(0xF1170))),
        MESSAGE_QUESTION(new String(Character.toChars(0xF173A))),
        MESSAGE_QUESTION_OUTLINE(new String(Character.toChars(0xF173B))),
        MESSAGE_REPLY(new String(Character.toChars(0xF0367))),
        MESSAGE_REPLY_OUTLINE(new String(Character.toChars(0xF173D))),
        MESSAGE_REPLY_TEXT(new String(Character.toChars(0xF0368))),
        MESSAGE_REPLY_TEXT_OUTLINE(new String(Character.toChars(0xF173E))),
        MESSAGE_SETTINGS(new String(Character.toChars(0xF06F0))),
        MESSAGE_SETTINGS_OUTLINE(new String(Character.toChars(0xF1171))),
        MESSAGE_STAR(new String(Character.toChars(0xF069A))),
        MESSAGE_STAR_OUTLINE(new String(Character.toChars(0xF1250))),
        MESSAGE_TEXT(new String(Character.toChars(0xF0369))),
        MESSAGE_TEXT_CLOCK(new String(Character.toChars(0xF1173))),
        MESSAGE_TEXT_CLOCK_OUTLINE(new String(Character.toChars(0xF1174))),
        MESSAGE_TEXT_FAST(new String(Character.toChars(0xF19CE))),
        MESSAGE_TEXT_FAST_OUTLINE(new String(Character.toChars(0xF19CF))),
        MESSAGE_TEXT_LOCK(new String(Character.toChars(0xF0FCD))),
        MESSAGE_TEXT_LOCK_OUTLINE(new String(Character.toChars(0xF1175))),
        MESSAGE_TEXT_OUTLINE(new String(Character.toChars(0xF036A))),
        MESSAGE_VIDEO(new String(Character.toChars(0xF036B))),
        METEOR(new String(Character.toChars(0xF0629))),
        METER_ELECTRIC(new String(Character.toChars(0xF1A57))),
        METER_ELECTRIC_OUTLINE(new String(Character.toChars(0xF1A58))),
        METER_GAS(new String(Character.toChars(0xF1A59))),
        METER_GAS_OUTLINE(new String(Character.toChars(0xF1A5A))),
        METRONOME(new String(Character.toChars(0xF07DA))),
        METRONOME_TICK(new String(Character.toChars(0xF07DB))),
        MICRO_SD(new String(Character.toChars(0xF07DC))),
        MICROPHONE(new String(Character.toChars(0xF036C))),
        MICROPHONE_MESSAGE(new String(Character.toChars(0xF050A))),
        MICROPHONE_MESSAGE_OFF(new String(Character.toChars(0xF050B))),
        MICROPHONE_MINUS(new String(Character.toChars(0xF08B3))),
        MICROPHONE_OFF(new String(Character.toChars(0xF036D))),
        MICROPHONE_OUTLINE(new String(Character.toChars(0xF036E))),
        MICROPHONE_PLUS(new String(Character.toChars(0xF08B4))),
        MICROPHONE_QUESTION(new String(Character.toChars(0xF1989))),
        MICROPHONE_QUESTION_OUTLINE(new String(Character.toChars(0xF198A))),
        MICROPHONE_SETTINGS(new String(Character.toChars(0xF036F))),
        MICROPHONE_VARIANT(new String(Character.toChars(0xF0370))),
        MICROPHONE_VARIANT_OFF(new String(Character.toChars(0xF0371))),
        MICROSCOPE(new String(Character.toChars(0xF0654))),
        MICROSOFT(new String(Character.toChars(0xF0372))),
        MICROSOFT_ACCESS(new String(Character.toChars(0xF138E))),
        MICROSOFT_AZURE(new String(Character.toChars(0xF0805))),
        MICROSOFT_AZURE_DEVOPS(new String(Character.toChars(0xF0FD5))),
        MICROSOFT_BING(new String(Character.toChars(0xF00A4))),
        MICROSOFT_DYNAMICS_365(new String(Character.toChars(0xF0988))),
        MICROSOFT_EDGE(new String(Character.toChars(0xF01E9))),
        MICROSOFT_EXCEL(new String(Character.toChars(0xF138F))),
        MICROSOFT_INTERNET_EXPLORER(new String(Character.toChars(0xF0300))),
        MICROSOFT_OFFICE(new String(Character.toChars(0xF03C6))),
        MICROSOFT_ONEDRIVE(new String(Character.toChars(0xF03CA))),
        MICROSOFT_ONENOTE(new String(Character.toChars(0xF0747))),
        MICROSOFT_OUTLOOK(new String(Character.toChars(0xF0D22))),
        MICROSOFT_POWERPOINT(new String(Character.toChars(0xF1390))),
        MICROSOFT_SHAREPOINT(new String(Character.toChars(0xF1391))),
        MICROSOFT_TEAMS(new String(Character.toChars(0xF02BB))),
        MICROSOFT_VISUAL_STUDIO(new String(Character.toChars(0xF0610))),
        MICROSOFT_VISUAL_STUDIO_CODE(new String(Character.toChars(0xF0A1E))),
        MICROSOFT_WINDOWS(new String(Character.toChars(0xF05B3))),
        MICROSOFT_WINDOWS_CLASSIC(new String(Character.toChars(0xF0A21))),
        MICROSOFT_WORD(new String(Character.toChars(0xF1392))),
        MICROSOFT_XBOX(new String(Character.toChars(0xF05B9))),
        MICROSOFT_XBOX_CONTROLLER(new String(Character.toChars(0xF05BA))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_ALERT(new String(Character.toChars(0xF074B))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_CHARGING(new String(Character.toChars(0xF0A22))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_EMPTY(new String(Character.toChars(0xF074C))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_FULL(new String(Character.toChars(0xF074D))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_LOW(new String(Character.toChars(0xF074E))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_MEDIUM(new String(Character.toChars(0xF074F))),
        MICROSOFT_XBOX_CONTROLLER_BATTERY_UNKNOWN(new String(Character.toChars(0xF0750))),
        MICROSOFT_XBOX_CONTROLLER_MENU(new String(Character.toChars(0xF0E6F))),
        MICROSOFT_XBOX_CONTROLLER_OFF(new String(Character.toChars(0xF05BB))),
        MICROSOFT_XBOX_CONTROLLER_VIEW(new String(Character.toChars(0xF0E70))),
        MICROWAVE(new String(Character.toChars(0xF0C99))),
        MICROWAVE_OFF(new String(Character.toChars(0xF1423))),
        MIDDLEWARE(new String(Character.toChars(0xF0F5D))),
        MIDDLEWARE_OUTLINE(new String(Character.toChars(0xF0F5E))),
        MIDI(new String(Character.toChars(0xF08F1))),
        MIDI_PORT(new String(Character.toChars(0xF08F2))),
        MINE(new String(Character.toChars(0xF0DDA))),
        MINECRAFT(new String(Character.toChars(0xF0373))),
        MINI_SD(new String(Character.toChars(0xF0A05))),
        MINIDISC(new String(Character.toChars(0xF0A06))),
        MINUS(new String(Character.toChars(0xF0374))),
        MINUS_BOX(new String(Character.toChars(0xF0375))),
        MINUS_BOX_MULTIPLE(new String(Character.toChars(0xF1141))),
        MINUS_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1142))),
        MINUS_BOX_OUTLINE(new String(Character.toChars(0xF06F2))),
        MINUS_CIRCLE(new String(Character.toChars(0xF0376))),
        MINUS_CIRCLE_MULTIPLE(new String(Character.toChars(0xF035A))),
        MINUS_CIRCLE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0AD3))),
        MINUS_CIRCLE_OFF(new String(Character.toChars(0xF1459))),
        MINUS_CIRCLE_OFF_OUTLINE(new String(Character.toChars(0xF145A))),
        MINUS_CIRCLE_OUTLINE(new String(Character.toChars(0xF0377))),
        MINUS_NETWORK(new String(Character.toChars(0xF0378))),
        MINUS_NETWORK_OUTLINE(new String(Character.toChars(0xF0C9A))),
        MINUS_THICK(new String(Character.toChars(0xF1639))),
        MIRROR(new String(Character.toChars(0xF11FD))),
        MIRROR_RECTANGLE(new String(Character.toChars(0xF179F))),
        MIRROR_VARIANT(new String(Character.toChars(0xF17A0))),
        MIXED_MARTIAL_ARTS(new String(Character.toChars(0xF0D8F))),
        MIXED_REALITY(new String(Character.toChars(0xF087F))),
        MOLECULE(new String(Character.toChars(0xF0BAC))),
        MOLECULE_CO(new String(Character.toChars(0xF12FE))),
        MOLECULE_CO2(new String(Character.toChars(0xF07E4))),
        MONITOR(new String(Character.toChars(0xF0379))),
        MONITOR_ACCOUNT(new String(Character.toChars(0xF1A5B))),
        MONITOR_ARROW_DOWN(new String(Character.toChars(0xF19D0))),
        MONITOR_ARROW_DOWN_VARIANT(new String(Character.toChars(0xF19D1))),
        MONITOR_CELLPHONE(new String(Character.toChars(0xF0989))),
        MONITOR_CELLPHONE_STAR(new String(Character.toChars(0xF098A))),
        MONITOR_DASHBOARD(new String(Character.toChars(0xF0A07))),
        MONITOR_EDIT(new String(Character.toChars(0xF12C6))),
        MONITOR_EYE(new String(Character.toChars(0xF13B4))),
        MONITOR_LOCK(new String(Character.toChars(0xF0DDB))),
        MONITOR_MULTIPLE(new String(Character.toChars(0xF037A))),
        MONITOR_OFF(new String(Character.toChars(0xF0D90))),
        MONITOR_SCREENSHOT(new String(Character.toChars(0xF0E51))),
        MONITOR_SHARE(new String(Character.toChars(0xF1483))),
        MONITOR_SHIMMER(new String(Character.toChars(0xF1104))),
        MONITOR_SMALL(new String(Character.toChars(0xF1876))),
        MONITOR_SPEAKER(new String(Character.toChars(0xF0F5F))),
        MONITOR_SPEAKER_OFF(new String(Character.toChars(0xF0F60))),
        MONITOR_STAR(new String(Character.toChars(0xF0DDC))),
        MONITOR_VERTICAL(new String(Character.toChars(0xF1C33))),
        MOON_FIRST_QUARTER(new String(Character.toChars(0xF0F61))),
        MOON_FULL(new String(Character.toChars(0xF0F62))),
        MOON_LAST_QUARTER(new String(Character.toChars(0xF0F63))),
        MOON_NEW(new String(Character.toChars(0xF0F64))),
        MOON_WANING_CRESCENT(new String(Character.toChars(0xF0F65))),
        MOON_WANING_GIBBOUS(new String(Character.toChars(0xF0F66))),
        MOON_WAXING_CRESCENT(new String(Character.toChars(0xF0F67))),
        MOON_WAXING_GIBBOUS(new String(Character.toChars(0xF0F68))),
        MOPED(new String(Character.toChars(0xF1086))),
        MOPED_ELECTRIC(new String(Character.toChars(0xF15B7))),
        MOPED_ELECTRIC_OUTLINE(new String(Character.toChars(0xF15B8))),
        MOPED_OUTLINE(new String(Character.toChars(0xF15B9))),
        MORE(new String(Character.toChars(0xF037B))),
        MORTAR_PESTLE(new String(Character.toChars(0xF1748))),
        MORTAR_PESTLE_PLUS(new String(Character.toChars(0xF03F1))),
        MOSQUE(new String(Character.toChars(0xF0D45))),
        MOSQUE_OUTLINE(new String(Character.toChars(0xF1827))),
        MOTHER_HEART(new String(Character.toChars(0xF1314))),
        MOTHER_NURSE(new String(Character.toChars(0xF0D21))),
        MOTION(new String(Character.toChars(0xF15B2))),
        MOTION_OUTLINE(new String(Character.toChars(0xF15B3))),
        MOTION_PAUSE(new String(Character.toChars(0xF1590))),
        MOTION_PAUSE_OUTLINE(new String(Character.toChars(0xF1592))),
        MOTION_PLAY(new String(Character.toChars(0xF158F))),
        MOTION_PLAY_OUTLINE(new String(Character.toChars(0xF1591))),
        MOTION_SENSOR(new String(Character.toChars(0xF0D91))),
        MOTION_SENSOR_OFF(new String(Character.toChars(0xF1435))),
        MOTORBIKE(new String(Character.toChars(0xF037C))),
        MOTORBIKE_ELECTRIC(new String(Character.toChars(0xF15BA))),
        MOTORBIKE_OFF(new String(Character.toChars(0xF1B16))),
        MOUSE(new String(Character.toChars(0xF037D))),
        MOUSE_BLUETOOTH(new String(Character.toChars(0xF098B))),
        MOUSE_MOVE_DOWN(new String(Character.toChars(0xF1550))),
        MOUSE_MOVE_UP(new String(Character.toChars(0xF1551))),
        MOUSE_MOVE_VERTICAL(new String(Character.toChars(0xF1552))),
        MOUSE_OFF(new String(Character.toChars(0xF037E))),
        MOUSE_VARIANT(new String(Character.toChars(0xF037F))),
        MOUSE_VARIANT_OFF(new String(Character.toChars(0xF0380))),
        MOVE_RESIZE(new String(Character.toChars(0xF0655))),
        MOVE_RESIZE_VARIANT(new String(Character.toChars(0xF0656))),
        MOVIE(new String(Character.toChars(0xF0381))),
        MOVIE_CHECK(new String(Character.toChars(0xF16F3))),
        MOVIE_CHECK_OUTLINE(new String(Character.toChars(0xF16F4))),
        MOVIE_COG(new String(Character.toChars(0xF16F5))),
        MOVIE_COG_OUTLINE(new String(Character.toChars(0xF16F6))),
        MOVIE_EDIT(new String(Character.toChars(0xF1122))),
        MOVIE_EDIT_OUTLINE(new String(Character.toChars(0xF1123))),
        MOVIE_FILTER(new String(Character.toChars(0xF1124))),
        MOVIE_FILTER_OUTLINE(new String(Character.toChars(0xF1125))),
        MOVIE_MINUS(new String(Character.toChars(0xF16F7))),
        MOVIE_MINUS_OUTLINE(new String(Character.toChars(0xF16F8))),
        MOVIE_OFF(new String(Character.toChars(0xF16F9))),
        MOVIE_OFF_OUTLINE(new String(Character.toChars(0xF16FA))),
        MOVIE_OPEN(new String(Character.toChars(0xF0FCE))),
        MOVIE_OPEN_CHECK(new String(Character.toChars(0xF16FB))),
        MOVIE_OPEN_CHECK_OUTLINE(new String(Character.toChars(0xF16FC))),
        MOVIE_OPEN_COG(new String(Character.toChars(0xF16FD))),
        MOVIE_OPEN_COG_OUTLINE(new String(Character.toChars(0xF16FE))),
        MOVIE_OPEN_EDIT(new String(Character.toChars(0xF16FF))),
        MOVIE_OPEN_EDIT_OUTLINE(new String(Character.toChars(0xF1700))),
        MOVIE_OPEN_MINUS(new String(Character.toChars(0xF1701))),
        MOVIE_OPEN_MINUS_OUTLINE(new String(Character.toChars(0xF1702))),
        MOVIE_OPEN_OFF(new String(Character.toChars(0xF1703))),
        MOVIE_OPEN_OFF_OUTLINE(new String(Character.toChars(0xF1704))),
        MOVIE_OPEN_OUTLINE(new String(Character.toChars(0xF0FCF))),
        MOVIE_OPEN_PLAY(new String(Character.toChars(0xF1705))),
        MOVIE_OPEN_PLAY_OUTLINE(new String(Character.toChars(0xF1706))),
        MOVIE_OPEN_PLUS(new String(Character.toChars(0xF1707))),
        MOVIE_OPEN_PLUS_OUTLINE(new String(Character.toChars(0xF1708))),
        MOVIE_OPEN_REMOVE(new String(Character.toChars(0xF1709))),
        MOVIE_OPEN_REMOVE_OUTLINE(new String(Character.toChars(0xF170A))),
        MOVIE_OPEN_SETTINGS(new String(Character.toChars(0xF170B))),
        MOVIE_OPEN_SETTINGS_OUTLINE(new String(Character.toChars(0xF170C))),
        MOVIE_OPEN_STAR(new String(Character.toChars(0xF170D))),
        MOVIE_OPEN_STAR_OUTLINE(new String(Character.toChars(0xF170E))),
        MOVIE_OUTLINE(new String(Character.toChars(0xF0DDD))),
        MOVIE_PLAY(new String(Character.toChars(0xF170F))),
        MOVIE_PLAY_OUTLINE(new String(Character.toChars(0xF1710))),
        MOVIE_PLUS(new String(Character.toChars(0xF1711))),
        MOVIE_PLUS_OUTLINE(new String(Character.toChars(0xF1712))),
        MOVIE_REMOVE(new String(Character.toChars(0xF1713))),
        MOVIE_REMOVE_OUTLINE(new String(Character.toChars(0xF1714))),
        MOVIE_ROLL(new String(Character.toChars(0xF07DE))),
        MOVIE_SEARCH(new String(Character.toChars(0xF11D2))),
        MOVIE_SEARCH_OUTLINE(new String(Character.toChars(0xF11D3))),
        MOVIE_SETTINGS(new String(Character.toChars(0xF1715))),
        MOVIE_SETTINGS_OUTLINE(new String(Character.toChars(0xF1716))),
        MOVIE_STAR(new String(Character.toChars(0xF1717))),
        MOVIE_STAR_OUTLINE(new String(Character.toChars(0xF1718))),
        MOWER(new String(Character.toChars(0xF166F))),
        MOWER_BAG(new String(Character.toChars(0xF1670))),
        MOWER_BAG_ON(new String(Character.toChars(0xF1B60))),
        MOWER_ON(new String(Character.toChars(0xF1B5F))),
        MUFFIN(new String(Character.toChars(0xF098C))),
        MULTICAST(new String(Character.toChars(0xF1893))),
        MULTIMEDIA(new String(Character.toChars(0xF1B97))),
        MULTIPLICATION(new String(Character.toChars(0xF0382))),
        MULTIPLICATION_BOX(new String(Character.toChars(0xF0383))),
        MUSHROOM(new String(Character.toChars(0xF07DF))),
        MUSHROOM_OFF(new String(Character.toChars(0xF13FA))),
        MUSHROOM_OFF_OUTLINE(new String(Character.toChars(0xF13FB))),
        MUSHROOM_OUTLINE(new String(Character.toChars(0xF07E0))),
        MUSIC(new String(Character.toChars(0xF075A))),
        MUSIC_ACCIDENTAL_DOUBLE_FLAT(new String(Character.toChars(0xF0F69))),
        MUSIC_ACCIDENTAL_DOUBLE_SHARP(new String(Character.toChars(0xF0F6A))),
        MUSIC_ACCIDENTAL_FLAT(new String(Character.toChars(0xF0F6B))),
        MUSIC_ACCIDENTAL_NATURAL(new String(Character.toChars(0xF0F6C))),
        MUSIC_ACCIDENTAL_SHARP(new String(Character.toChars(0xF0F6D))),
        MUSIC_BOX(new String(Character.toChars(0xF0384))),
        MUSIC_BOX_MULTIPLE(new String(Character.toChars(0xF0333))),
        MUSIC_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0F04))),
        MUSIC_BOX_OUTLINE(new String(Character.toChars(0xF0385))),
        MUSIC_CIRCLE(new String(Character.toChars(0xF0386))),
        MUSIC_CIRCLE_OUTLINE(new String(Character.toChars(0xF0AD4))),
        MUSIC_CLEF_ALTO(new String(Character.toChars(0xF0F6E))),
        MUSIC_CLEF_BASS(new String(Character.toChars(0xF0F6F))),
        MUSIC_CLEF_TREBLE(new String(Character.toChars(0xF0F70))),
        MUSIC_NOTE(new String(Character.toChars(0xF0387))),
        MUSIC_NOTE_BLUETOOTH(new String(Character.toChars(0xF05FE))),
        MUSIC_NOTE_BLUETOOTH_OFF(new String(Character.toChars(0xF05FF))),
        MUSIC_NOTE_EIGHTH(new String(Character.toChars(0xF0388))),
        MUSIC_NOTE_EIGHTH_DOTTED(new String(Character.toChars(0xF0F71))),
        MUSIC_NOTE_HALF(new String(Character.toChars(0xF0389))),
        MUSIC_NOTE_HALF_DOTTED(new String(Character.toChars(0xF0F72))),
        MUSIC_NOTE_MINUS(new String(Character.toChars(0xF1B89))),
        MUSIC_NOTE_OFF(new String(Character.toChars(0xF038A))),
        MUSIC_NOTE_OFF_OUTLINE(new String(Character.toChars(0xF0F73))),
        MUSIC_NOTE_OUTLINE(new String(Character.toChars(0xF0F74))),
        MUSIC_NOTE_PLUS(new String(Character.toChars(0xF0DDE))),
        MUSIC_NOTE_QUARTER(new String(Character.toChars(0xF038B))),
        MUSIC_NOTE_QUARTER_DOTTED(new String(Character.toChars(0xF0F75))),
        MUSIC_NOTE_SIXTEENTH(new String(Character.toChars(0xF038C))),
        MUSIC_NOTE_SIXTEENTH_DOTTED(new String(Character.toChars(0xF0F76))),
        MUSIC_NOTE_WHOLE(new String(Character.toChars(0xF038D))),
        MUSIC_NOTE_WHOLE_DOTTED(new String(Character.toChars(0xF0F77))),
        MUSIC_OFF(new String(Character.toChars(0xF075B))),
        MUSIC_REST_EIGHTH(new String(Character.toChars(0xF0F78))),
        MUSIC_REST_HALF(new String(Character.toChars(0xF0F79))),
        MUSIC_REST_QUARTER(new String(Character.toChars(0xF0F7A))),
        MUSIC_REST_SIXTEENTH(new String(Character.toChars(0xF0F7B))),
        MUSIC_REST_WHOLE(new String(Character.toChars(0xF0F7C))),
        MUSTACHE(new String(Character.toChars(0xF15DE)));

        private final String unicode;

        M(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public M getDefaultGlyph()
        {
            return M.MACE;
        }
    }

    public enum N implements MaterialDesignIconGlyphs<N> {

        NAIL(new String(Character.toChars(0xF0DDF))),
        NAS(new String(Character.toChars(0xF08F3))),
        NATIVESCRIPT(new String(Character.toChars(0xF0880))),
        NATURE(new String(Character.toChars(0xF038E))),
        NATURE_OUTLINE(new String(Character.toChars(0xF1C71))),
        NATURE_PEOPLE(new String(Character.toChars(0xF038F))),
        NATURE_PEOPLE_OUTLINE(new String(Character.toChars(0xF1C72))),
        NAVIGATION(new String(Character.toChars(0xF0390))),
        NAVIGATION_OUTLINE(new String(Character.toChars(0xF1607))),
        NAVIGATION_VARIANT(new String(Character.toChars(0xF18F0))),
        NAVIGATION_VARIANT_OUTLINE(new String(Character.toChars(0xF18F1))),
        NEAR_ME(new String(Character.toChars(0xF05CD))),
        NECKLACE(new String(Character.toChars(0xF0F0B))),
        NEEDLE(new String(Character.toChars(0xF0391))),
        NEEDLE_OFF(new String(Character.toChars(0xF19D2))),
        NETFLIX(new String(Character.toChars(0xF0746))),
        NETWORK(new String(Character.toChars(0xF06F3))),
        NETWORK_OFF(new String(Character.toChars(0xF0C9B))),
        NETWORK_OFF_OUTLINE(new String(Character.toChars(0xF0C9C))),
        NETWORK_OUTLINE(new String(Character.toChars(0xF0C9D))),
        NETWORK_POS(new String(Character.toChars(0xF1ACB))),
        NETWORK_STRENGTH_1(new String(Character.toChars(0xF08F4))),
        NETWORK_STRENGTH_1_ALERT(new String(Character.toChars(0xF08F5))),
        NETWORK_STRENGTH_2(new String(Character.toChars(0xF08F6))),
        NETWORK_STRENGTH_2_ALERT(new String(Character.toChars(0xF08F7))),
        NETWORK_STRENGTH_3(new String(Character.toChars(0xF08F8))),
        NETWORK_STRENGTH_3_ALERT(new String(Character.toChars(0xF08F9))),
        NETWORK_STRENGTH_4(new String(Character.toChars(0xF08FA))),
        NETWORK_STRENGTH_4_ALERT(new String(Character.toChars(0xF08FB))),
        NETWORK_STRENGTH_4_COG(new String(Character.toChars(0xF191A))),
        NETWORK_STRENGTH_OFF(new String(Character.toChars(0xF08FC))),
        NETWORK_STRENGTH_OFF_OUTLINE(new String(Character.toChars(0xF08FD))),
        NETWORK_STRENGTH_OUTLINE(new String(Character.toChars(0xF08FE))),
        NEW_BOX(new String(Character.toChars(0xF0394))),
        NEWSPAPER(new String(Character.toChars(0xF0395))),
        NEWSPAPER_CHECK(new String(Character.toChars(0xF1943))),
        NEWSPAPER_MINUS(new String(Character.toChars(0xF0F0C))),
        NEWSPAPER_PLUS(new String(Character.toChars(0xF0F0D))),
        NEWSPAPER_REMOVE(new String(Character.toChars(0xF1944))),
        NEWSPAPER_VARIANT(new String(Character.toChars(0xF1001))),
        NEWSPAPER_VARIANT_MULTIPLE(new String(Character.toChars(0xF1002))),
        NEWSPAPER_VARIANT_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1003))),
        NEWSPAPER_VARIANT_OUTLINE(new String(Character.toChars(0xF1004))),
        NFC(new String(Character.toChars(0xF0396))),
        NFC_SEARCH_VARIANT(new String(Character.toChars(0xF0E53))),
        NFC_TAP(new String(Character.toChars(0xF0397))),
        NFC_VARIANT(new String(Character.toChars(0xF0398))),
        NFC_VARIANT_OFF(new String(Character.toChars(0xF0E54))),
        NINJA(new String(Character.toChars(0xF0774))),
        NINTENDO_GAME_BOY(new String(Character.toChars(0xF1393))),
        NINTENDO_SWITCH(new String(Character.toChars(0xF07E1))),
        NINTENDO_WII(new String(Character.toChars(0xF05AB))),
        NINTENDO_WIIU(new String(Character.toChars(0xF072D))),
        NIX(new String(Character.toChars(0xF1105))),
        NODEJS(new String(Character.toChars(0xF0399))),
        NOODLES(new String(Character.toChars(0xF117E))),
        NOT_EQUAL(new String(Character.toChars(0xF098D))),
        NOT_EQUAL_VARIANT(new String(Character.toChars(0xF098E))),
        NOTE(new String(Character.toChars(0xF039A))),
        NOTE_ALERT(new String(Character.toChars(0xF177D))),
        NOTE_ALERT_OUTLINE(new String(Character.toChars(0xF177E))),
        NOTE_CHECK(new String(Character.toChars(0xF177F))),
        NOTE_CHECK_OUTLINE(new String(Character.toChars(0xF1780))),
        NOTE_EDIT(new String(Character.toChars(0xF1781))),
        NOTE_EDIT_OUTLINE(new String(Character.toChars(0xF1782))),
        NOTE_MINUS(new String(Character.toChars(0xF164F))),
        NOTE_MINUS_OUTLINE(new String(Character.toChars(0xF1650))),
        NOTE_MULTIPLE(new String(Character.toChars(0xF06B8))),
        NOTE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF06B9))),
        NOTE_OFF(new String(Character.toChars(0xF1783))),
        NOTE_OFF_OUTLINE(new String(Character.toChars(0xF1784))),
        NOTE_OUTLINE(new String(Character.toChars(0xF039B))),
        NOTE_PLUS(new String(Character.toChars(0xF039C))),
        NOTE_PLUS_OUTLINE(new String(Character.toChars(0xF039D))),
        NOTE_REMOVE(new String(Character.toChars(0xF1651))),
        NOTE_REMOVE_OUTLINE(new String(Character.toChars(0xF1652))),
        NOTE_SEARCH(new String(Character.toChars(0xF1653))),
        NOTE_SEARCH_OUTLINE(new String(Character.toChars(0xF1654))),
        NOTE_TEXT(new String(Character.toChars(0xF039E))),
        NOTE_TEXT_OUTLINE(new String(Character.toChars(0xF11D7))),
        NOTEBOOK(new String(Character.toChars(0xF082E))),
        NOTEBOOK_CHECK(new String(Character.toChars(0xF14F5))),
        NOTEBOOK_CHECK_OUTLINE(new String(Character.toChars(0xF14F6))),
        NOTEBOOK_EDIT(new String(Character.toChars(0xF14E7))),
        NOTEBOOK_EDIT_OUTLINE(new String(Character.toChars(0xF14E9))),
        NOTEBOOK_HEART(new String(Character.toChars(0xF1A0B))),
        NOTEBOOK_HEART_OUTLINE(new String(Character.toChars(0xF1A0C))),
        NOTEBOOK_MINUS(new String(Character.toChars(0xF1610))),
        NOTEBOOK_MINUS_OUTLINE(new String(Character.toChars(0xF1611))),
        NOTEBOOK_MULTIPLE(new String(Character.toChars(0xF0E55))),
        NOTEBOOK_OUTLINE(new String(Character.toChars(0xF0EBF))),
        NOTEBOOK_PLUS(new String(Character.toChars(0xF1612))),
        NOTEBOOK_PLUS_OUTLINE(new String(Character.toChars(0xF1613))),
        NOTEBOOK_REMOVE(new String(Character.toChars(0xF1614))),
        NOTEBOOK_REMOVE_OUTLINE(new String(Character.toChars(0xF1615))),
        NOTIFICATION_CLEAR_ALL(new String(Character.toChars(0xF039F))),
        NPM(new String(Character.toChars(0xF06F7))),
        NUKE(new String(Character.toChars(0xF06A4))),
        NULL(new String(Character.toChars(0xF07E2))),
        NUMERIC(new String(Character.toChars(0xF03A0))),
        NUMERIC_0(new String(Character.toChars(0xF0B39))),
        NUMERIC_0_BOX(new String(Character.toChars(0xF03A1))),
        NUMERIC_0_BOX_MULTIPLE(new String(Character.toChars(0xF0F0E))),
        NUMERIC_0_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03A2))),
        NUMERIC_0_BOX_OUTLINE(new String(Character.toChars(0xF03A3))),
        NUMERIC_0_CIRCLE(new String(Character.toChars(0xF0C9E))),
        NUMERIC_0_CIRCLE_OUTLINE(new String(Character.toChars(0xF0C9F))),
        NUMERIC_1(new String(Character.toChars(0xF0B3A))),
        NUMERIC_1_BOX(new String(Character.toChars(0xF03A4))),
        NUMERIC_1_BOX_MULTIPLE(new String(Character.toChars(0xF0F0F))),
        NUMERIC_1_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03A5))),
        NUMERIC_1_BOX_OUTLINE(new String(Character.toChars(0xF03A6))),
        NUMERIC_1_CIRCLE(new String(Character.toChars(0xF0CA0))),
        NUMERIC_1_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CA1))),
        NUMERIC_10(new String(Character.toChars(0xF0FE9))),
        NUMERIC_10_BOX(new String(Character.toChars(0xF0F7D))),
        NUMERIC_10_BOX_MULTIPLE(new String(Character.toChars(0xF0FEA))),
        NUMERIC_10_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0FEB))),
        NUMERIC_10_BOX_OUTLINE(new String(Character.toChars(0xF0F7E))),
        NUMERIC_10_CIRCLE(new String(Character.toChars(0xF0FEC))),
        NUMERIC_10_CIRCLE_OUTLINE(new String(Character.toChars(0xF0FED))),
        NUMERIC_2(new String(Character.toChars(0xF0B3B))),
        NUMERIC_2_BOX(new String(Character.toChars(0xF03A7))),
        NUMERIC_2_BOX_MULTIPLE(new String(Character.toChars(0xF0F10))),
        NUMERIC_2_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03A8))),
        NUMERIC_2_BOX_OUTLINE(new String(Character.toChars(0xF03A9))),
        NUMERIC_2_CIRCLE(new String(Character.toChars(0xF0CA2))),
        NUMERIC_2_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CA3))),
        NUMERIC_3(new String(Character.toChars(0xF0B3C))),
        NUMERIC_3_BOX(new String(Character.toChars(0xF03AA))),
        NUMERIC_3_BOX_MULTIPLE(new String(Character.toChars(0xF0F11))),
        NUMERIC_3_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03AB))),
        NUMERIC_3_BOX_OUTLINE(new String(Character.toChars(0xF03AC))),
        NUMERIC_3_CIRCLE(new String(Character.toChars(0xF0CA4))),
        NUMERIC_3_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CA5))),
        NUMERIC_4(new String(Character.toChars(0xF0B3D))),
        NUMERIC_4_BOX(new String(Character.toChars(0xF03AD))),
        NUMERIC_4_BOX_MULTIPLE(new String(Character.toChars(0xF0F12))),
        NUMERIC_4_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03B2))),
        NUMERIC_4_BOX_OUTLINE(new String(Character.toChars(0xF03AE))),
        NUMERIC_4_CIRCLE(new String(Character.toChars(0xF0CA6))),
        NUMERIC_4_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CA7))),
        NUMERIC_5(new String(Character.toChars(0xF0B3E))),
        NUMERIC_5_BOX(new String(Character.toChars(0xF03B1))),
        NUMERIC_5_BOX_MULTIPLE(new String(Character.toChars(0xF0F13))),
        NUMERIC_5_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03AF))),
        NUMERIC_5_BOX_OUTLINE(new String(Character.toChars(0xF03B0))),
        NUMERIC_5_CIRCLE(new String(Character.toChars(0xF0CA8))),
        NUMERIC_5_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CA9))),
        NUMERIC_6(new String(Character.toChars(0xF0B3F))),
        NUMERIC_6_BOX(new String(Character.toChars(0xF03B3))),
        NUMERIC_6_BOX_MULTIPLE(new String(Character.toChars(0xF0F14))),
        NUMERIC_6_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03B4))),
        NUMERIC_6_BOX_OUTLINE(new String(Character.toChars(0xF03B5))),
        NUMERIC_6_CIRCLE(new String(Character.toChars(0xF0CAA))),
        NUMERIC_6_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CAB))),
        NUMERIC_7(new String(Character.toChars(0xF0B40))),
        NUMERIC_7_BOX(new String(Character.toChars(0xF03B6))),
        NUMERIC_7_BOX_MULTIPLE(new String(Character.toChars(0xF0F15))),
        NUMERIC_7_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03B7))),
        NUMERIC_7_BOX_OUTLINE(new String(Character.toChars(0xF03B8))),
        NUMERIC_7_CIRCLE(new String(Character.toChars(0xF0CAC))),
        NUMERIC_7_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CAD))),
        NUMERIC_8(new String(Character.toChars(0xF0B41))),
        NUMERIC_8_BOX(new String(Character.toChars(0xF03B9))),
        NUMERIC_8_BOX_MULTIPLE(new String(Character.toChars(0xF0F16))),
        NUMERIC_8_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03BA))),
        NUMERIC_8_BOX_OUTLINE(new String(Character.toChars(0xF03BB))),
        NUMERIC_8_CIRCLE(new String(Character.toChars(0xF0CAE))),
        NUMERIC_8_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CAF))),
        NUMERIC_9(new String(Character.toChars(0xF0B42))),
        NUMERIC_9_BOX(new String(Character.toChars(0xF03BC))),
        NUMERIC_9_BOX_MULTIPLE(new String(Character.toChars(0xF0F17))),
        NUMERIC_9_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03BD))),
        NUMERIC_9_BOX_OUTLINE(new String(Character.toChars(0xF03BE))),
        NUMERIC_9_CIRCLE(new String(Character.toChars(0xF0CB0))),
        NUMERIC_9_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CB1))),
        NUMERIC_9_PLUS(new String(Character.toChars(0xF0FEE))),
        NUMERIC_9_PLUS_BOX(new String(Character.toChars(0xF03BF))),
        NUMERIC_9_PLUS_BOX_MULTIPLE(new String(Character.toChars(0xF0F18))),
        NUMERIC_9_PLUS_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF03C0))),
        NUMERIC_9_PLUS_BOX_OUTLINE(new String(Character.toChars(0xF03C1))),
        NUMERIC_9_PLUS_CIRCLE(new String(Character.toChars(0xF0CB2))),
        NUMERIC_9_PLUS_CIRCLE_OUTLINE(new String(Character.toChars(0xF0CB3))),
        NUMERIC_NEGATIVE_1(new String(Character.toChars(0xF1052))),
        NUMERIC_OFF(new String(Character.toChars(0xF19D3))),
        NUMERIC_POSITIVE_1(new String(Character.toChars(0xF15CB))),
        NUT(new String(Character.toChars(0xF06F8))),
        NUTRITION(new String(Character.toChars(0xF03C2))),
        NUXT(new String(Character.toChars(0xF1106)));

        private final String unicode;

        N(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public N getDefaultGlyph()
        {
            return N.NAIL;
        }
    }

    public enum O implements MaterialDesignIconGlyphs<O> {

        OAR(new String(Character.toChars(0xF067C))),
        OCARINA(new String(Character.toChars(0xF0DE0))),
        OCI(new String(Character.toChars(0xF12E9))),
        OCR(new String(Character.toChars(0xF113A))),
        OCTAGON(new String(Character.toChars(0xF03C3))),
        OCTAGON_OUTLINE(new String(Character.toChars(0xF03C4))),
        OCTAGRAM(new String(Character.toChars(0xF06F9))),
        OCTAGRAM_EDIT(new String(Character.toChars(0xF1C34))),
        OCTAGRAM_EDIT_OUTLINE(new String(Character.toChars(0xF1C35))),
        OCTAGRAM_MINUS(new String(Character.toChars(0xF1C36))),
        OCTAGRAM_MINUS_OUTLINE(new String(Character.toChars(0xF1C37))),
        OCTAGRAM_OUTLINE(new String(Character.toChars(0xF0775))),
        OCTAGRAM_PLUS(new String(Character.toChars(0xF1C38))),
        OCTAGRAM_PLUS_OUTLINE(new String(Character.toChars(0xF1C39))),
        OCTAHEDRON(new String(Character.toChars(0xF1950))),
        OCTAHEDRON_OFF(new String(Character.toChars(0xF1951))),
        ODNOKLASSNIKI(new String(Character.toChars(0xF03C5))),
        OFFER(new String(Character.toChars(0xF121B))),
        OFFICE_BUILDING(new String(Character.toChars(0xF0991))),
        OFFICE_BUILDING_COG(new String(Character.toChars(0xF1949))),
        OFFICE_BUILDING_COG_OUTLINE(new String(Character.toChars(0xF194A))),
        OFFICE_BUILDING_MARKER(new String(Character.toChars(0xF1520))),
        OFFICE_BUILDING_MARKER_OUTLINE(new String(Character.toChars(0xF1521))),
        OFFICE_BUILDING_MINUS(new String(Character.toChars(0xF1BAA))),
        OFFICE_BUILDING_MINUS_OUTLINE(new String(Character.toChars(0xF1BAB))),
        OFFICE_BUILDING_OUTLINE(new String(Character.toChars(0xF151F))),
        OFFICE_BUILDING_PLUS(new String(Character.toChars(0xF1BA8))),
        OFFICE_BUILDING_PLUS_OUTLINE(new String(Character.toChars(0xF1BA9))),
        OFFICE_BUILDING_REMOVE(new String(Character.toChars(0xF1BAC))),
        OFFICE_BUILDING_REMOVE_OUTLINE(new String(Character.toChars(0xF1BAD))),
        OIL(new String(Character.toChars(0xF03C7))),
        OIL_LAMP(new String(Character.toChars(0xF0F19))),
        OIL_LEVEL(new String(Character.toChars(0xF1053))),
        OIL_TEMPERATURE(new String(Character.toChars(0xF0FF8))),
        OM(new String(Character.toChars(0xF0973))),
        OMEGA(new String(Character.toChars(0xF03C9))),
        ONE_UP(new String(Character.toChars(0xF0BAD))),
        ONEPASSWORD(new String(Character.toChars(0xF0881))),
        OPACITY(new String(Character.toChars(0xF05CC))),
        OPEN_IN_APP(new String(Character.toChars(0xF03CB))),
        OPEN_IN_NEW(new String(Character.toChars(0xF03CC))),
        OPEN_SOURCE_INITIATIVE(new String(Character.toChars(0xF0BAE))),
        OPENID(new String(Character.toChars(0xF03CD))),
        OPERA(new String(Character.toChars(0xF03CE))),
        ORBIT(new String(Character.toChars(0xF0018))),
        ORBIT_VARIANT(new String(Character.toChars(0xF15DB))),
        ORDER_ALPHABETICAL_ASCENDING(new String(Character.toChars(0xF020D))),
        ORDER_ALPHABETICAL_DESCENDING(new String(Character.toChars(0xF0D07))),
        ORDER_BOOL_ASCENDING(new String(Character.toChars(0xF02BE))),
        ORDER_BOOL_ASCENDING_VARIANT(new String(Character.toChars(0xF098F))),
        ORDER_BOOL_DESCENDING(new String(Character.toChars(0xF1384))),
        ORDER_BOOL_DESCENDING_VARIANT(new String(Character.toChars(0xF0990))),
        ORDER_NUMERIC_ASCENDING(new String(Character.toChars(0xF0545))),
        ORDER_NUMERIC_DESCENDING(new String(Character.toChars(0xF0546))),
        ORIGIN(new String(Character.toChars(0xF0B43))),
        ORNAMENT(new String(Character.toChars(0xF03CF))),
        ORNAMENT_VARIANT(new String(Character.toChars(0xF03D0))),
        OUTDOOR_LAMP(new String(Character.toChars(0xF1054))),
        OVERSCAN(new String(Character.toChars(0xF1005))),
        OWL(new String(Character.toChars(0xF03D2)));

        private final String unicode;

        O(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public O getDefaultGlyph()
        {
            return O.OAR;
        }
    }

    public enum P implements MaterialDesignIconGlyphs<P> {

        PAC_MAN(new String(Character.toChars(0xF0BAF))),
        PACKAGE(new String(Character.toChars(0xF03D3))),
        PACKAGE_CHECK(new String(Character.toChars(0xF1B51))),
        PACKAGE_DOWN(new String(Character.toChars(0xF03D4))),
        PACKAGE_UP(new String(Character.toChars(0xF03D5))),
        PACKAGE_VARIANT(new String(Character.toChars(0xF03D6))),
        PACKAGE_VARIANT_CLOSED(new String(Character.toChars(0xF03D7))),
        PACKAGE_VARIANT_CLOSED_CHECK(new String(Character.toChars(0xF1B52))),
        PACKAGE_VARIANT_CLOSED_MINUS(new String(Character.toChars(0xF19D4))),
        PACKAGE_VARIANT_CLOSED_PLUS(new String(Character.toChars(0xF19D5))),
        PACKAGE_VARIANT_CLOSED_REMOVE(new String(Character.toChars(0xF19D6))),
        PACKAGE_VARIANT_MINUS(new String(Character.toChars(0xF19D7))),
        PACKAGE_VARIANT_PLUS(new String(Character.toChars(0xF19D8))),
        PACKAGE_VARIANT_REMOVE(new String(Character.toChars(0xF19D9))),
        PAGE_FIRST(new String(Character.toChars(0xF0600))),
        PAGE_LAST(new String(Character.toChars(0xF0601))),
        PAGE_LAYOUT_BODY(new String(Character.toChars(0xF06FA))),
        PAGE_LAYOUT_FOOTER(new String(Character.toChars(0xF06FB))),
        PAGE_LAYOUT_HEADER(new String(Character.toChars(0xF06FC))),
        PAGE_LAYOUT_HEADER_FOOTER(new String(Character.toChars(0xF0F7F))),
        PAGE_LAYOUT_SIDEBAR_LEFT(new String(Character.toChars(0xF06FD))),
        PAGE_LAYOUT_SIDEBAR_RIGHT(new String(Character.toChars(0xF06FE))),
        PAGE_NEXT(new String(Character.toChars(0xF0BB0))),
        PAGE_NEXT_OUTLINE(new String(Character.toChars(0xF0BB1))),
        PAGE_PREVIOUS(new String(Character.toChars(0xF0BB2))),
        PAGE_PREVIOUS_OUTLINE(new String(Character.toChars(0xF0BB3))),
        PAIL(new String(Character.toChars(0xF1417))),
        PAIL_MINUS(new String(Character.toChars(0xF1437))),
        PAIL_MINUS_OUTLINE(new String(Character.toChars(0xF143C))),
        PAIL_OFF(new String(Character.toChars(0xF1439))),
        PAIL_OFF_OUTLINE(new String(Character.toChars(0xF143E))),
        PAIL_OUTLINE(new String(Character.toChars(0xF143A))),
        PAIL_PLUS(new String(Character.toChars(0xF1436))),
        PAIL_PLUS_OUTLINE(new String(Character.toChars(0xF143B))),
        PAIL_REMOVE(new String(Character.toChars(0xF1438))),
        PAIL_REMOVE_OUTLINE(new String(Character.toChars(0xF143D))),
        PALETTE(new String(Character.toChars(0xF03D8))),
        PALETTE_ADVANCED(new String(Character.toChars(0xF03D9))),
        PALETTE_OUTLINE(new String(Character.toChars(0xF0E0C))),
        PALETTE_SWATCH(new String(Character.toChars(0xF08B5))),
        PALETTE_SWATCH_OUTLINE(new String(Character.toChars(0xF135C))),
        PALETTE_SWATCH_VARIANT(new String(Character.toChars(0xF195A))),
        PALM_TREE(new String(Character.toChars(0xF1055))),
        PAN(new String(Character.toChars(0xF0BB4))),
        PAN_BOTTOM_LEFT(new String(Character.toChars(0xF0BB5))),
        PAN_BOTTOM_RIGHT(new String(Character.toChars(0xF0BB6))),
        PAN_DOWN(new String(Character.toChars(0xF0BB7))),
        PAN_HORIZONTAL(new String(Character.toChars(0xF0BB8))),
        PAN_LEFT(new String(Character.toChars(0xF0BB9))),
        PAN_RIGHT(new String(Character.toChars(0xF0BBA))),
        PAN_TOP_LEFT(new String(Character.toChars(0xF0BBB))),
        PAN_TOP_RIGHT(new String(Character.toChars(0xF0BBC))),
        PAN_UP(new String(Character.toChars(0xF0BBD))),
        PAN_VERTICAL(new String(Character.toChars(0xF0BBE))),
        PANDA(new String(Character.toChars(0xF03DA))),
        PANDORA(new String(Character.toChars(0xF03DB))),
        PANORAMA(new String(Character.toChars(0xF03DC))),
        PANORAMA_FISHEYE(new String(Character.toChars(0xF03DD))),
        PANORAMA_HORIZONTAL(new String(Character.toChars(0xF1928))),
        PANORAMA_HORIZONTAL_OUTLINE(new String(Character.toChars(0xF03DE))),
        PANORAMA_OUTLINE(new String(Character.toChars(0xF198C))),
        PANORAMA_SPHERE(new String(Character.toChars(0xF198D))),
        PANORAMA_SPHERE_OUTLINE(new String(Character.toChars(0xF198E))),
        PANORAMA_VARIANT(new String(Character.toChars(0xF198F))),
        PANORAMA_VARIANT_OUTLINE(new String(Character.toChars(0xF1990))),
        PANORAMA_VERTICAL(new String(Character.toChars(0xF1929))),
        PANORAMA_VERTICAL_OUTLINE(new String(Character.toChars(0xF03DF))),
        PANORAMA_WIDE_ANGLE(new String(Character.toChars(0xF195F))),
        PANORAMA_WIDE_ANGLE_OUTLINE(new String(Character.toChars(0xF03E0))),
        PAPER_CUT_VERTICAL(new String(Character.toChars(0xF03E1))),
        PAPER_ROLL(new String(Character.toChars(0xF1157))),
        PAPER_ROLL_OUTLINE(new String(Character.toChars(0xF1158))),
        PAPERCLIP(new String(Character.toChars(0xF03E2))),
        PAPERCLIP_CHECK(new String(Character.toChars(0xF1AC6))),
        PAPERCLIP_LOCK(new String(Character.toChars(0xF19DA))),
        PAPERCLIP_MINUS(new String(Character.toChars(0xF1AC7))),
        PAPERCLIP_OFF(new String(Character.toChars(0xF1AC8))),
        PAPERCLIP_PLUS(new String(Character.toChars(0xF1AC9))),
        PAPERCLIP_REMOVE(new String(Character.toChars(0xF1ACA))),
        PARACHUTE(new String(Character.toChars(0xF0CB4))),
        PARACHUTE_OUTLINE(new String(Character.toChars(0xF0CB5))),
        PARAGLIDING(new String(Character.toChars(0xF1745))),
        PARKING(new String(Character.toChars(0xF03E3))),
        PARTY_POPPER(new String(Character.toChars(0xF1056))),
        PASSPORT(new String(Character.toChars(0xF07E3))),
        PASSPORT_BIOMETRIC(new String(Character.toChars(0xF0DE1))),
        PASTA(new String(Character.toChars(0xF1160))),
        PATIO_HEATER(new String(Character.toChars(0xF0F80))),
        PATREON(new String(Character.toChars(0xF0882))),
        PAUSE(new String(Character.toChars(0xF03E4))),
        PAUSE_BOX(new String(Character.toChars(0xF00BC))),
        PAUSE_BOX_OUTLINE(new String(Character.toChars(0xF1B7A))),
        PAUSE_CIRCLE(new String(Character.toChars(0xF03E5))),
        PAUSE_CIRCLE_OUTLINE(new String(Character.toChars(0xF03E6))),
        PAUSE_OCTAGON(new String(Character.toChars(0xF03E7))),
        PAUSE_OCTAGON_OUTLINE(new String(Character.toChars(0xF03E8))),
        PAW(new String(Character.toChars(0xF03E9))),
        PAW_OFF(new String(Character.toChars(0xF0657))),
        PAW_OFF_OUTLINE(new String(Character.toChars(0xF1676))),
        PAW_OUTLINE(new String(Character.toChars(0xF1675))),
        PEACE(new String(Character.toChars(0xF0884))),
        PEANUT(new String(Character.toChars(0xF0FFC))),
        PEANUT_OFF(new String(Character.toChars(0xF0FFD))),
        PEANUT_OFF_OUTLINE(new String(Character.toChars(0xF0FFF))),
        PEANUT_OUTLINE(new String(Character.toChars(0xF0FFE))),
        PEN(new String(Character.toChars(0xF03EA))),
        PEN_LOCK(new String(Character.toChars(0xF0DE2))),
        PEN_MINUS(new String(Character.toChars(0xF0DE3))),
        PEN_OFF(new String(Character.toChars(0xF0DE4))),
        PEN_PLUS(new String(Character.toChars(0xF0DE5))),
        PEN_REMOVE(new String(Character.toChars(0xF0DE6))),
        PENCIL(new String(Character.toChars(0xF03EB))),
        PENCIL_BOX(new String(Character.toChars(0xF03EC))),
        PENCIL_BOX_MULTIPLE(new String(Character.toChars(0xF1144))),
        PENCIL_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1145))),
        PENCIL_BOX_OUTLINE(new String(Character.toChars(0xF03ED))),
        PENCIL_CIRCLE(new String(Character.toChars(0xF06FF))),
        PENCIL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0776))),
        PENCIL_LOCK(new String(Character.toChars(0xF03EE))),
        PENCIL_LOCK_OUTLINE(new String(Character.toChars(0xF0DE7))),
        PENCIL_MINUS(new String(Character.toChars(0xF0DE8))),
        PENCIL_MINUS_OUTLINE(new String(Character.toChars(0xF0DE9))),
        PENCIL_OFF(new String(Character.toChars(0xF03EF))),
        PENCIL_OFF_OUTLINE(new String(Character.toChars(0xF0DEA))),
        PENCIL_OUTLINE(new String(Character.toChars(0xF0CB6))),
        PENCIL_PLUS(new String(Character.toChars(0xF0DEB))),
        PENCIL_PLUS_OUTLINE(new String(Character.toChars(0xF0DEC))),
        PENCIL_REMOVE(new String(Character.toChars(0xF0DED))),
        PENCIL_REMOVE_OUTLINE(new String(Character.toChars(0xF0DEE))),
        PENCIL_RULER(new String(Character.toChars(0xF1353))),
        PENCIL_RULER_OUTLINE(new String(Character.toChars(0xF1C11))),
        PENGUIN(new String(Character.toChars(0xF0EC0))),
        PENTAGON(new String(Character.toChars(0xF0701))),
        PENTAGON_OUTLINE(new String(Character.toChars(0xF0700))),
        PENTAGRAM(new String(Character.toChars(0xF1667))),
        PERCENT(new String(Character.toChars(0xF03F0))),
        PERCENT_BOX(new String(Character.toChars(0xF1A02))),
        PERCENT_BOX_OUTLINE(new String(Character.toChars(0xF1A03))),
        PERCENT_CIRCLE(new String(Character.toChars(0xF1A04))),
        PERCENT_CIRCLE_OUTLINE(new String(Character.toChars(0xF1A05))),
        PERCENT_OUTLINE(new String(Character.toChars(0xF1278))),
        PERIODIC_TABLE(new String(Character.toChars(0xF08B6))),
        PERSPECTIVE_LESS(new String(Character.toChars(0xF0D23))),
        PERSPECTIVE_MORE(new String(Character.toChars(0xF0D24))),
        PH(new String(Character.toChars(0xF17C5))),
        PHONE(new String(Character.toChars(0xF03F2))),
        PHONE_ALERT(new String(Character.toChars(0xF0F1A))),
        PHONE_ALERT_OUTLINE(new String(Character.toChars(0xF118E))),
        PHONE_BLUETOOTH(new String(Character.toChars(0xF03F3))),
        PHONE_BLUETOOTH_OUTLINE(new String(Character.toChars(0xF118F))),
        PHONE_CANCEL(new String(Character.toChars(0xF10BC))),
        PHONE_CANCEL_OUTLINE(new String(Character.toChars(0xF1190))),
        PHONE_CHECK(new String(Character.toChars(0xF11A9))),
        PHONE_CHECK_OUTLINE(new String(Character.toChars(0xF11AA))),
        PHONE_CLASSIC(new String(Character.toChars(0xF0602))),
        PHONE_CLASSIC_OFF(new String(Character.toChars(0xF1279))),
        PHONE_CLOCK(new String(Character.toChars(0xF19DB))),
        PHONE_DIAL(new String(Character.toChars(0xF1559))),
        PHONE_DIAL_OUTLINE(new String(Character.toChars(0xF155A))),
        PHONE_FORWARD(new String(Character.toChars(0xF03F4))),
        PHONE_FORWARD_OUTLINE(new String(Character.toChars(0xF1191))),
        PHONE_HANGUP(new String(Character.toChars(0xF03F5))),
        PHONE_HANGUP_OUTLINE(new String(Character.toChars(0xF1192))),
        PHONE_IN_TALK(new String(Character.toChars(0xF03F6))),
        PHONE_IN_TALK_OUTLINE(new String(Character.toChars(0xF1182))),
        PHONE_INCOMING(new String(Character.toChars(0xF03F7))),
        PHONE_INCOMING_OUTGOING(new String(Character.toChars(0xF1B3F))),
        PHONE_INCOMING_OUTGOING_OUTLINE(new String(Character.toChars(0xF1B40))),
        PHONE_INCOMING_OUTLINE(new String(Character.toChars(0xF1193))),
        PHONE_LOCK(new String(Character.toChars(0xF03F8))),
        PHONE_LOCK_OUTLINE(new String(Character.toChars(0xF1194))),
        PHONE_LOG(new String(Character.toChars(0xF03F9))),
        PHONE_LOG_OUTLINE(new String(Character.toChars(0xF1195))),
        PHONE_MESSAGE(new String(Character.toChars(0xF1196))),
        PHONE_MESSAGE_OUTLINE(new String(Character.toChars(0xF1197))),
        PHONE_MINUS(new String(Character.toChars(0xF0658))),
        PHONE_MINUS_OUTLINE(new String(Character.toChars(0xF1198))),
        PHONE_MISSED(new String(Character.toChars(0xF03FA))),
        PHONE_MISSED_OUTLINE(new String(Character.toChars(0xF11A5))),
        PHONE_OFF(new String(Character.toChars(0xF0DEF))),
        PHONE_OFF_OUTLINE(new String(Character.toChars(0xF11A6))),
        PHONE_OUTGOING(new String(Character.toChars(0xF03FB))),
        PHONE_OUTGOING_OUTLINE(new String(Character.toChars(0xF1199))),
        PHONE_OUTLINE(new String(Character.toChars(0xF0DF0))),
        PHONE_PAUSED(new String(Character.toChars(0xF03FC))),
        PHONE_PAUSED_OUTLINE(new String(Character.toChars(0xF119A))),
        PHONE_PLUS(new String(Character.toChars(0xF0659))),
        PHONE_PLUS_OUTLINE(new String(Character.toChars(0xF119B))),
        PHONE_REFRESH(new String(Character.toChars(0xF1993))),
        PHONE_REFRESH_OUTLINE(new String(Character.toChars(0xF1994))),
        PHONE_REMOVE(new String(Character.toChars(0xF152F))),
        PHONE_REMOVE_OUTLINE(new String(Character.toChars(0xF1530))),
        PHONE_RETURN(new String(Character.toChars(0xF082F))),
        PHONE_RETURN_OUTLINE(new String(Character.toChars(0xF119C))),
        PHONE_RING(new String(Character.toChars(0xF11AB))),
        PHONE_RING_OUTLINE(new String(Character.toChars(0xF11AC))),
        PHONE_ROTATE_LANDSCAPE(new String(Character.toChars(0xF0885))),
        PHONE_ROTATE_PORTRAIT(new String(Character.toChars(0xF0886))),
        PHONE_SETTINGS(new String(Character.toChars(0xF03FD))),
        PHONE_SETTINGS_OUTLINE(new String(Character.toChars(0xF119D))),
        PHONE_SYNC(new String(Character.toChars(0xF1995))),
        PHONE_SYNC_OUTLINE(new String(Character.toChars(0xF1996))),
        PHONE_VOIP(new String(Character.toChars(0xF03FE))),
        PI(new String(Character.toChars(0xF03FF))),
        PI_BOX(new String(Character.toChars(0xF0400))),
        PI_HOLE(new String(Character.toChars(0xF0DF1))),
        PIANO(new String(Character.toChars(0xF067D))),
        PIANO_OFF(new String(Character.toChars(0xF0698))),
        PICKAXE(new String(Character.toChars(0xF08B7))),
        PICTURE_IN_PICTURE_BOTTOM_RIGHT(new String(Character.toChars(0xF0E57))),
        PICTURE_IN_PICTURE_BOTTOM_RIGHT_OUTLINE(new String(Character.toChars(0xF0E58))),
        PICTURE_IN_PICTURE_TOP_RIGHT(new String(Character.toChars(0xF0E59))),
        PICTURE_IN_PICTURE_TOP_RIGHT_OUTLINE(new String(Character.toChars(0xF0E5A))),
        PIER(new String(Character.toChars(0xF0887))),
        PIER_CRANE(new String(Character.toChars(0xF0888))),
        PIG(new String(Character.toChars(0xF0401))),
        PIG_VARIANT(new String(Character.toChars(0xF1006))),
        PIG_VARIANT_OUTLINE(new String(Character.toChars(0xF1678))),
        PIGGY_BANK(new String(Character.toChars(0xF1007))),
        PIGGY_BANK_OUTLINE(new String(Character.toChars(0xF1679))),
        PILL(new String(Character.toChars(0xF0402))),
        PILL_MULTIPLE(new String(Character.toChars(0xF1B4C))),
        PILL_OFF(new String(Character.toChars(0xF1A5C))),
        PILLAR(new String(Character.toChars(0xF0702))),
        PIN(new String(Character.toChars(0xF0403))),
        PIN_OFF(new String(Character.toChars(0xF0404))),
        PIN_OFF_OUTLINE(new String(Character.toChars(0xF0930))),
        PIN_OUTLINE(new String(Character.toChars(0xF0931))),
        PINE_TREE(new String(Character.toChars(0xF0405))),
        PINE_TREE_BOX(new String(Character.toChars(0xF0406))),
        PINE_TREE_FIRE(new String(Character.toChars(0xF141A))),
        PINE_TREE_VARIANT(new String(Character.toChars(0xF1C73))),
        PINE_TREE_VARIANT_OUTLINE(new String(Character.toChars(0xF1C74))),
        PINTEREST(new String(Character.toChars(0xF0407))),
        PINWHEEL(new String(Character.toChars(0xF0AD5))),
        PINWHEEL_OUTLINE(new String(Character.toChars(0xF0AD6))),
        PIPE(new String(Character.toChars(0xF07E5))),
        PIPE_DISCONNECTED(new String(Character.toChars(0xF07E6))),
        PIPE_LEAK(new String(Character.toChars(0xF0889))),
        PIPE_VALVE(new String(Character.toChars(0xF184D))),
        PIPE_WRENCH(new String(Character.toChars(0xF1354))),
        PIRATE(new String(Character.toChars(0xF0A08))),
        PISTOL(new String(Character.toChars(0xF0703))),
        PISTON(new String(Character.toChars(0xF088A))),
        PITCHFORK(new String(Character.toChars(0xF1553))),
        PIZZA(new String(Character.toChars(0xF0409))),
        PLANE_CAR(new String(Character.toChars(0xF1AFF))),
        PLANE_TRAIN(new String(Character.toChars(0xF1B00))),
        PLAY(new String(Character.toChars(0xF040A))),
        PLAY_BOX(new String(Character.toChars(0xF127A))),
        PLAY_BOX_EDIT_OUTLINE(new String(Character.toChars(0xF1C3A))),
        PLAY_BOX_LOCK(new String(Character.toChars(0xF1A16))),
        PLAY_BOX_LOCK_OPEN(new String(Character.toChars(0xF1A17))),
        PLAY_BOX_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1A18))),
        PLAY_BOX_LOCK_OUTLINE(new String(Character.toChars(0xF1A19))),
        PLAY_BOX_MULTIPLE(new String(Character.toChars(0xF0D19))),
        PLAY_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF13E6))),
        PLAY_BOX_OUTLINE(new String(Character.toChars(0xF040B))),
        PLAY_CIRCLE(new String(Character.toChars(0xF040C))),
        PLAY_CIRCLE_OUTLINE(new String(Character.toChars(0xF040D))),
        PLAY_NETWORK(new String(Character.toChars(0xF088B))),
        PLAY_NETWORK_OUTLINE(new String(Character.toChars(0xF0CB7))),
        PLAY_OUTLINE(new String(Character.toChars(0xF0F1B))),
        PLAY_PAUSE(new String(Character.toChars(0xF040E))),
        PLAY_PROTECTED_CONTENT(new String(Character.toChars(0xF040F))),
        PLAY_SPEED(new String(Character.toChars(0xF08FF))),
        PLAYLIST_CHECK(new String(Character.toChars(0xF05C7))),
        PLAYLIST_EDIT(new String(Character.toChars(0xF0900))),
        PLAYLIST_MINUS(new String(Character.toChars(0xF0410))),
        PLAYLIST_MUSIC(new String(Character.toChars(0xF0CB8))),
        PLAYLIST_MUSIC_OUTLINE(new String(Character.toChars(0xF0CB9))),
        PLAYLIST_PLAY(new String(Character.toChars(0xF0411))),
        PLAYLIST_PLUS(new String(Character.toChars(0xF0412))),
        PLAYLIST_REMOVE(new String(Character.toChars(0xF0413))),
        PLAYLIST_STAR(new String(Character.toChars(0xF0DF2))),
        PLEX(new String(Character.toChars(0xF06BA))),
        PLIERS(new String(Character.toChars(0xF19A4))),
        PLUS(new String(Character.toChars(0xF0415))),
        PLUS_BOX(new String(Character.toChars(0xF0416))),
        PLUS_BOX_MULTIPLE(new String(Character.toChars(0xF0334))),
        PLUS_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1143))),
        PLUS_BOX_OUTLINE(new String(Character.toChars(0xF0704))),
        PLUS_CIRCLE(new String(Character.toChars(0xF0417))),
        PLUS_CIRCLE_MULTIPLE(new String(Character.toChars(0xF034C))),
        PLUS_CIRCLE_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0418))),
        PLUS_CIRCLE_OUTLINE(new String(Character.toChars(0xF0419))),
        PLUS_LOCK(new String(Character.toChars(0xF1A5D))),
        PLUS_LOCK_OPEN(new String(Character.toChars(0xF1A5E))),
        PLUS_MINUS(new String(Character.toChars(0xF0992))),
        PLUS_MINUS_BOX(new String(Character.toChars(0xF0993))),
        PLUS_MINUS_VARIANT(new String(Character.toChars(0xF14C9))),
        PLUS_NETWORK(new String(Character.toChars(0xF041A))),
        PLUS_NETWORK_OUTLINE(new String(Character.toChars(0xF0CBA))),
        PLUS_OUTLINE(new String(Character.toChars(0xF0705))),
        PLUS_THICK(new String(Character.toChars(0xF11EC))),
        PODCAST(new String(Character.toChars(0xF0994))),
        PODIUM(new String(Character.toChars(0xF0D25))),
        PODIUM_BRONZE(new String(Character.toChars(0xF0D26))),
        PODIUM_GOLD(new String(Character.toChars(0xF0D27))),
        PODIUM_SILVER(new String(Character.toChars(0xF0D28))),
        POINT_OF_SALE(new String(Character.toChars(0xF0D92))),
        POKEBALL(new String(Character.toChars(0xF041D))),
        POKEMON_GO(new String(Character.toChars(0xF0A09))),
        POKER_CHIP(new String(Character.toChars(0xF0830))),
        POLAROID(new String(Character.toChars(0xF041E))),
        POLICE_BADGE(new String(Character.toChars(0xF1167))),
        POLICE_BADGE_OUTLINE(new String(Character.toChars(0xF1168))),
        POLICE_STATION(new String(Character.toChars(0xF1839))),
        POLL(new String(Character.toChars(0xF041F))),
        POLO(new String(Character.toChars(0xF14C3))),
        POLYMER(new String(Character.toChars(0xF0421))),
        POOL(new String(Character.toChars(0xF0606))),
        POOL_THERMOMETER(new String(Character.toChars(0xF1A5F))),
        POPCORN(new String(Character.toChars(0xF0422))),
        POST(new String(Character.toChars(0xF1008))),
        POST_LAMP(new String(Character.toChars(0xF1A60))),
        POST_OUTLINE(new String(Character.toChars(0xF1009))),
        POSTAGE_STAMP(new String(Character.toChars(0xF0CBB))),
        POT(new String(Character.toChars(0xF02E5))),
        POT_MIX(new String(Character.toChars(0xF065B))),
        POT_MIX_OUTLINE(new String(Character.toChars(0xF0677))),
        POT_OUTLINE(new String(Character.toChars(0xF02FF))),
        POT_STEAM(new String(Character.toChars(0xF065A))),
        POT_STEAM_OUTLINE(new String(Character.toChars(0xF0326))),
        POUND(new String(Character.toChars(0xF0423))),
        POUND_BOX(new String(Character.toChars(0xF0424))),
        POUND_BOX_OUTLINE(new String(Character.toChars(0xF117F))),
        POWER(new String(Character.toChars(0xF0425))),
        POWER_CYCLE(new String(Character.toChars(0xF0901))),
        POWER_OFF(new String(Character.toChars(0xF0902))),
        POWER_ON(new String(Character.toChars(0xF0903))),
        POWER_PLUG(new String(Character.toChars(0xF06A5))),
        POWER_PLUG_BATTERY(new String(Character.toChars(0xF1C3B))),
        POWER_PLUG_BATTERY_OUTLINE(new String(Character.toChars(0xF1C3C))),
        POWER_PLUG_OFF(new String(Character.toChars(0xF06A6))),
        POWER_PLUG_OFF_OUTLINE(new String(Character.toChars(0xF1424))),
        POWER_PLUG_OUTLINE(new String(Character.toChars(0xF1425))),
        POWER_SETTINGS(new String(Character.toChars(0xF0426))),
        POWER_SLEEP(new String(Character.toChars(0xF0904))),
        POWER_SOCKET(new String(Character.toChars(0xF0427))),
        POWER_SOCKET_AU(new String(Character.toChars(0xF0905))),
        POWER_SOCKET_CH(new String(Character.toChars(0xF0FB3))),
        POWER_SOCKET_DE(new String(Character.toChars(0xF1107))),
        POWER_SOCKET_EU(new String(Character.toChars(0xF07E7))),
        POWER_SOCKET_FR(new String(Character.toChars(0xF1108))),
        POWER_SOCKET_IT(new String(Character.toChars(0xF14FF))),
        POWER_SOCKET_JP(new String(Character.toChars(0xF1109))),
        POWER_SOCKET_UK(new String(Character.toChars(0xF07E8))),
        POWER_SOCKET_US(new String(Character.toChars(0xF07E9))),
        POWER_STANDBY(new String(Character.toChars(0xF0906))),
        POWERSHELL(new String(Character.toChars(0xF0A0A))),
        PRESCRIPTION(new String(Character.toChars(0xF0706))),
        PRESENTATION(new String(Character.toChars(0xF0428))),
        PRESENTATION_PLAY(new String(Character.toChars(0xF0429))),
        PRETZEL(new String(Character.toChars(0xF1562))),
        PRINTER(new String(Character.toChars(0xF042A))),
        PRINTER_3D(new String(Character.toChars(0xF042B))),
        PRINTER_3D_NOZZLE(new String(Character.toChars(0xF0E5B))),
        PRINTER_3D_NOZZLE_ALERT(new String(Character.toChars(0xF11C0))),
        PRINTER_3D_NOZZLE_ALERT_OUTLINE(new String(Character.toChars(0xF11C1))),
        PRINTER_3D_NOZZLE_HEAT(new String(Character.toChars(0xF18B8))),
        PRINTER_3D_NOZZLE_HEAT_OUTLINE(new String(Character.toChars(0xF18B9))),
        PRINTER_3D_NOZZLE_OFF(new String(Character.toChars(0xF1B19))),
        PRINTER_3D_NOZZLE_OFF_OUTLINE(new String(Character.toChars(0xF1B1A))),
        PRINTER_3D_NOZZLE_OUTLINE(new String(Character.toChars(0xF0E5C))),
        PRINTER_3D_OFF(new String(Character.toChars(0xF1B0E))),
        PRINTER_ALERT(new String(Character.toChars(0xF042C))),
        PRINTER_CHECK(new String(Character.toChars(0xF1146))),
        PRINTER_EYE(new String(Character.toChars(0xF1458))),
        PRINTER_OFF(new String(Character.toChars(0xF0E5D))),
        PRINTER_OFF_OUTLINE(new String(Character.toChars(0xF1785))),
        PRINTER_OUTLINE(new String(Character.toChars(0xF1786))),
        PRINTER_POS(new String(Character.toChars(0xF1057))),
        PRINTER_POS_ALERT(new String(Character.toChars(0xF1BBC))),
        PRINTER_POS_ALERT_OUTLINE(new String(Character.toChars(0xF1BBD))),
        PRINTER_POS_CANCEL(new String(Character.toChars(0xF1BBE))),
        PRINTER_POS_CANCEL_OUTLINE(new String(Character.toChars(0xF1BBF))),
        PRINTER_POS_CHECK(new String(Character.toChars(0xF1BC0))),
        PRINTER_POS_CHECK_OUTLINE(new String(Character.toChars(0xF1BC1))),
        PRINTER_POS_COG(new String(Character.toChars(0xF1BC2))),
        PRINTER_POS_COG_OUTLINE(new String(Character.toChars(0xF1BC3))),
        PRINTER_POS_EDIT(new String(Character.toChars(0xF1BC4))),
        PRINTER_POS_EDIT_OUTLINE(new String(Character.toChars(0xF1BC5))),
        PRINTER_POS_MINUS(new String(Character.toChars(0xF1BC6))),
        PRINTER_POS_MINUS_OUTLINE(new String(Character.toChars(0xF1BC7))),
        PRINTER_POS_NETWORK(new String(Character.toChars(0xF1BC8))),
        PRINTER_POS_NETWORK_OUTLINE(new String(Character.toChars(0xF1BC9))),
        PRINTER_POS_OFF(new String(Character.toChars(0xF1BCA))),
        PRINTER_POS_OFF_OUTLINE(new String(Character.toChars(0xF1BCB))),
        PRINTER_POS_OUTLINE(new String(Character.toChars(0xF1BCC))),
        PRINTER_POS_PAUSE(new String(Character.toChars(0xF1BCD))),
        PRINTER_POS_PAUSE_OUTLINE(new String(Character.toChars(0xF1BCE))),
        PRINTER_POS_PLAY(new String(Character.toChars(0xF1BCF))),
        PRINTER_POS_PLAY_OUTLINE(new String(Character.toChars(0xF1BD0))),
        PRINTER_POS_PLUS(new String(Character.toChars(0xF1BD1))),
        PRINTER_POS_PLUS_OUTLINE(new String(Character.toChars(0xF1BD2))),
        PRINTER_POS_REFRESH(new String(Character.toChars(0xF1BD3))),
        PRINTER_POS_REFRESH_OUTLINE(new String(Character.toChars(0xF1BD4))),
        PRINTER_POS_REMOVE(new String(Character.toChars(0xF1BD5))),
        PRINTER_POS_REMOVE_OUTLINE(new String(Character.toChars(0xF1BD6))),
        PRINTER_POS_STAR(new String(Character.toChars(0xF1BD7))),
        PRINTER_POS_STAR_OUTLINE(new String(Character.toChars(0xF1BD8))),
        PRINTER_POS_STOP(new String(Character.toChars(0xF1BD9))),
        PRINTER_POS_STOP_OUTLINE(new String(Character.toChars(0xF1BDA))),
        PRINTER_POS_SYNC(new String(Character.toChars(0xF1BDB))),
        PRINTER_POS_SYNC_OUTLINE(new String(Character.toChars(0xF1BDC))),
        PRINTER_POS_WRENCH(new String(Character.toChars(0xF1BDD))),
        PRINTER_POS_WRENCH_OUTLINE(new String(Character.toChars(0xF1BDE))),
        PRINTER_SEARCH(new String(Character.toChars(0xF1457))),
        PRINTER_SETTINGS(new String(Character.toChars(0xF0707))),
        PRINTER_WIRELESS(new String(Character.toChars(0xF0A0B))),
        PRIORITY_HIGH(new String(Character.toChars(0xF0603))),
        PRIORITY_LOW(new String(Character.toChars(0xF0604))),
        PROFESSIONAL_HEXAGON(new String(Character.toChars(0xF042D))),
        PROGRESS_ALERT(new String(Character.toChars(0xF0CBC))),
        PROGRESS_CHECK(new String(Character.toChars(0xF0995))),
        PROGRESS_CLOCK(new String(Character.toChars(0xF0996))),
        PROGRESS_CLOSE(new String(Character.toChars(0xF110A))),
        PROGRESS_DOWNLOAD(new String(Character.toChars(0xF0997))),
        PROGRESS_HELPER(new String(Character.toChars(0xF1BA2))),
        PROGRESS_PENCIL(new String(Character.toChars(0xF1787))),
        PROGRESS_QUESTION(new String(Character.toChars(0xF1522))),
        PROGRESS_STAR(new String(Character.toChars(0xF1788))),
        PROGRESS_STAR_FOUR_POINTS(new String(Character.toChars(0xF1C3D))),
        PROGRESS_UPLOAD(new String(Character.toChars(0xF0998))),
        PROGRESS_WRENCH(new String(Character.toChars(0xF0CBD))),
        PROJECTOR(new String(Character.toChars(0xF042E))),
        PROJECTOR_OFF(new String(Character.toChars(0xF1A23))),
        PROJECTOR_SCREEN(new String(Character.toChars(0xF042F))),
        PROJECTOR_SCREEN_OFF(new String(Character.toChars(0xF180D))),
        PROJECTOR_SCREEN_OFF_OUTLINE(new String(Character.toChars(0xF180E))),
        PROJECTOR_SCREEN_OUTLINE(new String(Character.toChars(0xF1724))),
        PROJECTOR_SCREEN_VARIANT(new String(Character.toChars(0xF180F))),
        PROJECTOR_SCREEN_VARIANT_OFF(new String(Character.toChars(0xF1810))),
        PROJECTOR_SCREEN_VARIANT_OFF_OUTLINE(new String(Character.toChars(0xF1811))),
        PROJECTOR_SCREEN_VARIANT_OUTLINE(new String(Character.toChars(0xF1812))),
        PROPANE_TANK(new String(Character.toChars(0xF1357))),
        PROPANE_TANK_OUTLINE(new String(Character.toChars(0xF1358))),
        PROTOCOL(new String(Character.toChars(0xF0FD8))),
        PUBLISH(new String(Character.toChars(0xF06A7))),
        PUBLISH_OFF(new String(Character.toChars(0xF1945))),
        PULSE(new String(Character.toChars(0xF0430))),
        PUMP(new String(Character.toChars(0xF1402))),
        PUMP_OFF(new String(Character.toChars(0xF1B22))),
        PUMPKIN(new String(Character.toChars(0xF0BBF))),
        PURSE(new String(Character.toChars(0xF0F1C))),
        PURSE_OUTLINE(new String(Character.toChars(0xF0F1D))),
        PUZZLE(new String(Character.toChars(0xF0431))),
        PUZZLE_CHECK(new String(Character.toChars(0xF1426))),
        PUZZLE_CHECK_OUTLINE(new String(Character.toChars(0xF1427))),
        PUZZLE_EDIT(new String(Character.toChars(0xF14D3))),
        PUZZLE_EDIT_OUTLINE(new String(Character.toChars(0xF14D9))),
        PUZZLE_HEART(new String(Character.toChars(0xF14D4))),
        PUZZLE_HEART_OUTLINE(new String(Character.toChars(0xF14DA))),
        PUZZLE_MINUS(new String(Character.toChars(0xF14D1))),
        PUZZLE_MINUS_OUTLINE(new String(Character.toChars(0xF14D7))),
        PUZZLE_OUTLINE(new String(Character.toChars(0xF0A66))),
        PUZZLE_PLUS(new String(Character.toChars(0xF14D0))),
        PUZZLE_PLUS_OUTLINE(new String(Character.toChars(0xF14D6))),
        PUZZLE_REMOVE(new String(Character.toChars(0xF14D2))),
        PUZZLE_REMOVE_OUTLINE(new String(Character.toChars(0xF14D8))),
        PUZZLE_STAR(new String(Character.toChars(0xF14D5))),
        PUZZLE_STAR_OUTLINE(new String(Character.toChars(0xF14DB))),
        PYRAMID(new String(Character.toChars(0xF1952))),
        PYRAMID_OFF(new String(Character.toChars(0xF1953)));

        private final String unicode;

        P(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public P getDefaultGlyph()
        {
            return P.PAC_MAN;
        }
    }

    public enum Q implements MaterialDesignIconGlyphs<Q> {

        QI(new String(Character.toChars(0xF0999))),
        QQCHAT(new String(Character.toChars(0xF0605))),
        QRCODE(new String(Character.toChars(0xF0432))),
        QRCODE_EDIT(new String(Character.toChars(0xF08B8))),
        QRCODE_MINUS(new String(Character.toChars(0xF118C))),
        QRCODE_PLUS(new String(Character.toChars(0xF118B))),
        QRCODE_REMOVE(new String(Character.toChars(0xF118D))),
        QRCODE_SCAN(new String(Character.toChars(0xF0433))),
        QUADCOPTER(new String(Character.toChars(0xF0434))),
        QUALITY_HIGH(new String(Character.toChars(0xF0435))),
        QUALITY_LOW(new String(Character.toChars(0xF0A0C))),
        QUALITY_MEDIUM(new String(Character.toChars(0xF0A0D))),
        QUORA(new String(Character.toChars(0xF0D29)));

        private final String unicode;

        Q(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public Q getDefaultGlyph()
        {
            return Q.QI;
        }
    }

    public enum R implements MaterialDesignIconGlyphs<R> {

        RABBIT(new String(Character.toChars(0xF0907))),
        RABBIT_VARIANT(new String(Character.toChars(0xF1A61))),
        RABBIT_VARIANT_OUTLINE(new String(Character.toChars(0xF1A62))),
        RACING_HELMET(new String(Character.toChars(0xF0D93))),
        RACQUETBALL(new String(Character.toChars(0xF0D94))),
        RADAR(new String(Character.toChars(0xF0437))),
        RADIATOR(new String(Character.toChars(0xF0438))),
        RADIATOR_DISABLED(new String(Character.toChars(0xF0AD7))),
        RADIATOR_OFF(new String(Character.toChars(0xF0AD8))),
        RADIO(new String(Character.toChars(0xF0439))),
        RADIO_AM(new String(Character.toChars(0xF0CBE))),
        RADIO_FM(new String(Character.toChars(0xF0CBF))),
        RADIO_HANDHELD(new String(Character.toChars(0xF043A))),
        RADIO_OFF(new String(Character.toChars(0xF121C))),
        RADIO_TOWER(new String(Character.toChars(0xF043B))),
        RADIOACTIVE(new String(Character.toChars(0xF043C))),
        RADIOACTIVE_CIRCLE(new String(Character.toChars(0xF185D))),
        RADIOACTIVE_CIRCLE_OUTLINE(new String(Character.toChars(0xF185E))),
        RADIOACTIVE_OFF(new String(Character.toChars(0xF0EC1))),
        RADIOBOX_BLANK(new String(Character.toChars(0xF043D))),
        RADIOBOX_INDETERMINATE_VARIANT(new String(Character.toChars(0xF1C5E))),
        RADIOBOX_MARKED(new String(Character.toChars(0xF043E))),
        RADIOLOGY_BOX(new String(Character.toChars(0xF14C5))),
        RADIOLOGY_BOX_OUTLINE(new String(Character.toChars(0xF14C6))),
        RADIUS(new String(Character.toChars(0xF0CC0))),
        RADIUS_OUTLINE(new String(Character.toChars(0xF0CC1))),
        RAILROAD_LIGHT(new String(Character.toChars(0xF0F1E))),
        RAKE(new String(Character.toChars(0xF1544))),
        RASPBERRY_PI(new String(Character.toChars(0xF043F))),
        RAW(new String(Character.toChars(0xF1A0F))),
        RAW_OFF(new String(Character.toChars(0xF1A10))),
        RAY_END(new String(Character.toChars(0xF0440))),
        RAY_END_ARROW(new String(Character.toChars(0xF0441))),
        RAY_START(new String(Character.toChars(0xF0442))),
        RAY_START_ARROW(new String(Character.toChars(0xF0443))),
        RAY_START_END(new String(Character.toChars(0xF0444))),
        RAY_START_VERTEX_END(new String(Character.toChars(0xF15D8))),
        RAY_VERTEX(new String(Character.toChars(0xF0445))),
        RAZOR_DOUBLE_EDGE(new String(Character.toChars(0xF1997))),
        RAZOR_SINGLE_EDGE(new String(Character.toChars(0xF1998))),
        REACT(new String(Character.toChars(0xF0708))),
        READ(new String(Character.toChars(0xF0447))),
        RECEIPT(new String(Character.toChars(0xF0824))),
        RECEIPT_CLOCK(new String(Character.toChars(0xF1C3E))),
        RECEIPT_CLOCK_OUTLINE(new String(Character.toChars(0xF1C3F))),
        RECEIPT_OUTLINE(new String(Character.toChars(0xF04F7))),
        RECEIPT_SEND(new String(Character.toChars(0xF1C40))),
        RECEIPT_SEND_OUTLINE(new String(Character.toChars(0xF1C41))),
        RECEIPT_TEXT(new String(Character.toChars(0xF0449))),
        RECEIPT_TEXT_ARROW_LEFT(new String(Character.toChars(0xF1C42))),
        RECEIPT_TEXT_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF1C43))),
        RECEIPT_TEXT_ARROW_RIGHT(new String(Character.toChars(0xF1C44))),
        RECEIPT_TEXT_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1C45))),
        RECEIPT_TEXT_CHECK(new String(Character.toChars(0xF1A63))),
        RECEIPT_TEXT_CHECK_OUTLINE(new String(Character.toChars(0xF1A64))),
        RECEIPT_TEXT_CLOCK(new String(Character.toChars(0xF1C46))),
        RECEIPT_TEXT_CLOCK_OUTLINE(new String(Character.toChars(0xF1C47))),
        RECEIPT_TEXT_EDIT(new String(Character.toChars(0xF1C48))),
        RECEIPT_TEXT_EDIT_OUTLINE(new String(Character.toChars(0xF1C49))),
        RECEIPT_TEXT_MINUS(new String(Character.toChars(0xF1A65))),
        RECEIPT_TEXT_MINUS_OUTLINE(new String(Character.toChars(0xF1A66))),
        RECEIPT_TEXT_OUTLINE(new String(Character.toChars(0xF19DC))),
        RECEIPT_TEXT_PLUS(new String(Character.toChars(0xF1A67))),
        RECEIPT_TEXT_PLUS_OUTLINE(new String(Character.toChars(0xF1A68))),
        RECEIPT_TEXT_REMOVE(new String(Character.toChars(0xF1A69))),
        RECEIPT_TEXT_REMOVE_OUTLINE(new String(Character.toChars(0xF1A6A))),
        RECEIPT_TEXT_SEND(new String(Character.toChars(0xF1C4A))),
        RECEIPT_TEXT_SEND_OUTLINE(new String(Character.toChars(0xF1C4B))),
        RECORD(new String(Character.toChars(0xF044A))),
        RECORD_CIRCLE(new String(Character.toChars(0xF0EC2))),
        RECORD_CIRCLE_OUTLINE(new String(Character.toChars(0xF0EC3))),
        RECORD_PLAYER(new String(Character.toChars(0xF099A))),
        RECORD_REC(new String(Character.toChars(0xF044B))),
        RECTANGLE(new String(Character.toChars(0xF0E5E))),
        RECTANGLE_OUTLINE(new String(Character.toChars(0xF0E5F))),
        RECYCLE(new String(Character.toChars(0xF044C))),
        RECYCLE_VARIANT(new String(Character.toChars(0xF139D))),
        REDDIT(new String(Character.toChars(0xF044D))),
        REDHAT(new String(Character.toChars(0xF111B))),
        REDO(new String(Character.toChars(0xF044E))),
        REDO_VARIANT(new String(Character.toChars(0xF044F))),
        REFLECT_HORIZONTAL(new String(Character.toChars(0xF0A0E))),
        REFLECT_VERTICAL(new String(Character.toChars(0xF0A0F))),
        REFRESH(new String(Character.toChars(0xF0450))),
        REFRESH_AUTO(new String(Character.toChars(0xF18F2))),
        REFRESH_CIRCLE(new String(Character.toChars(0xF1377))),
        REGEX(new String(Character.toChars(0xF0451))),
        REGISTERED_TRADEMARK(new String(Character.toChars(0xF0A67))),
        REITERATE(new String(Character.toChars(0xF1588))),
        RELATION_MANY_TO_MANY(new String(Character.toChars(0xF1496))),
        RELATION_MANY_TO_ONE(new String(Character.toChars(0xF1497))),
        RELATION_MANY_TO_ONE_OR_MANY(new String(Character.toChars(0xF1498))),
        RELATION_MANY_TO_ONLY_ONE(new String(Character.toChars(0xF1499))),
        RELATION_MANY_TO_ZERO_OR_MANY(new String(Character.toChars(0xF149A))),
        RELATION_MANY_TO_ZERO_OR_ONE(new String(Character.toChars(0xF149B))),
        RELATION_ONE_OR_MANY_TO_MANY(new String(Character.toChars(0xF149C))),
        RELATION_ONE_OR_MANY_TO_ONE(new String(Character.toChars(0xF149D))),
        RELATION_ONE_OR_MANY_TO_ONE_OR_MANY(new String(Character.toChars(0xF149E))),
        RELATION_ONE_OR_MANY_TO_ONLY_ONE(new String(Character.toChars(0xF149F))),
        RELATION_ONE_OR_MANY_TO_ZERO_OR_MANY(new String(Character.toChars(0xF14A0))),
        RELATION_ONE_OR_MANY_TO_ZERO_OR_ONE(new String(Character.toChars(0xF14A1))),
        RELATION_ONE_TO_MANY(new String(Character.toChars(0xF14A2))),
        RELATION_ONE_TO_ONE(new String(Character.toChars(0xF14A3))),
        RELATION_ONE_TO_ONE_OR_MANY(new String(Character.toChars(0xF14A4))),
        RELATION_ONE_TO_ONLY_ONE(new String(Character.toChars(0xF14A5))),
        RELATION_ONE_TO_ZERO_OR_MANY(new String(Character.toChars(0xF14A6))),
        RELATION_ONE_TO_ZERO_OR_ONE(new String(Character.toChars(0xF14A7))),
        RELATION_ONLY_ONE_TO_MANY(new String(Character.toChars(0xF14A8))),
        RELATION_ONLY_ONE_TO_ONE(new String(Character.toChars(0xF14A9))),
        RELATION_ONLY_ONE_TO_ONE_OR_MANY(new String(Character.toChars(0xF14AA))),
        RELATION_ONLY_ONE_TO_ONLY_ONE(new String(Character.toChars(0xF14AB))),
        RELATION_ONLY_ONE_TO_ZERO_OR_MANY(new String(Character.toChars(0xF14AC))),
        RELATION_ONLY_ONE_TO_ZERO_OR_ONE(new String(Character.toChars(0xF14AD))),
        RELATION_ZERO_OR_MANY_TO_MANY(new String(Character.toChars(0xF14AE))),
        RELATION_ZERO_OR_MANY_TO_ONE(new String(Character.toChars(0xF14AF))),
        RELATION_ZERO_OR_MANY_TO_ONE_OR_MANY(new String(Character.toChars(0xF14B0))),
        RELATION_ZERO_OR_MANY_TO_ONLY_ONE(new String(Character.toChars(0xF14B1))),
        RELATION_ZERO_OR_MANY_TO_ZERO_OR_MANY(new String(Character.toChars(0xF14B2))),
        RELATION_ZERO_OR_MANY_TO_ZERO_OR_ONE(new String(Character.toChars(0xF14B3))),
        RELATION_ZERO_OR_ONE_TO_MANY(new String(Character.toChars(0xF14B4))),
        RELATION_ZERO_OR_ONE_TO_ONE(new String(Character.toChars(0xF14B5))),
        RELATION_ZERO_OR_ONE_TO_ONE_OR_MANY(new String(Character.toChars(0xF14B6))),
        RELATION_ZERO_OR_ONE_TO_ONLY_ONE(new String(Character.toChars(0xF14B7))),
        RELATION_ZERO_OR_ONE_TO_ZERO_OR_MANY(new String(Character.toChars(0xF14B8))),
        RELATION_ZERO_OR_ONE_TO_ZERO_OR_ONE(new String(Character.toChars(0xF14B9))),
        RELATIVE_SCALE(new String(Character.toChars(0xF0452))),
        RELOAD(new String(Character.toChars(0xF0453))),
        RELOAD_ALERT(new String(Character.toChars(0xF110B))),
        REMINDER(new String(Character.toChars(0xF088C))),
        REMOTE(new String(Character.toChars(0xF0454))),
        REMOTE_DESKTOP(new String(Character.toChars(0xF08B9))),
        REMOTE_OFF(new String(Character.toChars(0xF0EC4))),
        REMOTE_TV(new String(Character.toChars(0xF0EC5))),
        REMOTE_TV_OFF(new String(Character.toChars(0xF0EC6))),
        RENAME(new String(Character.toChars(0xF1C18))),
        RENAME_BOX(new String(Character.toChars(0xF0455))),
        RENAME_BOX_OUTLINE(new String(Character.toChars(0xF1C19))),
        RENAME_OUTLINE(new String(Character.toChars(0xF1C1A))),
        REORDER_HORIZONTAL(new String(Character.toChars(0xF0688))),
        REORDER_VERTICAL(new String(Character.toChars(0xF0689))),
        REPEAT(new String(Character.toChars(0xF0456))),
        REPEAT_OFF(new String(Character.toChars(0xF0457))),
        REPEAT_ONCE(new String(Character.toChars(0xF0458))),
        REPEAT_VARIANT(new String(Character.toChars(0xF0547))),
        REPLAY(new String(Character.toChars(0xF0459))),
        REPLY(new String(Character.toChars(0xF045A))),
        REPLY_ALL(new String(Character.toChars(0xF045B))),
        REPLY_ALL_OUTLINE(new String(Character.toChars(0xF0F1F))),
        REPLY_CIRCLE(new String(Character.toChars(0xF11AE))),
        REPLY_OUTLINE(new String(Character.toChars(0xF0F20))),
        REPRODUCTION(new String(Character.toChars(0xF045C))),
        RESISTOR(new String(Character.toChars(0xF0B44))),
        RESISTOR_NODES(new String(Character.toChars(0xF0B45))),
        RESIZE(new String(Character.toChars(0xF0A68))),
        RESIZE_BOTTOM_RIGHT(new String(Character.toChars(0xF045D))),
        RESPONSIVE(new String(Character.toChars(0xF045E))),
        RESTART(new String(Character.toChars(0xF0709))),
        RESTART_ALERT(new String(Character.toChars(0xF110C))),
        RESTART_OFF(new String(Character.toChars(0xF0D95))),
        RESTORE(new String(Character.toChars(0xF099B))),
        RESTORE_ALERT(new String(Character.toChars(0xF110D))),
        REWIND(new String(Character.toChars(0xF045F))),
        REWIND_10(new String(Character.toChars(0xF0D2A))),
        REWIND_15(new String(Character.toChars(0xF1946))),
        REWIND_30(new String(Character.toChars(0xF0D96))),
        REWIND_45(new String(Character.toChars(0xF1B13))),
        REWIND_5(new String(Character.toChars(0xF11F9))),
        REWIND_60(new String(Character.toChars(0xF160C))),
        REWIND_OUTLINE(new String(Character.toChars(0xF070A))),
        RHOMBUS(new String(Character.toChars(0xF070B))),
        RHOMBUS_MEDIUM(new String(Character.toChars(0xF0A10))),
        RHOMBUS_MEDIUM_OUTLINE(new String(Character.toChars(0xF14DC))),
        RHOMBUS_OUTLINE(new String(Character.toChars(0xF070C))),
        RHOMBUS_SPLIT(new String(Character.toChars(0xF0A11))),
        RHOMBUS_SPLIT_OUTLINE(new String(Character.toChars(0xF14DD))),
        RIBBON(new String(Character.toChars(0xF0460))),
        RICE(new String(Character.toChars(0xF07EA))),
        RICKSHAW(new String(Character.toChars(0xF15BB))),
        RICKSHAW_ELECTRIC(new String(Character.toChars(0xF15BC))),
        RING(new String(Character.toChars(0xF07EB))),
        RIVET(new String(Character.toChars(0xF0E60))),
        ROAD(new String(Character.toChars(0xF0461))),
        ROAD_VARIANT(new String(Character.toChars(0xF0462))),
        ROBBER(new String(Character.toChars(0xF1058))),
        ROBOT(new String(Character.toChars(0xF06A9))),
        ROBOT_ANGRY(new String(Character.toChars(0xF169D))),
        ROBOT_ANGRY_OUTLINE(new String(Character.toChars(0xF169E))),
        ROBOT_CONFUSED(new String(Character.toChars(0xF169F))),
        ROBOT_CONFUSED_OUTLINE(new String(Character.toChars(0xF16A0))),
        ROBOT_DEAD(new String(Character.toChars(0xF16A1))),
        ROBOT_DEAD_OUTLINE(new String(Character.toChars(0xF16A2))),
        ROBOT_EXCITED(new String(Character.toChars(0xF16A3))),
        ROBOT_EXCITED_OUTLINE(new String(Character.toChars(0xF16A4))),
        ROBOT_HAPPY(new String(Character.toChars(0xF1719))),
        ROBOT_HAPPY_OUTLINE(new String(Character.toChars(0xF171A))),
        ROBOT_INDUSTRIAL(new String(Character.toChars(0xF0B46))),
        ROBOT_INDUSTRIAL_OUTLINE(new String(Character.toChars(0xF1A1A))),
        ROBOT_LOVE(new String(Character.toChars(0xF16A5))),
        ROBOT_LOVE_OUTLINE(new String(Character.toChars(0xF16A6))),
        ROBOT_MOWER(new String(Character.toChars(0xF11F7))),
        ROBOT_MOWER_OUTLINE(new String(Character.toChars(0xF11F3))),
        ROBOT_OFF(new String(Character.toChars(0xF16A7))),
        ROBOT_OFF_OUTLINE(new String(Character.toChars(0xF167B))),
        ROBOT_OUTLINE(new String(Character.toChars(0xF167A))),
        ROBOT_VACUUM(new String(Character.toChars(0xF070D))),
        ROBOT_VACUUM_ALERT(new String(Character.toChars(0xF1B5D))),
        ROBOT_VACUUM_OFF(new String(Character.toChars(0xF1C01))),
        ROBOT_VACUUM_VARIANT(new String(Character.toChars(0xF0908))),
        ROBOT_VACUUM_VARIANT_ALERT(new String(Character.toChars(0xF1B5E))),
        ROBOT_VACUUM_VARIANT_OFF(new String(Character.toChars(0xF1C02))),
        ROCKET(new String(Character.toChars(0xF0463))),
        ROCKET_LAUNCH(new String(Character.toChars(0xF14DE))),
        ROCKET_LAUNCH_OUTLINE(new String(Character.toChars(0xF14DF))),
        ROCKET_OUTLINE(new String(Character.toChars(0xF13AF))),
        RODENT(new String(Character.toChars(0xF1327))),
        ROLLER_SHADE(new String(Character.toChars(0xF1A6B))),
        ROLLER_SHADE_CLOSED(new String(Character.toChars(0xF1A6C))),
        ROLLER_SKATE(new String(Character.toChars(0xF0D2B))),
        ROLLER_SKATE_OFF(new String(Character.toChars(0xF0145))),
        ROLLERBLADE(new String(Character.toChars(0xF0D2C))),
        ROLLERBLADE_OFF(new String(Character.toChars(0xF002E))),
        ROLLUPJS(new String(Character.toChars(0xF0BC0))),
        ROLODEX(new String(Character.toChars(0xF1AB9))),
        ROLODEX_OUTLINE(new String(Character.toChars(0xF1ABA))),
        ROMAN_NUMERAL_1(new String(Character.toChars(0xF1088))),
        ROMAN_NUMERAL_10(new String(Character.toChars(0xF1091))),
        ROMAN_NUMERAL_2(new String(Character.toChars(0xF1089))),
        ROMAN_NUMERAL_3(new String(Character.toChars(0xF108A))),
        ROMAN_NUMERAL_4(new String(Character.toChars(0xF108B))),
        ROMAN_NUMERAL_5(new String(Character.toChars(0xF108C))),
        ROMAN_NUMERAL_6(new String(Character.toChars(0xF108D))),
        ROMAN_NUMERAL_7(new String(Character.toChars(0xF108E))),
        ROMAN_NUMERAL_8(new String(Character.toChars(0xF108F))),
        ROMAN_NUMERAL_9(new String(Character.toChars(0xF1090))),
        ROOM_SERVICE(new String(Character.toChars(0xF088D))),
        ROOM_SERVICE_OUTLINE(new String(Character.toChars(0xF0D97))),
        ROTATE_360(new String(Character.toChars(0xF1999))),
        ROTATE_3D(new String(Character.toChars(0xF0EC7))),
        ROTATE_3D_VARIANT(new String(Character.toChars(0xF0464))),
        ROTATE_LEFT(new String(Character.toChars(0xF0465))),
        ROTATE_LEFT_VARIANT(new String(Character.toChars(0xF0466))),
        ROTATE_ORBIT(new String(Character.toChars(0xF0D98))),
        ROTATE_RIGHT(new String(Character.toChars(0xF0467))),
        ROTATE_RIGHT_VARIANT(new String(Character.toChars(0xF0468))),
        ROUNDED_CORNER(new String(Character.toChars(0xF0607))),
        ROUTER(new String(Character.toChars(0xF11E2))),
        ROUTER_NETWORK(new String(Character.toChars(0xF1087))),
        ROUTER_WIRELESS(new String(Character.toChars(0xF0469))),
        ROUTER_WIRELESS_OFF(new String(Character.toChars(0xF15A3))),
        ROUTER_WIRELESS_SETTINGS(new String(Character.toChars(0xF0A69))),
        ROUTES(new String(Character.toChars(0xF046A))),
        ROUTES_CLOCK(new String(Character.toChars(0xF1059))),
        ROWING(new String(Character.toChars(0xF0608))),
        RSS(new String(Character.toChars(0xF046B))),
        RSS_BOX(new String(Character.toChars(0xF046C))),
        RSS_OFF(new String(Character.toChars(0xF0F21))),
        RUG(new String(Character.toChars(0xF1475))),
        RUGBY(new String(Character.toChars(0xF0D99))),
        RULER(new String(Character.toChars(0xF046D))),
        RULER_SQUARE(new String(Character.toChars(0xF0CC2))),
        RULER_SQUARE_COMPASS(new String(Character.toChars(0xF0EBE))),
        RUN(new String(Character.toChars(0xF070E))),
        RUN_FAST(new String(Character.toChars(0xF046E))),
        RV_TRUCK(new String(Character.toChars(0xF11D4)));

        private final String unicode;

        R(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public R getDefaultGlyph()
        {
            return R.RABBIT;
        }
    }

    public enum S implements MaterialDesignIconGlyphs<S> {

        SACK(new String(Character.toChars(0xF0D2E))),
        SACK_OUTLINE(new String(Character.toChars(0xF1C4C))),
        SACK_PERCENT(new String(Character.toChars(0xF0D2F))),
        SAFE(new String(Character.toChars(0xF0A6A))),
        SAFE_SQUARE(new String(Character.toChars(0xF127C))),
        SAFE_SQUARE_OUTLINE(new String(Character.toChars(0xF127D))),
        SAFETY_GOGGLES(new String(Character.toChars(0xF0D30))),
        SAIL_BOAT(new String(Character.toChars(0xF0EC8))),
        SAIL_BOAT_SINK(new String(Character.toChars(0xF1AEF))),
        SALE(new String(Character.toChars(0xF046F))),
        SALE_OUTLINE(new String(Character.toChars(0xF1A06))),
        SALESFORCE(new String(Character.toChars(0xF088E))),
        SASS(new String(Character.toChars(0xF07EC))),
        SATELLITE(new String(Character.toChars(0xF0470))),
        SATELLITE_UPLINK(new String(Character.toChars(0xF0909))),
        SATELLITE_VARIANT(new String(Character.toChars(0xF0471))),
        SAUSAGE(new String(Character.toChars(0xF08BA))),
        SAUSAGE_OFF(new String(Character.toChars(0xF1789))),
        SAW_BLADE(new String(Character.toChars(0xF0E61))),
        SAWTOOTH_WAVE(new String(Character.toChars(0xF147A))),
        SAXOPHONE(new String(Character.toChars(0xF0609))),
        SCALE(new String(Character.toChars(0xF0472))),
        SCALE_BALANCE(new String(Character.toChars(0xF05D1))),
        SCALE_BATHROOM(new String(Character.toChars(0xF0473))),
        SCALE_OFF(new String(Character.toChars(0xF105A))),
        SCALE_UNBALANCED(new String(Character.toChars(0xF19B8))),
        SCAN_HELPER(new String(Character.toChars(0xF13D8))),
        SCANNER(new String(Character.toChars(0xF06AB))),
        SCANNER_OFF(new String(Character.toChars(0xF090A))),
        SCATTER_PLOT(new String(Character.toChars(0xF0EC9))),
        SCATTER_PLOT_OUTLINE(new String(Character.toChars(0xF0ECA))),
        SCENT(new String(Character.toChars(0xF1958))),
        SCENT_OFF(new String(Character.toChars(0xF1959))),
        SCHOOL(new String(Character.toChars(0xF0474))),
        SCHOOL_OUTLINE(new String(Character.toChars(0xF1180))),
        SCISSORS_CUTTING(new String(Character.toChars(0xF0A6B))),
        SCOOTER(new String(Character.toChars(0xF15BD))),
        SCOOTER_ELECTRIC(new String(Character.toChars(0xF15BE))),
        SCOREBOARD(new String(Character.toChars(0xF127E))),
        SCOREBOARD_OUTLINE(new String(Character.toChars(0xF127F))),
        SCREEN_ROTATION(new String(Character.toChars(0xF0475))),
        SCREEN_ROTATION_LOCK(new String(Character.toChars(0xF0478))),
        SCREW_FLAT_TOP(new String(Character.toChars(0xF0DF3))),
        SCREW_LAG(new String(Character.toChars(0xF0DF4))),
        SCREW_MACHINE_FLAT_TOP(new String(Character.toChars(0xF0DF5))),
        SCREW_MACHINE_ROUND_TOP(new String(Character.toChars(0xF0DF6))),
        SCREW_ROUND_TOP(new String(Character.toChars(0xF0DF7))),
        SCREWDRIVER(new String(Character.toChars(0xF0476))),
        SCRIPT(new String(Character.toChars(0xF0BC1))),
        SCRIPT_OUTLINE(new String(Character.toChars(0xF0477))),
        SCRIPT_TEXT(new String(Character.toChars(0xF0BC2))),
        SCRIPT_TEXT_KEY(new String(Character.toChars(0xF1725))),
        SCRIPT_TEXT_KEY_OUTLINE(new String(Character.toChars(0xF1726))),
        SCRIPT_TEXT_OUTLINE(new String(Character.toChars(0xF0BC3))),
        SCRIPT_TEXT_PLAY(new String(Character.toChars(0xF1727))),
        SCRIPT_TEXT_PLAY_OUTLINE(new String(Character.toChars(0xF1728))),
        SD(new String(Character.toChars(0xF0479))),
        SEAL(new String(Character.toChars(0xF047A))),
        SEAL_VARIANT(new String(Character.toChars(0xF0FD9))),
        SEARCH_WEB(new String(Character.toChars(0xF070F))),
        SEAT(new String(Character.toChars(0xF0CC3))),
        SEAT_FLAT(new String(Character.toChars(0xF047B))),
        SEAT_FLAT_ANGLED(new String(Character.toChars(0xF047C))),
        SEAT_INDIVIDUAL_SUITE(new String(Character.toChars(0xF047D))),
        SEAT_LEGROOM_EXTRA(new String(Character.toChars(0xF047E))),
        SEAT_LEGROOM_NORMAL(new String(Character.toChars(0xF047F))),
        SEAT_LEGROOM_REDUCED(new String(Character.toChars(0xF0480))),
        SEAT_OUTLINE(new String(Character.toChars(0xF0CC4))),
        SEAT_PASSENGER(new String(Character.toChars(0xF1249))),
        SEAT_RECLINE_EXTRA(new String(Character.toChars(0xF0481))),
        SEAT_RECLINE_NORMAL(new String(Character.toChars(0xF0482))),
        SEATBELT(new String(Character.toChars(0xF0CC5))),
        SECURITY(new String(Character.toChars(0xF0483))),
        SECURITY_NETWORK(new String(Character.toChars(0xF0484))),
        SEED(new String(Character.toChars(0xF0E62))),
        SEED_OFF(new String(Character.toChars(0xF13FD))),
        SEED_OFF_OUTLINE(new String(Character.toChars(0xF13FE))),
        SEED_OUTLINE(new String(Character.toChars(0xF0E63))),
        SEED_PLUS(new String(Character.toChars(0xF1A6D))),
        SEED_PLUS_OUTLINE(new String(Character.toChars(0xF1A6E))),
        SEESAW(new String(Character.toChars(0xF15A4))),
        SEGMENT(new String(Character.toChars(0xF0ECB))),
        SELECT(new String(Character.toChars(0xF0485))),
        SELECT_ALL(new String(Character.toChars(0xF0486))),
        SELECT_ARROW_DOWN(new String(Character.toChars(0xF1B59))),
        SELECT_ARROW_UP(new String(Character.toChars(0xF1B58))),
        SELECT_COLOR(new String(Character.toChars(0xF0D31))),
        SELECT_COMPARE(new String(Character.toChars(0xF0AD9))),
        SELECT_DRAG(new String(Character.toChars(0xF0A6C))),
        SELECT_GROUP(new String(Character.toChars(0xF0F82))),
        SELECT_INVERSE(new String(Character.toChars(0xF0487))),
        SELECT_MARKER(new String(Character.toChars(0xF1280))),
        SELECT_MULTIPLE(new String(Character.toChars(0xF1281))),
        SELECT_MULTIPLE_MARKER(new String(Character.toChars(0xF1282))),
        SELECT_OFF(new String(Character.toChars(0xF0488))),
        SELECT_PLACE(new String(Character.toChars(0xF0FDA))),
        SELECT_REMOVE(new String(Character.toChars(0xF17C1))),
        SELECT_SEARCH(new String(Character.toChars(0xF1204))),
        SELECTION(new String(Character.toChars(0xF0489))),
        SELECTION_DRAG(new String(Character.toChars(0xF0A6D))),
        SELECTION_ELLIPSE(new String(Character.toChars(0xF0D32))),
        SELECTION_ELLIPSE_ARROW_INSIDE(new String(Character.toChars(0xF0F22))),
        SELECTION_ELLIPSE_REMOVE(new String(Character.toChars(0xF17C2))),
        SELECTION_MARKER(new String(Character.toChars(0xF1283))),
        SELECTION_MULTIPLE(new String(Character.toChars(0xF1285))),
        SELECTION_MULTIPLE_MARKER(new String(Character.toChars(0xF1284))),
        SELECTION_OFF(new String(Character.toChars(0xF0777))),
        SELECTION_REMOVE(new String(Character.toChars(0xF17C3))),
        SELECTION_SEARCH(new String(Character.toChars(0xF1205))),
        SEMANTIC_WEB(new String(Character.toChars(0xF1316))),
        SEND(new String(Character.toChars(0xF048A))),
        SEND_CHECK(new String(Character.toChars(0xF1161))),
        SEND_CHECK_OUTLINE(new String(Character.toChars(0xF1162))),
        SEND_CIRCLE(new String(Character.toChars(0xF0DF8))),
        SEND_CIRCLE_OUTLINE(new String(Character.toChars(0xF0DF9))),
        SEND_CLOCK(new String(Character.toChars(0xF1163))),
        SEND_CLOCK_OUTLINE(new String(Character.toChars(0xF1164))),
        SEND_LOCK(new String(Character.toChars(0xF07ED))),
        SEND_LOCK_OUTLINE(new String(Character.toChars(0xF1166))),
        SEND_OUTLINE(new String(Character.toChars(0xF1165))),
        SEND_VARIANT(new String(Character.toChars(0xF1C4D))),
        SEND_VARIANT_CLOCK(new String(Character.toChars(0xF1C7E))),
        SEND_VARIANT_CLOCK_OUTLINE(new String(Character.toChars(0xF1C7F))),
        SEND_VARIANT_OUTLINE(new String(Character.toChars(0xF1C4E))),
        SERIAL_PORT(new String(Character.toChars(0xF065C))),
        SERVER(new String(Character.toChars(0xF048B))),
        SERVER_MINUS(new String(Character.toChars(0xF048C))),
        SERVER_NETWORK(new String(Character.toChars(0xF048D))),
        SERVER_NETWORK_OFF(new String(Character.toChars(0xF048E))),
        SERVER_OFF(new String(Character.toChars(0xF048F))),
        SERVER_PLUS(new String(Character.toChars(0xF0490))),
        SERVER_REMOVE(new String(Character.toChars(0xF0491))),
        SERVER_SECURITY(new String(Character.toChars(0xF0492))),
        SET_ALL(new String(Character.toChars(0xF0778))),
        SET_CENTER(new String(Character.toChars(0xF0779))),
        SET_CENTER_RIGHT(new String(Character.toChars(0xF077A))),
        SET_LEFT(new String(Character.toChars(0xF077B))),
        SET_LEFT_CENTER(new String(Character.toChars(0xF077C))),
        SET_LEFT_RIGHT(new String(Character.toChars(0xF077D))),
        SET_MERGE(new String(Character.toChars(0xF14E0))),
        SET_NONE(new String(Character.toChars(0xF077E))),
        SET_RIGHT(new String(Character.toChars(0xF077F))),
        SET_SPLIT(new String(Character.toChars(0xF14E1))),
        SET_SQUARE(new String(Character.toChars(0xF145D))),
        SET_TOP_BOX(new String(Character.toChars(0xF099F))),
        SETTINGS_HELPER(new String(Character.toChars(0xF0A6E))),
        SHAKER(new String(Character.toChars(0xF110E))),
        SHAKER_OUTLINE(new String(Character.toChars(0xF110F))),
        SHAPE(new String(Character.toChars(0xF0831))),
        SHAPE_CIRCLE_PLUS(new String(Character.toChars(0xF065D))),
        SHAPE_OUTLINE(new String(Character.toChars(0xF0832))),
        SHAPE_OVAL_PLUS(new String(Character.toChars(0xF11FA))),
        SHAPE_PLUS(new String(Character.toChars(0xF0495))),
        SHAPE_PLUS_OUTLINE(new String(Character.toChars(0xF1C4F))),
        SHAPE_POLYGON_PLUS(new String(Character.toChars(0xF065E))),
        SHAPE_RECTANGLE_PLUS(new String(Character.toChars(0xF065F))),
        SHAPE_SQUARE_PLUS(new String(Character.toChars(0xF0660))),
        SHAPE_SQUARE_ROUNDED_PLUS(new String(Character.toChars(0xF14FA))),
        SHARE(new String(Character.toChars(0xF0496))),
        SHARE_ALL(new String(Character.toChars(0xF11F4))),
        SHARE_ALL_OUTLINE(new String(Character.toChars(0xF11F5))),
        SHARE_CIRCLE(new String(Character.toChars(0xF11AD))),
        SHARE_OFF(new String(Character.toChars(0xF0F23))),
        SHARE_OFF_OUTLINE(new String(Character.toChars(0xF0F24))),
        SHARE_OUTLINE(new String(Character.toChars(0xF0932))),
        SHARE_VARIANT(new String(Character.toChars(0xF0497))),
        SHARE_VARIANT_OUTLINE(new String(Character.toChars(0xF1514))),
        SHARK(new String(Character.toChars(0xF18BA))),
        SHARK_FIN(new String(Character.toChars(0xF1673))),
        SHARK_FIN_OUTLINE(new String(Character.toChars(0xF1674))),
        SHARK_OFF(new String(Character.toChars(0xF18BB))),
        SHEEP(new String(Character.toChars(0xF0CC6))),
        SHIELD(new String(Character.toChars(0xF0498))),
        SHIELD_ACCOUNT(new String(Character.toChars(0xF088F))),
        SHIELD_ACCOUNT_OUTLINE(new String(Character.toChars(0xF0A12))),
        SHIELD_ACCOUNT_VARIANT(new String(Character.toChars(0xF15A7))),
        SHIELD_ACCOUNT_VARIANT_OUTLINE(new String(Character.toChars(0xF15A8))),
        SHIELD_AIRPLANE(new String(Character.toChars(0xF06BB))),
        SHIELD_AIRPLANE_OUTLINE(new String(Character.toChars(0xF0CC7))),
        SHIELD_ALERT(new String(Character.toChars(0xF0ECC))),
        SHIELD_ALERT_OUTLINE(new String(Character.toChars(0xF0ECD))),
        SHIELD_BUG(new String(Character.toChars(0xF13DA))),
        SHIELD_BUG_OUTLINE(new String(Character.toChars(0xF13DB))),
        SHIELD_CAR(new String(Character.toChars(0xF0F83))),
        SHIELD_CHECK(new String(Character.toChars(0xF0565))),
        SHIELD_CHECK_OUTLINE(new String(Character.toChars(0xF0CC8))),
        SHIELD_CROSS(new String(Character.toChars(0xF0CC9))),
        SHIELD_CROSS_OUTLINE(new String(Character.toChars(0xF0CCA))),
        SHIELD_CROWN(new String(Character.toChars(0xF18BC))),
        SHIELD_CROWN_OUTLINE(new String(Character.toChars(0xF18BD))),
        SHIELD_EDIT(new String(Character.toChars(0xF11A0))),
        SHIELD_EDIT_OUTLINE(new String(Character.toChars(0xF11A1))),
        SHIELD_HALF(new String(Character.toChars(0xF1360))),
        SHIELD_HALF_FULL(new String(Character.toChars(0xF0780))),
        SHIELD_HOME(new String(Character.toChars(0xF068A))),
        SHIELD_HOME_OUTLINE(new String(Character.toChars(0xF0CCB))),
        SHIELD_KEY(new String(Character.toChars(0xF0BC4))),
        SHIELD_KEY_OUTLINE(new String(Character.toChars(0xF0BC5))),
        SHIELD_LINK_VARIANT(new String(Character.toChars(0xF0D33))),
        SHIELD_LINK_VARIANT_OUTLINE(new String(Character.toChars(0xF0D34))),
        SHIELD_LOCK(new String(Character.toChars(0xF099D))),
        SHIELD_LOCK_OPEN(new String(Character.toChars(0xF199A))),
        SHIELD_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF199B))),
        SHIELD_LOCK_OUTLINE(new String(Character.toChars(0xF0CCC))),
        SHIELD_MOON(new String(Character.toChars(0xF1828))),
        SHIELD_MOON_OUTLINE(new String(Character.toChars(0xF1829))),
        SHIELD_OFF(new String(Character.toChars(0xF099E))),
        SHIELD_OFF_OUTLINE(new String(Character.toChars(0xF099C))),
        SHIELD_OUTLINE(new String(Character.toChars(0xF0499))),
        SHIELD_PLUS(new String(Character.toChars(0xF0ADA))),
        SHIELD_PLUS_OUTLINE(new String(Character.toChars(0xF0ADB))),
        SHIELD_REFRESH(new String(Character.toChars(0xF00AA))),
        SHIELD_REFRESH_OUTLINE(new String(Character.toChars(0xF01E0))),
        SHIELD_REMOVE(new String(Character.toChars(0xF0ADC))),
        SHIELD_REMOVE_OUTLINE(new String(Character.toChars(0xF0ADD))),
        SHIELD_SEARCH(new String(Character.toChars(0xF0D9A))),
        SHIELD_STAR(new String(Character.toChars(0xF113B))),
        SHIELD_STAR_OUTLINE(new String(Character.toChars(0xF113C))),
        SHIELD_SUN(new String(Character.toChars(0xF105D))),
        SHIELD_SUN_OUTLINE(new String(Character.toChars(0xF105E))),
        SHIELD_SWORD(new String(Character.toChars(0xF18BE))),
        SHIELD_SWORD_OUTLINE(new String(Character.toChars(0xF18BF))),
        SHIELD_SYNC(new String(Character.toChars(0xF11A2))),
        SHIELD_SYNC_OUTLINE(new String(Character.toChars(0xF11A3))),
        SHIMMER(new String(Character.toChars(0xF1545))),
        SHIP_WHEEL(new String(Character.toChars(0xF0833))),
        SHIPPING_PALLET(new String(Character.toChars(0xF184E))),
        SHOE_BALLET(new String(Character.toChars(0xF15CA))),
        SHOE_CLEAT(new String(Character.toChars(0xF15C7))),
        SHOE_FORMAL(new String(Character.toChars(0xF0B47))),
        SHOE_HEEL(new String(Character.toChars(0xF0B48))),
        SHOE_PRINT(new String(Character.toChars(0xF0DFA))),
        SHOE_SNEAKER(new String(Character.toChars(0xF15C8))),
        SHOPPING(new String(Character.toChars(0xF049A))),
        SHOPPING_MUSIC(new String(Character.toChars(0xF049B))),
        SHOPPING_OUTLINE(new String(Character.toChars(0xF11D5))),
        SHOPPING_SEARCH(new String(Character.toChars(0xF0F84))),
        SHOPPING_SEARCH_OUTLINE(new String(Character.toChars(0xF1A6F))),
        SHORE(new String(Character.toChars(0xF14F9))),
        SHOVEL(new String(Character.toChars(0xF0710))),
        SHOVEL_OFF(new String(Character.toChars(0xF0711))),
        SHOWER(new String(Character.toChars(0xF09A0))),
        SHOWER_HEAD(new String(Character.toChars(0xF09A1))),
        SHREDDER(new String(Character.toChars(0xF049C))),
        SHUFFLE(new String(Character.toChars(0xF049D))),
        SHUFFLE_DISABLED(new String(Character.toChars(0xF049E))),
        SHUFFLE_VARIANT(new String(Character.toChars(0xF049F))),
        SHURIKEN(new String(Character.toChars(0xF137F))),
        SICKLE(new String(Character.toChars(0xF18C0))),
        SIGMA(new String(Character.toChars(0xF04A0))),
        SIGMA_LOWER(new String(Character.toChars(0xF062B))),
        SIGN_CAUTION(new String(Character.toChars(0xF04A1))),
        SIGN_DIRECTION(new String(Character.toChars(0xF0781))),
        SIGN_DIRECTION_MINUS(new String(Character.toChars(0xF1000))),
        SIGN_DIRECTION_PLUS(new String(Character.toChars(0xF0FDC))),
        SIGN_DIRECTION_REMOVE(new String(Character.toChars(0xF0FDD))),
        SIGN_LANGUAGE(new String(Character.toChars(0xF1B4D))),
        SIGN_LANGUAGE_OUTLINE(new String(Character.toChars(0xF1B4E))),
        SIGN_POLE(new String(Character.toChars(0xF14F8))),
        SIGN_REAL_ESTATE(new String(Character.toChars(0xF1118))),
        SIGN_TEXT(new String(Character.toChars(0xF0782))),
        SIGN_YIELD(new String(Character.toChars(0xF1BAF))),
        SIGNAL(new String(Character.toChars(0xF04A2))),
        SIGNAL_2G(new String(Character.toChars(0xF0712))),
        SIGNAL_3G(new String(Character.toChars(0xF0713))),
        SIGNAL_4G(new String(Character.toChars(0xF0714))),
        SIGNAL_5G(new String(Character.toChars(0xF0A6F))),
        SIGNAL_CELLULAR_1(new String(Character.toChars(0xF08BC))),
        SIGNAL_CELLULAR_2(new String(Character.toChars(0xF08BD))),
        SIGNAL_CELLULAR_3(new String(Character.toChars(0xF08BE))),
        SIGNAL_CELLULAR_OUTLINE(new String(Character.toChars(0xF08BF))),
        SIGNAL_DISTANCE_VARIANT(new String(Character.toChars(0xF0E64))),
        SIGNAL_HSPA(new String(Character.toChars(0xF0715))),
        SIGNAL_HSPA_PLUS(new String(Character.toChars(0xF0716))),
        SIGNAL_OFF(new String(Character.toChars(0xF0783))),
        SIGNAL_VARIANT(new String(Character.toChars(0xF060A))),
        SIGNATURE(new String(Character.toChars(0xF0DFB))),
        SIGNATURE_FREEHAND(new String(Character.toChars(0xF0DFC))),
        SIGNATURE_IMAGE(new String(Character.toChars(0xF0DFD))),
        SIGNATURE_TEXT(new String(Character.toChars(0xF0DFE))),
        SILO(new String(Character.toChars(0xF1B9F))),
        SILO_OUTLINE(new String(Character.toChars(0xF0B49))),
        SILVERWARE(new String(Character.toChars(0xF04A3))),
        SILVERWARE_CLEAN(new String(Character.toChars(0xF0FDE))),
        SILVERWARE_FORK(new String(Character.toChars(0xF04A4))),
        SILVERWARE_FORK_KNIFE(new String(Character.toChars(0xF0A70))),
        SILVERWARE_SPOON(new String(Character.toChars(0xF04A5))),
        SILVERWARE_VARIANT(new String(Character.toChars(0xF04A6))),
        SIM(new String(Character.toChars(0xF04A7))),
        SIM_ALERT(new String(Character.toChars(0xF04A8))),
        SIM_ALERT_OUTLINE(new String(Character.toChars(0xF15D3))),
        SIM_OFF(new String(Character.toChars(0xF04A9))),
        SIM_OFF_OUTLINE(new String(Character.toChars(0xF15D4))),
        SIM_OUTLINE(new String(Character.toChars(0xF15D5))),
        SIMPLE_ICONS(new String(Character.toChars(0xF131D))),
        SINA_WEIBO(new String(Character.toChars(0xF0ADF))),
        SINE_WAVE(new String(Character.toChars(0xF095B))),
        SITEMAP(new String(Character.toChars(0xF04AA))),
        SITEMAP_OUTLINE(new String(Character.toChars(0xF199C))),
        SIZE_L(new String(Character.toChars(0xF13A6))),
        SIZE_M(new String(Character.toChars(0xF13A5))),
        SIZE_S(new String(Character.toChars(0xF13A4))),
        SIZE_XL(new String(Character.toChars(0xF13A7))),
        SIZE_XS(new String(Character.toChars(0xF13A3))),
        SIZE_XXL(new String(Character.toChars(0xF13A8))),
        SIZE_XXS(new String(Character.toChars(0xF13A2))),
        SIZE_XXXL(new String(Character.toChars(0xF13A9))),
        SKATE(new String(Character.toChars(0xF0D35))),
        SKATE_OFF(new String(Character.toChars(0xF0699))),
        SKATEBOARD(new String(Character.toChars(0xF14C2))),
        SKATEBOARDING(new String(Character.toChars(0xF0501))),
        SKEW_LESS(new String(Character.toChars(0xF0D36))),
        SKEW_MORE(new String(Character.toChars(0xF0D37))),
        SKI(new String(Character.toChars(0xF1304))),
        SKI_CROSS_COUNTRY(new String(Character.toChars(0xF1305))),
        SKI_WATER(new String(Character.toChars(0xF1306))),
        SKIP_BACKWARD(new String(Character.toChars(0xF04AB))),
        SKIP_BACKWARD_OUTLINE(new String(Character.toChars(0xF0F25))),
        SKIP_FORWARD(new String(Character.toChars(0xF04AC))),
        SKIP_FORWARD_OUTLINE(new String(Character.toChars(0xF0F26))),
        SKIP_NEXT(new String(Character.toChars(0xF04AD))),
        SKIP_NEXT_CIRCLE(new String(Character.toChars(0xF0661))),
        SKIP_NEXT_CIRCLE_OUTLINE(new String(Character.toChars(0xF0662))),
        SKIP_NEXT_OUTLINE(new String(Character.toChars(0xF0F27))),
        SKIP_PREVIOUS(new String(Character.toChars(0xF04AE))),
        SKIP_PREVIOUS_CIRCLE(new String(Character.toChars(0xF0663))),
        SKIP_PREVIOUS_CIRCLE_OUTLINE(new String(Character.toChars(0xF0664))),
        SKIP_PREVIOUS_OUTLINE(new String(Character.toChars(0xF0F28))),
        SKULL(new String(Character.toChars(0xF068C))),
        SKULL_CROSSBONES(new String(Character.toChars(0xF0BC6))),
        SKULL_CROSSBONES_OUTLINE(new String(Character.toChars(0xF0BC7))),
        SKULL_OUTLINE(new String(Character.toChars(0xF0BC8))),
        SKULL_SCAN(new String(Character.toChars(0xF14C7))),
        SKULL_SCAN_OUTLINE(new String(Character.toChars(0xF14C8))),
        SKYPE(new String(Character.toChars(0xF04AF))),
        SKYPE_BUSINESS(new String(Character.toChars(0xF04B0))),
        SLACK(new String(Character.toChars(0xF04B1))),
        SLASH_FORWARD(new String(Character.toChars(0xF0FDF))),
        SLASH_FORWARD_BOX(new String(Character.toChars(0xF0FE0))),
        SLEDDING(new String(Character.toChars(0xF041B))),
        SLEEP(new String(Character.toChars(0xF04B2))),
        SLEEP_OFF(new String(Character.toChars(0xF04B3))),
        SLIDE(new String(Character.toChars(0xF15A5))),
        SLOPE_DOWNHILL(new String(Character.toChars(0xF0DFF))),
        SLOPE_UPHILL(new String(Character.toChars(0xF0E00))),
        SLOT_MACHINE(new String(Character.toChars(0xF1114))),
        SLOT_MACHINE_OUTLINE(new String(Character.toChars(0xF1115))),
        SMART_CARD(new String(Character.toChars(0xF10BD))),
        SMART_CARD_OFF(new String(Character.toChars(0xF18F7))),
        SMART_CARD_OFF_OUTLINE(new String(Character.toChars(0xF18F8))),
        SMART_CARD_OUTLINE(new String(Character.toChars(0xF10BE))),
        SMART_CARD_READER(new String(Character.toChars(0xF10BF))),
        SMART_CARD_READER_OUTLINE(new String(Character.toChars(0xF10C0))),
        SMOG(new String(Character.toChars(0xF0A71))),
        SMOKE(new String(Character.toChars(0xF1799))),
        SMOKE_DETECTOR(new String(Character.toChars(0xF0392))),
        SMOKE_DETECTOR_ALERT(new String(Character.toChars(0xF192E))),
        SMOKE_DETECTOR_ALERT_OUTLINE(new String(Character.toChars(0xF192F))),
        SMOKE_DETECTOR_OFF(new String(Character.toChars(0xF1809))),
        SMOKE_DETECTOR_OFF_OUTLINE(new String(Character.toChars(0xF180A))),
        SMOKE_DETECTOR_OUTLINE(new String(Character.toChars(0xF1808))),
        SMOKE_DETECTOR_VARIANT(new String(Character.toChars(0xF180B))),
        SMOKE_DETECTOR_VARIANT_ALERT(new String(Character.toChars(0xF1930))),
        SMOKE_DETECTOR_VARIANT_OFF(new String(Character.toChars(0xF180C))),
        SMOKING(new String(Character.toChars(0xF04B4))),
        SMOKING_OFF(new String(Character.toChars(0xF04B5))),
        SMOKING_PIPE(new String(Character.toChars(0xF140D))),
        SMOKING_PIPE_OFF(new String(Character.toChars(0xF1428))),
        SNAIL(new String(Character.toChars(0xF1677))),
        SNAKE(new String(Character.toChars(0xF150E))),
        SNAPCHAT(new String(Character.toChars(0xF04B6))),
        SNOWBOARD(new String(Character.toChars(0xF1307))),
        SNOWFLAKE(new String(Character.toChars(0xF0717))),
        SNOWFLAKE_ALERT(new String(Character.toChars(0xF0F29))),
        SNOWFLAKE_CHECK(new String(Character.toChars(0xF1A70))),
        SNOWFLAKE_MELT(new String(Character.toChars(0xF12CB))),
        SNOWFLAKE_OFF(new String(Character.toChars(0xF14E3))),
        SNOWFLAKE_THERMOMETER(new String(Character.toChars(0xF1A71))),
        SNOWFLAKE_VARIANT(new String(Character.toChars(0xF0F2A))),
        SNOWMAN(new String(Character.toChars(0xF04B7))),
        SNOWMOBILE(new String(Character.toChars(0xF06DD))),
        SNOWSHOEING(new String(Character.toChars(0xF1A72))),
        SOCCER(new String(Character.toChars(0xF04B8))),
        SOCCER_FIELD(new String(Character.toChars(0xF0834))),
        SOCIAL_DISTANCE_2_METERS(new String(Character.toChars(0xF1579))),
        SOCIAL_DISTANCE_6_FEET(new String(Character.toChars(0xF157A))),
        SOFA(new String(Character.toChars(0xF04B9))),
        SOFA_OUTLINE(new String(Character.toChars(0xF156D))),
        SOFA_SINGLE(new String(Character.toChars(0xF156E))),
        SOFA_SINGLE_OUTLINE(new String(Character.toChars(0xF156F))),
        SOLAR_PANEL(new String(Character.toChars(0xF0D9B))),
        SOLAR_PANEL_LARGE(new String(Character.toChars(0xF0D9C))),
        SOLAR_POWER(new String(Character.toChars(0xF0A72))),
        SOLAR_POWER_VARIANT(new String(Character.toChars(0xF1A73))),
        SOLAR_POWER_VARIANT_OUTLINE(new String(Character.toChars(0xF1A74))),
        SOLDERING_IRON(new String(Character.toChars(0xF1092))),
        SOLID(new String(Character.toChars(0xF068D))),
        SONY_PLAYSTATION(new String(Character.toChars(0xF0414))),
        SORT(new String(Character.toChars(0xF04BA))),
        SORT_ALPHABETICAL_ASCENDING(new String(Character.toChars(0xF05BD))),
        SORT_ALPHABETICAL_ASCENDING_VARIANT(new String(Character.toChars(0xF1148))),
        SORT_ALPHABETICAL_DESCENDING(new String(Character.toChars(0xF05BF))),
        SORT_ALPHABETICAL_DESCENDING_VARIANT(new String(Character.toChars(0xF1149))),
        SORT_ALPHABETICAL_VARIANT(new String(Character.toChars(0xF04BB))),
        SORT_ASCENDING(new String(Character.toChars(0xF04BC))),
        SORT_BOOL_ASCENDING(new String(Character.toChars(0xF1385))),
        SORT_BOOL_ASCENDING_VARIANT(new String(Character.toChars(0xF1386))),
        SORT_BOOL_DESCENDING(new String(Character.toChars(0xF1387))),
        SORT_BOOL_DESCENDING_VARIANT(new String(Character.toChars(0xF1388))),
        SORT_CALENDAR_ASCENDING(new String(Character.toChars(0xF1547))),
        SORT_CALENDAR_DESCENDING(new String(Character.toChars(0xF1548))),
        SORT_CLOCK_ASCENDING(new String(Character.toChars(0xF1549))),
        SORT_CLOCK_ASCENDING_OUTLINE(new String(Character.toChars(0xF154A))),
        SORT_CLOCK_DESCENDING(new String(Character.toChars(0xF154B))),
        SORT_CLOCK_DESCENDING_OUTLINE(new String(Character.toChars(0xF154C))),
        SORT_DESCENDING(new String(Character.toChars(0xF04BD))),
        SORT_NUMERIC_ASCENDING(new String(Character.toChars(0xF1389))),
        SORT_NUMERIC_ASCENDING_VARIANT(new String(Character.toChars(0xF090D))),
        SORT_NUMERIC_DESCENDING(new String(Character.toChars(0xF138A))),
        SORT_NUMERIC_DESCENDING_VARIANT(new String(Character.toChars(0xF0AD2))),
        SORT_NUMERIC_VARIANT(new String(Character.toChars(0xF04BE))),
        SORT_REVERSE_VARIANT(new String(Character.toChars(0xF033C))),
        SORT_VARIANT(new String(Character.toChars(0xF04BF))),
        SORT_VARIANT_LOCK(new String(Character.toChars(0xF0CCD))),
        SORT_VARIANT_LOCK_OPEN(new String(Character.toChars(0xF0CCE))),
        SORT_VARIANT_OFF(new String(Character.toChars(0xF1ABB))),
        SORT_VARIANT_REMOVE(new String(Character.toChars(0xF1147))),
        SOUNDBAR(new String(Character.toChars(0xF17DB))),
        SOUNDCLOUD(new String(Character.toChars(0xF04C0))),
        SOURCE_BRANCH(new String(Character.toChars(0xF062C))),
        SOURCE_BRANCH_CHECK(new String(Character.toChars(0xF14CF))),
        SOURCE_BRANCH_MINUS(new String(Character.toChars(0xF14CB))),
        SOURCE_BRANCH_PLUS(new String(Character.toChars(0xF14CA))),
        SOURCE_BRANCH_REFRESH(new String(Character.toChars(0xF14CD))),
        SOURCE_BRANCH_REMOVE(new String(Character.toChars(0xF14CC))),
        SOURCE_BRANCH_SYNC(new String(Character.toChars(0xF14CE))),
        SOURCE_COMMIT(new String(Character.toChars(0xF0718))),
        SOURCE_COMMIT_END(new String(Character.toChars(0xF0719))),
        SOURCE_COMMIT_END_LOCAL(new String(Character.toChars(0xF071A))),
        SOURCE_COMMIT_LOCAL(new String(Character.toChars(0xF071B))),
        SOURCE_COMMIT_NEXT_LOCAL(new String(Character.toChars(0xF071C))),
        SOURCE_COMMIT_START(new String(Character.toChars(0xF071D))),
        SOURCE_COMMIT_START_NEXT_LOCAL(new String(Character.toChars(0xF071E))),
        SOURCE_FORK(new String(Character.toChars(0xF04C1))),
        SOURCE_MERGE(new String(Character.toChars(0xF062D))),
        SOURCE_PULL(new String(Character.toChars(0xF04C2))),
        SOURCE_REPOSITORY(new String(Character.toChars(0xF0CCF))),
        SOURCE_REPOSITORY_MULTIPLE(new String(Character.toChars(0xF0CD0))),
        SOY_SAUCE(new String(Character.toChars(0xF07EE))),
        SOY_SAUCE_OFF(new String(Character.toChars(0xF13FC))),
        SPA(new String(Character.toChars(0xF0CD1))),
        SPA_OUTLINE(new String(Character.toChars(0xF0CD2))),
        SPACE_INVADERS(new String(Character.toChars(0xF0BC9))),
        SPACE_STATION(new String(Character.toChars(0xF1383))),
        SPADE(new String(Character.toChars(0xF0E65))),
        SPEAKER(new String(Character.toChars(0xF04C3))),
        SPEAKER_BLUETOOTH(new String(Character.toChars(0xF09A2))),
        SPEAKER_MESSAGE(new String(Character.toChars(0xF1B11))),
        SPEAKER_MULTIPLE(new String(Character.toChars(0xF0D38))),
        SPEAKER_OFF(new String(Character.toChars(0xF04C4))),
        SPEAKER_PAUSE(new String(Character.toChars(0xF1B73))),
        SPEAKER_PLAY(new String(Character.toChars(0xF1B72))),
        SPEAKER_STOP(new String(Character.toChars(0xF1B74))),
        SPEAKER_WIRELESS(new String(Character.toChars(0xF071F))),
        SPEAR(new String(Character.toChars(0xF1845))),
        SPEEDOMETER(new String(Character.toChars(0xF04C5))),
        SPEEDOMETER_MEDIUM(new String(Character.toChars(0xF0F85))),
        SPEEDOMETER_SLOW(new String(Character.toChars(0xF0F86))),
        SPELLCHECK(new String(Character.toChars(0xF04C6))),
        SPHERE(new String(Character.toChars(0xF1954))),
        SPHERE_OFF(new String(Character.toChars(0xF1955))),
        SPIDER(new String(Character.toChars(0xF11EA))),
        SPIDER_OUTLINE(new String(Character.toChars(0xF1C75))),
        SPIDER_THREAD(new String(Character.toChars(0xF11EB))),
        SPIDER_WEB(new String(Character.toChars(0xF0BCA))),
        SPIRIT_LEVEL(new String(Character.toChars(0xF14F1))),
        SPOON_SUGAR(new String(Character.toChars(0xF1429))),
        SPOTIFY(new String(Character.toChars(0xF04C7))),
        SPOTLIGHT(new String(Character.toChars(0xF04C8))),
        SPOTLIGHT_BEAM(new String(Character.toChars(0xF04C9))),
        SPRAY(new String(Character.toChars(0xF0665))),
        SPRAY_BOTTLE(new String(Character.toChars(0xF0AE0))),
        SPRINKLER(new String(Character.toChars(0xF105F))),
        SPRINKLER_FIRE(new String(Character.toChars(0xF199D))),
        SPRINKLER_VARIANT(new String(Character.toChars(0xF1060))),
        SPROUT(new String(Character.toChars(0xF0E66))),
        SPROUT_OUTLINE(new String(Character.toChars(0xF0E67))),
        SQUARE(new String(Character.toChars(0xF0764))),
        SQUARE_CIRCLE(new String(Character.toChars(0xF1500))),
        SQUARE_CIRCLE_OUTLINE(new String(Character.toChars(0xF1C50))),
        SQUARE_EDIT_OUTLINE(new String(Character.toChars(0xF090C))),
        SQUARE_MEDIUM(new String(Character.toChars(0xF0A13))),
        SQUARE_MEDIUM_OUTLINE(new String(Character.toChars(0xF0A14))),
        SQUARE_OFF(new String(Character.toChars(0xF12EE))),
        SQUARE_OFF_OUTLINE(new String(Character.toChars(0xF12EF))),
        SQUARE_OPACITY(new String(Character.toChars(0xF1854))),
        SQUARE_OUTLINE(new String(Character.toChars(0xF0763))),
        SQUARE_ROOT(new String(Character.toChars(0xF0784))),
        SQUARE_ROOT_BOX(new String(Character.toChars(0xF09A3))),
        SQUARE_ROUNDED(new String(Character.toChars(0xF14FB))),
        SQUARE_ROUNDED_BADGE(new String(Character.toChars(0xF1A07))),
        SQUARE_ROUNDED_BADGE_OUTLINE(new String(Character.toChars(0xF1A08))),
        SQUARE_ROUNDED_OUTLINE(new String(Character.toChars(0xF14FC))),
        SQUARE_SMALL(new String(Character.toChars(0xF0A15))),
        SQUARE_WAVE(new String(Character.toChars(0xF147B))),
        SQUEEGEE(new String(Character.toChars(0xF0AE1))),
        SSH(new String(Character.toChars(0xF08C0))),
        STACK_EXCHANGE(new String(Character.toChars(0xF060B))),
        STACK_OVERFLOW(new String(Character.toChars(0xF04CC))),
        STACKPATH(new String(Character.toChars(0xF0359))),
        STADIUM(new String(Character.toChars(0xF0FF9))),
        STADIUM_OUTLINE(new String(Character.toChars(0xF1B03))),
        STADIUM_VARIANT(new String(Character.toChars(0xF0720))),
        STAIRS(new String(Character.toChars(0xF04CD))),
        STAIRS_BOX(new String(Character.toChars(0xF139E))),
        STAIRS_DOWN(new String(Character.toChars(0xF12BE))),
        STAIRS_UP(new String(Character.toChars(0xF12BD))),
        STAMPER(new String(Character.toChars(0xF0D39))),
        STANDARD_DEFINITION(new String(Character.toChars(0xF07EF))),
        STAR(new String(Character.toChars(0xF04CE))),
        STAR_BOX(new String(Character.toChars(0xF0A73))),
        STAR_BOX_MULTIPLE(new String(Character.toChars(0xF1286))),
        STAR_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF1287))),
        STAR_BOX_OUTLINE(new String(Character.toChars(0xF0A74))),
        STAR_CHECK(new String(Character.toChars(0xF1566))),
        STAR_CHECK_OUTLINE(new String(Character.toChars(0xF156A))),
        STAR_CIRCLE(new String(Character.toChars(0xF04CF))),
        STAR_CIRCLE_OUTLINE(new String(Character.toChars(0xF09A4))),
        STAR_COG(new String(Character.toChars(0xF1668))),
        STAR_COG_OUTLINE(new String(Character.toChars(0xF1669))),
        STAR_CRESCENT(new String(Character.toChars(0xF0979))),
        STAR_DAVID(new String(Character.toChars(0xF097A))),
        STAR_FACE(new String(Character.toChars(0xF09A5))),
        STAR_FOUR_POINTS(new String(Character.toChars(0xF0AE2))),
        STAR_FOUR_POINTS_BOX(new String(Character.toChars(0xF1C51))),
        STAR_FOUR_POINTS_BOX_OUTLINE(new String(Character.toChars(0xF1C52))),
        STAR_FOUR_POINTS_CIRCLE(new String(Character.toChars(0xF1C53))),
        STAR_FOUR_POINTS_CIRCLE_OUTLINE(new String(Character.toChars(0xF1C54))),
        STAR_FOUR_POINTS_OUTLINE(new String(Character.toChars(0xF0AE3))),
        STAR_FOUR_POINTS_SMALL(new String(Character.toChars(0xF1C55))),
        STAR_HALF(new String(Character.toChars(0xF0246))),
        STAR_HALF_FULL(new String(Character.toChars(0xF04D0))),
        STAR_MINUS(new String(Character.toChars(0xF1564))),
        STAR_MINUS_OUTLINE(new String(Character.toChars(0xF1568))),
        STAR_OFF(new String(Character.toChars(0xF04D1))),
        STAR_OFF_OUTLINE(new String(Character.toChars(0xF155B))),
        STAR_OUTLINE(new String(Character.toChars(0xF04D2))),
        STAR_PLUS(new String(Character.toChars(0xF1563))),
        STAR_PLUS_OUTLINE(new String(Character.toChars(0xF1567))),
        STAR_REMOVE(new String(Character.toChars(0xF1565))),
        STAR_REMOVE_OUTLINE(new String(Character.toChars(0xF1569))),
        STAR_SETTINGS(new String(Character.toChars(0xF166A))),
        STAR_SETTINGS_OUTLINE(new String(Character.toChars(0xF166B))),
        STAR_SHOOTING(new String(Character.toChars(0xF1741))),
        STAR_SHOOTING_OUTLINE(new String(Character.toChars(0xF1742))),
        STAR_THREE_POINTS(new String(Character.toChars(0xF0AE4))),
        STAR_THREE_POINTS_OUTLINE(new String(Character.toChars(0xF0AE5))),
        STATE_MACHINE(new String(Character.toChars(0xF11EF))),
        STEAM(new String(Character.toChars(0xF04D3))),
        STEERING(new String(Character.toChars(0xF04D4))),
        STEERING_OFF(new String(Character.toChars(0xF090E))),
        STEP_BACKWARD(new String(Character.toChars(0xF04D5))),
        STEP_BACKWARD_2(new String(Character.toChars(0xF04D6))),
        STEP_FORWARD(new String(Character.toChars(0xF04D7))),
        STEP_FORWARD_2(new String(Character.toChars(0xF04D8))),
        STETHOSCOPE(new String(Character.toChars(0xF04D9))),
        STICKER(new String(Character.toChars(0xF1364))),
        STICKER_ALERT(new String(Character.toChars(0xF1365))),
        STICKER_ALERT_OUTLINE(new String(Character.toChars(0xF1366))),
        STICKER_CHECK(new String(Character.toChars(0xF1367))),
        STICKER_CHECK_OUTLINE(new String(Character.toChars(0xF1368))),
        STICKER_CIRCLE_OUTLINE(new String(Character.toChars(0xF05D0))),
        STICKER_EMOJI(new String(Character.toChars(0xF0785))),
        STICKER_MINUS(new String(Character.toChars(0xF1369))),
        STICKER_MINUS_OUTLINE(new String(Character.toChars(0xF136A))),
        STICKER_OUTLINE(new String(Character.toChars(0xF136B))),
        STICKER_PLUS(new String(Character.toChars(0xF136C))),
        STICKER_PLUS_OUTLINE(new String(Character.toChars(0xF136D))),
        STICKER_REMOVE(new String(Character.toChars(0xF136E))),
        STICKER_REMOVE_OUTLINE(new String(Character.toChars(0xF136F))),
        STICKER_TEXT(new String(Character.toChars(0xF178E))),
        STICKER_TEXT_OUTLINE(new String(Character.toChars(0xF178F))),
        STOCKING(new String(Character.toChars(0xF04DA))),
        STOMACH(new String(Character.toChars(0xF1093))),
        STOOL(new String(Character.toChars(0xF195D))),
        STOOL_OUTLINE(new String(Character.toChars(0xF195E))),
        STOP(new String(Character.toChars(0xF04DB))),
        STOP_CIRCLE(new String(Character.toChars(0xF0666))),
        STOP_CIRCLE_OUTLINE(new String(Character.toChars(0xF0667))),
        STORAGE_TANK(new String(Character.toChars(0xF1A75))),
        STORAGE_TANK_OUTLINE(new String(Character.toChars(0xF1A76))),
        STORE(new String(Character.toChars(0xF04DC))),
        STORE_24_HOUR(new String(Character.toChars(0xF04DD))),
        STORE_ALERT(new String(Character.toChars(0xF18C1))),
        STORE_ALERT_OUTLINE(new String(Character.toChars(0xF18C2))),
        STORE_CHECK(new String(Character.toChars(0xF18C3))),
        STORE_CHECK_OUTLINE(new String(Character.toChars(0xF18C4))),
        STORE_CLOCK(new String(Character.toChars(0xF18C5))),
        STORE_CLOCK_OUTLINE(new String(Character.toChars(0xF18C6))),
        STORE_COG(new String(Character.toChars(0xF18C7))),
        STORE_COG_OUTLINE(new String(Character.toChars(0xF18C8))),
        STORE_EDIT(new String(Character.toChars(0xF18C9))),
        STORE_EDIT_OUTLINE(new String(Character.toChars(0xF18CA))),
        STORE_MARKER(new String(Character.toChars(0xF18CB))),
        STORE_MARKER_OUTLINE(new String(Character.toChars(0xF18CC))),
        STORE_MINUS(new String(Character.toChars(0xF165E))),
        STORE_MINUS_OUTLINE(new String(Character.toChars(0xF18CD))),
        STORE_OFF(new String(Character.toChars(0xF18CE))),
        STORE_OFF_OUTLINE(new String(Character.toChars(0xF18CF))),
        STORE_OUTLINE(new String(Character.toChars(0xF1361))),
        STORE_PLUS(new String(Character.toChars(0xF165F))),
        STORE_PLUS_OUTLINE(new String(Character.toChars(0xF18D0))),
        STORE_REMOVE(new String(Character.toChars(0xF1660))),
        STORE_REMOVE_OUTLINE(new String(Character.toChars(0xF18D1))),
        STORE_SEARCH(new String(Character.toChars(0xF18D2))),
        STORE_SEARCH_OUTLINE(new String(Character.toChars(0xF18D3))),
        STORE_SETTINGS(new String(Character.toChars(0xF18D4))),
        STORE_SETTINGS_OUTLINE(new String(Character.toChars(0xF18D5))),
        STOREFRONT(new String(Character.toChars(0xF07C7))),
        STOREFRONT_CHECK(new String(Character.toChars(0xF1B7D))),
        STOREFRONT_CHECK_OUTLINE(new String(Character.toChars(0xF1B7E))),
        STOREFRONT_EDIT(new String(Character.toChars(0xF1B7F))),
        STOREFRONT_EDIT_OUTLINE(new String(Character.toChars(0xF1B80))),
        STOREFRONT_MINUS(new String(Character.toChars(0xF1B83))),
        STOREFRONT_MINUS_OUTLINE(new String(Character.toChars(0xF1B84))),
        STOREFRONT_OUTLINE(new String(Character.toChars(0xF10C1))),
        STOREFRONT_PLUS(new String(Character.toChars(0xF1B81))),
        STOREFRONT_PLUS_OUTLINE(new String(Character.toChars(0xF1B82))),
        STOREFRONT_REMOVE(new String(Character.toChars(0xF1B85))),
        STOREFRONT_REMOVE_OUTLINE(new String(Character.toChars(0xF1B86))),
        STOVE(new String(Character.toChars(0xF04DE))),
        STRATEGY(new String(Character.toChars(0xF11D6))),
        STRETCH_TO_PAGE(new String(Character.toChars(0xF0F2B))),
        STRETCH_TO_PAGE_OUTLINE(new String(Character.toChars(0xF0F2C))),
        STRING_LIGHTS(new String(Character.toChars(0xF12BA))),
        STRING_LIGHTS_OFF(new String(Character.toChars(0xF12BB))),
        SUBDIRECTORY_ARROW_LEFT(new String(Character.toChars(0xF060C))),
        SUBDIRECTORY_ARROW_RIGHT(new String(Character.toChars(0xF060D))),
        SUBMARINE(new String(Character.toChars(0xF156C))),
        SUBTITLES(new String(Character.toChars(0xF0A16))),
        SUBTITLES_OUTLINE(new String(Character.toChars(0xF0A17))),
        SUBWAY(new String(Character.toChars(0xF06AC))),
        SUBWAY_ALERT_VARIANT(new String(Character.toChars(0xF0D9D))),
        SUBWAY_VARIANT(new String(Character.toChars(0xF04DF))),
        SUMMIT(new String(Character.toChars(0xF0786))),
        SUN_ANGLE(new String(Character.toChars(0xF1B27))),
        SUN_ANGLE_OUTLINE(new String(Character.toChars(0xF1B28))),
        SUN_CLOCK(new String(Character.toChars(0xF1A77))),
        SUN_CLOCK_OUTLINE(new String(Character.toChars(0xF1A78))),
        SUN_COMPASS(new String(Character.toChars(0xF19A5))),
        SUN_SNOWFLAKE(new String(Character.toChars(0xF1796))),
        SUN_SNOWFLAKE_VARIANT(new String(Character.toChars(0xF1A79))),
        SUN_THERMOMETER(new String(Character.toChars(0xF18D6))),
        SUN_THERMOMETER_OUTLINE(new String(Character.toChars(0xF18D7))),
        SUN_WIRELESS(new String(Character.toChars(0xF17FE))),
        SUN_WIRELESS_OUTLINE(new String(Character.toChars(0xF17FF))),
        SUNGLASSES(new String(Character.toChars(0xF04E0))),
        SURFING(new String(Character.toChars(0xF1746))),
        SURROUND_SOUND(new String(Character.toChars(0xF05C5))),
        SURROUND_SOUND_2_0(new String(Character.toChars(0xF07F0))),
        SURROUND_SOUND_2_1(new String(Character.toChars(0xF1729))),
        SURROUND_SOUND_3_1(new String(Character.toChars(0xF07F1))),
        SURROUND_SOUND_5_1(new String(Character.toChars(0xF07F2))),
        SURROUND_SOUND_5_1_2(new String(Character.toChars(0xF172A))),
        SURROUND_SOUND_7_1(new String(Character.toChars(0xF07F3))),
        SVG(new String(Character.toChars(0xF0721))),
        SWAP_HORIZONTAL(new String(Character.toChars(0xF04E1))),
        SWAP_HORIZONTAL_BOLD(new String(Character.toChars(0xF0BCD))),
        SWAP_HORIZONTAL_CIRCLE(new String(Character.toChars(0xF0FE1))),
        SWAP_HORIZONTAL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0FE2))),
        SWAP_HORIZONTAL_VARIANT(new String(Character.toChars(0xF08C1))),
        SWAP_VERTICAL(new String(Character.toChars(0xF04E2))),
        SWAP_VERTICAL_BOLD(new String(Character.toChars(0xF0BCE))),
        SWAP_VERTICAL_CIRCLE(new String(Character.toChars(0xF0FE3))),
        SWAP_VERTICAL_CIRCLE_OUTLINE(new String(Character.toChars(0xF0FE4))),
        SWAP_VERTICAL_VARIANT(new String(Character.toChars(0xF08C2))),
        SWIM(new String(Character.toChars(0xF04E3))),
        SWITCH(new String(Character.toChars(0xF04E4))),
        SWORD(new String(Character.toChars(0xF04E5))),
        SWORD_CROSS(new String(Character.toChars(0xF0787))),
        SYLLABARY_HANGUL(new String(Character.toChars(0xF1333))),
        SYLLABARY_HIRAGANA(new String(Character.toChars(0xF1334))),
        SYLLABARY_KATAKANA(new String(Character.toChars(0xF1335))),
        SYLLABARY_KATAKANA_HALFWIDTH(new String(Character.toChars(0xF1336))),
        SYMBOL(new String(Character.toChars(0xF1501))),
        SYMFONY(new String(Character.toChars(0xF0AE6))),
        SYNAGOGUE(new String(Character.toChars(0xF1B04))),
        SYNAGOGUE_OUTLINE(new String(Character.toChars(0xF1B05))),
        SYNC(new String(Character.toChars(0xF04E6))),
        SYNC_ALERT(new String(Character.toChars(0xF04E7))),
        SYNC_CIRCLE(new String(Character.toChars(0xF1378))),
        SYNC_OFF(new String(Character.toChars(0xF04E8)));

        private final String unicode;

        S(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public S getDefaultGlyph()
        {
            return S.SACK;
        }
    }

    public enum T implements MaterialDesignIconGlyphs<T> {

        TAB(new String(Character.toChars(0xF04E9))),
        TAB_MINUS(new String(Character.toChars(0xF0B4B))),
        TAB_PLUS(new String(Character.toChars(0xF075C))),
        TAB_REMOVE(new String(Character.toChars(0xF0B4C))),
        TAB_SEARCH(new String(Character.toChars(0xF199E))),
        TAB_UNSELECTED(new String(Character.toChars(0xF04EA))),
        TABLE(new String(Character.toChars(0xF04EB))),
        TABLE_ACCOUNT(new String(Character.toChars(0xF13B9))),
        TABLE_ALERT(new String(Character.toChars(0xF13BA))),
        TABLE_ARROW_DOWN(new String(Character.toChars(0xF13BB))),
        TABLE_ARROW_LEFT(new String(Character.toChars(0xF13BC))),
        TABLE_ARROW_RIGHT(new String(Character.toChars(0xF13BD))),
        TABLE_ARROW_UP(new String(Character.toChars(0xF13BE))),
        TABLE_BORDER(new String(Character.toChars(0xF0A18))),
        TABLE_CANCEL(new String(Character.toChars(0xF13BF))),
        TABLE_CHAIR(new String(Character.toChars(0xF1061))),
        TABLE_CHECK(new String(Character.toChars(0xF13C0))),
        TABLE_CLOCK(new String(Character.toChars(0xF13C1))),
        TABLE_COG(new String(Character.toChars(0xF13C2))),
        TABLE_COLUMN(new String(Character.toChars(0xF0835))),
        TABLE_COLUMN_PLUS_AFTER(new String(Character.toChars(0xF04EC))),
        TABLE_COLUMN_PLUS_BEFORE(new String(Character.toChars(0xF04ED))),
        TABLE_COLUMN_REMOVE(new String(Character.toChars(0xF04EE))),
        TABLE_COLUMN_WIDTH(new String(Character.toChars(0xF04EF))),
        TABLE_EDIT(new String(Character.toChars(0xF04F0))),
        TABLE_EYE(new String(Character.toChars(0xF1094))),
        TABLE_EYE_OFF(new String(Character.toChars(0xF13C3))),
        TABLE_FILTER(new String(Character.toChars(0xF1B8C))),
        TABLE_FURNITURE(new String(Character.toChars(0xF05BC))),
        TABLE_HEADERS_EYE(new String(Character.toChars(0xF121D))),
        TABLE_HEADERS_EYE_OFF(new String(Character.toChars(0xF121E))),
        TABLE_HEART(new String(Character.toChars(0xF13C4))),
        TABLE_KEY(new String(Character.toChars(0xF13C5))),
        TABLE_LARGE(new String(Character.toChars(0xF04F1))),
        TABLE_LARGE_PLUS(new String(Character.toChars(0xF0F87))),
        TABLE_LARGE_REMOVE(new String(Character.toChars(0xF0F88))),
        TABLE_LOCK(new String(Character.toChars(0xF13C6))),
        TABLE_MERGE_CELLS(new String(Character.toChars(0xF09A6))),
        TABLE_MINUS(new String(Character.toChars(0xF13C7))),
        TABLE_MULTIPLE(new String(Character.toChars(0xF13C8))),
        TABLE_NETWORK(new String(Character.toChars(0xF13C9))),
        TABLE_OF_CONTENTS(new String(Character.toChars(0xF0836))),
        TABLE_OFF(new String(Character.toChars(0xF13CA))),
        TABLE_PICNIC(new String(Character.toChars(0xF1743))),
        TABLE_PIVOT(new String(Character.toChars(0xF183C))),
        TABLE_PLUS(new String(Character.toChars(0xF0A75))),
        TABLE_QUESTION(new String(Character.toChars(0xF1B21))),
        TABLE_REFRESH(new String(Character.toChars(0xF13A0))),
        TABLE_REMOVE(new String(Character.toChars(0xF0A76))),
        TABLE_ROW(new String(Character.toChars(0xF0837))),
        TABLE_ROW_HEIGHT(new String(Character.toChars(0xF04F2))),
        TABLE_ROW_PLUS_AFTER(new String(Character.toChars(0xF04F3))),
        TABLE_ROW_PLUS_BEFORE(new String(Character.toChars(0xF04F4))),
        TABLE_ROW_REMOVE(new String(Character.toChars(0xF04F5))),
        TABLE_SEARCH(new String(Character.toChars(0xF090F))),
        TABLE_SETTINGS(new String(Character.toChars(0xF0838))),
        TABLE_SPLIT_CELL(new String(Character.toChars(0xF142A))),
        TABLE_STAR(new String(Character.toChars(0xF13CB))),
        TABLE_SYNC(new String(Character.toChars(0xF13A1))),
        TABLE_TENNIS(new String(Character.toChars(0xF0E68))),
        TABLET(new String(Character.toChars(0xF04F6))),
        TABLET_CELLPHONE(new String(Character.toChars(0xF09A7))),
        TABLET_DASHBOARD(new String(Character.toChars(0xF0ECE))),
        TACO(new String(Character.toChars(0xF0762))),
        TAG(new String(Character.toChars(0xF04F9))),
        TAG_ARROW_DOWN(new String(Character.toChars(0xF172B))),
        TAG_ARROW_DOWN_OUTLINE(new String(Character.toChars(0xF172C))),
        TAG_ARROW_LEFT(new String(Character.toChars(0xF172D))),
        TAG_ARROW_LEFT_OUTLINE(new String(Character.toChars(0xF172E))),
        TAG_ARROW_RIGHT(new String(Character.toChars(0xF172F))),
        TAG_ARROW_RIGHT_OUTLINE(new String(Character.toChars(0xF1730))),
        TAG_ARROW_UP(new String(Character.toChars(0xF1731))),
        TAG_ARROW_UP_OUTLINE(new String(Character.toChars(0xF1732))),
        TAG_CHECK(new String(Character.toChars(0xF1A7A))),
        TAG_CHECK_OUTLINE(new String(Character.toChars(0xF1A7B))),
        TAG_FACES(new String(Character.toChars(0xF04FA))),
        TAG_HEART(new String(Character.toChars(0xF068B))),
        TAG_HEART_OUTLINE(new String(Character.toChars(0xF0BCF))),
        TAG_HIDDEN(new String(Character.toChars(0xF1C76))),
        TAG_MINUS(new String(Character.toChars(0xF0910))),
        TAG_MINUS_OUTLINE(new String(Character.toChars(0xF121F))),
        TAG_MULTIPLE(new String(Character.toChars(0xF04FB))),
        TAG_MULTIPLE_OUTLINE(new String(Character.toChars(0xF12F7))),
        TAG_OFF(new String(Character.toChars(0xF1220))),
        TAG_OFF_OUTLINE(new String(Character.toChars(0xF1221))),
        TAG_OUTLINE(new String(Character.toChars(0xF04FC))),
        TAG_PLUS(new String(Character.toChars(0xF0722))),
        TAG_PLUS_OUTLINE(new String(Character.toChars(0xF1222))),
        TAG_REMOVE(new String(Character.toChars(0xF0723))),
        TAG_REMOVE_OUTLINE(new String(Character.toChars(0xF1223))),
        TAG_SEARCH(new String(Character.toChars(0xF1907))),
        TAG_SEARCH_OUTLINE(new String(Character.toChars(0xF1908))),
        TAG_TEXT(new String(Character.toChars(0xF1224))),
        TAG_TEXT_OUTLINE(new String(Character.toChars(0xF04FD))),
        TAILWIND(new String(Character.toChars(0xF13FF))),
        TALLY_MARK_1(new String(Character.toChars(0xF1ABC))),
        TALLY_MARK_2(new String(Character.toChars(0xF1ABD))),
        TALLY_MARK_3(new String(Character.toChars(0xF1ABE))),
        TALLY_MARK_4(new String(Character.toChars(0xF1ABF))),
        TALLY_MARK_5(new String(Character.toChars(0xF1AC0))),
        TANGRAM(new String(Character.toChars(0xF04F8))),
        TANK(new String(Character.toChars(0xF0D3A))),
        TANKER_TRUCK(new String(Character.toChars(0xF0FE5))),
        TAPE_DRIVE(new String(Character.toChars(0xF16DF))),
        TAPE_MEASURE(new String(Character.toChars(0xF0B4D))),
        TARGET(new String(Character.toChars(0xF04FE))),
        TARGET_ACCOUNT(new String(Character.toChars(0xF0BD0))),
        TARGET_VARIANT(new String(Character.toChars(0xF0A77))),
        TAXI(new String(Character.toChars(0xF04FF))),
        TEA(new String(Character.toChars(0xF0D9E))),
        TEA_OUTLINE(new String(Character.toChars(0xF0D9F))),
        TEAMVIEWER(new String(Character.toChars(0xF0500))),
        TEDDY_BEAR(new String(Character.toChars(0xF18FB))),
        TELESCOPE(new String(Character.toChars(0xF0B4E))),
        TELEVISION(new String(Character.toChars(0xF0502))),
        TELEVISION_AMBIENT_LIGHT(new String(Character.toChars(0xF1356))),
        TELEVISION_BOX(new String(Character.toChars(0xF0839))),
        TELEVISION_CLASSIC(new String(Character.toChars(0xF07F4))),
        TELEVISION_CLASSIC_OFF(new String(Character.toChars(0xF083A))),
        TELEVISION_GUIDE(new String(Character.toChars(0xF0503))),
        TELEVISION_OFF(new String(Character.toChars(0xF083B))),
        TELEVISION_PAUSE(new String(Character.toChars(0xF0F89))),
        TELEVISION_PLAY(new String(Character.toChars(0xF0ECF))),
        TELEVISION_SHIMMER(new String(Character.toChars(0xF1110))),
        TELEVISION_SPEAKER(new String(Character.toChars(0xF1B1B))),
        TELEVISION_SPEAKER_OFF(new String(Character.toChars(0xF1B1C))),
        TELEVISION_STOP(new String(Character.toChars(0xF0F8A))),
        TEMPERATURE_CELSIUS(new String(Character.toChars(0xF0504))),
        TEMPERATURE_FAHRENHEIT(new String(Character.toChars(0xF0505))),
        TEMPERATURE_KELVIN(new String(Character.toChars(0xF0506))),
        TEMPLE_BUDDHIST(new String(Character.toChars(0xF1B06))),
        TEMPLE_BUDDHIST_OUTLINE(new String(Character.toChars(0xF1B07))),
        TEMPLE_HINDU(new String(Character.toChars(0xF1B08))),
        TEMPLE_HINDU_OUTLINE(new String(Character.toChars(0xF1B09))),
        TENNIS(new String(Character.toChars(0xF0DA0))),
        TENNIS_BALL(new String(Character.toChars(0xF0507))),
        TENNIS_BALL_OUTLINE(new String(Character.toChars(0xF1C5F))),
        TENT(new String(Character.toChars(0xF0508))),
        TERRAFORM(new String(Character.toChars(0xF1062))),
        TERRAIN(new String(Character.toChars(0xF0509))),
        TEST_TUBE(new String(Character.toChars(0xF0668))),
        TEST_TUBE_EMPTY(new String(Character.toChars(0xF0911))),
        TEST_TUBE_OFF(new String(Character.toChars(0xF0912))),
        TEXT(new String(Character.toChars(0xF09A8))),
        TEXT_ACCOUNT(new String(Character.toChars(0xF1570))),
        TEXT_BOX(new String(Character.toChars(0xF021A))),
        TEXT_BOX_CHECK(new String(Character.toChars(0xF0EA6))),
        TEXT_BOX_CHECK_OUTLINE(new String(Character.toChars(0xF0EA7))),
        TEXT_BOX_EDIT(new String(Character.toChars(0xF1A7C))),
        TEXT_BOX_EDIT_OUTLINE(new String(Character.toChars(0xF1A7D))),
        TEXT_BOX_MINUS(new String(Character.toChars(0xF0EA8))),
        TEXT_BOX_MINUS_OUTLINE(new String(Character.toChars(0xF0EA9))),
        TEXT_BOX_MULTIPLE(new String(Character.toChars(0xF0AB7))),
        TEXT_BOX_MULTIPLE_OUTLINE(new String(Character.toChars(0xF0AB8))),
        TEXT_BOX_OUTLINE(new String(Character.toChars(0xF09ED))),
        TEXT_BOX_PLUS(new String(Character.toChars(0xF0EAA))),
        TEXT_BOX_PLUS_OUTLINE(new String(Character.toChars(0xF0EAB))),
        TEXT_BOX_REMOVE(new String(Character.toChars(0xF0EAC))),
        TEXT_BOX_REMOVE_OUTLINE(new String(Character.toChars(0xF0EAD))),
        TEXT_BOX_SEARCH(new String(Character.toChars(0xF0EAE))),
        TEXT_BOX_SEARCH_OUTLINE(new String(Character.toChars(0xF0EAF))),
        TEXT_LONG(new String(Character.toChars(0xF09AA))),
        TEXT_RECOGNITION(new String(Character.toChars(0xF113D))),
        TEXT_SEARCH(new String(Character.toChars(0xF13B8))),
        TEXT_SEARCH_VARIANT(new String(Character.toChars(0xF1A7E))),
        TEXT_SHADOW(new String(Character.toChars(0xF0669))),
        TEXT_SHORT(new String(Character.toChars(0xF09A9))),
        TEXTURE(new String(Character.toChars(0xF050C))),
        TEXTURE_BOX(new String(Character.toChars(0xF0FE6))),
        THEATER(new String(Character.toChars(0xF050D))),
        THEME_LIGHT_DARK(new String(Character.toChars(0xF050E))),
        THERMOMETER(new String(Character.toChars(0xF050F))),
        THERMOMETER_ALERT(new String(Character.toChars(0xF0E01))),
        THERMOMETER_AUTO(new String(Character.toChars(0xF1B0F))),
        THERMOMETER_BLUETOOTH(new String(Character.toChars(0xF1895))),
        THERMOMETER_CHECK(new String(Character.toChars(0xF1A7F))),
        THERMOMETER_CHEVRON_DOWN(new String(Character.toChars(0xF0E02))),
        THERMOMETER_CHEVRON_UP(new String(Character.toChars(0xF0E03))),
        THERMOMETER_HIGH(new String(Character.toChars(0xF10C2))),
        THERMOMETER_LINES(new String(Character.toChars(0xF0510))),
        THERMOMETER_LOW(new String(Character.toChars(0xF10C3))),
        THERMOMETER_MINUS(new String(Character.toChars(0xF0E04))),
        THERMOMETER_OFF(new String(Character.toChars(0xF1531))),
        THERMOMETER_PLUS(new String(Character.toChars(0xF0E05))),
        THERMOMETER_PROBE(new String(Character.toChars(0xF1B2B))),
        THERMOMETER_PROBE_OFF(new String(Character.toChars(0xF1B2C))),
        THERMOMETER_WATER(new String(Character.toChars(0xF1A80))),
        THERMOSTAT(new String(Character.toChars(0xF0393))),
        THERMOSTAT_AUTO(new String(Character.toChars(0xF1B17))),
        THERMOSTAT_BOX(new String(Character.toChars(0xF0891))),
        THERMOSTAT_BOX_AUTO(new String(Character.toChars(0xF1B18))),
        THERMOSTAT_COG(new String(Character.toChars(0xF1C80))),
        THOUGHT_BUBBLE(new String(Character.toChars(0xF07F6))),
        THOUGHT_BUBBLE_OUTLINE(new String(Character.toChars(0xF07F7))),
        THUMB_DOWN(new String(Character.toChars(0xF0511))),
        THUMB_DOWN_OUTLINE(new String(Character.toChars(0xF0512))),
        THUMB_UP(new String(Character.toChars(0xF0513))),
        THUMB_UP_OUTLINE(new String(Character.toChars(0xF0514))),
        THUMBS_UP_DOWN(new String(Character.toChars(0xF0515))),
        THUMBS_UP_DOWN_OUTLINE(new String(Character.toChars(0xF1914))),
        TICKET(new String(Character.toChars(0xF0516))),
        TICKET_ACCOUNT(new String(Character.toChars(0xF0517))),
        TICKET_CONFIRMATION(new String(Character.toChars(0xF0518))),
        TICKET_CONFIRMATION_OUTLINE(new String(Character.toChars(0xF13AA))),
        TICKET_OUTLINE(new String(Character.toChars(0xF0913))),
        TICKET_PERCENT(new String(Character.toChars(0xF0724))),
        TICKET_PERCENT_OUTLINE(new String(Character.toChars(0xF142B))),
        TIE(new String(Character.toChars(0xF0519))),
        TILDE(new String(Character.toChars(0xF0725))),
        TILDE_OFF(new String(Character.toChars(0xF18F3))),
        TIMELAPSE(new String(Character.toChars(0xF051A))),
        TIMELINE(new String(Character.toChars(0xF0BD1))),
        TIMELINE_ALERT(new String(Character.toChars(0xF0F95))),
        TIMELINE_ALERT_OUTLINE(new String(Character.toChars(0xF0F98))),
        TIMELINE_CHECK(new String(Character.toChars(0xF1532))),
        TIMELINE_CHECK_OUTLINE(new String(Character.toChars(0xF1533))),
        TIMELINE_CLOCK(new String(Character.toChars(0xF11FB))),
        TIMELINE_CLOCK_OUTLINE(new String(Character.toChars(0xF11FC))),
        TIMELINE_MINUS(new String(Character.toChars(0xF1534))),
        TIMELINE_MINUS_OUTLINE(new String(Character.toChars(0xF1535))),
        TIMELINE_OUTLINE(new String(Character.toChars(0xF0BD2))),
        TIMELINE_PLUS(new String(Character.toChars(0xF0F96))),
        TIMELINE_PLUS_OUTLINE(new String(Character.toChars(0xF0F97))),
        TIMELINE_QUESTION(new String(Character.toChars(0xF0F99))),
        TIMELINE_QUESTION_OUTLINE(new String(Character.toChars(0xF0F9A))),
        TIMELINE_REMOVE(new String(Character.toChars(0xF1536))),
        TIMELINE_REMOVE_OUTLINE(new String(Character.toChars(0xF1537))),
        TIMELINE_TEXT(new String(Character.toChars(0xF0BD3))),
        TIMELINE_TEXT_OUTLINE(new String(Character.toChars(0xF0BD4))),
        TIMER(new String(Character.toChars(0xF13AB))),
        TIMER_10(new String(Character.toChars(0xF051C))),
        TIMER_3(new String(Character.toChars(0xF051D))),
        TIMER_ALERT(new String(Character.toChars(0xF1ACC))),
        TIMER_ALERT_OUTLINE(new String(Character.toChars(0xF1ACD))),
        TIMER_CANCEL(new String(Character.toChars(0xF1ACE))),
        TIMER_CANCEL_OUTLINE(new String(Character.toChars(0xF1ACF))),
        TIMER_CHECK(new String(Character.toChars(0xF1AD0))),
        TIMER_CHECK_OUTLINE(new String(Character.toChars(0xF1AD1))),
        TIMER_COG(new String(Character.toChars(0xF1925))),
        TIMER_COG_OUTLINE(new String(Character.toChars(0xF1926))),
        TIMER_EDIT(new String(Character.toChars(0xF1AD2))),
        TIMER_EDIT_OUTLINE(new String(Character.toChars(0xF1AD3))),
        TIMER_LOCK(new String(Character.toChars(0xF1AD4))),
        TIMER_LOCK_OPEN(new String(Character.toChars(0xF1AD5))),
        TIMER_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF1AD6))),
        TIMER_LOCK_OUTLINE(new String(Character.toChars(0xF1AD7))),
        TIMER_MARKER(new String(Character.toChars(0xF1AD8))),
        TIMER_MARKER_OUTLINE(new String(Character.toChars(0xF1AD9))),
        TIMER_MINUS(new String(Character.toChars(0xF1ADA))),
        TIMER_MINUS_OUTLINE(new String(Character.toChars(0xF1ADB))),
        TIMER_MUSIC(new String(Character.toChars(0xF1ADC))),
        TIMER_MUSIC_OUTLINE(new String(Character.toChars(0xF1ADD))),
        TIMER_OFF(new String(Character.toChars(0xF13AC))),
        TIMER_OFF_OUTLINE(new String(Character.toChars(0xF051E))),
        TIMER_OUTLINE(new String(Character.toChars(0xF051B))),
        TIMER_PAUSE(new String(Character.toChars(0xF1ADE))),
        TIMER_PAUSE_OUTLINE(new String(Character.toChars(0xF1ADF))),
        TIMER_PLAY(new String(Character.toChars(0xF1AE0))),
        TIMER_PLAY_OUTLINE(new String(Character.toChars(0xF1AE1))),
        TIMER_PLUS(new String(Character.toChars(0xF1AE2))),
        TIMER_PLUS_OUTLINE(new String(Character.toChars(0xF1AE3))),
        TIMER_REFRESH(new String(Character.toChars(0xF1AE4))),
        TIMER_REFRESH_OUTLINE(new String(Character.toChars(0xF1AE5))),
        TIMER_REMOVE(new String(Character.toChars(0xF1AE6))),
        TIMER_REMOVE_OUTLINE(new String(Character.toChars(0xF1AE7))),
        TIMER_SAND(new String(Character.toChars(0xF051F))),
        TIMER_SAND_COMPLETE(new String(Character.toChars(0xF199F))),
        TIMER_SAND_EMPTY(new String(Character.toChars(0xF06AD))),
        TIMER_SAND_FULL(new String(Character.toChars(0xF078C))),
        TIMER_SAND_PAUSED(new String(Character.toChars(0xF19A0))),
        TIMER_SETTINGS(new String(Character.toChars(0xF1923))),
        TIMER_SETTINGS_OUTLINE(new String(Character.toChars(0xF1924))),
        TIMER_STAR(new String(Character.toChars(0xF1AE8))),
        TIMER_STAR_OUTLINE(new String(Character.toChars(0xF1AE9))),
        TIMER_STOP(new String(Character.toChars(0xF1AEA))),
        TIMER_STOP_OUTLINE(new String(Character.toChars(0xF1AEB))),
        TIMER_SYNC(new String(Character.toChars(0xF1AEC))),
        TIMER_SYNC_OUTLINE(new String(Character.toChars(0xF1AED))),
        TIMETABLE(new String(Character.toChars(0xF0520))),
        TIRE(new String(Character.toChars(0xF1896))),
        TOASTER(new String(Character.toChars(0xF1063))),
        TOASTER_OFF(new String(Character.toChars(0xF11B7))),
        TOASTER_OVEN(new String(Character.toChars(0xF0CD3))),
        TOGGLE_SWITCH(new String(Character.toChars(0xF0521))),
        TOGGLE_SWITCH_OFF(new String(Character.toChars(0xF0522))),
        TOGGLE_SWITCH_OFF_OUTLINE(new String(Character.toChars(0xF0A19))),
        TOGGLE_SWITCH_OUTLINE(new String(Character.toChars(0xF0A1A))),
        TOGGLE_SWITCH_VARIANT(new String(Character.toChars(0xF1A25))),
        TOGGLE_SWITCH_VARIANT_OFF(new String(Character.toChars(0xF1A26))),
        TOILET(new String(Character.toChars(0xF09AB))),
        TOOLBOX(new String(Character.toChars(0xF09AC))),
        TOOLBOX_OUTLINE(new String(Character.toChars(0xF09AD))),
        TOOLS(new String(Character.toChars(0xF1064))),
        TOOLTIP(new String(Character.toChars(0xF0523))),
        TOOLTIP_ACCOUNT(new String(Character.toChars(0xF000C))),
        TOOLTIP_CELLPHONE(new String(Character.toChars(0xF183B))),
        TOOLTIP_CHECK(new String(Character.toChars(0xF155C))),
        TOOLTIP_CHECK_OUTLINE(new String(Character.toChars(0xF155D))),
        TOOLTIP_EDIT(new String(Character.toChars(0xF0524))),
        TOOLTIP_EDIT_OUTLINE(new String(Character.toChars(0xF12C5))),
        TOOLTIP_IMAGE(new String(Character.toChars(0xF0525))),
        TOOLTIP_IMAGE_OUTLINE(new String(Character.toChars(0xF0BD5))),
        TOOLTIP_MINUS(new String(Character.toChars(0xF155E))),
        TOOLTIP_MINUS_OUTLINE(new String(Character.toChars(0xF155F))),
        TOOLTIP_OUTLINE(new String(Character.toChars(0xF0526))),
        TOOLTIP_PLUS(new String(Character.toChars(0xF0BD6))),
        TOOLTIP_PLUS_OUTLINE(new String(Character.toChars(0xF0527))),
        TOOLTIP_QUESTION(new String(Character.toChars(0xF1BBA))),
        TOOLTIP_QUESTION_OUTLINE(new String(Character.toChars(0xF1BBB))),
        TOOLTIP_REMOVE(new String(Character.toChars(0xF1560))),
        TOOLTIP_REMOVE_OUTLINE(new String(Character.toChars(0xF1561))),
        TOOLTIP_TEXT(new String(Character.toChars(0xF0528))),
        TOOLTIP_TEXT_OUTLINE(new String(Character.toChars(0xF0BD7))),
        TOOTH(new String(Character.toChars(0xF08C3))),
        TOOTH_OUTLINE(new String(Character.toChars(0xF0529))),
        TOOTHBRUSH(new String(Character.toChars(0xF1129))),
        TOOTHBRUSH_ELECTRIC(new String(Character.toChars(0xF112C))),
        TOOTHBRUSH_PASTE(new String(Character.toChars(0xF112A))),
        TORCH(new String(Character.toChars(0xF1606))),
        TORTOISE(new String(Character.toChars(0xF0D3B))),
        TOSLINK(new String(Character.toChars(0xF12B8))),
        TOUCH_TEXT_OUTLINE(new String(Character.toChars(0xF1C60))),
        TOURNAMENT(new String(Character.toChars(0xF09AE))),
        TOW_TRUCK(new String(Character.toChars(0xF083C))),
        TOWER_BEACH(new String(Character.toChars(0xF0681))),
        TOWER_FIRE(new String(Character.toChars(0xF0682))),
        TOWN_HALL(new String(Character.toChars(0xF1875))),
        TOY_BRICK(new String(Character.toChars(0xF1288))),
        TOY_BRICK_MARKER(new String(Character.toChars(0xF1289))),
        TOY_BRICK_MARKER_OUTLINE(new String(Character.toChars(0xF128A))),
        TOY_BRICK_MINUS(new String(Character.toChars(0xF128B))),
        TOY_BRICK_MINUS_OUTLINE(new String(Character.toChars(0xF128C))),
        TOY_BRICK_OUTLINE(new String(Character.toChars(0xF128D))),
        TOY_BRICK_PLUS(new String(Character.toChars(0xF128E))),
        TOY_BRICK_PLUS_OUTLINE(new String(Character.toChars(0xF128F))),
        TOY_BRICK_REMOVE(new String(Character.toChars(0xF1290))),
        TOY_BRICK_REMOVE_OUTLINE(new String(Character.toChars(0xF1291))),
        TOY_BRICK_SEARCH(new String(Character.toChars(0xF1292))),
        TOY_BRICK_SEARCH_OUTLINE(new String(Character.toChars(0xF1293))),
        TRACK_LIGHT(new String(Character.toChars(0xF0914))),
        TRACK_LIGHT_OFF(new String(Character.toChars(0xF1B01))),
        TRACKPAD(new String(Character.toChars(0xF07F8))),
        TRACKPAD_LOCK(new String(Character.toChars(0xF0933))),
        TRACTOR(new String(Character.toChars(0xF0892))),
        TRACTOR_VARIANT(new String(Character.toChars(0xF14C4))),
        TRADEMARK(new String(Character.toChars(0xF0A78))),
        TRAFFIC_CONE(new String(Character.toChars(0xF137C))),
        TRAFFIC_LIGHT(new String(Character.toChars(0xF052B))),
        TRAFFIC_LIGHT_OUTLINE(new String(Character.toChars(0xF182A))),
        TRAIN(new String(Character.toChars(0xF052C))),
        TRAIN_CAR(new String(Character.toChars(0xF0BD8))),
        TRAIN_CAR_AUTORACK(new String(Character.toChars(0xF1B2D))),
        TRAIN_CAR_BOX(new String(Character.toChars(0xF1B2E))),
        TRAIN_CAR_BOX_FULL(new String(Character.toChars(0xF1B2F))),
        TRAIN_CAR_BOX_OPEN(new String(Character.toChars(0xF1B30))),
        TRAIN_CAR_CABOOSE(new String(Character.toChars(0xF1B31))),
        TRAIN_CAR_CENTERBEAM(new String(Character.toChars(0xF1B32))),
        TRAIN_CAR_CENTERBEAM_FULL(new String(Character.toChars(0xF1B33))),
        TRAIN_CAR_CONTAINER(new String(Character.toChars(0xF1B34))),
        TRAIN_CAR_FLATBED(new String(Character.toChars(0xF1B35))),
        TRAIN_CAR_FLATBED_CAR(new String(Character.toChars(0xF1B36))),
        TRAIN_CAR_FLATBED_TANK(new String(Character.toChars(0xF1B37))),
        TRAIN_CAR_GONDOLA(new String(Character.toChars(0xF1B38))),
        TRAIN_CAR_GONDOLA_FULL(new String(Character.toChars(0xF1B39))),
        TRAIN_CAR_HOPPER(new String(Character.toChars(0xF1B3A))),
        TRAIN_CAR_HOPPER_COVERED(new String(Character.toChars(0xF1B3B))),
        TRAIN_CAR_HOPPER_FULL(new String(Character.toChars(0xF1B3C))),
        TRAIN_CAR_INTERMODAL(new String(Character.toChars(0xF1B3D))),
        TRAIN_CAR_PASSENGER(new String(Character.toChars(0xF1733))),
        TRAIN_CAR_PASSENGER_DOOR(new String(Character.toChars(0xF1734))),
        TRAIN_CAR_PASSENGER_DOOR_OPEN(new String(Character.toChars(0xF1735))),
        TRAIN_CAR_PASSENGER_VARIANT(new String(Character.toChars(0xF1736))),
        TRAIN_CAR_TANK(new String(Character.toChars(0xF1B3E))),
        TRAIN_VARIANT(new String(Character.toChars(0xF08C4))),
        TRAM(new String(Character.toChars(0xF052D))),
        TRAM_SIDE(new String(Character.toChars(0xF0FE7))),
        TRANSCRIBE(new String(Character.toChars(0xF052E))),
        TRANSCRIBE_CLOSE(new String(Character.toChars(0xF052F))),
        TRANSFER(new String(Character.toChars(0xF1065))),
        TRANSFER_DOWN(new String(Character.toChars(0xF0DA1))),
        TRANSFER_LEFT(new String(Character.toChars(0xF0DA2))),
        TRANSFER_RIGHT(new String(Character.toChars(0xF0530))),
        TRANSFER_UP(new String(Character.toChars(0xF0DA3))),
        TRANSIT_CONNECTION(new String(Character.toChars(0xF0D3C))),
        TRANSIT_CONNECTION_HORIZONTAL(new String(Character.toChars(0xF1546))),
        TRANSIT_CONNECTION_VARIANT(new String(Character.toChars(0xF0D3D))),
        TRANSIT_DETOUR(new String(Character.toChars(0xF0F8B))),
        TRANSIT_SKIP(new String(Character.toChars(0xF1515))),
        TRANSIT_TRANSFER(new String(Character.toChars(0xF06AE))),
        TRANSITION(new String(Character.toChars(0xF0915))),
        TRANSITION_MASKED(new String(Character.toChars(0xF0916))),
        TRANSLATE(new String(Character.toChars(0xF05CA))),
        TRANSLATE_OFF(new String(Character.toChars(0xF0E06))),
        TRANSLATE_VARIANT(new String(Character.toChars(0xF1B99))),
        TRANSMISSION_TOWER(new String(Character.toChars(0xF0D3E))),
        TRANSMISSION_TOWER_EXPORT(new String(Character.toChars(0xF192C))),
        TRANSMISSION_TOWER_IMPORT(new String(Character.toChars(0xF192D))),
        TRANSMISSION_TOWER_OFF(new String(Character.toChars(0xF19DD))),
        TRASH_CAN(new String(Character.toChars(0xF0A79))),
        TRASH_CAN_OUTLINE(new String(Character.toChars(0xF0A7A))),
        TRAY(new String(Character.toChars(0xF1294))),
        TRAY_ALERT(new String(Character.toChars(0xF1295))),
        TRAY_ARROW_DOWN(new String(Character.toChars(0xF0120))),
        TRAY_ARROW_UP(new String(Character.toChars(0xF011D))),
        TRAY_FULL(new String(Character.toChars(0xF1296))),
        TRAY_MINUS(new String(Character.toChars(0xF1297))),
        TRAY_PLUS(new String(Character.toChars(0xF1298))),
        TRAY_REMOVE(new String(Character.toChars(0xF1299))),
        TREASURE_CHEST(new String(Character.toChars(0xF0726))),
        TREASURE_CHEST_OUTLINE(new String(Character.toChars(0xF1C77))),
        TREE(new String(Character.toChars(0xF0531))),
        TREE_OUTLINE(new String(Character.toChars(0xF0E69))),
        TRELLO(new String(Character.toChars(0xF0532))),
        TRENDING_DOWN(new String(Character.toChars(0xF0533))),
        TRENDING_NEUTRAL(new String(Character.toChars(0xF0534))),
        TRENDING_UP(new String(Character.toChars(0xF0535))),
        TRIANGLE(new String(Character.toChars(0xF0536))),
        TRIANGLE_DOWN(new String(Character.toChars(0xF1C56))),
        TRIANGLE_DOWN_OUTLINE(new String(Character.toChars(0xF1C57))),
        TRIANGLE_OUTLINE(new String(Character.toChars(0xF0537))),
        TRIANGLE_SMALL_DOWN(new String(Character.toChars(0xF1A09))),
        TRIANGLE_SMALL_UP(new String(Character.toChars(0xF1A0A))),
        TRIANGLE_WAVE(new String(Character.toChars(0xF147C))),
        TRIFORCE(new String(Character.toChars(0xF0BD9))),
        TROPHY(new String(Character.toChars(0xF0538))),
        TROPHY_AWARD(new String(Character.toChars(0xF0539))),
        TROPHY_BROKEN(new String(Character.toChars(0xF0DA4))),
        TROPHY_OUTLINE(new String(Character.toChars(0xF053A))),
        TROPHY_VARIANT(new String(Character.toChars(0xF053B))),
        TROPHY_VARIANT_OUTLINE(new String(Character.toChars(0xF053C))),
        TRUCK(new String(Character.toChars(0xF053D))),
        TRUCK_ALERT(new String(Character.toChars(0xF19DE))),
        TRUCK_ALERT_OUTLINE(new String(Character.toChars(0xF19DF))),
        TRUCK_CARGO_CONTAINER(new String(Character.toChars(0xF18D8))),
        TRUCK_CHECK(new String(Character.toChars(0xF0CD4))),
        TRUCK_CHECK_OUTLINE(new String(Character.toChars(0xF129A))),
        TRUCK_DELIVERY(new String(Character.toChars(0xF053E))),
        TRUCK_DELIVERY_OUTLINE(new String(Character.toChars(0xF129B))),
        TRUCK_FAST(new String(Character.toChars(0xF0788))),
        TRUCK_FAST_OUTLINE(new String(Character.toChars(0xF129C))),
        TRUCK_FLATBED(new String(Character.toChars(0xF1891))),
        TRUCK_MINUS(new String(Character.toChars(0xF19AE))),
        TRUCK_MINUS_OUTLINE(new String(Character.toChars(0xF19BD))),
        TRUCK_OUTLINE(new String(Character.toChars(0xF129D))),
        TRUCK_PLUS(new String(Character.toChars(0xF19AD))),
        TRUCK_PLUS_OUTLINE(new String(Character.toChars(0xF19BC))),
        TRUCK_REMOVE(new String(Character.toChars(0xF19AF))),
        TRUCK_REMOVE_OUTLINE(new String(Character.toChars(0xF19BE))),
        TRUCK_SNOWFLAKE(new String(Character.toChars(0xF19A6))),
        TRUCK_TRAILER(new String(Character.toChars(0xF0727))),
        TRUMPET(new String(Character.toChars(0xF1096))),
        TSHIRT_CREW(new String(Character.toChars(0xF0A7B))),
        TSHIRT_CREW_OUTLINE(new String(Character.toChars(0xF053F))),
        TSHIRT_V(new String(Character.toChars(0xF0A7C))),
        TSHIRT_V_OUTLINE(new String(Character.toChars(0xF0540))),
        TSUNAMI(new String(Character.toChars(0xF1A81))),
        TUMBLE_DRYER(new String(Character.toChars(0xF0917))),
        TUMBLE_DRYER_ALERT(new String(Character.toChars(0xF11BA))),
        TUMBLE_DRYER_OFF(new String(Character.toChars(0xF11BB))),
        TUNE(new String(Character.toChars(0xF062E))),
        TUNE_VARIANT(new String(Character.toChars(0xF1542))),
        TUNE_VERTICAL(new String(Character.toChars(0xF066A))),
        TUNE_VERTICAL_VARIANT(new String(Character.toChars(0xF1543))),
        TUNNEL(new String(Character.toChars(0xF183D))),
        TUNNEL_OUTLINE(new String(Character.toChars(0xF183E))),
        TURBINE(new String(Character.toChars(0xF1A82))),
        TURKEY(new String(Character.toChars(0xF171B))),
        TURNSTILE(new String(Character.toChars(0xF0CD5))),
        TURNSTILE_OUTLINE(new String(Character.toChars(0xF0CD6))),
        TURTLE(new String(Character.toChars(0xF0CD7))),
        TWITCH(new String(Character.toChars(0xF0543))),
        TWITTER(new String(Character.toChars(0xF0544))),
        TWO_FACTOR_AUTHENTICATION(new String(Character.toChars(0xF09AF))),
        TYPEWRITER(new String(Character.toChars(0xF0F2D)));

        private final String unicode;

        T(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public T getDefaultGlyph()
        {
            return T.TAB;
        }
    }

    public enum U implements MaterialDesignIconGlyphs<U> {

        UBISOFT(new String(Character.toChars(0xF0BDA))),
        UBUNTU(new String(Character.toChars(0xF0548))),
        UFO(new String(Character.toChars(0xF10C4))),
        UFO_OUTLINE(new String(Character.toChars(0xF10C5))),
        ULTRA_HIGH_DEFINITION(new String(Character.toChars(0xF07F9))),
        UMBRACO(new String(Character.toChars(0xF0549))),
        UMBRELLA(new String(Character.toChars(0xF054A))),
        UMBRELLA_BEACH(new String(Character.toChars(0xF188A))),
        UMBRELLA_BEACH_OUTLINE(new String(Character.toChars(0xF188B))),
        UMBRELLA_CLOSED(new String(Character.toChars(0xF09B0))),
        UMBRELLA_CLOSED_OUTLINE(new String(Character.toChars(0xF13E2))),
        UMBRELLA_CLOSED_VARIANT(new String(Character.toChars(0xF13E1))),
        UMBRELLA_OUTLINE(new String(Character.toChars(0xF054B))),
        UNDO(new String(Character.toChars(0xF054C))),
        UNDO_VARIANT(new String(Character.toChars(0xF054D))),
        UNFOLD_LESS_HORIZONTAL(new String(Character.toChars(0xF054E))),
        UNFOLD_LESS_VERTICAL(new String(Character.toChars(0xF0760))),
        UNFOLD_MORE_HORIZONTAL(new String(Character.toChars(0xF054F))),
        UNFOLD_MORE_VERTICAL(new String(Character.toChars(0xF0761))),
        UNGROUP(new String(Character.toChars(0xF0550))),
        UNICODE(new String(Character.toChars(0xF0ED0))),
        UNICORN(new String(Character.toChars(0xF15C2))),
        UNICORN_VARIANT(new String(Character.toChars(0xF15C3))),
        UNICYCLE(new String(Character.toChars(0xF15E5))),
        UNITY(new String(Character.toChars(0xF06AF))),
        UNREAL(new String(Character.toChars(0xF09B1))),
        UPDATE(new String(Character.toChars(0xF06B0))),
        UPLOAD(new String(Character.toChars(0xF0552))),
        UPLOAD_LOCK(new String(Character.toChars(0xF1373))),
        UPLOAD_LOCK_OUTLINE(new String(Character.toChars(0xF1374))),
        UPLOAD_MULTIPLE(new String(Character.toChars(0xF083D))),
        UPLOAD_NETWORK(new String(Character.toChars(0xF06F6))),
        UPLOAD_NETWORK_OUTLINE(new String(Character.toChars(0xF0CD8))),
        UPLOAD_OFF(new String(Character.toChars(0xF10C6))),
        UPLOAD_OFF_OUTLINE(new String(Character.toChars(0xF10C7))),
        UPLOAD_OUTLINE(new String(Character.toChars(0xF0E07))),
        USB(new String(Character.toChars(0xF0553))),
        USB_FLASH_DRIVE(new String(Character.toChars(0xF129E))),
        USB_FLASH_DRIVE_OUTLINE(new String(Character.toChars(0xF129F))),
        USB_PORT(new String(Character.toChars(0xF11F0)));

        private final String unicode;

        U(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public U getDefaultGlyph()
        {
            return U.UBISOFT;
        }
    }

    public enum V implements MaterialDesignIconGlyphs<V> {

        VACUUM(new String(Character.toChars(0xF19A1))),
        VACUUM_OUTLINE(new String(Character.toChars(0xF19A2))),
        VALVE(new String(Character.toChars(0xF1066))),
        VALVE_CLOSED(new String(Character.toChars(0xF1067))),
        VALVE_OPEN(new String(Character.toChars(0xF1068))),
        VAN_PASSENGER(new String(Character.toChars(0xF07FA))),
        VAN_UTILITY(new String(Character.toChars(0xF07FB))),
        VANISH(new String(Character.toChars(0xF07FC))),
        VANISH_QUARTER(new String(Character.toChars(0xF1554))),
        VANITY_LIGHT(new String(Character.toChars(0xF11E1))),
        VARIABLE(new String(Character.toChars(0xF0AE7))),
        VARIABLE_BOX(new String(Character.toChars(0xF1111))),
        VECTOR_ARRANGE_ABOVE(new String(Character.toChars(0xF0554))),
        VECTOR_ARRANGE_BELOW(new String(Character.toChars(0xF0555))),
        VECTOR_BEZIER(new String(Character.toChars(0xF0AE8))),
        VECTOR_CIRCLE(new String(Character.toChars(0xF0556))),
        VECTOR_CIRCLE_VARIANT(new String(Character.toChars(0xF0557))),
        VECTOR_COMBINE(new String(Character.toChars(0xF0558))),
        VECTOR_CURVE(new String(Character.toChars(0xF0559))),
        VECTOR_DIFFERENCE(new String(Character.toChars(0xF055A))),
        VECTOR_DIFFERENCE_AB(new String(Character.toChars(0xF055B))),
        VECTOR_DIFFERENCE_BA(new String(Character.toChars(0xF055C))),
        VECTOR_ELLIPSE(new String(Character.toChars(0xF0893))),
        VECTOR_INTERSECTION(new String(Character.toChars(0xF055D))),
        VECTOR_LINE(new String(Character.toChars(0xF055E))),
        VECTOR_LINK(new String(Character.toChars(0xF0FE8))),
        VECTOR_POINT(new String(Character.toChars(0xF01C4))),
        VECTOR_POINT_EDIT(new String(Character.toChars(0xF09E8))),
        VECTOR_POINT_MINUS(new String(Character.toChars(0xF1B78))),
        VECTOR_POINT_PLUS(new String(Character.toChars(0xF1B79))),
        VECTOR_POINT_SELECT(new String(Character.toChars(0xF055F))),
        VECTOR_POLYGON(new String(Character.toChars(0xF0560))),
        VECTOR_POLYGON_VARIANT(new String(Character.toChars(0xF1856))),
        VECTOR_POLYLINE(new String(Character.toChars(0xF0561))),
        VECTOR_POLYLINE_EDIT(new String(Character.toChars(0xF1225))),
        VECTOR_POLYLINE_MINUS(new String(Character.toChars(0xF1226))),
        VECTOR_POLYLINE_PLUS(new String(Character.toChars(0xF1227))),
        VECTOR_POLYLINE_REMOVE(new String(Character.toChars(0xF1228))),
        VECTOR_RADIUS(new String(Character.toChars(0xF074A))),
        VECTOR_RECTANGLE(new String(Character.toChars(0xF05C6))),
        VECTOR_SELECTION(new String(Character.toChars(0xF0562))),
        VECTOR_SQUARE(new String(Character.toChars(0xF0001))),
        VECTOR_SQUARE_CLOSE(new String(Character.toChars(0xF1857))),
        VECTOR_SQUARE_EDIT(new String(Character.toChars(0xF18D9))),
        VECTOR_SQUARE_MINUS(new String(Character.toChars(0xF18DA))),
        VECTOR_SQUARE_OPEN(new String(Character.toChars(0xF1858))),
        VECTOR_SQUARE_PLUS(new String(Character.toChars(0xF18DB))),
        VECTOR_SQUARE_REMOVE(new String(Character.toChars(0xF18DC))),
        VECTOR_TRIANGLE(new String(Character.toChars(0xF0563))),
        VECTOR_UNION(new String(Character.toChars(0xF0564))),
        VHS(new String(Character.toChars(0xF0A1B))),
        VIBRATE(new String(Character.toChars(0xF0566))),
        VIBRATE_OFF(new String(Character.toChars(0xF0CD9))),
        VIDEO(new String(Character.toChars(0xF0567))),
        VIDEO_2D(new String(Character.toChars(0xF1A1C))),
        VIDEO_3D(new String(Character.toChars(0xF07FD))),
        VIDEO_3D_OFF(new String(Character.toChars(0xF13D9))),
        VIDEO_3D_VARIANT(new String(Character.toChars(0xF0ED1))),
        VIDEO_4K_BOX(new String(Character.toChars(0xF083E))),
        VIDEO_ACCOUNT(new String(Character.toChars(0xF0919))),
        VIDEO_BOX(new String(Character.toChars(0xF00FD))),
        VIDEO_BOX_OFF(new String(Character.toChars(0xF00FE))),
        VIDEO_CHECK(new String(Character.toChars(0xF1069))),
        VIDEO_CHECK_OUTLINE(new String(Character.toChars(0xF106A))),
        VIDEO_HIGH_DEFINITION(new String(Character.toChars(0xF152E))),
        VIDEO_IMAGE(new String(Character.toChars(0xF091A))),
        VIDEO_INPUT_ANTENNA(new String(Character.toChars(0xF083F))),
        VIDEO_INPUT_COMPONENT(new String(Character.toChars(0xF0840))),
        VIDEO_INPUT_HDMI(new String(Character.toChars(0xF0841))),
        VIDEO_INPUT_SCART(new String(Character.toChars(0xF0F8C))),
        VIDEO_INPUT_SVIDEO(new String(Character.toChars(0xF0842))),
        VIDEO_MARKER(new String(Character.toChars(0xF19A9))),
        VIDEO_MARKER_OUTLINE(new String(Character.toChars(0xF19AA))),
        VIDEO_MINUS(new String(Character.toChars(0xF09B2))),
        VIDEO_MINUS_OUTLINE(new String(Character.toChars(0xF02BA))),
        VIDEO_OFF(new String(Character.toChars(0xF0568))),
        VIDEO_OFF_OUTLINE(new String(Character.toChars(0xF0BDB))),
        VIDEO_OUTLINE(new String(Character.toChars(0xF0BDC))),
        VIDEO_PLUS(new String(Character.toChars(0xF09B3))),
        VIDEO_PLUS_OUTLINE(new String(Character.toChars(0xF01D3))),
        VIDEO_STABILIZATION(new String(Character.toChars(0xF091B))),
        VIDEO_SWITCH(new String(Character.toChars(0xF0569))),
        VIDEO_SWITCH_OUTLINE(new String(Character.toChars(0xF0790))),
        VIDEO_VINTAGE(new String(Character.toChars(0xF0A1C))),
        VIDEO_WIRELESS(new String(Character.toChars(0xF0ED2))),
        VIDEO_WIRELESS_OUTLINE(new String(Character.toChars(0xF0ED3))),
        VIEW_AGENDA(new String(Character.toChars(0xF056A))),
        VIEW_AGENDA_OUTLINE(new String(Character.toChars(0xF11D8))),
        VIEW_ARRAY(new String(Character.toChars(0xF056B))),
        VIEW_ARRAY_OUTLINE(new String(Character.toChars(0xF1485))),
        VIEW_CAROUSEL(new String(Character.toChars(0xF056C))),
        VIEW_CAROUSEL_OUTLINE(new String(Character.toChars(0xF1486))),
        VIEW_COLUMN(new String(Character.toChars(0xF056D))),
        VIEW_COLUMN_OUTLINE(new String(Character.toChars(0xF1487))),
        VIEW_COMFY(new String(Character.toChars(0xF0E6A))),
        VIEW_COMFY_OUTLINE(new String(Character.toChars(0xF1488))),
        VIEW_COMPACT(new String(Character.toChars(0xF0E6B))),
        VIEW_COMPACT_OUTLINE(new String(Character.toChars(0xF0E6C))),
        VIEW_DASHBOARD(new String(Character.toChars(0xF056E))),
        VIEW_DASHBOARD_EDIT(new String(Character.toChars(0xF1947))),
        VIEW_DASHBOARD_EDIT_OUTLINE(new String(Character.toChars(0xF1948))),
        VIEW_DASHBOARD_OUTLINE(new String(Character.toChars(0xF0A1D))),
        VIEW_DASHBOARD_VARIANT(new String(Character.toChars(0xF0843))),
        VIEW_DASHBOARD_VARIANT_OUTLINE(new String(Character.toChars(0xF1489))),
        VIEW_DAY(new String(Character.toChars(0xF056F))),
        VIEW_DAY_OUTLINE(new String(Character.toChars(0xF148A))),
        VIEW_GALLERY(new String(Character.toChars(0xF1888))),
        VIEW_GALLERY_OUTLINE(new String(Character.toChars(0xF1889))),
        VIEW_GRID(new String(Character.toChars(0xF0570))),
        VIEW_GRID_COMPACT(new String(Character.toChars(0xF1C61))),
        VIEW_GRID_OUTLINE(new String(Character.toChars(0xF11D9))),
        VIEW_GRID_PLUS(new String(Character.toChars(0xF0F8D))),
        VIEW_GRID_PLUS_OUTLINE(new String(Character.toChars(0xF11DA))),
        VIEW_HEADLINE(new String(Character.toChars(0xF0571))),
        VIEW_LIST(new String(Character.toChars(0xF0572))),
        VIEW_LIST_OUTLINE(new String(Character.toChars(0xF148B))),
        VIEW_MODULE(new String(Character.toChars(0xF0573))),
        VIEW_MODULE_OUTLINE(new String(Character.toChars(0xF148C))),
        VIEW_PARALLEL(new String(Character.toChars(0xF0728))),
        VIEW_PARALLEL_OUTLINE(new String(Character.toChars(0xF148D))),
        VIEW_QUILT(new String(Character.toChars(0xF0574))),
        VIEW_QUILT_OUTLINE(new String(Character.toChars(0xF148E))),
        VIEW_SEQUENTIAL(new String(Character.toChars(0xF0729))),
        VIEW_SEQUENTIAL_OUTLINE(new String(Character.toChars(0xF148F))),
        VIEW_SPLIT_HORIZONTAL(new String(Character.toChars(0xF0BCB))),
        VIEW_SPLIT_VERTICAL(new String(Character.toChars(0xF0BCC))),
        VIEW_STREAM(new String(Character.toChars(0xF0575))),
        VIEW_STREAM_OUTLINE(new String(Character.toChars(0xF1490))),
        VIEW_WEEK(new String(Character.toChars(0xF0576))),
        VIEW_WEEK_OUTLINE(new String(Character.toChars(0xF1491))),
        VIMEO(new String(Character.toChars(0xF0577))),
        VIOLIN(new String(Character.toChars(0xF060F))),
        VIRTUAL_REALITY(new String(Character.toChars(0xF0894))),
        VIRUS(new String(Character.toChars(0xF13B6))),
        VIRUS_OFF(new String(Character.toChars(0xF18E1))),
        VIRUS_OFF_OUTLINE(new String(Character.toChars(0xF18E2))),
        VIRUS_OUTLINE(new String(Character.toChars(0xF13B7))),
        VLC(new String(Character.toChars(0xF057C))),
        VOICEMAIL(new String(Character.toChars(0xF057D))),
        VOLCANO(new String(Character.toChars(0xF1A83))),
        VOLCANO_OUTLINE(new String(Character.toChars(0xF1A84))),
        VOLLEYBALL(new String(Character.toChars(0xF09B4))),
        VOLUME_EQUAL(new String(Character.toChars(0xF1B10))),
        VOLUME_HIGH(new String(Character.toChars(0xF057E))),
        VOLUME_LOW(new String(Character.toChars(0xF057F))),
        VOLUME_MEDIUM(new String(Character.toChars(0xF0580))),
        VOLUME_MINUS(new String(Character.toChars(0xF075E))),
        VOLUME_MUTE(new String(Character.toChars(0xF075F))),
        VOLUME_OFF(new String(Character.toChars(0xF0581))),
        VOLUME_PLUS(new String(Character.toChars(0xF075D))),
        VOLUME_SOURCE(new String(Character.toChars(0xF1120))),
        VOLUME_VARIANT_OFF(new String(Character.toChars(0xF0E08))),
        VOLUME_VIBRATE(new String(Character.toChars(0xF1121))),
        VOTE(new String(Character.toChars(0xF0A1F))),
        VOTE_OUTLINE(new String(Character.toChars(0xF0A20))),
        VPN(new String(Character.toChars(0xF0582))),
        VUEJS(new String(Character.toChars(0xF0844))),
        VUETIFY(new String(Character.toChars(0xF0E6D)));

        private final String unicode;

        V(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public V getDefaultGlyph()
        {
            return V.VACUUM;
        }
    }

    public enum W implements MaterialDesignIconGlyphs<W> {

        WALK(new String(Character.toChars(0xF0583))),
        WALL(new String(Character.toChars(0xF07FE))),
        WALL_FIRE(new String(Character.toChars(0xF1A11))),
        WALL_SCONCE(new String(Character.toChars(0xF091C))),
        WALL_SCONCE_FLAT(new String(Character.toChars(0xF091D))),
        WALL_SCONCE_FLAT_OUTLINE(new String(Character.toChars(0xF17C9))),
        WALL_SCONCE_FLAT_VARIANT(new String(Character.toChars(0xF041C))),
        WALL_SCONCE_FLAT_VARIANT_OUTLINE(new String(Character.toChars(0xF17CA))),
        WALL_SCONCE_OUTLINE(new String(Character.toChars(0xF17CB))),
        WALL_SCONCE_ROUND(new String(Character.toChars(0xF0748))),
        WALL_SCONCE_ROUND_OUTLINE(new String(Character.toChars(0xF17CC))),
        WALL_SCONCE_ROUND_VARIANT(new String(Character.toChars(0xF091E))),
        WALL_SCONCE_ROUND_VARIANT_OUTLINE(new String(Character.toChars(0xF17CD))),
        WALLET(new String(Character.toChars(0xF0584))),
        WALLET_BIFOLD(new String(Character.toChars(0xF1C58))),
        WALLET_BIFOLD_OUTLINE(new String(Character.toChars(0xF1C59))),
        WALLET_GIFTCARD(new String(Character.toChars(0xF0585))),
        WALLET_MEMBERSHIP(new String(Character.toChars(0xF0586))),
        WALLET_OUTLINE(new String(Character.toChars(0xF0BDD))),
        WALLET_PLUS(new String(Character.toChars(0xF0F8E))),
        WALLET_PLUS_OUTLINE(new String(Character.toChars(0xF0F8F))),
        WALLET_TRAVEL(new String(Character.toChars(0xF0587))),
        WALLPAPER(new String(Character.toChars(0xF0E09))),
        WAN(new String(Character.toChars(0xF0588))),
        WARDROBE(new String(Character.toChars(0xF0F90))),
        WARDROBE_OUTLINE(new String(Character.toChars(0xF0F91))),
        WAREHOUSE(new String(Character.toChars(0xF0F81))),
        WASHING_MACHINE(new String(Character.toChars(0xF072A))),
        WASHING_MACHINE_ALERT(new String(Character.toChars(0xF11BC))),
        WASHING_MACHINE_OFF(new String(Character.toChars(0xF11BD))),
        WATCH(new String(Character.toChars(0xF0589))),
        WATCH_EXPORT(new String(Character.toChars(0xF058A))),
        WATCH_EXPORT_VARIANT(new String(Character.toChars(0xF0895))),
        WATCH_IMPORT(new String(Character.toChars(0xF058B))),
        WATCH_IMPORT_VARIANT(new String(Character.toChars(0xF0896))),
        WATCH_VARIANT(new String(Character.toChars(0xF0897))),
        WATCH_VIBRATE(new String(Character.toChars(0xF06B1))),
        WATCH_VIBRATE_OFF(new String(Character.toChars(0xF0CDA))),
        WATER(new String(Character.toChars(0xF058C))),
        WATER_ALERT(new String(Character.toChars(0xF1502))),
        WATER_ALERT_OUTLINE(new String(Character.toChars(0xF1503))),
        WATER_BOILER(new String(Character.toChars(0xF0F92))),
        WATER_BOILER_ALERT(new String(Character.toChars(0xF11B3))),
        WATER_BOILER_AUTO(new String(Character.toChars(0xF1B98))),
        WATER_BOILER_OFF(new String(Character.toChars(0xF11B4))),
        WATER_CHECK(new String(Character.toChars(0xF1504))),
        WATER_CHECK_OUTLINE(new String(Character.toChars(0xF1505))),
        WATER_CIRCLE(new String(Character.toChars(0xF1806))),
        WATER_MINUS(new String(Character.toChars(0xF1506))),
        WATER_MINUS_OUTLINE(new String(Character.toChars(0xF1507))),
        WATER_OFF(new String(Character.toChars(0xF058D))),
        WATER_OFF_OUTLINE(new String(Character.toChars(0xF1508))),
        WATER_OPACITY(new String(Character.toChars(0xF1855))),
        WATER_OUTLINE(new String(Character.toChars(0xF0E0A))),
        WATER_PERCENT(new String(Character.toChars(0xF058E))),
        WATER_PERCENT_ALERT(new String(Character.toChars(0xF1509))),
        WATER_PLUS(new String(Character.toChars(0xF150A))),
        WATER_PLUS_OUTLINE(new String(Character.toChars(0xF150B))),
        WATER_POLO(new String(Character.toChars(0xF12A0))),
        WATER_PUMP(new String(Character.toChars(0xF058F))),
        WATER_PUMP_OFF(new String(Character.toChars(0xF0F93))),
        WATER_REMOVE(new String(Character.toChars(0xF150C))),
        WATER_REMOVE_OUTLINE(new String(Character.toChars(0xF150D))),
        WATER_SYNC(new String(Character.toChars(0xF17C6))),
        WATER_THERMOMETER(new String(Character.toChars(0xF1A85))),
        WATER_THERMOMETER_OUTLINE(new String(Character.toChars(0xF1A86))),
        WATER_WELL(new String(Character.toChars(0xF106B))),
        WATER_WELL_OUTLINE(new String(Character.toChars(0xF106C))),
        WATERFALL(new String(Character.toChars(0xF1849))),
        WATERING_CAN(new String(Character.toChars(0xF1481))),
        WATERING_CAN_OUTLINE(new String(Character.toChars(0xF1482))),
        WATERMARK(new String(Character.toChars(0xF0612))),
        WAVE(new String(Character.toChars(0xF0F2E))),
        WAVEFORM(new String(Character.toChars(0xF147D))),
        WAVES(new String(Character.toChars(0xF078D))),
        WAVES_ARROW_LEFT(new String(Character.toChars(0xF1859))),
        WAVES_ARROW_RIGHT(new String(Character.toChars(0xF185A))),
        WAVES_ARROW_UP(new String(Character.toChars(0xF185B))),
        WAZE(new String(Character.toChars(0xF0BDE))),
        WEATHER_CLOUDY(new String(Character.toChars(0xF0590))),
        WEATHER_CLOUDY_ALERT(new String(Character.toChars(0xF0F2F))),
        WEATHER_CLOUDY_ARROW_RIGHT(new String(Character.toChars(0xF0E6E))),
        WEATHER_CLOUDY_CLOCK(new String(Character.toChars(0xF18F6))),
        WEATHER_DUST(new String(Character.toChars(0xF1B5A))),
        WEATHER_FOG(new String(Character.toChars(0xF0591))),
        WEATHER_HAIL(new String(Character.toChars(0xF0592))),
        WEATHER_HAZY(new String(Character.toChars(0xF0F30))),
        WEATHER_HURRICANE(new String(Character.toChars(0xF0898))),
        WEATHER_HURRICANE_OUTLINE(new String(Character.toChars(0xF1C78))),
        WEATHER_LIGHTNING(new String(Character.toChars(0xF0593))),
        WEATHER_LIGHTNING_RAINY(new String(Character.toChars(0xF067E))),
        WEATHER_NIGHT(new String(Character.toChars(0xF0594))),
        WEATHER_NIGHT_PARTLY_CLOUDY(new String(Character.toChars(0xF0F31))),
        WEATHER_PARTLY_CLOUDY(new String(Character.toChars(0xF0595))),
        WEATHER_PARTLY_LIGHTNING(new String(Character.toChars(0xF0F32))),
        WEATHER_PARTLY_RAINY(new String(Character.toChars(0xF0F33))),
        WEATHER_PARTLY_SNOWY(new String(Character.toChars(0xF0F34))),
        WEATHER_PARTLY_SNOWY_RAINY(new String(Character.toChars(0xF0F35))),
        WEATHER_POURING(new String(Character.toChars(0xF0596))),
        WEATHER_RAINY(new String(Character.toChars(0xF0597))),
        WEATHER_SNOWY(new String(Character.toChars(0xF0598))),
        WEATHER_SNOWY_HEAVY(new String(Character.toChars(0xF0F36))),
        WEATHER_SNOWY_RAINY(new String(Character.toChars(0xF067F))),
        WEATHER_SUNNY(new String(Character.toChars(0xF0599))),
        WEATHER_SUNNY_ALERT(new String(Character.toChars(0xF0F37))),
        WEATHER_SUNNY_OFF(new String(Character.toChars(0xF14E4))),
        WEATHER_SUNSET(new String(Character.toChars(0xF059A))),
        WEATHER_SUNSET_DOWN(new String(Character.toChars(0xF059B))),
        WEATHER_SUNSET_UP(new String(Character.toChars(0xF059C))),
        WEATHER_TORNADO(new String(Character.toChars(0xF0F38))),
        WEATHER_WINDY(new String(Character.toChars(0xF059D))),
        WEATHER_WINDY_VARIANT(new String(Character.toChars(0xF059E))),
        WEB(new String(Character.toChars(0xF059F))),
        WEB_BOX(new String(Character.toChars(0xF0F94))),
        WEB_CANCEL(new String(Character.toChars(0xF1790))),
        WEB_CHECK(new String(Character.toChars(0xF0789))),
        WEB_CLOCK(new String(Character.toChars(0xF124A))),
        WEB_MINUS(new String(Character.toChars(0xF10A0))),
        WEB_OFF(new String(Character.toChars(0xF0A8E))),
        WEB_PLUS(new String(Character.toChars(0xF0033))),
        WEB_REFRESH(new String(Character.toChars(0xF1791))),
        WEB_REMOVE(new String(Character.toChars(0xF0551))),
        WEB_SYNC(new String(Character.toChars(0xF1792))),
        WEBCAM(new String(Character.toChars(0xF05A0))),
        WEBCAM_OFF(new String(Character.toChars(0xF1737))),
        WEBHOOK(new String(Character.toChars(0xF062F))),
        WEBPACK(new String(Character.toChars(0xF072B))),
        WEBRTC(new String(Character.toChars(0xF1248))),
        WECHAT(new String(Character.toChars(0xF0611))),
        WEIGHT(new String(Character.toChars(0xF05A1))),
        WEIGHT_GRAM(new String(Character.toChars(0xF0D3F))),
        WEIGHT_KILOGRAM(new String(Character.toChars(0xF05A2))),
        WEIGHT_LIFTER(new String(Character.toChars(0xF115D))),
        WEIGHT_POUND(new String(Character.toChars(0xF09B5))),
        WHATSAPP(new String(Character.toChars(0xF05A3))),
        WHEEL_BARROW(new String(Character.toChars(0xF14F2))),
        WHEELCHAIR(new String(Character.toChars(0xF1A87))),
        WHEELCHAIR_ACCESSIBILITY(new String(Character.toChars(0xF05A4))),
        WHISTLE(new String(Character.toChars(0xF09B6))),
        WHISTLE_OUTLINE(new String(Character.toChars(0xF12BC))),
        WHITE_BALANCE_AUTO(new String(Character.toChars(0xF05A5))),
        WHITE_BALANCE_INCANDESCENT(new String(Character.toChars(0xF05A6))),
        WHITE_BALANCE_IRIDESCENT(new String(Character.toChars(0xF05A7))),
        WHITE_BALANCE_SUNNY(new String(Character.toChars(0xF05A8))),
        WIDGETS(new String(Character.toChars(0xF072C))),
        WIDGETS_OUTLINE(new String(Character.toChars(0xF1355))),
        WIFI(new String(Character.toChars(0xF05A9))),
        WIFI_ALERT(new String(Character.toChars(0xF16B5))),
        WIFI_ARROW_DOWN(new String(Character.toChars(0xF16B6))),
        WIFI_ARROW_LEFT(new String(Character.toChars(0xF16B7))),
        WIFI_ARROW_LEFT_RIGHT(new String(Character.toChars(0xF16B8))),
        WIFI_ARROW_RIGHT(new String(Character.toChars(0xF16B9))),
        WIFI_ARROW_UP(new String(Character.toChars(0xF16BA))),
        WIFI_ARROW_UP_DOWN(new String(Character.toChars(0xF16BB))),
        WIFI_CANCEL(new String(Character.toChars(0xF16BC))),
        WIFI_CHECK(new String(Character.toChars(0xF16BD))),
        WIFI_COG(new String(Character.toChars(0xF16BE))),
        WIFI_LOCK(new String(Character.toChars(0xF16BF))),
        WIFI_LOCK_OPEN(new String(Character.toChars(0xF16C0))),
        WIFI_MARKER(new String(Character.toChars(0xF16C1))),
        WIFI_MINUS(new String(Character.toChars(0xF16C2))),
        WIFI_OFF(new String(Character.toChars(0xF05AA))),
        WIFI_PLUS(new String(Character.toChars(0xF16C3))),
        WIFI_REFRESH(new String(Character.toChars(0xF16C4))),
        WIFI_REMOVE(new String(Character.toChars(0xF16C5))),
        WIFI_SETTINGS(new String(Character.toChars(0xF16C6))),
        WIFI_STAR(new String(Character.toChars(0xF0E0B))),
        WIFI_STRENGTH_1(new String(Character.toChars(0xF091F))),
        WIFI_STRENGTH_1_ALERT(new String(Character.toChars(0xF0920))),
        WIFI_STRENGTH_1_LOCK(new String(Character.toChars(0xF0921))),
        WIFI_STRENGTH_1_LOCK_OPEN(new String(Character.toChars(0xF16CB))),
        WIFI_STRENGTH_2(new String(Character.toChars(0xF0922))),
        WIFI_STRENGTH_2_ALERT(new String(Character.toChars(0xF0923))),
        WIFI_STRENGTH_2_LOCK(new String(Character.toChars(0xF0924))),
        WIFI_STRENGTH_2_LOCK_OPEN(new String(Character.toChars(0xF16CC))),
        WIFI_STRENGTH_3(new String(Character.toChars(0xF0925))),
        WIFI_STRENGTH_3_ALERT(new String(Character.toChars(0xF0926))),
        WIFI_STRENGTH_3_LOCK(new String(Character.toChars(0xF0927))),
        WIFI_STRENGTH_3_LOCK_OPEN(new String(Character.toChars(0xF16CD))),
        WIFI_STRENGTH_4(new String(Character.toChars(0xF0928))),
        WIFI_STRENGTH_4_ALERT(new String(Character.toChars(0xF0929))),
        WIFI_STRENGTH_4_LOCK(new String(Character.toChars(0xF092A))),
        WIFI_STRENGTH_4_LOCK_OPEN(new String(Character.toChars(0xF16CE))),
        WIFI_STRENGTH_ALERT_OUTLINE(new String(Character.toChars(0xF092B))),
        WIFI_STRENGTH_LOCK_OPEN_OUTLINE(new String(Character.toChars(0xF16CF))),
        WIFI_STRENGTH_LOCK_OUTLINE(new String(Character.toChars(0xF092C))),
        WIFI_STRENGTH_OFF(new String(Character.toChars(0xF092D))),
        WIFI_STRENGTH_OFF_OUTLINE(new String(Character.toChars(0xF092E))),
        WIFI_STRENGTH_OUTLINE(new String(Character.toChars(0xF092F))),
        WIFI_SYNC(new String(Character.toChars(0xF16C7))),
        WIKIPEDIA(new String(Character.toChars(0xF05AC))),
        WIND_POWER(new String(Character.toChars(0xF1A88))),
        WIND_POWER_OUTLINE(new String(Character.toChars(0xF1A89))),
        WIND_TURBINE(new String(Character.toChars(0xF0DA5))),
        WIND_TURBINE_ALERT(new String(Character.toChars(0xF19AB))),
        WIND_TURBINE_CHECK(new String(Character.toChars(0xF19AC))),
        WINDOW_CLOSE(new String(Character.toChars(0xF05AD))),
        WINDOW_CLOSED(new String(Character.toChars(0xF05AE))),
        WINDOW_CLOSED_VARIANT(new String(Character.toChars(0xF11DB))),
        WINDOW_MAXIMIZE(new String(Character.toChars(0xF05AF))),
        WINDOW_MINIMIZE(new String(Character.toChars(0xF05B0))),
        WINDOW_OPEN(new String(Character.toChars(0xF05B1))),
        WINDOW_OPEN_VARIANT(new String(Character.toChars(0xF11DC))),
        WINDOW_RESTORE(new String(Character.toChars(0xF05B2))),
        WINDOW_SHUTTER(new String(Character.toChars(0xF111C))),
        WINDOW_SHUTTER_ALERT(new String(Character.toChars(0xF111D))),
        WINDOW_SHUTTER_AUTO(new String(Character.toChars(0xF1BA3))),
        WINDOW_SHUTTER_COG(new String(Character.toChars(0xF1A8A))),
        WINDOW_SHUTTER_OPEN(new String(Character.toChars(0xF111E))),
        WINDOW_SHUTTER_SETTINGS(new String(Character.toChars(0xF1A8B))),
        WINDSOCK(new String(Character.toChars(0xF15FA))),
        WIPER(new String(Character.toChars(0xF0AE9))),
        WIPER_WASH(new String(Character.toChars(0xF0DA6))),
        WIPER_WASH_ALERT(new String(Character.toChars(0xF18DF))),
        WIZARD_HAT(new String(Character.toChars(0xF1477))),
        WORDPRESS(new String(Character.toChars(0xF05B4))),
        WRAP(new String(Character.toChars(0xF05B6))),
        WRAP_DISABLED(new String(Character.toChars(0xF0BDF))),
        WRENCH(new String(Character.toChars(0xF05B7))),
        WRENCH_CHECK(new String(Character.toChars(0xF1B8F))),
        WRENCH_CHECK_OUTLINE(new String(Character.toChars(0xF1B90))),
        WRENCH_CLOCK(new String(Character.toChars(0xF19A3))),
        WRENCH_CLOCK_OUTLINE(new String(Character.toChars(0xF1B93))),
        WRENCH_COG(new String(Character.toChars(0xF1B91))),
        WRENCH_COG_OUTLINE(new String(Character.toChars(0xF1B92))),
        WRENCH_OUTLINE(new String(Character.toChars(0xF0BE0)));

        private final String unicode;

        W(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public W getDefaultGlyph()
        {
            return W.WALK;
        }
    }

    public enum X implements MaterialDesignIconGlyphs<X> {

        XAMARIN(new String(Character.toChars(0xF0845))),
        XML(new String(Character.toChars(0xF05C0))),
        XMPP(new String(Character.toChars(0xF07FF)));

        private final String unicode;

        X(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public X getDefaultGlyph()
        {
            return X.XAMARIN;
        }
    }

    public enum Y implements MaterialDesignIconGlyphs<Y> {

        YAHOO(new String(Character.toChars(0xF0B4F))),
        YEAST(new String(Character.toChars(0xF05C1))),
        YIN_YANG(new String(Character.toChars(0xF0680))),
        YOGA(new String(Character.toChars(0xF117C))),
        YOUTUBE(new String(Character.toChars(0xF05C3))),
        YOUTUBE_GAMING(new String(Character.toChars(0xF0848))),
        YOUTUBE_STUDIO(new String(Character.toChars(0xF0847))),
        YOUTUBE_SUBSCRIPTION(new String(Character.toChars(0xF0D40))),
        YOUTUBE_TV(new String(Character.toChars(0xF0448))),
        YURT(new String(Character.toChars(0xF1516)));

        private final String unicode;

        Y(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public Y getDefaultGlyph()
        {
            return Y.YAHOO;
        }
    }

    public enum Z implements MaterialDesignIconGlyphs<Z> {

        Z_WAVE(new String(Character.toChars(0xF0AEA))),
        ZEND(new String(Character.toChars(0xF0AEB))),
        ZIGBEE(new String(Character.toChars(0xF0D41))),
        ZIP_BOX(new String(Character.toChars(0xF05C4))),
        ZIP_BOX_OUTLINE(new String(Character.toChars(0xF0FFA))),
        ZIP_DISK(new String(Character.toChars(0xF0A23))),
        ZODIAC_AQUARIUS(new String(Character.toChars(0xF0A7D))),
        ZODIAC_ARIES(new String(Character.toChars(0xF0A7E))),
        ZODIAC_CANCER(new String(Character.toChars(0xF0A7F))),
        ZODIAC_CAPRICORN(new String(Character.toChars(0xF0A80))),
        ZODIAC_GEMINI(new String(Character.toChars(0xF0A81))),
        ZODIAC_LEO(new String(Character.toChars(0xF0A82))),
        ZODIAC_LIBRA(new String(Character.toChars(0xF0A83))),
        ZODIAC_PISCES(new String(Character.toChars(0xF0A84))),
        ZODIAC_SAGITTARIUS(new String(Character.toChars(0xF0A85))),
        ZODIAC_SCORPIO(new String(Character.toChars(0xF0A86))),
        ZODIAC_TAURUS(new String(Character.toChars(0xF0A87))),
        ZODIAC_VIRGO(new String(Character.toChars(0xF0A88)));

        private final String unicode;

        Z(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public String unicode() {
            return unicode;
        }

        @Override
        public String fontFamily() {
            return "'Material Design Icons'";
        }

        @Override
        public Z getDefaultGlyph()
        {
            return Z.Z_WAVE;
        }
    }

    public static final List<MaterialDesignIconGlyphs<?>> GLYPH_ICONS;

    static {
        final List<MaterialDesignIconGlyphs<?>> icons = new ArrayList<>();
        icons.addAll(Arrays.asList(A.values()));
        icons.addAll(Arrays.asList(B.values()));
        icons.addAll(Arrays.asList(C.values()));
        icons.addAll(Arrays.asList(D.values()));
        icons.addAll(Arrays.asList(E.values()));
        icons.addAll(Arrays.asList(F.values()));
        icons.addAll(Arrays.asList(G.values()));
        icons.addAll(Arrays.asList(H.values()));
        icons.addAll(Arrays.asList(I.values()));
        icons.addAll(Arrays.asList(J.values()));
        icons.addAll(Arrays.asList(K.values()));
        icons.addAll(Arrays.asList(L.values()));
        icons.addAll(Arrays.asList(M.values()));
        icons.addAll(Arrays.asList(N.values()));
        icons.addAll(Arrays.asList(O.values()));
        icons.addAll(Arrays.asList(P.values()));
        icons.addAll(Arrays.asList(Q.values()));
        icons.addAll(Arrays.asList(R.values()));
        icons.addAll(Arrays.asList(S.values()));
        icons.addAll(Arrays.asList(T.values()));
        icons.addAll(Arrays.asList(U.values()));
        icons.addAll(Arrays.asList(V.values()));
        icons.addAll(Arrays.asList(W.values()));
        icons.addAll(Arrays.asList(X.values()));
        icons.addAll(Arrays.asList(Y.values()));
        icons.addAll(Arrays.asList(Z.values()));

        GLYPH_ICONS = Collections.unmodifiableList(icons);
    }
}
