/*
 * Decompiled with CFR 0.152.
 */
package fr.ght1pc9kc.testy.mongo;

import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.Start;
import fr.ght1pc9kc.testy.mongo.MongoDatabaseName;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;

public class WithEmbeddedMongo
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WithEmbeddedMongo.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{WithEmbeddedMongo.class});
    private static final String P_MONGO_PROCESS = "mongoPocess";
    private static final String P_MONGO_CLIENT = "mongoClient";
    private static final String P_MONGO_FACTORY = "reactiveMongoFactory";
    private static final String P_MONGO_TEMPLATE = "reactiveMongoTemplate";
    private static final String P_MONGO_DB_NAME = "mongoDbName";
    private final String databaseName;
    private final AtomicReference<ReactiveMongoDatabaseFactory> atomicMongoFactory;

    public WithEmbeddedMongo() {
        this(UUID.randomUUID().toString());
    }

    private WithEmbeddedMongo(String databaseName) {
        this.databaseName = databaseName;
        this.atomicMongoFactory = new AtomicReference();
    }

    public ReactiveMongoDatabaseFactory getMongoFactory() {
        return this.atomicMongoFactory.updateAndGet(old -> {
            assert (old != null) : "No Mongo factory initialized !";
            return old;
        });
    }

    public ReactiveMongoTemplate getMongoTemplate(ExtensionContext context) {
        return (ReactiveMongoTemplate)this.getStore(context).get((Object)P_MONGO_TEMPLATE, ReactiveMongoTemplate.class);
    }

    public void beforeAll(ExtensionContext context) throws IOException {
        RunningMongodProcess process = (RunningMongodProcess)Mongod.instance().withProcessOutput((Transition)Start.to(ProcessOutput.class).initializedWith((Object)ProcessOutput.named((String)"Slf4j Logger", (Logger)log))).start((Version)Version.Main.V6_0).current();
        MongoClient mongo = MongoClients.create((String)String.format("mongodb://%s:%d/%s", process.getServerAddress().getHost(), process.getServerAddress().getPort(), this.databaseName));
        SimpleReactiveMongoDatabaseFactory mongoFactory = new SimpleReactiveMongoDatabaseFactory(mongo, this.databaseName);
        if (!this.atomicMongoFactory.compareAndSet(null, (ReactiveMongoDatabaseFactory)mongoFactory)) {
            throw new IllegalStateException("Mongo factory already initialized ! Multiple Mongo factory not supported !");
        }
        ReactiveMongoTemplate mongoTemplate = new ReactiveMongoTemplate((ReactiveMongoDatabaseFactory)mongoFactory);
        ExtensionContext.Store store = this.getStore(context);
        store.put((Object)P_MONGO_DB_NAME, (Object)this.databaseName);
        store.put((Object)P_MONGO_PROCESS, (Object)process);
        store.put((Object)P_MONGO_CLIENT, (Object)mongo);
        store.put((Object)P_MONGO_FACTORY, (Object)mongoFactory);
        store.put((Object)P_MONGO_TEMPLATE, (Object)mongoTemplate);
    }

    public void afterAll(ExtensionContext context) {
        RunningMongodProcess running;
        ExtensionContext.Store store = this.getStore(context);
        MongoClient mongo = (MongoClient)store.get((Object)P_MONGO_CLIENT, MongoClient.class);
        if (mongo != null) {
            mongo.close();
        }
        if ((running = (RunningMongodProcess)store.get((Object)P_MONGO_PROCESS, RunningMongodProcess.class)) != null) {
            running.stop();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> type = parameter.getType();
        return MongoClient.class.equals(type) || ReactiveMongoDatabaseFactory.class.equals(type) || ReactiveMongoTemplate.class.equals(type) || String.class.equals(type) && parameter.isAnnotationPresent(MongoDatabaseName.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> type = parameter.getType();
        if (MongoClient.class.equals(type)) {
            return this.getStore(extensionContext).get((Object)P_MONGO_CLIENT);
        }
        if (ReactiveMongoDatabaseFactory.class.equals(type)) {
            return this.getStore(extensionContext).get((Object)P_MONGO_FACTORY);
        }
        if (ReactiveMongoTemplate.class.equals(type)) {
            return this.getStore(extensionContext).get((Object)P_MONGO_TEMPLATE);
        }
        if (type.equals(String.class) && parameter.isAnnotationPresent(MongoDatabaseName.class)) {
            return this.getStore(extensionContext).get((Object)P_MONGO_DB_NAME);
        }
        throw new ParameterResolutionException(this.getClass().getName() + " must be static and package-protected !");
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }

    public static WithEmbeddedMongoBuilder builder() {
        return new WithEmbeddedMongoBuilder();
    }

    public static final class WithEmbeddedMongoBuilder {
        private String databaseName = UUID.randomUUID().toString();

        public WithEmbeddedMongoBuilder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public WithEmbeddedMongo build() {
            return new WithEmbeddedMongo(this.databaseName);
        }
    }
}

