/*
 * Decompiled with CFR 0.152.
 */
package fr.ght1pc9kc.testy.mongo;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.ght1pc9kc.testy.core.extensions.WithObjectMapper;
import fr.ght1pc9kc.testy.mongo.MongoDataSet;
import fr.ght1pc9kc.testy.mongo.WithEmbeddedMongo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.publisher.Mono;

public final class WithMongoData
implements BeforeEachCallback {
    private final WithEmbeddedMongo wEmbeddedMongo;
    @Nullable
    private final WithObjectMapper wObjectMapper;
    private final Map<String, MongoDataSet<?>> dataSets;

    private WithMongoData(WithEmbeddedMongo wEmbeddedMongo, Map<String, MongoDataSet<?>> dataSets) {
        this.wEmbeddedMongo = wEmbeddedMongo;
        this.wObjectMapper = null;
        this.dataSets = dataSets;
    }

    private WithMongoData(WithEmbeddedMongo wEmbeddedMongo, @NotNull WithObjectMapper wObjectMapper, Map<String, MongoDataSet<?>> dataSets) {
        this.wEmbeddedMongo = wEmbeddedMongo;
        this.wObjectMapper = wObjectMapper;
        this.dataSets = dataSets;
    }

    public void beforeEach(ExtensionContext context) {
        ObjectMapper objectMapper = Optional.ofNullable(this.wObjectMapper).map(wom -> wom.getObjectMapper(context)).orElseGet(ObjectMapper::new);
        ReactiveMongoTemplate mongoTemplate = this.wEmbeddedMongo.getMongoTemplate(context);
        this.dataSets.forEach((collection, dataSet) -> {
            mongoTemplate.dropCollection(collection).block();
            this.fillCollection(mongoTemplate, objectMapper, (String)collection, (MongoDataSet<?>)dataSet);
        });
    }

    private void fillCollection(ReactiveMongoTemplate mongoDb, ObjectMapper objectMapper, String collectionName, MongoDataSet<?> dataSet) {
        List<Document> toInsert = dataSet.documents().stream().map(o -> (Document)objectMapper.convertValue(o, Document.class)).toList();
        mongoDb.insertAll(Mono.just(toInsert), collectionName).blockLast();
    }

    public static WithMongoDataBuilder builder(WithEmbeddedMongo wEmbeddedMongo) {
        return new WithMongoDataBuilder(wEmbeddedMongo);
    }

    public static final class WithMongoDataBuilder {
        private final WithEmbeddedMongo wEmbeddedMongo;
        @Nullable
        private WithObjectMapper wObjectMapper;
        private final Map<String, MongoDataSet<?>> dataSetsBuilder = new HashMap();

        private WithMongoDataBuilder(WithEmbeddedMongo wEmbeddedMongo) {
            this.wEmbeddedMongo = wEmbeddedMongo;
        }

        public WithMongoDataBuilder withObjectMapper(WithObjectMapper wObjectMapper) {
            this.wObjectMapper = wObjectMapper;
            return this;
        }

        public WithMongoDataBuilder addDataset(String collectionName, MongoDataSet<?> dataSet) {
            this.dataSetsBuilder.put(collectionName, dataSet);
            return this;
        }

        public WithMongoData build() {
            return Optional.ofNullable(this.wObjectMapper).map(wom -> new WithMongoData(this.wEmbeddedMongo, (WithObjectMapper)wom, Map.copyOf(this.dataSetsBuilder))).orElseGet(() -> new WithMongoData(this.wEmbeddedMongo, Map.copyOf(this.dataSetsBuilder)));
        }
    }
}

