package fr.ird.observe.maven.plugins.toolbox;

/*-
 * #%L
 * ObServe Toolkit :: Maven plugin
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

import java.io.File;
import java.nio.file.Path;

/**
 * Created on 31/08/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class ToolboxMojoSupport extends AbstractPlugin {

    @Parameter(defaultValue = "${project}", required = true, readonly = true)
    private MavenProject project;

    @Parameter(defaultValue = "${project.basedir}/src/main/resources", required = true)
    private File sourceRoot;

    @Override
    protected void init() throws Exception {

        if (isSkip()) {
            return;
        }
        if (getLog().isDebugEnabled()) {
            setVerbose(true);
        }
    }

    protected abstract boolean isSkip();

    @Override
    public MavenProject getProject() {
        return project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getSourceRoot() {
        return sourceRoot;
    }

    public Path getSourceRootPath() {
        return getSourceRoot().toPath();
    }

}
