package fr.ird.observe.toolkit.runner.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.maven.plugins.toolbox.ExecuteRunnerMojo;
import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

/**
 * Created on 01/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public abstract class GenerateSupport extends ExecuteRunnerMojo.MojoRunnable {

    protected abstract void generate(Path targetDirectory, NavigationNodeDescriptor descriptor) throws IOException;

    @Override
    public void run() {
        NavigationNodeDescriptor descriptor = NavigationNodeDescriptor.getRootDescriptor();
        Path targetDirectory = new File(System.getProperty("target.directory")).toPath();
        try {
            generate(targetDirectory, descriptor);
        } catch (IOException e) {
            throw new IllegalStateException("Can't generate model", e);
        }
    }

}
