package fr.ird.observe.toolkit.runner.navigation.id;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.runner.navigation.GenerateSupport;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

/**
 * To generate the navigation select model from the generated descriptors.
 * <p>
 * Created on 01/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class GenerateEditModel extends GenerateSupport {

    public static final String PACKAGE = "fr.ird.observe.navigation.edit";
    public static final String SUFFIX = "EditNode";

    @Override
    protected void generate(Path targetDirectory, NavigationNodeDescriptor descriptor) throws IOException {

        Path rootTargetDirectory = targetDirectory.resolve(PACKAGE.replaceAll("\\.", File.separator));
        getLog().info(String.format("Will generate at %s", rootTargetDirectory));

        EditNodesBuilder builder = new EditNodesBuilder();
        List<NodeModel> models = builder.build(descriptor);
        getLog().info(String.format("Detect %d edit node(s) to generate.\n%s", models.size(), builder.getDebugTree()));

        EditTemplate template = new EditTemplate(log, rootTargetDirectory);
        for (NodeModel model : models) {
            template.generate(model);
        }
    }
}
