package fr.ird.observe.toolkit.runner.navigation.id;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeCapability;
import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeType;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModelsBuilder;

import java.util.LinkedList;
import java.util.Map;

/**
 * Created on 06/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class SelectNodesBuilder extends NodeModelsBuilder {

    public SelectNodesBuilder() {
        super(c -> c.isEdit() || c.isOpen() || c.isOpenList());
    }

    @Override
    protected void onCapacity(LinkedList<NavigationNodeCapability<?>> stack, Map<NavigationNodeDescriptor, NodeModel> mapping, NavigationNodeCapability<?> capability) {
        if (capability.isOpenList()) {
            capability = capability.toType(NavigationNodeType.Open);
            if (stack.size() == 2) {
                capability = capability.toPropertyName(NodeModel.getPropertyNameFromTarget(capability));
            }
        }
        super.onCapacity(stack, mapping, capability);
    }
}
