package fr.ird.observe.toolkit.runner.navigation.id;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.maven.plugin.logging.Log;

import java.nio.file.Path;

/**
 * Created on 03/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class SelectTemplate extends ModelTemplate {
    public static final String NODE_MODEL = "" +
            "package %1$s;\n\n" +
            "import fr.ird.observe.spi.module.ObserveBusinessProject;\n" +
            "import fr.ird.observe.toolkit.navigation.id.select.SelectNode;\n" +
            "import io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition;\n" +
            "import java.util.function.Supplier;\n" +
            "import javax.annotation.Generated;\n\n" +
            "@GenerateJavaBeanDefinition\n" +
            "@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.id.GenerateSelectModel\", date = \"%2$s\")\n" +
            "public class %3$s extends SelectNode<%4$s> {\n" +
            "\n" +
            "    public %3$s() {\n" +
            "        super(%5$s);\n" +
            "    }\n\n" +
            "    @Override\n" +
            "    public final int getLevel() {\n" +
            "        return %6$d;\n" +
            "    }\n\n" +
            "%7$s" +
            "%8$s" +
            "    @Override\n" +
            "    protected Supplier<ObserveBusinessProject> getProjectSupplier() {\n" +
            "        return ObserveBusinessProject::get;\n" +
            "    }\n}\n";


    public static final String MODULE_MODEL = "" +
            "package %1$s;\n\n" +
            "import fr.ird.observe.spi.module.ObserveBusinessProject;\n" +
            "import fr.ird.observe.toolkit.navigation.id.select.SelectNode;\n" +
            "import io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition;\n" +
            "import java.util.function.Supplier;\n" +
            "import javax.annotation.Generated;\n\n" +
            "@GenerateJavaBeanDefinition\n" +
            "@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.id.GenerateSelectModel\", date = \"%2$s\")\n" +
            "public class ModuleSelectModel extends fr.ird.observe.toolkit.navigation.id.select.ModuleSelectModel<SelectNode<?>> {\n" +
            "\n" +
            "    public ModuleSelectModel() {\n" +
            "        super(new %3$s());\n" +
            "    }\n\n" +
            "%4$s" +
            "    @Override\n" +
            "    protected Supplier<ObserveBusinessProject> getProjectSupplier() {\n" +
            "        return ObserveBusinessProject::get;\n" +
            "    }\n}\n";
    public static final String PROJECT_MODEL = "" +
            "package %1$s;\n\n" +
            "import fr.ird.observe.toolkit.navigation.id.AggregateNavigationModel;\n" +
            "import io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition;\n" +
            "import com.google.auto.service.AutoService;\n" +
            "import javax.annotation.Generated;\n\n" +
            "@GenerateJavaBeanDefinition\n" +
            "@AutoService(value = {AggregateNavigationModel.class, fr.ird.observe.toolkit.navigation.id.select.ProjectSelectModel.class})\n" +
            "@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.id.GenerateSelectModel\", date = \"%2$s\")\n" +
            "public class ProjectSelectModel extends fr.ird.observe.toolkit.navigation.id.select.ProjectSelectModel {\n" +
            "\n" +
            "%3$s" +
            "    public ProjectSelectModel() {\n" +
            "        super(%4$s);\n" +
            "        %5$s\n" +
            "    }\n\n" +
            "%6$s" +
            "}\n";

    public SelectTemplate(Log log, Path targetDirectory) {
        super(log, GenerateSelectModel.PACKAGE, GenerateSelectModel.SUFFIX, targetDirectory);
    }

    @Override
    public String getNodeTemplate() {
        return NODE_MODEL;
    }

    @Override
    public String getModuleTemplate() {
        return MODULE_MODEL;
    }

    @Override
    public String getProjectTemplate() {
        return PROJECT_MODEL;
    }
}
