package fr.ird.observe.toolkit.runner.navigation.tree;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.runner.navigation.GenerateSupport;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import fr.ird.observe.toolkit.templates.navigation.SelectionNodesBuilder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

/**
 * Created on 03/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class GenerateSelectionModel extends GenerateSupport {

    public static final String PACKAGE = "fr.ird.observe.tree.selection";
    public static final String SUFFIX = "SelectionTreeNode";

    @Override
    protected void generate(Path targetDirectory, NavigationNodeDescriptor descriptor) throws IOException {

        Path rootTargetDirectory = targetDirectory.resolve(PACKAGE.replaceAll("\\.", File.separator));
        getLog().info(String.format("Will generate at %s", rootTargetDirectory));

        SelectionNodesBuilder builder = new SelectionNodesBuilder();
        List<NodeModel> models = builder.build(descriptor);
        getLog().info(String.format("Detect %d selection node(s) to generate.\n%s", models.size(), builder.getDebugTree()));

        String modelName = Objects.requireNonNull(getExtraProperties().get("modelName"));
        SelectionTemplate template = new SelectionTemplate(getLog(), getGetterFile(), rootTargetDirectory, modelName);
        for (NodeModel model : models) {
            template.generate(model);
        }
        template.generateMapping();
    }

}
