package fr.ird.observe.toolkit.runner.navigation.tree;

/*-
 * #%L
 * ObServe Toolkit :: Runner for Navigation
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.templates.navigation.NodeLinkModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import io.ultreia.java4all.i18n.spi.builder.I18nKeySet;
import org.apache.maven.plugin.logging.Log;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

/**
 * Created on 03/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class SelectionTemplate extends ModelTemplate {
    public static final String NODE_MODEL = "" +
            "package %1$s;\n\n" +
            "import fr.ird.observe.toolkit.navigation.tree.selection.SelectionTreeNode;\n" +
            "import javax.annotation.Generated;\n" +
            "import java.nio.file.Path;\n\n" +
            "@Generated(value = \"fr.ird.observe.maven.plugins.toolbox.selection.GenerateSelectionModel\", date = \"%2$s\")\n" +
            "public class %3$s extends SelectionTreeNode {\n\n" +
            "%4$s" +
            "    public %3$s() {\n" +
            "        super(new %3$sBean());\n" +
            "    }\n\n" +
            "%5$s" +
            "}\n";
    public static final String BEAN_MODEL = "" +
            "package %1$s;\n\n" +
            "import com.google.common.collect.ImmutableMap;\n" +
            "import fr.ird.observe.spi.module.ObserveBusinessProject;\n" +
            "import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeType;\n" +
            "import fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNodeBeanState;\n\n" +
            "import javax.annotation.Generated;\n" +
            "import java.util.Map;\n" +
            "import java.util.function.Supplier;\n\n" +
            "@Generated(value = \"fr.ird.observe.maven.plugins.toolbox.selection.GenerateSelectionModel\", date = \"%2$s\")\n" +
            "public class %3$s extends fr.ird.observe.toolkit.navigation.tree.selection.bean.%4$sSelectionTreeNodeBean {\n" +
            "%5$s" +
            "    @Override\n" +
            "    protected Supplier<ObserveBusinessProject> getProjectSupplier() {\n" +
            "        return ObserveBusinessProject::get;\n" +
            "    }\n}\n";
    public static final String INTERCEPTOR_MODEL = "" +
            "package %1$s;\n\n" +
            "import fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNode;\n" +
            "import fr.ird.observe.toolkit.navigation.spi.tree.ToolkitTreeNodeInterceptor;\n\n" +
            "import javax.annotation.Generated;\n" +
            "import java.util.Objects;\n\n" +
            "@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.GenerateSelectionModel\", date = \"%2$s\")\n" +
            "public interface %3$s extends ToolkitTreeNodeInterceptor {\n" +
            "\n" +
            "    static void intercept(%3$s provider, ToolkitTreeNode node) {\n" +
            "        switch (Objects.requireNonNull(node.getClass().getName())) {\n" +
            "            %4$s\n" +
            "        }\n" +
            "    }\n\n" +
            "    @Override\n" +
            "    default void intercept(ToolkitTreeNode node) {\n" +
            "        intercept(this, node);\n" +
            "    }\n\n" +
            "    %5$s\n" +
            "}";

    public SelectionTemplate(Log log, I18nKeySet getterFile, Path targetDirectory, String modelName) {
        super(log, getterFile, GenerateSelectionModel.PACKAGE, GenerateSelectionModel.SUFFIX, targetDirectory, modelName);
    }

    @Override
    public void generate(NodeModel model) throws IOException {
        super.generate(model);
        for (NodeLinkModel child : model.getChildren()) {
            registerInterceptorNode(child.getTargetModel());
        }
    }

    @Override
    public void generateMapping() throws IOException {
        generateMapping("selection");
        {
            String className = modelName + "SelectionTreeNodeInterceptor";
            String content = String.format(INTERCEPTOR_MODEL
                    , "fr.ird.observe.spi.tree.selection"
                    , now
                    , className
                    , interceptorCaseBuilder.substring(1).trim()
                    , interceptorMethodsBuilder.substring(1).trim());
            store(targetDirectory.getParent().getParent(), "spi.tree.selection", className, content);
        }
    }

    @Override
    public String getNodeTemplate() {
        return NODE_MODEL;
    }

    @Override
    public String getBeanTemplate() {
        return BEAN_MODEL;
    }

    @Override
    protected void addCapability(Map<String, String> defaultStates, boolean capabilityLeaf, boolean capabilitySelectReference, boolean capabilityEditReference, boolean capabilitySelectReferenceContainer, boolean capabilityEditReferenceContainer) {
        // not used for selection model : all nodes are static and fully loaded
    }
}
