/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation;

import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;

public abstract class Template {
    protected final Date now;
    protected final Log log;
    protected final String prefix;
    protected final String suffix;
    protected final Path targetDirectory;

    public Template(Log log, String prefix, String suffix, Path targetDirectory) {
        this.log = log;
        this.prefix = prefix;
        this.suffix = suffix;
        this.targetDirectory = targetDirectory;
        this.now = new Date();
    }

    public abstract void generate(NodeModel var1) throws IOException;

    public Path store(Path targetDirectory, String packageName, String simpleName, String content) throws IOException {
        Path targetFile = targetDirectory.resolve(packageName.replaceAll("\\.", File.separator)).resolve(simpleName + ".java");
        if (Files.notExists(targetFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        }
        this.log.debug((CharSequence)String.format("Will generate at %s", targetFile));
        Files.write(targetFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return targetFile;
    }
}

