/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.id;

import fr.ird.observe.toolkit.runner.navigation.Template;
import fr.ird.observe.toolkit.templates.navigation.NodeLinkModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public abstract class ModelTemplate
extends Template {
    public static final String PARENT_MODEL = "    @Override\n    public final %1$s getParent() {\n        return (%1$s) super.getParent();\n    }\n\n";
    public static final String CAPABILITY_MODEL = "    public final %1$s get%2$s() {\n        return getNode(%3$d);\n    }\n\n";
    public static final String CAPABILITY_CONSTRUCTOR_MODEL = "              new %1$s()%2$s";
    public static final String CAPABILITY_FIELD_MODEL = "    private final transient %1$s %2$s;\n\n";
    public static final String CAPABILITY_FIELD_INIT_MODEL = "        this.%1$s = forModelType(%2$s.class).orElse(null);\n";
    public static final String GET_MODULE = "    public final %1$s get%2$s() {\n        return %3$s;\n    }\n\n";
    private final Map<String, String> modules = new LinkedHashMap<String, String>();

    public ModelTemplate(Log log, String prefix, String suffix, Path targetDirectory) {
        super(log, prefix, suffix, targetDirectory);
    }

    public abstract String getNodeTemplate();

    public abstract String getModuleTemplate();

    public abstract String getProjectTemplate();

    @Override
    public void generate(NodeModel model) throws IOException {
        String content = this.generateNodeContent(model);
        Path generate = this.store(this.targetDirectory, model.getPackageName("").replace("data.", ""), model.getSimpleName(this.suffix), content);
        if (model.getLevel() == 0) {
            String moduleName = generate.getParent().getParent().toFile().getName();
            this.generateModule(generate, model, moduleName);
        }
        this.generateProject();
    }

    public void generateModule(Path generate, NodeModel model, String moduleName) throws IOException {
        String content = this.generateModuleContent(generate, model);
        String moduleClassName = "Module" + this.suffix.replace("Node", "Model");
        this.modules.put(moduleName, this.prefix + "." + moduleName + "." + moduleClassName);
        this.store(this.targetDirectory, moduleName, moduleClassName, content);
    }

    public void generateProject() throws IOException {
        String projectContent = this.generateProjectContent();
        this.store(this.targetDirectory, "", "Project" + this.suffix.replace("Node", "Model"), projectContent);
    }

    public String generateNodeContent(NodeModel model) {
        StringBuilder constructorBuilder = new StringBuilder();
        StringBuilder capabilityBuilder = new StringBuilder();
        Iterator iterator = model.getChildren().iterator();
        while (iterator.hasNext()) {
            NodeLinkModel child = (NodeLinkModel)iterator.next();
            boolean hasNext = iterator.hasNext();
            constructorBuilder.append(String.format(CAPABILITY_CONSTRUCTOR_MODEL, child.getName(this.prefix, this.suffix).replace(".data", ""), hasNext ? ",\n" : ""));
            capabilityBuilder.append(String.format(CAPABILITY_MODEL, child.getName(this.prefix, this.suffix).replace(".data", ""), StringUtils.capitalize((String)child.getPropertyName()), child.getOrder()));
        }
        int level = model.getLevel();
        return String.format(this.getNodeTemplate(), model.getPackageName(this.prefix).replace(".data", ""), this.now, model.getSimpleName(this.suffix), model.getDtoType(), constructorBuilder.toString().trim(), level, level == -1 ? "" : String.format(PARENT_MODEL, model.getParentName(this.prefix, this.suffix).replace(".data", "")), capabilityBuilder.toString());
    }

    public String generateModuleContent(Path generate, NodeModel model) {
        String moduleName = generate.getParent().getParent().toFile().getName();
        List nodes = model.collectNodes();
        StringBuilder capabilityBuilder = new StringBuilder();
        int index = 0;
        for (NodeModel child : nodes) {
            String[] nodeName = child.getPackageName("").replace("data.", "").split("\\.");
            String getterName = StringUtils.capitalize((String)nodeName[1]) + child.getSimpleName("");
            capabilityBuilder.append(String.format(CAPABILITY_MODEL, child.getName(this.prefix, this.suffix).replace(".data", ""), getterName, index++));
        }
        return String.format(this.getModuleTemplate(), this.prefix + "." + moduleName, this.now, model.getName(this.prefix, this.suffix).replace(".data", ""), capabilityBuilder.toString());
    }

    public String generateProjectContent() {
        StringBuilder fieldBuilder = new StringBuilder();
        StringBuilder constructorBuilder = new StringBuilder();
        StringBuilder constructor2Builder = new StringBuilder();
        StringBuilder capabilityBuilder = new StringBuilder();
        Iterator<String> iterator = this.modules.keySet().iterator();
        while (iterator.hasNext()) {
            String moduleName = iterator.next();
            boolean hasNext = iterator.hasNext();
            String moduleFqn = this.modules.get(moduleName);
            fieldBuilder.append(String.format(CAPABILITY_FIELD_MODEL, moduleFqn, moduleName));
            constructorBuilder.append(String.format(CAPABILITY_CONSTRUCTOR_MODEL, moduleFqn, hasNext ? ",\n" : ""));
            constructor2Builder.append(String.format(CAPABILITY_FIELD_INIT_MODEL, moduleName, moduleFqn));
            capabilityBuilder.append(String.format(GET_MODULE, moduleFqn, StringUtils.capitalize((String)moduleName), moduleName));
        }
        return String.format(this.getProjectTemplate(), this.prefix, this.now, fieldBuilder.toString(), constructorBuilder.toString().trim(), constructor2Builder.toString().trim(), capabilityBuilder.toString());
    }
}

