/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.tree;

import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.runner.navigation.GenerateSupport;
import fr.ird.observe.toolkit.runner.navigation.tree.NavigationTemplate;
import fr.ird.observe.toolkit.templates.navigation.NavigationNodesBuilder;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class GenerateNavigationModel
extends GenerateSupport {
    public static final String PACKAGE = "fr.ird.observe.tree.navigation";
    public static final String SUFFIX = "NavigationTreeNode";

    @Override
    protected final void generate(Path targetDirectory, NavigationNodeDescriptor descriptor) throws IOException {
        NavigationNodesBuilder builder = new NavigationNodesBuilder(this.getLog());
        List models = builder.build(descriptor);
        this.getLog().info((CharSequence)String.format("Detect %d navigation node(s) to generate.\n%s", models.size(), builder.getDebugTree()));
        this.generate(targetDirectory, models);
    }

    protected void generate(Path targetDirectory, List<NodeModel> models) throws IOException {
        Path rootTargetDirectory = targetDirectory.resolve(PACKAGE.replaceAll("\\.", File.separator));
        this.getLog().info((CharSequence)String.format("Will generate at %s", rootTargetDirectory));
        String modelName = Objects.requireNonNull((String)this.getExtraProperties().get("modelName"));
        NavigationTemplate template = new NavigationTemplate(this.getLog(), this.getGetterFile(), rootTargetDirectory, modelName);
        for (NodeModel model : models) {
            template.generate(model);
        }
        template.generateMapping();
    }
}

