/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.tree;

import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.runner.navigation.GenerateSupport;
import fr.ird.observe.toolkit.runner.navigation.tree.SelectionTemplate;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import fr.ird.observe.toolkit.templates.navigation.SelectionNodesBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class GenerateSelectionModel
extends GenerateSupport {
    public static final String PACKAGE = "fr.ird.observe.tree.selection";
    public static final String SUFFIX = "SelectionTreeNode";

    @Override
    protected void generate(Path targetDirectory, NavigationNodeDescriptor descriptor) throws IOException {
        Path rootTargetDirectory = targetDirectory.resolve(PACKAGE.replaceAll("\\.", File.separator));
        this.getLog().info((CharSequence)String.format("Will generate at %s", rootTargetDirectory));
        SelectionNodesBuilder builder = new SelectionNodesBuilder();
        List models = builder.build(descriptor);
        this.getLog().info((CharSequence)String.format("Detect %d selection node(s) to generate.\n%s", models.size(), builder.getDebugTree()));
        String modelName = Objects.requireNonNull((String)this.getExtraProperties().get("modelName"));
        SelectionTemplate template = new SelectionTemplate(this.getLog(), this.getGetterFile(), rootTargetDirectory, modelName);
        for (NodeModel model : models) {
            template.generate(model);
        }
        template.generateMapping();
    }
}

