/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.tree;

import fr.ird.observe.dto.BusinessDto;
import fr.ird.observe.dto.data.ContainerDto;
import fr.ird.observe.dto.data.SimpleDto;
import fr.ird.observe.spi.module.BusinessProject;
import fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeType;
import fr.ird.observe.toolkit.runner.navigation.Template;
import fr.ird.observe.toolkit.templates.navigation.NodeLinkModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import io.ultreia.java4all.i18n.spi.builder.I18nKeySet;
import io.ultreia.java4all.util.ServiceLoaders;
import java.beans.Introspector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public abstract class ModelTemplate
extends Template {
    public static final String PATH_MAPPING_MODEL = "package %1$s;\n\nimport com.google.common.collect.ImmutableMap;\nimport fr.ird.observe.dto.BusinessDto;\nimport fr.ird.observe.toolkit.navigation.spi.tree.DtoToToolkitTreePathMapping;\n\nimport javax.annotation.Generated;\nimport java.nio.file.Path;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.GenerateNavigationModel\", date = \"%2$s\")\npublic class %3$s extends DtoToToolkitTreePathMapping {\n\n    private static %3$s INSTANCE;\n\n    public static %3$s get() {\n        return INSTANCE == null ? INSTANCE = new %3$s() : INSTANCE;\n    }\n\n    protected %3$s() {\n        super(ImmutableMap\n                      .<Class<? extends BusinessDto>, Path>builder()\n                      %4$s\n                      .build());\n    }\n\n}";
    public static final String GET_USER_OBJECT = "    @Override\n    public final %1$s getUserObject() {\n        return (%1$s) super.getUserObject();\n    }\n\n";
    public static final String PARENT_MODEL = "    @Override\n    public final %1$s getParent() {\n        return (%1$s) super.getParent();\n    }\n\n";
    public static final String CAPABILITY_SINGLE = "    public final %1$s get%2$s() {\n        return find(%1$s.class);\n    }\n\n";
    public static final String CAPABILITY_MULTIPLE = "    public final %1$s get%2$s(fr.ird.observe.dto.ToolkitIdDtoBean %3$s) {\n        return find(%1$s.class, %3$s);\n    }\n\n";
    public static final String DEFAULT_CAPABILITY_MULTIPLE = "    public final %1$s get%2$s(fr.ird.observe.dto.ToolkitIdDtoBean %3$s) {\n        return get%2$s().getChildren(%3$s);\n    };\n\n";
    public static final String ROOT_PATH = "    public final static Path PATH = Path.of(\"/\");\n\n";
    public static final String NODE_PATH = "    public final static Path PATH = %1$s.PATH.resolve(\"%2$s\");\n\n";
    public static final String INTERCEPTOR_CASE = "           case \"%1$s\":\n                provider.intercept((%1$s) node);\n                break;\n";
    public static final String INTERCEPTOR_METHOD = "   default void intercept(%1$s node) {\n    }\n\n";
    protected final String modelName;
    protected final BusinessProject businessProject;
    protected final Set<Class<? extends ContainerDto<?>>> containerDataTypes;
    private final Map<String, String> pathMapping = new LinkedHashMap<String, String>();
    private final I18nKeySet getterFile;
    private final Set<Class<? extends SimpleDto>> simpleDataTypes;
    protected StringBuilder interceptorCaseBuilder = new StringBuilder();
    protected StringBuilder interceptorMethodsBuilder = new StringBuilder();

    public ModelTemplate(Log log, I18nKeySet getterFile, String prefix, String suffix, Path targetDirectory, String modelName) {
        super(log, prefix, suffix, targetDirectory);
        this.getterFile = getterFile;
        this.modelName = modelName;
        this.businessProject = (BusinessProject)ServiceLoaders.loadUniqueService(BusinessProject.class);
        this.containerDataTypes = this.businessProject.getContainerDataTypes();
        this.simpleDataTypes = this.businessProject.getSimpleDataTypes();
    }

    public abstract String getNodeTemplate();

    public abstract String getBeanTemplate();

    protected void registerInterceptorNode(NodeModel model) {
        String childName = model.getName(this.prefix, this.suffix);
        this.interceptorCaseBuilder.append(" ").append(String.format(INTERCEPTOR_CASE, childName));
        this.interceptorMethodsBuilder.append(" ").append(String.format(INTERCEPTOR_METHOD, childName));
    }

    public abstract void generateMapping() throws IOException;

    protected void generateMapping(String path) throws IOException {
        String data = this.pathMapping.entrySet().stream().map(e -> String.format("                     .put(%s.class, %s)\n", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
        String className = "DtoTo" + this.suffix.replace("TreeNode", "") + "TreePathMapping";
        String content = String.format(PATH_MAPPING_MODEL, "fr.ird.observe.spi.tree." + path, this.now, className, data.substring(1).trim());
        this.store(this.targetDirectory.getParent().getParent(), "spi.tree." + path, className, content);
    }

    @Override
    public void generate(NodeModel model) throws IOException {
        if (model.isRoot()) {
            this.registerInterceptorNode(model);
        }
        if (this.getNodeTemplate() != null) {
            this.generateNode(model);
        }
        if (this.getBeanTemplate() != null) {
            this.generateBean(model);
        }
        this.registerPath(this.pathMapping, model);
    }

    protected void registerPath(Map<String, String> pathMapping, NodeModel model) {
        String dtoType = model.getDtoType();
        if (model.getLevel() < 1 || dtoType == null) {
            return;
        }
        if (!model.isOpenList()) {
            this.pathMapping.put(dtoType, model.getName(this.prefix, this.suffix) + ".PATH");
        }
    }

    public void generateNode(NodeModel model) throws IOException {
        String content = this.generateNodeContent(model);
        this.store(this.targetDirectory, model.getPackageName(""), model.getSimpleName(this.suffix), content);
    }

    public void generateBean(NodeModel model) throws IOException {
        String content = this.generateBeanContent(model);
        this.store(this.targetDirectory, model.getPackageName(""), model.getSimpleName(this.suffix + "Bean"), content);
    }

    protected String generateNodeContent(NodeModel model) {
        StringBuilder fieldsBuilder = new StringBuilder();
        StringBuilder capabilityBuilder = new StringBuilder();
        String beanSimpleName = model.getSimpleName(this.suffix + "Bean");
        capabilityBuilder.append(String.format(GET_USER_OBJECT, beanSimpleName));
        if (model.getLevel() > -1) {
            String parentName = model.getParentName(this.prefix, this.suffix);
            capabilityBuilder.append(String.format(PARENT_MODEL, parentName));
            fieldsBuilder.append(String.format(NODE_PATH, parentName, this.getPath(model)));
        } else {
            fieldsBuilder.append(ROOT_PATH);
        }
        for (NodeLinkModel child : model.getChildren()) {
            String parameterId;
            String type = child.getName(this.prefix, this.suffix);
            String propertyName = child.getPropertyName();
            String getterName = StringUtils.capitalize((String)propertyName);
            if (child.getCapability().isMultiple()) {
                parameterId = Introspector.decapitalize(child.getSimpleName("").replace("List", "") + "Id");
                capabilityBuilder.append(String.format(CAPABILITY_MULTIPLE, type, getterName, parameterId));
                continue;
            }
            capabilityBuilder.append(String.format(CAPABILITY_SINGLE, type, getterName));
            if (!child.isOpenList()) continue;
            parameterId = Introspector.decapitalize(getterName + "Id");
            capabilityBuilder.append(String.format(DEFAULT_CAPABILITY_MULTIPLE, type.replace("List", ""), getterName, parameterId));
        }
        return String.format(this.getNodeTemplate(), model.getPackageName(this.prefix), this.now, model.getSimpleName(this.suffix), fieldsBuilder, capabilityBuilder);
    }

    protected String generateBeanContent(NodeModel model) {
        StringBuilder capabilityBuilder = new StringBuilder();
        TreeMap<String, String> defaultStates = new TreeMap<String, String>();
        this.addType(defaultStates, model);
        this.addMultiplicity(defaultStates, model);
        this.addDefaultMapping(defaultStates, model);
        switch (model.getType()) {
            case Root: {
                break;
            }
            case ReferentialPackage: {
                this.generateReferentialPackageBeanContent(model, defaultStates);
                break;
            }
            case ReferentialType: {
                this.generateReferentialTypeBeanContent(model, defaultStates);
                break;
            }
            case OpenList: {
                this.generateOpenListBeanContent(model, defaultStates);
                break;
            }
            case Open: {
                this.generateOpenBeanContent(model, defaultStates);
                break;
            }
            case Edit: {
                this.generateEditBeanContent(model, defaultStates);
                break;
            }
            case Table: {
                this.generateTableBeanContent(model, defaultStates);
                break;
            }
            case Simple: {
                this.generateSimpleBeanContent(model, defaultStates);
            }
        }
        this.addDefaultStates(capabilityBuilder, defaultStates);
        return this.generate0(model, capabilityBuilder);
    }

    protected String generate0(NodeModel model, StringBuilder capabilityBuilder) {
        return String.format(this.getBeanTemplate(), model.getPackageName(this.prefix), this.now, model.getSimpleName(this.suffix + "Bean"), model.getType().name(), capabilityBuilder.toString());
    }

    protected void addMapping(Map<String, String> capabilityBuilder, Map<String, String> mapping) {
        String map;
        if (mapping == null || mapping.isEmpty()) {
            map = "ImmutableMap.of()";
        } else {
            List collect = mapping.entrySet().stream().map(e -> "                      .put(\"" + (String)e.getKey() + "\", " + (String)e.getValue() + ")\n").collect(Collectors.toList());
            map = String.format("ImmutableMap.<String, Class<?>>builder()\n                        %1$s\n                        .build()", String.join((CharSequence)"  ", collect).substring(2).trim());
        }
        capabilityBuilder.put("STATE_NODE_MAPPING", map);
    }

    protected void addType(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_TYPE", NavigationNodeType.class.getName() + "." + model.getType().name());
    }

    protected void addMultiplicity(Map<String, String> capabilityBuilder, NodeModel model) {
        NodeModel parent = model.getParent();
        NodeLinkModel nodeLinkModel = parent == null ? null : parent.getChildren().stream().filter(l -> l.getTargetModel().equals(model)).findFirst().orElseThrow();
        boolean multiple = nodeLinkModel != null && nodeLinkModel.getCapability().isMultiple();
        capabilityBuilder.put("STATE_MULTIPLICITY", "" + multiple);
    }

    protected void addIconPath(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_ICON_PATH", String.format("\"navigation.%1$s\"", model.getIconPath()));
    }

    protected void addPath(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_PATH", model.getPath());
    }

    protected void addReferentialType(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_REFERENTIAL_TYPE", model.getDtoType() + ".class");
    }

    protected void addDataType(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_DATA_TYPE", model.getDtoType() + ".class");
    }

    private void addDefaultStates(StringBuilder capabilityBuilder, Map<String, String> defaultStates) {
        String map;
        String extra = "    @Override\n    protected final Map<ToolkitTreeNodeBeanState<?>, Object> defaultStates() {\n        return %1$s;\n    }\n\n";
        if (defaultStates == null || defaultStates.isEmpty()) {
            map = "ImmutableMap.of()";
        } else {
            List collect = defaultStates.entrySet().stream().map(e -> "              .put(" + (String)e.getKey() + ", " + (String)e.getValue() + ")\n").collect(Collectors.toList());
            map = String.format("ImmutableMap.<ToolkitTreeNodeBeanState<?>, Object>builder()\n                %1$s\n                .build()", String.join((CharSequence)"  ", collect).substring(2).trim());
        }
        capabilityBuilder.append(String.format(extra, map));
    }

    protected void addText(Map<String, String> capabilityBuilder, NodeModel model) {
        capabilityBuilder.put("STATE_TEXT", model.getText(this.getterFile));
    }

    private void addDefaultMapping(Map<String, String> defaultStates, NodeModel model) {
        LinkedHashMap<String, String> mappingState = new LinkedHashMap<String, String>();
        List children = model.getChildren();
        boolean capabilityLeaf = children.isEmpty();
        boolean capabilitySelectReference = model.isEdit() || model.isOpenList() && model.getLevel() == 0;
        boolean capabilityEditReference = model.isOpen();
        boolean capabilitySelectReferenceContainer = false;
        boolean capabilityEditReferenceContainer = false;
        for (NodeLinkModel child : children) {
            Object propertyName = child.getPropertyName();
            if (child.isReferentialPackage()) {
                propertyName = "referential-" + (String)propertyName;
            }
            mappingState.put((String)propertyName, child.getName(this.prefix, this.suffix) + ".class");
            if (child.isEdit()) {
                capabilitySelectReferenceContainer = true;
            }
            if (!child.isOpen()) continue;
            capabilityEditReferenceContainer = true;
        }
        this.addMapping(defaultStates, mappingState);
        this.addCapability(defaultStates, capabilityLeaf, capabilitySelectReference || capabilityEditReference, capabilityEditReference, capabilitySelectReferenceContainer, capabilityEditReferenceContainer);
    }

    protected void addCapability(Map<String, String> defaultStates, boolean capabilityLeaf, boolean capabilitySelectReference, boolean capabilityEditReference, boolean capabilitySelectReferenceContainer, boolean capabilityEditReferenceContainer) {
        if (capabilitySelectReference) {
            defaultStates.put("STATE_CAPABILITY_SELECT_REFERENCE", "true");
        }
        if (capabilityEditReference) {
            defaultStates.put("STATE_CAPABILITY_EDIT_REFERENCE", "true");
        }
        if (capabilityLeaf) {
            defaultStates.put("STATE_CAPABILITY_LEAF", "true");
        } else {
            defaultStates.put("STATE_CAPABILITY_CONTAINER", "true");
            if (capabilitySelectReferenceContainer) {
                defaultStates.put("STATE_CAPABILITY_SELECT_REFERENCE_CONTAINER", "true");
            }
            if (capabilityEditReferenceContainer) {
                defaultStates.put("STATE_CAPABILITY_EDIT_REFERENCE_CONTAINER", "true");
            }
        }
    }

    protected String getPath(NodeModel model) {
        NodeModel parent = model.getParent();
        if (parent == null) {
            return "/";
        }
        for (NodeLinkModel child : parent.getChildren()) {
            if (!child.getTargetModel().equals(model)) continue;
            Object propertyName = child.getPropertyName();
            if (child.isEdit() || (child.isOpenList() || child.isOpen()) && model.getLevel() == 0) {
                return String.format("%s:${%s}", propertyName, child.getSimpleName(""));
            }
            if (child.isOpen()) {
                return String.format("${%s}", child.getSimpleName(""));
            }
            if (child.isReferentialPackage()) {
                propertyName = "referential-" + (String)propertyName;
            }
            return propertyName;
        }
        throw new IllegalStateException("Can't find path for model: " + model);
    }

    protected void generateReferentialPackageBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addText(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected void generateReferentialTypeBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addText(defaultStates, model);
        this.addReferentialType(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected void generateOpenBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addDataType(defaultStates, model);
        if (model.getLevel() == 0) {
            this.addPath(defaultStates, model);
        }
    }

    protected void generateOpenListBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        if (model.getLevel() == 0) {
            this.addDataType(defaultStates, model);
        }
        this.addText(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected void generateEditBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addDataType(defaultStates, model);
        this.addText(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected void generateSimpleBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addDataType(defaultStates, model);
        this.addText(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected void generateTableBeanContent(NodeModel model, Map<String, String> defaultStates) {
        this.addIconPath(defaultStates, model);
        this.addDataType(defaultStates, model);
        this.addText(defaultStates, model);
        this.addPath(defaultStates, model);
    }

    protected boolean rejectDtoType(Class<? extends BusinessDto> dtoType) {
        return BusinessProject.isReferential(dtoType) || this.businessProject.getMapping().getReferenceType(dtoType) == null || this.simpleDataTypes.contains(dtoType) || this.containerDataTypes.contains(dtoType) && this.businessProject.getMapping().getMainDtoType(dtoType) != dtoType;
    }
}

