/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.tree;

import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.spi.module.BusinessDataPackage;
import fr.ird.observe.spi.module.BusinessModule;
import fr.ird.observe.spi.module.BusinessProjectVisitor;
import fr.ird.observe.spi.module.BusinessSubModule;
import fr.ird.observe.spi.parent.ToParentIdProvider;
import fr.ird.observe.toolkit.runner.navigation.tree.ModelTemplate;
import fr.ird.observe.toolkit.templates.navigation.NodeLinkModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import io.ultreia.java4all.i18n.spi.builder.I18nKeySet;
import java.beans.Introspector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class NavigationTemplate
extends ModelTemplate {
    public static final String NODE_MODEL = "package %1$s;\n\nimport fr.ird.observe.toolkit.navigation.tree.navigation.NavigationTreeNode;\n\nimport javax.annotation.Generated;\nimport java.nio.file.Path;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.NavigationTemplate\", date = \"%2$s\")\npublic class %3$s extends NavigationTreeNode {\n\n%4$s    public %3$s() {\n        super(new %3$sBean());\n    }\n\n%5$s}\n";
    public static final String BEAN_MODEL = "package %1$s;\n\nimport com.google.common.collect.ImmutableMap;\nimport fr.ird.observe.spi.module.ObserveBusinessProject;\nimport fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeType;\nimport fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNodeBeanState;\n\nimport javax.annotation.Generated;\nimport java.util.Map;\nimport java.util.function.Supplier;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.NavigationTemplate\", date = \"%2$s\")\npublic class %3$s extends fr.ird.observe.toolkit.navigation.tree.navigation.bean.%4$sNavigationTreeNodeBean {\n%5$s    @Override\n    protected Supplier<ObserveBusinessProject> getProjectSupplier() {\n        return ObserveBusinessProject::get;\n    }\n}\n";
    public static final String ID_PROVIDER_MODEL = "package %1$s;\n\nimport fr.ird.observe.dto.ToolkitIdDtoBean;\nimport fr.ird.observe.dto.ToolkitParentIdDtoBean;\n\nimport javax.annotation.Generated;\nimport java.util.Objects;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.NavigationTemplate\", date = \"%2$s\")\npublic interface %3$s extends ToParentIdProvider {\n\n    static ToolkitParentIdDtoBean getParent(%3$s provider, ToolkitIdDtoBean shortId) {\n        String id = Objects.requireNonNull(shortId.getId());\n        switch (shortId.getType().getName()) {\n            %4$s\n        }\n        return null;\n    }\n\n    @Override\n    default ToolkitParentIdDtoBean getParent(ToolkitIdDtoBean shortId) {\n        return getParent(this, shortId);\n    }\n\n    %5$s\n}";
    public static final String ID_CASE = "           case \"%1$s\":\n                return provider.get%2$sParent(id);\n";
    public static final String ID_METHOD = "   ToolkitParentIdDtoBean get%1$sParent(String %2$s);\n\n";
    public static final String INTERCEPTOR_MODEL = "package %1$s;\n\nimport fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNode;\nimport fr.ird.observe.toolkit.navigation.spi.tree.ToolkitTreeNodeInterceptor;\n\nimport javax.annotation.Generated;\nimport java.util.Objects;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.GenerateNavigationModel\", date = \"%2$s\")\npublic interface %3$s extends ToolkitTreeNodeInterceptor {\n\n    static void intercept(%3$s provider, ToolkitTreeNode node) {\n        switch (Objects.requireNonNull(node.getClass().getName())) {\n            %4$s\n        }\n    }\n\n    @Override\n    default void intercept(ToolkitTreeNode node) {\n        intercept(this, node);\n    }\n\n    %5$s\n}";
    StringBuilder idCaseBuilder = new StringBuilder();
    StringBuilder idMethodsBuilder = new StringBuilder();

    public NavigationTemplate(Log log, I18nKeySet getterFile, Path targetDirectory, String modelName) {
        super(log, getterFile, "fr.ird.observe.tree.navigation", "NavigationTreeNode", targetDirectory, modelName);
    }

    @Override
    protected void registerPath(Map<String, String> pathMapping, NodeModel model) {
        super.registerPath(pathMapping, model);
        String dtoType = model.getDtoType();
        if (model.getLevel() == 0 && dtoType != null && model.isOpenList()) {
            pathMapping.put(dtoType, model.getName(this.prefix, this.suffix) + ".PATH");
        }
    }

    @Override
    public void generate(NodeModel model) throws IOException {
        super.generate(model);
        for (NodeLinkModel child : model.getChildren()) {
            this.registerInterceptorNode(child.getTargetModel());
        }
    }

    @Override
    public void generateMapping() throws IOException {
        this.generateMapping("navigation");
        BusinessProjectVisitor visitor = new BusinessProjectVisitor(){

            public void enterSubModuleDataType(BusinessModule module, BusinessSubModule subModule, BusinessDataPackage dataPackage, Class<? extends DataDto> dtoType) {
                if (NavigationTemplate.this.rejectDtoType(dtoType)) {
                    return;
                }
                StringBuilder getterName = new StringBuilder();
                getterName.append(StringUtils.capitalize((String)module.getName()));
                getterName.append(StringUtils.capitalize((String)subModule.getName()));
                String simpleName = dtoType.getSimpleName().replace("Dto", "");
                getterName.append(simpleName);
                NavigationTemplate.this.idCaseBuilder.append(" ").append(String.format(NavigationTemplate.ID_CASE, dtoType.getName(), getterName));
                NavigationTemplate.this.idMethodsBuilder.append(" ").append(String.format(NavigationTemplate.ID_METHOD, getterName, Introspector.decapitalize(simpleName) + "Id"));
            }
        };
        this.businessProject.accept(visitor);
        String className = this.modelName + "ToParentIdProvider";
        String content = String.format(ID_PROVIDER_MODEL, ToParentIdProvider.class.getPackageName(), this.now, className, this.idCaseBuilder.substring(1).trim(), this.idMethodsBuilder.substring(1).trim());
        this.store(this.targetDirectory.getParent().getParent(), "spi.parent", className, content);
        className = this.modelName + "NavigationTreeNodeInterceptor";
        content = String.format(INTERCEPTOR_MODEL, "fr.ird.observe.spi.tree.navigation", this.now, className, this.interceptorCaseBuilder.substring(1).trim(), this.interceptorMethodsBuilder.substring(1).trim());
        this.store(this.targetDirectory.getParent().getParent(), "spi.tree.navigation", className, content);
    }

    @Override
    public String getNodeTemplate() {
        return NODE_MODEL;
    }

    @Override
    public String getBeanTemplate() {
        return BEAN_MODEL;
    }
}

