/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.toolkit.runner.navigation.tree;

import fr.ird.observe.toolkit.runner.navigation.tree.ModelTemplate;
import fr.ird.observe.toolkit.templates.navigation.NodeLinkModel;
import fr.ird.observe.toolkit.templates.navigation.NodeModel;
import io.ultreia.java4all.i18n.spi.builder.I18nKeySet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class SelectionTemplate
extends ModelTemplate {
    public static final String NODE_MODEL = "package %1$s;\n\nimport fr.ird.observe.toolkit.navigation.tree.selection.SelectionTreeNode;\nimport javax.annotation.Generated;\nimport java.nio.file.Path;\n\n@Generated(value = \"fr.ird.observe.maven.plugins.toolbox.selection.GenerateSelectionModel\", date = \"%2$s\")\npublic class %3$s extends SelectionTreeNode {\n\n%4$s    public %3$s() {\n        super(new %3$sBean());\n    }\n\n%5$s}\n";
    public static final String BEAN_MODEL = "package %1$s;\n\nimport com.google.common.collect.ImmutableMap;\nimport fr.ird.observe.spi.module.ObserveBusinessProject;\nimport fr.ird.observe.toolkit.navigation.spi.tree.descriptor.NavigationNodeType;\nimport fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNodeBeanState;\n\nimport javax.annotation.Generated;\nimport java.util.Map;\nimport java.util.function.Supplier;\n\n@Generated(value = \"fr.ird.observe.maven.plugins.toolbox.selection.GenerateSelectionModel\", date = \"%2$s\")\npublic class %3$s extends fr.ird.observe.toolkit.navigation.tree.selection.bean.%4$sSelectionTreeNodeBean {\n%5$s    @Override\n    protected Supplier<ObserveBusinessProject> getProjectSupplier() {\n        return ObserveBusinessProject::get;\n    }\n}\n";
    public static final String INTERCEPTOR_MODEL = "package %1$s;\n\nimport fr.ird.observe.toolkit.navigation.tree.ToolkitTreeNode;\nimport fr.ird.observe.toolkit.navigation.spi.tree.ToolkitTreeNodeInterceptor;\n\nimport javax.annotation.Generated;\nimport java.util.Objects;\n\n@Generated(value = \"fr.ird.observe.toolkit.runner.navigation.tree.GenerateSelectionModel\", date = \"%2$s\")\npublic interface %3$s extends ToolkitTreeNodeInterceptor {\n\n    static void intercept(%3$s provider, ToolkitTreeNode node) {\n        switch (Objects.requireNonNull(node.getClass().getName())) {\n            %4$s\n        }\n    }\n\n    @Override\n    default void intercept(ToolkitTreeNode node) {\n        intercept(this, node);\n    }\n\n    %5$s\n}";

    public SelectionTemplate(Log log, I18nKeySet getterFile, Path targetDirectory, String modelName) {
        super(log, getterFile, "fr.ird.observe.tree.selection", "SelectionTreeNode", targetDirectory, modelName);
    }

    @Override
    public void generate(NodeModel model) throws IOException {
        super.generate(model);
        for (NodeLinkModel child : model.getChildren()) {
            this.registerInterceptorNode(child.getTargetModel());
        }
    }

    @Override
    public void generateMapping() throws IOException {
        this.generateMapping("selection");
        String className = this.modelName + "SelectionTreeNodeInterceptor";
        String content = String.format(INTERCEPTOR_MODEL, "fr.ird.observe.spi.tree.selection", this.now, className, this.interceptorCaseBuilder.substring(1).trim(), this.interceptorMethodsBuilder.substring(1).trim());
        this.store(this.targetDirectory.getParent().getParent(), "spi.tree.selection", className, content);
    }

    @Override
    public String getNodeTemplate() {
        return NODE_MODEL;
    }

    @Override
    public String getBeanTemplate() {
        return BEAN_MODEL;
    }

    @Override
    protected void addCapability(Map<String, String> defaultStates, boolean capabilityLeaf, boolean capabilitySelectReference, boolean capabilityEditReference, boolean capabilitySelectReferenceContainer, boolean capabilityEditReferenceContainer) {
    }
}

