package fr.ird.observe.toolkit.templates;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.templates.io.TagValues;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.topia.templates.TopiaGenerator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

/**
 * Created on 31/03/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public abstract class TopiaMetaTransformer extends TopiaGenerator {

    @Override
    protected void applyTemplates(ObjectModel model, List<? extends Template<ObjectModel>> templates, File destDir) throws IOException {
        for (Template<ObjectModel> template : templates) {
            template.setLog(getLog());
        }
        super.applyTemplates(model, templates, destDir);
    }

    @Override
    protected boolean validateModel(ObjectModel model) {
        Path outputDirectory = getConfiguration().getProperty(PROP_OUTPUT_DIRECTORY, File.class).toPath().getParent().getParent();
        TagValues tagValues = new TagValues(model, "persistence", getLog());
        try {
            tagValues.load(getClassLoader(), outputDirectory, isVerbose());
        } catch (Exception e) {
            throw new IllegalStateException("Can't load tag-values", e);
        }
        return super.validateModel(model);
    }
}
