package fr.ird.observe.toolkit.templates.entity;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import fr.ird.observe.spi.context.DtoEntityContext;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.topia.persistence.metadata.TopiaMetadataEntity;
import org.nuiton.topia.persistence.metadata.TopiaMetadataEntityPath;
import org.nuiton.topia.templates.TopiaMetadataModelGeneratorSupport;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;

/**
 * Created on 13/09/2020.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 1.27
 */
public class EntityLastUpdateDateTableSqlScriptGenerator extends TopiaMetadataModelGeneratorSupport {

    private static final String UPDATE_LAST_UPDATE_DATE_TABLE_SQL = "UPDATE common.lastUpdateDate SET lastUpdateDate = '%%1$s'::timestamp WHERE type ='%s'";

    @Override
    public String getFilenameForClassifier(ObjectModelClassifier classifier) {
        return super.getFilenameForClassifier(classifier) + DtoEntityContext.LAST_UPDATE_DATE_SQL_SCRIPT_TABLE_CLASSIFIER;
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
        TopiaMetadataEntity entity = getEntityEnumName(input);
        if (entity != null && !entity.isAbstract()) {
            processEntity(entity, output);
        }
    }

    protected void processEntity(TopiaMetadataEntity entity, Writer output) throws IOException {

        ImmutableList<TopiaMetadataEntity> types;
        Optional<TopiaMetadataEntityPath> optionalPath = getAllPaths().getEntityPathsForEntryPoint(entity);
        if (optionalPath.isPresent()) {
            TopiaMetadataEntityPath path = optionalPath.get();
            types = path.getTypes();
        } else {
            // limit case, only one type
            types = ImmutableList.of(entity);
            // and no link
        }
        ImmutableList<String> requests = generateLastUpdateDateTableRequests(types);
        generate(output, requests);

    }

    private ImmutableList<String> generateLastUpdateDateTableRequests(ImmutableList<TopiaMetadataEntity> types) {
        ImmutableList.Builder<String> builder = ImmutableList.builder();
        for (TopiaMetadataEntity type : types.reverse()) {
            String tableSql = String.format(UPDATE_LAST_UPDATE_DATE_TABLE_SQL, type.getFullyQualifiedName());
            builder.add(tableSql + ";");
        }
        return builder.build();
    }

}
