package fr.ird.observe.toolkit.templates.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.NavigationNodeCapability;
import fr.ird.observe.toolkit.navigation.spi.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.navigation.spi.NavigationNodeType;
import org.apache.maven.plugin.logging.Log;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Created on 06/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class NavigationNodesBuilder extends NodeModelsBuilder {

    private final Log log;
    Map<NavigationNodeDescriptor, NodeModel> mappingList = new LinkedHashMap<>();

    public NavigationNodesBuilder(Log log) {
        super(c -> true);
        this.log = log;
    }

    @Override
    protected void onCapacity(LinkedList<NavigationNodeCapability<?>> stack, Map<NavigationNodeDescriptor, NodeModel> mapping, NavigationNodeCapability<?> capability) {
        int level = stack.size() - 2;
        NavigationNodeDescriptor parent = capability.getParent();
        registerNode(null, parent, level, NavigationNodeType.Root);
        NodeModel parentModel = mapping.get(parent);
        if (capability.isOpen() && level > 0) {

            log.debug(String.format("Need to create a OpenList node on %s:%s", capability.getParent().getClass(), capability.getPropertyName()));

            NavigationNodeDescriptor target = capability.getTarget();

            registerNode(mappingList, parentModel, target, level + 1, NavigationNodeType.OpenList);
            NodeModel targetListModel = mappingList.get(target);

            parentModel.addCapability(capability.toType(NavigationNodeType.OpenList).toParent(parent).toMultiple(false), targetListModel);

            registerNode(mapping, targetListModel, target, level + 1, capability.getType());

            NodeModel targetModel = mapping.get(target);
            targetListModel.addCapability(capability.toParent(target).toPropertyName("children"), targetModel);

            return;
        }
        if (level > -1 && capability.isOpenList()) {
            capability = capability.toPropertyName("children").toType(NavigationNodeType.Open);
        }
        super.onCapacity(stack, mapping, capability);
    }

    @Override
    public List<NodeModel> build(NavigationNodeDescriptor descriptor) {
        List<NodeModel> result = super.build(descriptor);
        result.addAll(mappingList.values());
        return result;
    }
}
