package fr.ird.observe.toolkit.templates.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.NavigationNodeCapability;
import fr.ird.observe.toolkit.navigation.spi.NavigationNodeType;
import org.apache.commons.lang3.StringUtils;

/**
 * Created on 01/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class NodeLinkModel implements NavigationNodeType.WithNavigationNodeType {
    final NavigationNodeCapability<?> capability;
    final int order;
    private final NodeModel targetModel;

    NodeLinkModel(NavigationNodeCapability<?> capability, NodeModel targetModel, int order) {
        this.capability = capability;
        this.targetModel = targetModel;
        this.order = order;
    }

    @Override
    public NavigationNodeType getType() {
        return capability.getType();
    }

    public NodeModel getTargetModel() {
        return targetModel;
    }

    public int getOrder() {
        return order;
    }

    public String getName(String prefix, String suffix) {
        String packageName = getPackageName(prefix);
        return packageName + (packageName.isEmpty() ? "" : ".") + getSimpleName(suffix);
    }

    public String getPackageName(String prefix) {
        return NodeModel.getPackageName(capability.getTarget(), prefix);
    }

    public String getSimpleName(String suffix) {
        return NodeModel.getSimpleName(capability.getTarget(), (isOpenList() && targetModel.getLevel() > 1 ? "List" : "") + suffix);
    }

    public String getPropertyName() {
        return capability.getPropertyName();
    }

    public String getCapitalizePropertyName() {
        return StringUtils.capitalize(getPropertyName());
    }

    public NavigationNodeCapability<?> getCapability() {
        return capability;
    }
}
