package fr.ird.observe.toolkit.templates.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.LinkedList;

/**
 * Created on 04/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
class NodeModelVisitor {

    protected final LinkedList<NodeModel> stack = new LinkedList<>();
    protected final LinkedList<NodeLinkModel> links = new LinkedList<>();

    public void start(NodeModel model) {
        stack.add(model);
    }

    public void end(NodeModel model) {
        stack.remove(model);
    }

    public void linkStart(NodeModel model, NodeLinkModel link) {
        links.add(link);
    }

    public void linkEnd(NodeModel model, NodeLinkModel link) {
        links.remove(link);
    }

}
