package fr.ird.observe.toolkit.templates.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.toolkit.navigation.spi.NavigationNodeCapability;
import fr.ird.observe.toolkit.navigation.spi.NavigationNodeDescriptor;
import fr.ird.observe.toolkit.navigation.spi.NavigationNodeType;

import java.util.LinkedList;
import java.util.Map;

/**
 * Created on 06/04/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.17
 */
public class SelectionNodesBuilder extends NodeModelsBuilder {

    public SelectionNodesBuilder() {
        super(c -> c.isOpen() || c.isReferentialPackage() || c.isReferentialType());
    }

    @Override
    protected void onCapacity(LinkedList<NavigationNodeCapability<?>> stack, Map<NavigationNodeDescriptor, NodeModel> mapping, NavigationNodeCapability<?> capability) {
        if (capability.isOpen()) {
            return;
        }
        if (capability.isOpenList()) {
            capability = capability.toType(NavigationNodeType.Open);
            if (stack.size() > 1) {
                capability = capability.toPropertyName("children");
            }
        }
        super.onCapacity(stack, mapping, capability);
    }
}
