package fr.ird.observe.toolkit.templates.service.local;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.spi.module.BusinessModule;
import fr.ird.observe.spi.module.BusinessSubModule;
import fr.ird.observe.toolkit.navigation.id.NavigationModel;
import fr.ird.observe.toolkit.navigation.id.select.ModuleSelectModel;
import fr.ird.observe.toolkit.navigation.id.select.ProjectSelectModel;
import fr.ird.observe.toolkit.navigation.id.select.SelectNode;
import fr.ird.observe.toolkit.templates.TemplateContract;
import fr.ird.observe.validation.ValidationContextConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

import java.util.ServiceLoader;
import java.util.function.Function;




/**
 * Created on 19/11/2020.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 8.0.1
 */
public class GenerateServiceLocalValidationContext extends ObjectModelTransformerToJava implements TemplateContract {

    @Override
    public void transformFromModel(ObjectModel model) {
        super.transformFromModel(model);

        String packageName = getDefaultPackageName().replace("dto", "validation");
        ObjectModelClass abstractClass = createAbstractClass("GeneratedServiceValidationContext", packageName);
        setSuperClass(abstractClass, packageName + ".ValidationContext");

        ImportsManager importManager = getImportManager(abstractClass);
        importManager.addExcludedPattern(".+\\.dto\\.data\\..+");
        importManager.addExcludedPattern(".+\\.dto\\.referential\\..+");

        ObjectModelOperation constructor = addConstructor(abstractClass, ObjectModelJavaModifier.PROTECTED);
        addParameter(constructor, packageName + ".DefaultService" + ValidationContextConfiguration.class.getSimpleName(), "configuration");
        setOperationBody(constructor, ""+"\n"
+"        super(configuration);\n"
+"    ");

        for (ProjectSelectModel selectModel : ServiceLoader.load(ProjectSelectModel.class, getClassLoader())) {

            for (NavigationModel<?> navigationModel : selectModel.getModels()) {

                ModuleSelectModel<?> moduleSelectModel = (ModuleSelectModel<?>) navigationModel;
                BusinessModule module = moduleSelectModel.getModule();

                for (SelectNode<?> node : moduleSelectModel.getNodes()) {

                    String dtoSimpleName = node.getClass().getSimpleName().replace("SelectNode", "");

                    BusinessSubModule subModule = node.getSubModule();
                    String capitalizeSubModuleName = StringUtils.capitalize(subModule.getName().toLowerCase());
                    String functionMethodName = module.getName() + capitalizeSubModuleName + dtoSimpleName + "Function";
                    String typeName = String.format("%s<String, %s>", Function.class.getName(), node.getType().getName());
                    ObjectModelOperation functionMethod = addOperation(abstractClass, functionMethodName, typeName, ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.FINAL);
                    addAnnotation(abstractClass, functionMethod, Override.class);
                    setOperationBody(functionMethod, ""+"\n"
+"        return function();\n"
+"    ");

                }
            }
            break;
        }
    }

    @Override
    public ObjectModelClass createClass(String className, String packageName) {
        return super.createClass(className, packageName);
    }

    @Override
    public void addImport(ObjectModelClass output, Class<?> type) {
        super.addImport(output, type);
    }

    @Override
    public void addImport(ObjectModelClass output, String type) {
        super.addImport(output, type);
    }

    @Override
    public void setSuperClass(ObjectModelClass output, Class<?> superClass) {
        super.setSuperClass(output, superClass);
    }

    @Override
    public ObjectModelAnnotation addAnnotation(ObjectModelClass output, ObjectModelElement output1, Class<?> annotationType) {
        return super.addAnnotation(output, output1, annotationType);
    }

    @Override
    public void addAnnotationParameter(ObjectModelClass output, ObjectModelAnnotation annotation, String name, String value) {
        super.addAnnotationParameter(output, annotation, name, value);
    }

    @Override
    public ObjectModelOperation addConstructor(ObjectModelClass output, ObjectModelJavaModifier modifiers) {
        return super.addConstructor(output, modifiers);
    }

    @Override
    public void setOperationBody(ObjectModelOperation constructor, String body) {
        super.setOperationBody(constructor, body);
    }

    @Override
    public ObjectModelParameter addParameter(ObjectModelOperation operation, Class<?> type, String name) {
        return super.addParameter(operation, type, name);
    }

    public ObjectModelOperation addOperation(ObjectModelClassifier classifier, String name, String type, ObjectModelModifier... modifiers) {
        return super.addOperation(classifier, name, type, modifiers);
    }

    @Override
    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier... modifiers) {
        return super.addAttribute(classifier, name, type, value, modifiers);
    }
}

