package fr.ird.observe.toolkit.templates.service.local;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.security.Permission;
import fr.ird.observe.services.spi.MethodCredential;
import io.ultreia.java4all.http.maven.plugin.model.ImportManager;
import io.ultreia.java4all.http.maven.plugin.model.MethodDescription;
import io.ultreia.java4all.http.spi.SpiHelper;
import io.ultreia.java4all.http.spi.Write;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Created on 26/12/2020.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 8.0.3
 */
@SuppressWarnings("unused")
public class ServiceLocalMethodDescriptionImpl implements MethodDescription {

    private final String name;
    private final String returnType;
    private final String returnInvocation;
    private final List<Class<?>> exceptions;
    private final List<String> parameterNames;
    private final List<String> parameterTypes;
    private final Permission methodeCredentials;
    private final boolean write;
    private final boolean noTransaction;

    <S> ServiceLocalMethodDescriptionImpl(ImportManager importManager, Class<S> serviceType, Method method, Map<String, String> currentMapping) {
        this.name = method.getName();

        String returnTypePrefix = importManager.getGenericDefinitionOfReturnType(method);
        String simpleReturnType = importManager.importReturnType(method, currentMapping);
        this.returnType = returnTypePrefix + simpleReturnType;

        parameterNames = new LinkedList<>();
        parameterTypes = new LinkedList<>();
        for (java.lang.reflect.Parameter parameter : method.getParameters()) {
            String name = parameter.getName();
            parameterNames.add(name);
            parameterTypes.add(importManager.importParameterType(parameter, currentMapping));
        }

        this.returnInvocation = returnType.contains("void") ? "" : "return ";
        this.exceptions = MethodDescription.getExceptions(method, importManager);

        methodeCredentials = Optional.ofNullable(method.getAnnotation(MethodCredential.class)).map(MethodCredential::value).orElse(null);
        write = Optional.ofNullable(method.getAnnotation(Write.class)).isPresent();
        noTransaction = !SpiHelper.getRequestAnnotation(method).isAddAuthToken();
    }

    public Permission getMethodeCredentials() {
        return methodeCredentials;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getReturnType() {
        return returnType;
    }

    @Override
    public String getParametersDefinition() {
        return null;
    }

    @Override
    public List<Class<?>> getExceptions() {
        return exceptions;
    }

    public String getParametersInvocation() {
        return null;
    }

    public String getReturnInvocation() {
        return returnInvocation;
    }

    public List<String> getParameterNames() {
        return parameterNames;
    }

    public List<String> getParameterTypes() {
        return parameterTypes;
    }

    public boolean isWrite() {
        return write;
    }

    public boolean isNoTransaction() {
        return noTransaction;
    }
}
