package fr.ird.observe.toolkit.templates.validation;

/*-
 * #%L
 * ObServe Toolkit :: Templates
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.validator.NuitonValidatorScope;

import java.nio.file.Path;
import java.util.Objects;

/**
 * Created on 11/05/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0.24
 */
public class ValidatorDescriptor {

    private transient final Path file;
    private final String typeName;
    private final String context;
    private final NuitonValidatorScope scope;

    ValidatorDescriptor(Path file, String typeName, String context, NuitonValidatorScope scope) {
        this.file = file;
        this.typeName = typeName;
        this.context = context;
        this.scope = scope;
    }

    public Path getFile() {
        return file;
    }

    public String getTypeName() {
        return typeName;
    }

    public String getContext() {
        return context;
    }

    public NuitonValidatorScope getScope() {
        return scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValidatorDescriptor that = (ValidatorDescriptor) o;
        return Objects.equals(getTypeName(), that.getTypeName()) &&
                Objects.equals(getContext(), that.getContext()) &&
                getScope() == that.getScope();
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTypeName(), getContext(), getScope());
    }
}
