/*
 * Decompiled with CFR 0.152.
 */
package fr.jetoile.hadoopunit;

import fr.jetoile.hadoopunit.Component;
import fr.jetoile.hadoopunit.HadoopUtils;
import fr.jetoile.hadoopunit.component.Bootstrap;
import fr.jetoile.hadoopunit.exception.NotFoundServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HadoopBootstrap {
    INSTANCE;

    private static final Logger LOGGER;
    List<Bootstrap> componentsToStart = new ArrayList<Bootstrap>();
    List<Bootstrap> manualComponentsToStart = new ArrayList<Bootstrap>();
    List<Bootstrap> componentsToStop = new ArrayList<Bootstrap>();
    List<Bootstrap> manualComponentsToStop = new ArrayList<Bootstrap>();
    private ServiceLoader<Bootstrap> commandLoader = ServiceLoader.load(Bootstrap.class);
    private Map<String, Bootstrap> commands = new HashMap<String, Bootstrap>();

    private HadoopBootstrap() {
        this.commands.clear();
        this.commandLoader.reload();
        for (Bootstrap command : this.commandLoader) {
            this.commands.put(command.getName(), command);
        }
        Arrays.asList(Component.values()).stream().forEach(c -> {
            if (this.commands.containsKey(c.name())) {
                this.componentsToStart.add(this.commands.get(c.name()));
            }
        });
        this.componentsToStop = this.componentsToStart.stream().collect(Collectors.toList());
        Collections.reverse(this.componentsToStop);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("All services are going to be stopped");
                HadoopBootstrap.this.stopAll();
            }
        });
    }

    public Bootstrap getService(Component c) throws NotFoundServiceException {
        if (this.commands.containsKey(c.name())) {
            return this.commands.get(c.name());
        }
        throw new NotFoundServiceException("unable to find service " + c.name());
    }

    public void startAll() {
        if (this.manualComponentsToStart.isEmpty()) {
            this.internalStart(this.componentsToStart);
        } else {
            this.internalStart(this.manualComponentsToStart);
        }
    }

    public void stopAll() {
        if (this.manualComponentsToStop.isEmpty()) {
            this.internalStop(this.componentsToStop);
        } else {
            this.manualComponentsToStop = this.manualComponentsToStart.stream().collect(Collectors.toList());
            Collections.reverse(this.manualComponentsToStop);
            this.internalStop(this.manualComponentsToStop);
        }
    }

    public HadoopBootstrap add(Component component) throws NotFoundServiceException {
        this.manualComponentsToStart.add(this.getService(component));
        return this;
    }

    private void internalStart(List<Bootstrap> componentsToStart) {
        componentsToStart.stream().forEach(c -> this.startService((Bootstrap)c));
        HadoopUtils.INSTANCE.printBanner(System.out);
        componentsToStart.stream().forEach(c -> HadoopUtils.printColorLine(System.out, Ansi.Color.GREEN, "\t\t - " + c.getName() + " " + c.getProperties()));
        System.out.println();
    }

    private void internalStop(List<Bootstrap> componentsToStop) {
        componentsToStop.stream().forEach(c -> this.stopService((Bootstrap)c));
    }

    private void startService(Bootstrap c) {
        c.start();
    }

    private void stopService(Bootstrap c) {
        c.stop();
    }

    static {
        LOGGER = LoggerFactory.getLogger(HadoopBootstrap.class);
    }
}

