/*
 * Decompiled with CFR 0.152.
 */
package fr.jetoile.hadoopunit;

import fr.jetoile.hadoopunit.exception.BootstrapException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HadoopUtils {
    INSTANCE;

    public static final String WINUTILS_EXE = "winutils.exe";
    public static final String HADOOP_HOME = "HADOOP_HOME";
    public static final String HADOOP_DLL = "/hadoop.dll";
    public static final String HDFS_DLL = "/hdfs.dll";
    private final Logger LOGGER = LoggerFactory.getLogger(HadoopUtils.class);
    private Configuration configuration;

    private HadoopUtils() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (StringUtils.isEmpty((CharSequence)System.getenv(HADOOP_HOME))) {
                try {
                    this.configuration = new PropertiesConfiguration("hadoop-unit-default.properties");
                }
                catch (ConfigurationException e) {
                    this.LOGGER.error("unable to load {}", (Object)"hadoop-unit-default.properties", (Object)e);
                }
                String hadoop_home = this.configuration.getString(HADOOP_HOME);
                this.LOGGER.info("Setting hadoop.home.dir: {}", (Object)hadoop_home);
                if (hadoop_home == null) {
                    this.LOGGER.error("HADOOP_HOME should be set or informed into hadoop-unit-default.properties");
                    System.exit(-1);
                } else {
                    System.setProperty(HADOOP_HOME, hadoop_home);
                }
            } else {
                System.setProperty(HADOOP_HOME, System.getenv(HADOOP_HOME));
            }
            String windowsLibDir = System.getenv(HADOOP_HOME);
            try {
                this.extractAndMoveWinUtils(windowsLibDir);
                this.extractAndLoadDll(HADOOP_DLL);
                this.extractAndLoadDll(HDFS_DLL);
            }
            catch (IOException e) {
                this.LOGGER.error("unable to load windows dll", (Throwable)e);
            }
        }
    }

    public static void printColorLine(PrintStream out, Ansi.Color color, String line) {
        AnsiConsole.systemInstall();
        out.println(Ansi.ansi().fg(color).a(line).reset());
        AnsiConsole.systemUninstall();
    }

    private void extractAndLoadDll(String lib) throws IOException {
        InputStream in = HadoopUtils.class.getResourceAsStream(lib);
        File fileOut = new File(System.getProperty("java.io.tmpdir") + File.separator + lib);
        System.out.println("Writing dll to: " + fileOut.getAbsolutePath());
        FileOutputStream out = FileUtils.openOutputStream((File)fileOut);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        try {
            System.load(fileOut.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private void extractAndMoveWinUtils(String path) throws IOException {
        InputStream in = HadoopUtils.class.getResourceAsStream("/winutils.exe");
        File fileOut = new File(path + File.separator + "bin" + File.separator + WINUTILS_EXE);
        this.LOGGER.info("Writing {} to: {}", (Object)WINUTILS_EXE, (Object)fileOut.getAbsolutePath());
        FileOutputStream out = FileUtils.openOutputStream((File)fileOut);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
    }

    public void setHadoopHome() {
    }

    public void printBanner(PrintStream out) {
        try {
            InputStream banner = HadoopUtils.class.getResourceAsStream("/banner.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(banner));
            String line = null;
            while ((line = br.readLine()) != null) {
                HadoopUtils.printColorLine(out, Ansi.Color.BLUE, line);
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Banner not printable", (Throwable)ex);
        }
    }

    public Configuration loadConfigFile(URL url) throws BootstrapException {
        try {
            this.configuration = url == null ? new PropertiesConfiguration("hadoop-unit-default.properties") : new PropertiesConfiguration(url);
            return this.configuration;
        }
        catch (ConfigurationException e) {
            throw new BootstrapException("bad config", e);
        }
    }
}

